# Generated by Django 3.1.1 on 2020-09-09 08:40

import uuid

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("authentik_flows", "0007_auto_20200703_2059"),
        ("authentik_policies", "0003_auto_20200908_1542"),
    ]

    operations = [
        migrations.CreateModel(
            name="Prompt",
            fields=[
                (
                    "prompt_uuid",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "field_key",
                    models.SlugField(
                        help_text="Name of the form field, also used to store the value"
                    ),
                ),
                ("label", models.TextField()),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("text", "Text: Simple Text input"),
                            (
                                "username",
                                (
                                    "Username: Same as Text input, but checks for and prevents"
                                    " duplicate usernames."
                                ),
                            ),
                            ("email", "Email: Text field with Email type."),
                            ("password", "Password"),
                            ("number", "Number"),
                            ("checkbox", "Checkbox"),
                            ("data", "Date"),
                            ("data-time", "Date Time"),
                            ("separator", "Separator: Static Separator Line"),
                            (
                                "hidden",
                                "Hidden: Hidden field, can be used to insert data into form.",
                            ),
                            ("static", "Static: Static value, displayed as-is."),
                        ],
                        max_length=100,
                    ),
                ),
                ("required", models.BooleanField(default=True)),
                ("placeholder", models.TextField(blank=True)),
                ("order", models.IntegerField(default=0)),
            ],
            options={
                "verbose_name": "Prompt",
                "verbose_name_plural": "Prompts",
            },
        ),
        migrations.CreateModel(
            name="PromptStage",
            fields=[
                (
                    "stage_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="authentik_flows.stage",
                    ),
                ),
                ("fields", models.ManyToManyField(to="authentik_stages_prompt.Prompt")),
                (
                    "validation_policies",
                    models.ManyToManyField(blank=True, to="authentik_policies.Policy"),
                ),
            ],
            options={
                "verbose_name": "Prompt Stage",
                "verbose_name_plural": "Prompt Stages",
            },
            bases=("authentik_flows.stage",),
        ),
    ]
