# Generated by Django 5.1.11 on 2025-07-13 01:07

import uuid
from django.db import migrations, models
from django.apps.registry import Apps

from django.db.backends.base.schema import BaseDatabaseSchemaEditor


def migrate_ext_id(apps: Apps, schema_editor: BaseDatabaseSchemaEditor):
    SCIMSourceUser = apps.get_model("authentik_sources_scim", "SCIMSourceUser")
    SCIMSourceGroup = apps.get_model("authentik_sources_scim", "SCIMSourceGroup")
    db_alias = schema_editor.connection.alias
    for user in SCIMSourceUser.objects.using(db_alias).all():
        user.external_id = user.id
        user.save(update_fields=["external_id"])
    for group in SCIMSourceGroup.objects.using(db_alias).all():
        group.external_id = group.id
        group.save(update_fields=["external_id"])


class Migration(migrations.Migration):

    dependencies = [
        ("authentik_sources_scim", "0002_scimsourcepropertymapping"),
    ]

    operations = [
        migrations.AlterUniqueTogether(
            name="scimsourcegroup",
            unique_together=set(),
        ),
        migrations.AlterUniqueTogether(
            name="scimsourceuser",
            unique_together=set(),
        ),
        migrations.AddField(
            model_name="scimsourcegroup",
            name="external_id",
            field=models.TextField(default=None, null=True),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="scimsourceuser",
            name="external_id",
            field=models.TextField(default=None, null=True),
            preserve_default=False,
        ),
        migrations.AlterUniqueTogether(
            name="scimsourcegroup",
            unique_together={("external_id", "source")},
        ),
        migrations.AlterUniqueTogether(
            name="scimsourceuser",
            unique_together={("external_id", "source")},
        ),
        migrations.RunPython(migrate_ext_id, migrations.RunPython.noop),
        migrations.AlterField(
            model_name="scimsourcegroup",
            name="external_id",
            field=models.TextField(),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="scimsourceuser",
            name="external_id",
            field=models.TextField(),
            preserve_default=False,
        ),
        migrations.AddIndex(
            model_name="scimsourcegroup",
            index=models.Index(fields=["external_id"], name="authentik_s_externa_05e346_idx"),
        ),
        migrations.AddIndex(
            model_name="scimsourceuser",
            index=models.Index(fields=["external_id"], name="authentik_s_externa_4bd760_idx"),
        ),
        migrations.AlterField(
            model_name="scimsourcegroup",
            name="id",
            field=models.TextField(default=uuid.uuid4, primary_key=True, serialize=False),
        ),
        migrations.AlterField(
            model_name="scimsourceuser",
            name="id",
            field=models.TextField(default=uuid.uuid4, primary_key=True, serialize=False),
        ),
        migrations.AddField(
            model_name="scimsourcegroup",
            name="last_update",
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.AddField(
            model_name="scimsourceuser",
            name="last_update",
            field=models.DateTimeField(auto_now=True),
        ),
    ]
