from django.db import migrations


def migrate_identifier(apps, schema_editor):
    db_alias = schema_editor.connection.alias
    UserOAuthSourceConnection = apps.get_model(
        "authentik_sources_oauth", "UserOAuthSourceConnection"
    )

    for connection in UserOAuthSourceConnection.objects.using(db_alias).all():
        connection.new_identifier = connection.identifier
        connection.save(using=db_alias)


class Migration(migrations.Migration):

    dependencies = [
        ("authentik_sources_oauth", "0008_groupoauthsourceconnection_and_more"),
        ("authentik_core", "0044_usersourceconnection_new_identifier"),
    ]

    operations = [
        migrations.RunPython(code=migrate_identifier, reverse_code=migrations.RunPython.noop),
        migrations.RemoveField(
            model_name="useroauthsourceconnection",
            name="identifier",
        ),
    ]
