# Generated by Django 5.1.9 on 2025-05-29 11:22

from django.apps.registry import Apps
from django.db import migrations, models
from django.db.backends.base.schema import BaseDatabaseSchemaEditor


def set_user_membership_attribute(apps: Apps, schema_editor: BaseDatabaseSchemaEditor):
    LDAPSource = apps.get_model("authentik_sources_ldap", "LDAPSource")
    db_alias = schema_editor.connection.alias

    LDAPSource.objects.using(db_alias).filter(group_membership_field="memberUid").all().update(
        user_membership_attribute="ldap_uniq"
    )


class Migration(migrations.Migration):
    dependencies = [
        ("authentik_sources_ldap", "0009_groupldapsourceconnection_validated_by_and_more"),
    ]

    operations = [
        migrations.AddField(
            model_name="ldapsource",
            name="user_membership_attribute",
            field=models.TextField(
                default="distinguishedName",
                help_text="Attribute which matches the value of `group_membership_field`.",
            ),
        ),
        migrations.RunPython(set_user_membership_attribute, migrations.RunPython.noop),
    ]
