# Generated by Django 3.1.2 on 2020-10-03 17:37

from django.apps.registry import Apps
from django.db import migrations
from django.db.backends.base.schema import BaseDatabaseSchemaEditor


def update_name_temp(apps: Apps, schema_editor: BaseDatabaseSchemaEditor):
    SAMLProvider = apps.get_model("authentik_providers_saml", "SAMLProvider")
    db_alias = schema_editor.connection.alias

    for provider in SAMLProvider.objects.using(db_alias).all():
        provider.name_temp = provider.name
        provider.save()


class Migration(migrations.Migration):
    dependencies = [
        ("authentik_core", "0011_provider_name_temp"),
        ("authentik_providers_saml", "0005_remove_samlprovider_processor_path"),
    ]

    operations = [
        migrations.RunPython(update_name_temp),
        migrations.RemoveField(
            model_name="samlprovider",
            name="name",
        ),
    ]
