# Generated by Django 5.0.11 on 2025-01-27 13:00

from django.db import migrations
import django.db.models.deletion
from django.db import migrations, models
from functools import partial


def migrate_sessions(apps, schema_editor, model):
    Model = apps.get_model("authentik_providers_oauth2", model)
    AuthenticatedSession = apps.get_model("authentik_core", "AuthenticatedSession")
    db_alias = schema_editor.connection.alias

    for obj in Model.objects.using(db_alias).all():
        if not obj.old_session:
            continue
        obj.session = (
            AuthenticatedSession.objects.using(db_alias)
            .filter(session__session_key=obj.old_session.session_key)
            .first()
        )
        if obj.session:
            obj.save()
        else:
            obj.delete()


class Migration(migrations.Migration):

    dependencies = [
        ("authentik_providers_oauth2", "0027_accesstoken_authentik_p_expires_9f24a5_idx_and_more"),
        ("authentik_core", "0046_session_and_more"),
    ]

    operations = [
        migrations.RenameField(
            model_name="accesstoken",
            old_name="session",
            new_name="old_session",
        ),
        migrations.RenameField(
            model_name="authorizationcode",
            old_name="session",
            new_name="old_session",
        ),
        migrations.RenameField(
            model_name="devicetoken",
            old_name="session",
            new_name="old_session",
        ),
        migrations.RenameField(
            model_name="refreshtoken",
            old_name="session",
            new_name="old_session",
        ),
        migrations.AddField(
            model_name="accesstoken",
            name="session",
            field=models.ForeignKey(
                default=None,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="authentik_core.authenticatedsession",
            ),
        ),
        migrations.AddField(
            model_name="authorizationcode",
            name="session",
            field=models.ForeignKey(
                default=None,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="authentik_core.authenticatedsession",
            ),
        ),
        migrations.AddField(
            model_name="devicetoken",
            name="session",
            field=models.ForeignKey(
                default=None,
                null=True,
                on_delete=django.db.models.deletion.SET_DEFAULT,
                to="authentik_core.authenticatedsession",
            ),
        ),
        migrations.AddField(
            model_name="refreshtoken",
            name="session",
            field=models.ForeignKey(
                default=None,
                null=True,
                on_delete=django.db.models.deletion.SET_DEFAULT,
                to="authentik_core.authenticatedsession",
            ),
        ),
        migrations.RunPython(code=partial(migrate_sessions, model="AccessToken")),
        migrations.RunPython(code=partial(migrate_sessions, model="AuthorizationCode")),
        migrations.RunPython(code=partial(migrate_sessions, model="DeviceToken")),
        migrations.RunPython(code=partial(migrate_sessions, model="RefreshToken")),
        migrations.RemoveField(
            model_name="accesstoken",
            name="old_session",
        ),
        migrations.RemoveField(
            model_name="authorizationcode",
            name="old_session",
        ),
        migrations.RemoveField(
            model_name="devicetoken",
            name="old_session",
        ),
        migrations.RemoveField(
            model_name="refreshtoken",
            name="old_session",
        ),
    ]
