# Generated by Django 3.2.8 on 2021-10-10 16:10

from django.db import migrations, models


class Migration(migrations.Migration):
    replaces = [
        ("authentik_flows", "0019_alter_flow_background"),
        ("authentik_flows", "0020_flow_compatibility_mode"),
        ("authentik_flows", "0021_flowstagebinding_invalid_response_action"),
        ("authentik_flows", "0022_alter_flowstagebinding_invalid_response_action"),
        ("authentik_flows", "0023_alter_flow_background"),
        ("authentik_flows", "0024_alter_flow_compatibility_mode"),
    ]

    dependencies = [
        ("authentik_flows", "0018_oob_flows"),
    ]

    operations = [
        migrations.AlterField(
            model_name="flow",
            name="background",
            field=models.FileField(
                default=None,
                help_text="Background shown during execution",
                null=True,
                upload_to="flow-backgrounds/",
            ),
        ),
        migrations.AddField(
            model_name="flowstagebinding",
            name="invalid_response_action",
            field=models.TextField(
                choices=[
                    ("retry", "Retry"),
                    ("restart", "Restart"),
                    ("restart_with_context", "Restart With Context"),
                ],
                default="retry",
                help_text=(
                    "Configure how the flow executor should handle an invalid response to a"
                    " challenge. RETRY returns the error message and a similar challenge to the"
                    " executor. RESTART restarts the flow from the beginning, and"
                    " RESTART_WITH_CONTEXT restarts the flow while keeping the current context."
                ),
            ),
        ),
        migrations.AlterField(
            model_name="flow",
            name="background",
            field=models.FileField(
                default=None,
                help_text="Background shown during execution",
                max_length=500,
                null=True,
                upload_to="flow-backgrounds/",
            ),
        ),
        migrations.AddField(
            model_name="flow",
            name="compatibility_mode",
            field=models.BooleanField(
                default=False,
                help_text=(
                    "Enable compatibility mode, increases compatibility with password managers on"
                    " mobile devices."
                ),
            ),
        ),
    ]
