"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.FactName=exports.Fact=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var aws_entities_1=()=>{var tmp=require("./aws-entities");return aws_entities_1=()=>tmp,tmp};class Fact{static get regions(){return[...new Set([...aws_entities_1().AWS_REGIONS,...Object.keys(this.database)])]}static get names(){return[...new Set(Object.values(this.database).flatMap(regionFacts=>Object.keys(regionFacts)))]}static definedFacts(){return Object.entries(this.database).flatMap(([regionName,regionFacts])=>Object.keys(regionFacts).map(factName=>[regionName,factName]))}static find(region,name){const regionFacts=this.database[region];return regionFacts&&regionFacts[name]}static requireFact(region,name){const foundFact=this.find(region,name);if(!foundFact)throw new Error(`No fact ${name} could be found for region: ${region} and name: ${name}.`);return foundFact}static register(fact,allowReplacing=!1){try{jsiiDeprecationWarnings().aws_cdk_lib_region_info_IFact(fact)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.register),error}const regionFacts=this.database[fact.region]||(this.database[fact.region]={});if(fact.name in regionFacts&&regionFacts[fact.name]!==fact.value&&!allowReplacing)throw new Error(`Region ${fact.region} already has a fact ${fact.name}, with value ${regionFacts[fact.name]}`);fact.value!==void 0&&(regionFacts[fact.name]=fact.value)}static unregister(region,name,value){const regionFacts=this.database[region]||{};if(name in regionFacts&&value&&regionFacts[name]!==value)throw new Error(`Attempted to remove ${name} from ${region} with value ${value}, but the fact's value is ${regionFacts[name]}`);delete regionFacts[name]}constructor(){throw new Error("Use the static methods of Fact instead!")}}exports.Fact=Fact,_a=JSII_RTTI_SYMBOL_1,Fact[_a]={fqn:"aws-cdk-lib.region_info.Fact",version:"2.188.0"},Fact.database={};class FactName{static cloudwatchLambdaInsightsVersion(version,arch){return`cloudwatch-lambda-insights-version:${version.split(".").join("_")+`_${arch??"x86_64"}`}`}static appConfigLambdaLayerVersion(version,arch){return`appconfig-lambda-layer:${version.split(".").join("_")+`_${arch??"x86_64"}`}`}static servicePrincipal(service){try{jsiiDeprecationWarnings().print("aws-cdk-lib.region_info.FactName#servicePrincipal","- Use `iam.ServicePrincipal.servicePrincipalName()` instead.")}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.servicePrincipal),error}return`${service.replace(/\.amazonaws\.com(\.cn)?$/,"")}.amazonaws.com`}static adotLambdaLayer(type,version,architecture){return`adot-lambda-layer:${type+"_"+version.split(".").join("_")+"_"+architecture}`}static paramsAndSecretsLambdaLayer(version,architecture){return`params-and-secrets-layer:${version.split(".").join("_")+`_${architecture}`}`}}exports.FactName=FactName,_b=JSII_RTTI_SYMBOL_1,FactName[_b]={fqn:"aws-cdk-lib.region_info.FactName",version:"2.188.0"},FactName.PARTITION="partition",FactName.DOMAIN_SUFFIX="domainSuffix",FactName.CDK_METADATA_RESOURCE_AVAILABLE="cdk:metadata-resource:available",FactName.IS_OPT_IN_REGION="aws:is-opt-in-region",FactName.S3_STATIC_WEBSITE_ENDPOINT="s3-static-website:endpoint",FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID="s3-static-website:route-53-hosted-zone-id",FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID="ebs-environment:route-53-hosted-zone-id",FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX="vpcEndpointServiceNamePrefix",FactName.ELBV2_ACCOUNT="elbv2Account",FactName.DLC_REPOSITORY_ACCOUNT="dlcRepositoryAccount",FactName.APPMESH_ECR_ACCOUNT="appMeshRepositoryAccount",FactName.FIREHOSE_CIDR_BLOCK="firehoseCidrBlock",FactName.SAML_SIGN_ON_URL="samlSignOnUrl",FactName.LATEST_NODE_RUNTIME="latestNodeRuntime";
