"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CodePipelineSource=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var constructs_1=()=>{var tmp=require("constructs");return constructs_1=()=>tmp,tmp},outputs_1=()=>{var tmp=require("./private/outputs");return outputs_1=()=>tmp,tmp},cp_actions=()=>{var tmp=require("../../../aws-codepipeline-actions");return cp_actions=()=>tmp,tmp},core_1=()=>{var tmp=require("../../../core");return core_1=()=>tmp,tmp},blueprint_1=()=>{var tmp=require("../blueprint");return blueprint_1=()=>tmp,tmp};class CodePipelineSource extends blueprint_1().Step{constructor(){super(...arguments),this.isSource=!0}static gitHub(repoString,branch,props={}){try{jsiiDeprecationWarnings().aws_cdk_lib_pipelines_GitHubSourceOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.gitHub),error}return new GitHubSource(repoString,branch,props)}static s3(bucket,objectKey,props={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_s3_IBucket(bucket),jsiiDeprecationWarnings().aws_cdk_lib_pipelines_S3SourceOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.s3),error}return new S3Source(bucket,objectKey,props)}static ecr(repository,props={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ecr_IRepository(repository),jsiiDeprecationWarnings().aws_cdk_lib_pipelines_ECRSourceOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.ecr),error}return new ECRSource(repository,props)}static connection(repoString,branch,props){try{jsiiDeprecationWarnings().aws_cdk_lib_pipelines_ConnectionSourceOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.connection),error}return new CodeStarConnectionSource(repoString,branch,props)}static codeCommit(repository,branch,props={}){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_codecommit_IRepository(repository),jsiiDeprecationWarnings().aws_cdk_lib_pipelines_CodeCommitSourceOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.codeCommit),error}return new CodeCommitSource(repository,branch,props)}produceAction(stage,options){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_codepipeline_IStage(stage),jsiiDeprecationWarnings().aws_cdk_lib_pipelines_ProduceActionOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.produceAction),error}const output=options.artifacts.toCodePipeline(this.primaryOutput),action=this.getAction(output,options.actionName,options.runOrder,options.variablesNamespace);return stage.addAction(action),{runOrdersConsumed:1}}sourceAttribute(name){return(0,outputs_1().makeCodePipelineOutput)(this,name)}}exports.CodePipelineSource=CodePipelineSource,_a=JSII_RTTI_SYMBOL_1,CodePipelineSource[_a]={fqn:"aws-cdk-lib.pipelines.CodePipelineSource",version:"2.188.0"};class GitHubSource extends CodePipelineSource{constructor(repoString,branch,props){super(repoString),this.branch=branch,this.props=props;const parts=repoString.split("/");if(core_1().Token.isUnresolved(repoString)||parts.length!==2)throw new(core_1()).UnscopedValidationError(`GitHub repository name should be a resolved string like '<owner>/<repo>', got '${repoString}'`);this.owner=parts[0],this.repo=parts[1],this.authentication=props.authentication??core_1().SecretValue.secretsManager("github-token"),this.configurePrimaryOutput(new(blueprint_1()).FileSet("Source",this))}getAction(output,actionName,runOrder,variablesNamespace){return new(cp_actions()).GitHubSourceAction({output,actionName:this.props.actionName??actionName,runOrder,oauthToken:this.authentication,owner:this.owner,repo:this.repo,branch:this.branch,trigger:this.props.trigger,variablesNamespace})}}class S3Source extends CodePipelineSource{constructor(bucket,objectKey,props){super(constructs_1().Node.of(bucket).addr),this.bucket=bucket,this.objectKey=objectKey,this.props=props,this.configurePrimaryOutput(new(blueprint_1()).FileSet("Source",this))}getAction(output,_actionName,runOrder,variablesNamespace){return new(cp_actions()).S3SourceAction({output,actionName:this.props.actionName??this.bucket.bucketName,runOrder,bucketKey:this.objectKey,trigger:this.props.trigger,bucket:this.bucket,role:this.props.role,variablesNamespace})}}class ECRSource extends CodePipelineSource{constructor(repository,props){super(constructs_1().Node.of(repository).addr),this.repository=repository,this.props=props,this.configurePrimaryOutput(new(blueprint_1()).FileSet("Source",this))}getAction(output,_actionName,runOrder,variablesNamespace){const formattedRepositoryName=core_1().Fn.join("_",core_1().Fn.split("/",this.repository.repositoryName));return new(cp_actions()).EcrSourceAction({output,actionName:this.props.actionName??formattedRepositoryName,runOrder,repository:this.repository,imageTag:this.props.imageTag,variablesNamespace})}}class CodeStarConnectionSource extends CodePipelineSource{constructor(repoString,branch,props){if(super(repoString),this.branch=branch,this.props=props,!this.isValidRepoString(repoString))throw new(core_1()).UnscopedValidationError(`CodeStar repository name should be a resolved string like '<owner>/<repo>' or '<owner>/<group1>/<group2>/.../<repo>', got '${repoString}'`);const parts=repoString.split("/");this.owner=parts[0],this.repo=parts.slice(1).join("/"),this.configurePrimaryOutput(new(blueprint_1()).FileSet("Source",this))}isValidRepoString(repoString){if(core_1().Token.isUnresolved(repoString))return!1;const parts=repoString.split("/");return parts.length<2||parts.length>23?!1:parts.every(element=>element!=="")}getAction(output,actionName,runOrder,variablesNamespace){return new(cp_actions()).CodeStarConnectionsSourceAction({output,actionName:this.props.actionName??actionName,runOrder,connectionArn:this.props.connectionArn,owner:this.owner,repo:this.repo,branch:this.branch,codeBuildCloneOutput:this.props.codeBuildCloneOutput,triggerOnPush:this.props.triggerOnPush,variablesNamespace})}}class CodeCommitSource extends CodePipelineSource{constructor(repository,branch,props){super(core_1().Token.isUnresolved(repository.repositoryName)?constructs_1().Node.of(repository).addr:repository.repositoryName),this.repository=repository,this.branch=branch,this.props=props,this.configurePrimaryOutput(new(blueprint_1()).FileSet("Source",this))}getAction(output,_actionName,runOrder,variablesNamespace){return new(cp_actions()).CodeCommitSourceAction({output,actionName:this.props.actionName??this.repository.repositoryName,runOrder,branch:this.branch,trigger:this.props.trigger,repository:this.repository,eventRole:this.props.eventRole,codeBuildCloneOutput:this.props.codeBuildCloneOutput,variablesNamespace})}}
