import { IConstruct } from 'constructs';
import * as lambda from '../../../aws-lambda';
import * as logs from '../../../aws-logs';
import { IAspect, RemovalPolicy } from '../../../core/lib';
export declare const CUSTOM_RESOURCE_PROVIDER = "aws:cdk:is-custom-resource-handler-customResourceProvider";
export declare const CUSTOM_RESOURCE_SINGLETON = "aws:cdk:is-custom-resource-handler-singleton";
export declare const CUSTOM_RESOURCE_SINGLETON_LOG_GROUP = "aws:cdk:is-custom-resource-handler-logGroup";
export declare const CUSTOM_RESOURCE_SINGLETON_LOG_RETENTION = "aws:cdk:is-custom-resource-handler-logRetention";
export declare const CUSTOM_RESOURCE_RUNTIME_FAMILY = "aws:cdk:is-custom-resource-handler-runtime-family";
/**
 * Manages AWS-vended Custom Resources
 *
 * This feature is currently experimental.
 */
export declare class CustomResourceConfig {
    private readonly scope;
    /**
     * Returns the CustomResourceConfig for this scope.
     */
    static of(scope: IConstruct): CustomResourceConfig;
    private constructor();
    /**
     * Set the log retention of AWS-vended custom resource lambdas.
     *
     * This feature is currently experimental.
     */
    addLogRetentionLifetime(rentention: logs.RetentionDays): void;
    /**
     * Set the removal policy of AWS-vended custom resource logGroup.
     *
     * This feature is currently experimental.
     */
    addRemovalPolicy(removalPolicy: RemovalPolicy): void;
    /**
     * Set the runtime version on AWS-vended custom resources lambdas.
     *
     * This feature is currently experimental.
     */
    addLambdaRuntime(lambdaRuntime: lambda.Runtime): void;
}
/**
 * Manages log retention for AWS-vended custom resources.
 *
 * This feature is currently experimental.
 */
export declare class CustomResourceLogRetention implements IAspect {
    private readonly logRetention;
    constructor(setLogRetention: logs.RetentionDays);
    visit(node: IConstruct): void;
    private createLogGroup;
}
/**
 * Manages removal policy for AWS-vended custom resources.
 *
 * This feature is currently experimental.
 */
export declare class CustomResourceRemovalPolicy implements IAspect {
    private readonly removalPolicy;
    constructor(removalPolicy: RemovalPolicy);
    visit(node: IConstruct): void;
}
/**
 * Manages lambda runtime for AWS-vended custom resources.
 *
 * This feature is currently experimental.
 */
export declare class CustomResourceLambdaRuntime implements IAspect {
    private readonly lambdaRuntime;
    constructor(lambdaRuntime: lambda.Runtime);
    visit(node: IConstruct): void;
}
