"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.PolicyValidationReportFormatter=void 0;var os=()=>{var tmp=require("os");return os=()=>tmp,tmp},path=()=>{var tmp=require("path");return path=()=>tmp,tmp},table_1=()=>{var tmp=require("table");return table_1=()=>tmp,tmp},trace_1=()=>{var tmp=require("./trace");return trace_1=()=>tmp,tmp},report=()=>{var tmp=require("../report");return report=()=>tmp,tmp};class PolicyValidationReportFormatter{constructor(tree){this.tree=tree,this.reportTrace=new(trace_1()).ReportTrace(tree)}formatPrettyPrinted(reps){const json=this.formatJson(reps),output=[json.title];return output.push("-".repeat(json.title.length)),json.pluginReports.forEach(plugin=>{output.push(""),output.push((0,table_1().table)([[`Plugin: ${plugin.summary.pluginName}`],[`Version: ${plugin.version??"N/A"}`],[`Status: ${plugin.summary.status}`]],{header:{content:"Plugin Report"},singleLine:!0,columns:[{paddingLeft:3,paddingRight:3}]})),plugin.summary.metadata&&(output.push(""),output.push(`Metadata: 
	${Object.entries(plugin.summary.metadata).flatMap(([key,value])=>`${key}: ${value}`).join(`
	`)}`)),plugin.violations.length>0&&(output.push(""),output.push("(Violations)")),plugin.violations.forEach(violation=>{const constructs=violation.violatingConstructs,occurrences=constructs.length,title=reset(red(bright(`${violation.ruleName} (${occurrences} occurrences)`)));output.push(""),output.push(title),violation.severity&&output.push(`Severity: ${violation.severity}`),output.push(""),output.push("  Occurrences:");for(const construct of constructs)if(output.push(""),output.push(`    - Construct Path: ${construct.constructPath??"N/A"}`),output.push(`    - Template Path: ${construct.templatePath}`),output.push(`    - Creation Stack:
	${this.reportTrace.formatPrettyPrinted(construct.constructPath)}`),output.push(`    - Resource ID: ${construct.resourceLogicalId}`),construct.locations){output.push("    - Template Locations:");for(const location of construct.locations)output.push(`      > ${location}`)}output.push(""),output.push(`  Description: ${violation.description}`),violation.fix&&output.push(`  How to fix: ${violation.fix}`),violation.ruleMetadata&&output.push(`  Rule Metadata: 
	${Object.entries(violation.ruleMetadata).flatMap(([key,value])=>`${key}: ${value}`).join(`
	`)}`)})}),output.push(""),output.push("Policy Validation Report Summary"),output.push(""),output.push((0,table_1().table)([["Plugin","Status"],...reps.map(rep=>[rep.pluginName,rep.success?"success":"failure"])],{})),output.join(os().EOL)}formatJson(reps){return{title:"Validation Report",pluginReports:reps.filter(rep=>!rep.success).map(rep=>({version:rep.pluginVersion,summary:{pluginName:rep.pluginName,status:rep.success?report().PolicyValidationReportStatusBeta1.SUCCESS:report().PolicyValidationReportStatusBeta1.FAILURE,metadata:rep.metadata},violations:rep.violations.map(violation=>({ruleName:violation.ruleName,description:violation.description,fix:violation.fix,ruleMetadata:violation.ruleMetadata,severity:violation.severity,violatingResources:violation.violatingResources,violatingConstructs:violation.violatingResources.map(resource=>{const constructPath=this.tree.getConstructByLogicalId(path().basename(resource.templatePath),resource.resourceLogicalId)?.node.path;return{constructStack:this.reportTrace.formatJson(constructPath),constructPath,locations:resource.locations,resourceLogicalId:resource.resourceLogicalId,templatePath:resource.templatePath}})}))}))}}}exports.PolicyValidationReportFormatter=PolicyValidationReportFormatter;function reset(s){return`${s}\x1B[0m`}function red(s){return`\x1B[31m${s}`}function bright(s){return`\x1B[1m${s}`}
