"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Stack=exports.STACK_RESOURCE_LIMIT_CONTEXT=void 0,exports.rootPathTo=rootPathTo;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var fs=()=>{var tmp=require("fs");return fs=()=>tmp,tmp},path=()=>{var tmp=require("path");return path=()=>tmp,tmp},constructs_1=()=>{var tmp=require("constructs");return constructs_1=()=>tmp,tmp},annotations_1=()=>{var tmp=require("./annotations");return annotations_1=()=>tmp,tmp},app_1=()=>{var tmp=require("./app");return app_1=()=>tmp,tmp},arn_1=()=>{var tmp=require("./arn");return arn_1=()=>tmp,tmp},aspect_1=()=>{var tmp=require("./aspect");return aspect_1=()=>tmp,tmp},cfn_element_1=()=>{var tmp=require("./cfn-element");return cfn_element_1=()=>tmp,tmp},cfn_fn_1=()=>{var tmp=require("./cfn-fn");return cfn_fn_1=()=>tmp,tmp},cfn_pseudo_1=()=>{var tmp=require("./cfn-pseudo");return cfn_pseudo_1=()=>tmp,tmp},cfn_resource_1=()=>{var tmp=require("./cfn-resource");return cfn_resource_1=()=>tmp,tmp},context_provider_1=()=>{var tmp=require("./context-provider");return context_provider_1=()=>tmp,tmp},feature_flags_1=()=>{var tmp=require("./feature-flags");return feature_flags_1=()=>tmp,tmp},permissions_boundary_1=()=>{var tmp=require("./permissions-boundary");return permissions_boundary_1=()=>tmp,tmp},cloudformation_lang_1=()=>{var tmp=require("./private/cloudformation-lang");return cloudformation_lang_1=()=>tmp,tmp},logical_id_1=()=>{var tmp=require("./private/logical-id");return logical_id_1=()=>tmp,tmp},resolve_1=()=>{var tmp=require("./private/resolve");return resolve_1=()=>tmp,tmp},uniqueid_1=()=>{var tmp=require("./private/uniqueid");return uniqueid_1=()=>tmp,tmp},cxschema=()=>{var tmp=require("../../cloud-assembly-schema");return cxschema=()=>tmp,tmp},cx_api_1=()=>{var tmp=require("../../cx-api");return cx_api_1=()=>tmp,tmp},cxapi=()=>{var tmp=require("../../cx-api");return cxapi=()=>tmp,tmp},minimatch=()=>{var tmp=require("minimatch");return minimatch=()=>tmp,tmp};const STACK_SYMBOL=Symbol.for("@aws-cdk/core.Stack"),MY_STACK_CACHE=Symbol.for("@aws-cdk/core.Stack.myStack");exports.STACK_RESOURCE_LIMIT_CONTEXT="@aws-cdk/core:stackResourceLimit";const SUPPRESS_TEMPLATE_INDENTATION_CONTEXT="@aws-cdk/core:suppressTemplateIndentation",TEMPLATE_BODY_MAXIMUM_SIZE=1e6,VALID_STACK_NAME_REGEX=/^[A-Za-z][A-Za-z0-9-]*$/,MAX_RESOURCES=500;class Stack extends constructs_1().Construct{static isStack(x){return x!==null&&typeof x=="object"&&STACK_SYMBOL in x}static of(construct){const cache=construct[MY_STACK_CACHE];if(cache)return cache;{const value=_lookup(construct);return Object.defineProperty(construct,MY_STACK_CACHE,{enumerable:!1,writable:!1,configurable:!1,value}),value}function _lookup(c){if(Stack.isStack(c))return c;const _scope=constructs_1().Node.of(c).scope;if(stage_1().Stage.isStage(c)||!_scope)throw new Error(`${construct.constructor?.name??"Construct"} at '${constructs_1().Node.of(construct).path}' should be created in the scope of a Stack, but no Stack found`);return _lookup(_scope)}}get terminationProtection(){return this._terminationProtection}set terminationProtection(value){this._terminationProtection=value}constructor(scope,id,props={}){try{jsiiDeprecationWarnings().aws_cdk_lib_StackProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Stack),error}scope=scope??new(app_1()).App({autoSynth:!1,outdir:fs_1().FileSystem.mkdtemp("cdk-test-app-")}),id=id??"Default",super(scope,id),this._missingContext=new Array,this._stackDependencies={},this.templateOptions={},this._crossRegionReferences=!!props.crossRegionReferences,this._suppressTemplateIndentation=props.suppressTemplateIndentation??this.node.tryGetContext(SUPPRESS_TEMPLATE_INDENTATION_CONTEXT)??!1,Object.defineProperty(this,STACK_SYMBOL,{value:!0}),this._logicalIds=new(logical_id_1()).LogicalIDs;const{account,region,environment}=this.parseEnvironment(props.env);if(this.account=account,this.region=region,this.environment=environment,this._terminationProtection=props.terminationProtection??!1,props.description!==void 0){if(props.description.length>512)throw new Error(`Stack description must be <= 1024 bytes. Received description: '${props.description}'`);this.templateOptions.description=props.description}if(this._stackName=props.stackName??this.generateStackName(),this._stackName.length>128)throw new Error(`Stack name must be <= 128 characters. Stack name: '${this._stackName}'`);this.tags=new(tag_manager_1()).TagManager(cfn_resource_1().TagType.KEY_VALUE,"aws:cdk:stack",props.tags);for(const notificationArn of props.notificationArns??[])if(token_1().Token.isUnresolved(notificationArn))throw new Error(`Stack '${id}' includes one or more tokens in its notification ARNs: ${props.notificationArns}`);if(this._notificationArns=props.notificationArns,!VALID_STACK_NAME_REGEX.test(this.stackName))throw new Error(`Stack name must match the regular expression: ${VALID_STACK_NAME_REGEX.toString()}, got '${this.stackName}'`);const featureFlags=feature_flags_1().FeatureFlags.of(this),stackNameDupeContext=featureFlags.isEnabled(cxapi().ENABLE_STACK_NAME_DUPLICATES_CONTEXT),newStyleSynthesisContext=featureFlags.isEnabled(cxapi().NEW_STYLE_STACK_SYNTHESIS_CONTEXT),artifactId=stackNameDupeContext||newStyleSynthesisContext?this.generateStackArtifactId():this.stackName;this.artifactId=artifactId.replace(/[^A-Za-z0-9_\-\.]/g,"_"),this.templateFile=`${this.artifactId}.template.json`,this._versionReportingEnabled=(props.analyticsReporting??this.node.tryGetContext(cxapi().ANALYTICS_REPORTING_ENABLED_CONTEXT))&&!this.nestedStackParent;const synthesizer=props.synthesizer??this.node.tryGetContext(private_context_1().PRIVATE_CONTEXT_DEFAULT_STACK_SYNTHESIZER)??(newStyleSynthesisContext?new(stack_synthesizers_1()).DefaultStackSynthesizer:new(stack_synthesizers_1()).LegacyStackSynthesizer);(0,stack_synthesizers_1().isReusableStackSynthesizer)(synthesizer)?this.synthesizer=synthesizer.reusableBind(this):(this.synthesizer=synthesizer,this.synthesizer.bind(this)),props.permissionsBoundary?._bind(this),this.addPermissionsBoundaryAspect()}get permissionsBoundaryArn(){const qualifier=this.synthesizer.bootstrapQualifier??this.node.tryGetContext(stack_synthesizers_1().BOOTSTRAP_QUALIFIER_CONTEXT)??stack_synthesizers_1().DefaultStackSynthesizer.DEFAULT_QUALIFIER,spec=new(string_specializer_1()).StringSpecializer(this,qualifier),context=this.node.tryGetContext(permissions_boundary_1().PERMISSIONS_BOUNDARY_CONTEXT_KEY);let arn;if(context&&context.arn?arn=spec.specialize(context.arn):context&&context.name&&(arn=spec.specialize(this.formatArn({service:"iam",resource:"policy",region:"",resourceName:context.name}))),arn&&(arn.includes("${Qualifier}")||arn.includes("${AWS::AccountId}")||arn.includes("${AWS::Region}")||arn.includes("${AWS::Partition}")))throw new Error(`The permissions boundary ${arn} includes a pseudo parameter, which is not supported for environment agnostic stacks`);return arn}addPermissionsBoundaryAspect(){const permissionsBoundaryArn=this.permissionsBoundaryArn;permissionsBoundaryArn&&aspect_1().Aspects.of(this).add({visit(node){cfn_resource_1().CfnResource.isCfnResource(node)&&(node.cfnResourceType=="AWS::IAM::Role"||node.cfnResourceType=="AWS::IAM::User")&&node.addPropertyOverride("PermissionsBoundary",permissionsBoundaryArn)}},{priority:aspect_1().AspectPriority.MUTATING})}resolve(obj){return(0,resolve_1().resolve)(obj,{scope:this,prefix:[],resolver:cloudformation_lang_1().CLOUDFORMATION_TOKEN_RESOLVER,preparing:!1})}toJsonString(obj,space){return cloudformation_lang_1().CloudFormationLang.toJSON(obj,space).toString()}toYamlString(obj){return cloudformation_lang_1().CloudFormationLang.toYAML(obj).toString()}reportMissingContext(report){if(!Object.values(cxschema().ContextProvider).includes(report.provider))throw new Error(`Unknown context provider requested in: ${JSON.stringify(report)}`);this.reportMissingContextKey(report)}reportMissingContextKey(report){try{jsiiDeprecationWarnings().aws_cdk_lib_cloud_assembly_schema_MissingContext(report)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.reportMissingContextKey),error}this._missingContext.push(report)}renameLogicalId(oldId,newId){this._logicalIds.addRename(oldId,newId)}getLogicalId(element){try{jsiiDeprecationWarnings().aws_cdk_lib_CfnElement(element)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.getLogicalId),error}const logicalId=this.allocateLogicalId(element);return this._logicalIds.applyRename(logicalId)}addDependency(target,reason){try{jsiiDeprecationWarnings().aws_cdk_lib_Stack(target)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addDependency),error}(0,deps_1().addDependency)(this,target,reason??`{${this.node.path}}.addDependency({${target.node.path}})`)}get dependencies(){return Object.values(this._stackDependencies).map(x=>x.stack)}get stackName(){return this._stackName}get partition(){return!feature_flags_1().FeatureFlags.of(this).isEnabled(cxapi().ENABLE_PARTITION_LITERALS)||token_1().Token.isUnresolved(this.region)?cfn_pseudo_1().Aws.PARTITION:region_info_1().RegionInfo.get(this.region).partition??cfn_pseudo_1().Aws.PARTITION}get urlSuffix(){return cfn_pseudo_1().Aws.URL_SUFFIX}get stackId(){return new(cfn_pseudo_1()).ScopedAws(this).stackId}get notificationArns(){return new(cfn_pseudo_1()).ScopedAws(this).notificationArns}get nested(){return this.nestedStackResource!==void 0}formatArn(components){try{jsiiDeprecationWarnings().aws_cdk_lib_ArnComponents(components)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.formatArn),error}return arn_1().Arn.format(components,this)}parseArn(arn,sepIfToken="/",hasName=!0){return arn_1().Arn.parse(arn,sepIfToken,hasName)}splitArn(arn,arnFormat){try{jsiiDeprecationWarnings().aws_cdk_lib_ArnFormat(arnFormat)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.splitArn),error}return arn_1().Arn.split(arn,arnFormat)}get availabilityZones(){if(token_1().Token.isUnresolved(this.account)||token_1().Token.isUnresolved(this.region))return this.node.tryGetContext(cxapi().AVAILABILITY_ZONE_FALLBACK_CONTEXT_KEY)||[cfn_fn_1().Fn.select(0,cfn_fn_1().Fn.getAzs()),cfn_fn_1().Fn.select(1,cfn_fn_1().Fn.getAzs())];const value=context_provider_1().ContextProvider.getValue(this,{provider:cxschema().ContextProvider.AVAILABILITY_ZONE_PROVIDER,dummyValue:["dummy1a","dummy1b","dummy1c"]}).value;if(!Array.isArray(value))throw new Error(`Provider ${cxschema().ContextProvider.AVAILABILITY_ZONE_PROVIDER} expects a list`);return value}addFileAsset(asset){return this.synthesizer.addFileAsset(asset)}addDockerImageAsset(asset){return this.synthesizer.addDockerImageAsset(asset)}get nestedStackParent(){return this.nestedStackResource&&Stack.of(this.nestedStackResource)}get parentStack(){return this.nestedStackParent}addTransform(transform){this.templateOptions.transforms||(this.templateOptions.transforms=[]),this.templateOptions.transforms.push(transform)}addMetadata(key,value){this.templateOptions.metadata||(this.templateOptions.metadata={}),this.templateOptions.metadata[key]=value}_addAssemblyDependency(target,reason={}){if(this.nested||target.nested)throw new Error("Cannot add assembly-level dependencies for nested stacks");reason.source||(reason.source=this),reason.target||(reason.target=target),reason.description||(reason.description="no description provided");const cycle=target.stackDependencyReasons(this);if(cycle!==void 0){const cycleDescription=cycle.map(cycleReason=>cycleReason.description).join(", ");throw new Error(`'${target.node.path}' depends on '${this.node.path}' (${cycleDescription}). Adding this dependency (${reason.description}) would create a cyclic reference.`)}let dep=this._stackDependencies[names_1().Names.uniqueId(target)];dep||(dep=this._stackDependencies[names_1().Names.uniqueId(target)]={stack:target,reasons:[]});let existingReasons=new Set;dep.reasons.forEach(existingReason=>{existingReason.source==reason.source&&existingReason.target==reason.target&&existingReasons.add(existingReason)}),!(existingReasons.size>0)&&(dep.reasons.push(reason),process.env.CDK_DEBUG_DEPS&&console.error(`[CDK_DEBUG_DEPS] stack "${reason.source.node.path}" depends on "${reason.target.node.path}"`))}_obtainAssemblyDependencies(reasonFilter){if(!reasonFilter.source)throw new Error("reasonFilter.source must be defined!");let dependencies=new Set;return Object.values(this._stackDependencies).forEach(dep=>{dep.reasons.forEach(reason=>{if(reasonFilter.source==reason.source){if(!reason.target)throw new Error(`Encountered an invalid dependency target from source '${reasonFilter.source.node.path}'`);dependencies.add(reason.target)}})}),Array.from(dependencies)}_removeAssemblyDependency(target,reasonFilter={}){if(this.nested||target.nested)throw new Error("There cannot be assembly-level dependencies for nested stacks");reasonFilter.source||(reasonFilter.source=this),reasonFilter.target||(reasonFilter.target=target);let dep=this._stackDependencies[names_1().Names.uniqueId(target)];if(!dep)return;let matchedReasons=new Set;if(dep.reasons.forEach(reason=>{reasonFilter.source==reason.source&&reasonFilter.target==reason.target&&matchedReasons.add(reason)}),matchedReasons.size>1)throw new Error(`There cannot be more than one reason for dependency removal, found: ${matchedReasons}`);if(matchedReasons.size==0)return;let matchedReason=Array.from(matchedReasons)[0],index=dep.reasons.indexOf(matchedReason,0);dep.reasons.splice(index,1),dep.reasons.length==0&&delete this._stackDependencies[names_1().Names.uniqueId(target)],process.env.CDK_DEBUG_DEPS&&console.log(`[CDK_DEBUG_DEPS] stack "${this.node.path}" no longer depends on "${target.node.path}" because: ${reasonFilter}`)}_synthesizeTemplate(session,lookupRoleArn,lookupRoleExternalId,lookupRoleAdditionalOptions){const builder=session.assembly,template=this._toCloudFormation(),outPath=path().join(builder.outdir,this.templateFile);if(this.maxResources>0){const resources=template.Resources||{},numberOfResources=Object.keys(resources).length;if(numberOfResources>this.maxResources){const counts=Object.entries(count(Object.values(resources).map(r=>`${r?.Type}`))).map(([type,c])=>`${type} (${c})`).join(", ");throw new Error(`Number of resources in stack '${this.node.path}': ${numberOfResources} is greater than allowed maximum of ${this.maxResources}: ${counts}`)}else numberOfResources>=this.maxResources*.8&&annotations_1().Annotations.of(this).addInfo(`Number of resources: ${numberOfResources} is approaching allowed maximum of ${this.maxResources}`)}const indent=this._suppressTemplateIndentation?void 0:1,templateData=JSON.stringify(template,void 0,indent);if(templateData.length>TEMPLATE_BODY_MAXIMUM_SIZE*.8){const verb=templateData.length>TEMPLATE_BODY_MAXIMUM_SIZE?"exceeds":"is approaching",advice=this._suppressTemplateIndentation?"Split resources into multiple stacks to reduce template size":"Split resources into multiple stacks or set suppressTemplateIndentation to reduce template size",message=`Template size ${verb} limit: ${templateData.length}/${TEMPLATE_BODY_MAXIMUM_SIZE}. ${advice}.`;annotations_1().Annotations.of(this).addWarningV2("@aws-cdk/core:Stack.templateSize",message)}fs().writeFileSync(outPath,templateData);for(const ctx of this._missingContext){const queryLookupOptions={lookupRoleArn,lookupRoleExternalId,assumeRoleAdditionalOptions:lookupRoleAdditionalOptions};builder.addMissing({...ctx,props:{...ctx.props,...queryLookupOptions}})}}regionalFact(factName,defaultValue){if(!token_1().Token.isUnresolved(this.region)){const ret=region_info_1().Fact.find(this.region,factName)??defaultValue;if(ret===void 0)throw new Error(`region-info: don't know ${factName} for region ${this.region}. Use 'Fact.register' to provide this value.`);return ret}const partitions=constructs_1().Node.of(this).tryGetContext(cxapi().TARGET_PARTITIONS);if(partitions!==void 0&&partitions!=="undefined"&&!Array.isArray(partitions))throw new Error(`Context value '${cxapi().TARGET_PARTITIONS}' should be a list of strings, got: ${JSON.stringify(partitions)}`);const lookupMap=partitions!==void 0&&partitions!=="undefined"?region_info_1().RegionInfo.limitedRegionMap(factName,partitions):region_info_1().RegionInfo.regionMap(factName);return(0,region_lookup_1().deployTimeLookup)(this,factName,lookupMap,defaultValue)}exportValue(exportedValue,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_ExportValueOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.exportValue),error}if(options.name)return new(cfn_output_1()).CfnOutput(this,`Export${options.name}`,{value:exportedValue,exportName:options.name,description:options.description}),cfn_fn_1().Fn.importValue(options.name);const{exportName,exportsScope,id,exportable}=this.resolveExportedValue(exportedValue);exportsScope.node.tryFindChild(id)||new(cfn_output_1()).CfnOutput(exportsScope,id,{value:token_1().Token.asString(exportable),exportName,description:options.description});const importValue=cfn_fn_1().Fn.importValue(exportName);if(Array.isArray(importValue))throw new Error("Attempted to export a list value from `exportValue()`: use `exportStringListValue()` instead");return importValue}exportStringListValue(exportedValue,options={}){try{jsiiDeprecationWarnings().aws_cdk_lib_ExportValueOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.exportStringListValue),error}if(options.name)return new(cfn_output_1()).CfnOutput(this,`Export${options.name}`,{value:cfn_fn_1().Fn.join(refs_1().STRING_LIST_REFERENCE_DELIMITER,exportedValue),exportName:options.name,description:options.description}),cfn_fn_1().Fn.split(refs_1().STRING_LIST_REFERENCE_DELIMITER,cfn_fn_1().Fn.importValue(options.name));const{exportName,exportsScope,id,exportable}=this.resolveExportedValue(exportedValue);exportsScope.node.tryFindChild(id)||new(cfn_output_1()).CfnOutput(exportsScope,id,{value:cfn_fn_1().Fn.join(refs_1().STRING_LIST_REFERENCE_DELIMITER,token_1().Token.asList(exportable)),exportName,description:options.description});const importValue=cfn_fn_1().Fn.split(refs_1().STRING_LIST_REFERENCE_DELIMITER,cfn_fn_1().Fn.importValue(exportName));if(!Array.isArray(importValue))throw new Error("Attempted to export a string value from `exportStringListValue()`: use `exportValue()` instead");return importValue}allocateLogicalId(cfnElement){try{jsiiDeprecationWarnings().aws_cdk_lib_CfnElement(cfnElement)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.allocateLogicalId),error}const scopes=cfnElement.node.scopes,stackIndex=scopes.indexOf(cfnElement.stack),pathComponents=scopes.slice(stackIndex+1).map(x=>x.node.id);return(0,uniqueid_1().makeUniqueId)(pathComponents)}_validateId(name){if(name&&!VALID_STACK_NAME_REGEX.test(name))throw new Error(`Stack name must match the regular expression: ${VALID_STACK_NAME_REGEX.toString()}, got '${name}'`)}_toCloudFormation(){let transform;this.templateOptions.transform&&(annotations_1().Annotations.of(this).addWarningV2("@aws-cdk/core:stackDeprecatedTransform","This stack is using the deprecated `templateOptions.transform` property. Consider switching to `addTransform()`."),this.addTransform(this.templateOptions.transform)),this.templateOptions.transforms&&(this.templateOptions.transforms.length===1?transform=this.templateOptions.transforms[0]:transform=Array.from(new Set(this.templateOptions.transforms)));const template={Description:this.templateOptions.description,Transform:transform,AWSTemplateFormatVersion:this.templateOptions.templateFormatVersion,Metadata:this.templateOptions.metadata},fragments=cfnElements(this).map(e=>this.resolve(e._toCloudFormation()));for(const fragment of fragments)merge(template,fragment);const ret=this.resolve(template)||{};return this._logicalIds.assertAllRenamesApplied(),ret}prepareCrossReference(_sourceStack,reference){return reference}parseEnvironment(env={}){const containingAssembly=stage_1().Stage.of(this);if(env.account&&typeof env.account!="string")throw new Error(`Account id of stack environment must be a 'string' but received '${typeof env.account}'`);if(env.region&&typeof env.region!="string")throw new Error(`Region of stack environment must be a 'string' but received '${typeof env.region}'`);const account=env.account??containingAssembly?.account??cfn_pseudo_1().Aws.ACCOUNT_ID,region=env.region??containingAssembly?.region??cfn_pseudo_1().Aws.REGION,envAccount=token_1().Token.isUnresolved(account)?cxapi().UNKNOWN_ACCOUNT:account,envRegion=token_1().Token.isUnresolved(region)?cxapi().UNKNOWN_REGION:region;return{account,region,environment:cxapi().EnvironmentUtils.format(envAccount,envRegion)}}get maxResources(){const contextLimit=this.node.tryGetContext(exports.STACK_RESOURCE_LIMIT_CONTEXT);return contextLimit!==void 0?parseInt(contextLimit,10):MAX_RESOURCES}stackDependencyReasons(other){if(this===other)return[];for(const dep of Object.values(this._stackDependencies)){const ret=dep.stack.stackDependencyReasons(other);if(ret!==void 0)return[...dep.reasons,...ret]}}generateStackName(){const assembly=stage_1().Stage.of(this),prefix=assembly&&assembly.stageName?`${assembly.stageName}-`:"";return feature_flags_1().FeatureFlags.of(this).isEnabled(cx_api_1().INCLUDE_PREFIX_IN_UNIQUE_NAME_GENERATION)?`${this.generateStackId(assembly,prefix)}`:`${prefix}${this.generateStackId(assembly)}`}generateStackArtifactId(){return this.generateStackId(this.node.root)}generateStackId(container,prefix=""){const ids=rootPathTo(this,container).map(c=>constructs_1().Node.of(c).id);if(ids.length===1&&!ids[0])throw new Error("unexpected: stack id must always be defined");return makeStackName(ids,prefix)}resolveExportedValue(exportedValue){const resolvable=token_1().Tokenization.reverse(exportedValue);if(!resolvable||!reference_1().Reference.isReference(resolvable))throw new Error("exportValue: either supply 'name' or make sure to export a resource attribute (like 'bucket.bucketName')");const exportable=(0,refs_1().getExportable)(this,resolvable),exportsScope=getCreateExportsScope(this),resolved=this.resolve(exportable),id="Output"+JSON.stringify(resolved),exportName=generateExportName(exportsScope,id);if(token_1().Token.isUnresolved(exportName))throw new Error(`unresolved token in generated export name: ${JSON.stringify(this.resolve(exportName))}`);return{exportable,exportsScope,id,exportName}}get bundlingRequired(){return(this.node.tryGetContext(cxapi().BUNDLING_STACKS)??["**"]).some(pattern=>minimatch()(this.node.path,pattern))}}exports.Stack=Stack,_a=JSII_RTTI_SYMBOL_1,Stack[_a]={fqn:"aws-cdk-lib.Stack",version:"2.188.0"};function merge(template,fragment){for(const section of Object.keys(fragment)){const src=fragment[section],dest=template[section];dest?template[section]=mergeSection(section,dest,src):template[section]=src}}function mergeSection(section,val1,val2){switch(section){case"Description":return`${val1}
${val2}`;case"AWSTemplateFormatVersion":if(val1!=null&&val2!=null&&val1!==val2)throw new Error(`Conflicting CloudFormation template versions provided: '${val1}' and '${val2}`);return val1??val2;case"Transform":return mergeSets(val1,val2);default:return mergeObjectsWithoutDuplicates(section,val1,val2)}}function mergeSets(val1,val2){const array1=val1==null?[]:Array.isArray(val1)?val1:[val1],array2=val2==null?[]:Array.isArray(val2)?val2:[val2];for(const value of array2)array1.includes(value)||array1.push(value);return array1.length===1?array1[0]:array1}function mergeObjectsWithoutDuplicates(section,dest,src){if(typeof dest!="object")throw new Error(`Expecting ${JSON.stringify(dest)} to be an object`);if(typeof src!="object")throw new Error(`Expecting ${JSON.stringify(src)} to be an object`);for(const id of Object.keys(src)){if(id in dest)throw new Error(`section '${section}' already contains '${id}'`);dest[id]=src[id]}return dest}function cfnElements(node,into=[]){cfn_element_1().CfnElement.isCfnElement(node)&&into.push(node);for(const child of constructs_1().Node.of(node).children)Stack.isStack(child)||cfnElements(child,into);return into}function rootPathTo(construct,ancestor){const scopes=constructs_1().Node.of(construct).scopes;for(let i=scopes.length-2;i>=0;i--)if(scopes[i]===ancestor)return scopes.slice(i+1);return scopes}function makeStackName(components,prefix=""){if(components.length===1){const stack_name=prefix+components[0];if(stack_name.length<=128)return stack_name}return(0,unique_resource_name_1().makeUniqueResourceName)(components,{maxLength:128,prefix})}function getCreateExportsScope(stack){const exportsName="Exports";let stackExports=stack.node.tryFindChild(exportsName);return stackExports===void 0&&(stackExports=new(constructs_1()).Construct(stack,exportsName)),stackExports}function generateExportName(stackExports,id){const stackRelativeExports=feature_flags_1().FeatureFlags.of(stackExports).isEnabled(cxapi().STACK_RELATIVE_EXPORTS_CONTEXT),stack=Stack.of(stackExports),components=[...stackExports.node.scopes.slice(stackRelativeExports?stack.node.scopes.length:2).map(c=>c.node.id),id],prefix=stack.stackName?stack.stackName+":":"",localPart=(0,uniqueid_1().makeUniqueId)(components);return prefix+localPart.slice(Math.max(0,localPart.length-255+prefix.length))}function count(xs){const ret={};for(const x of xs)x in ret?ret[x]+=1:ret[x]=1;return ret}var cfn_output_1=()=>{var tmp=require("./cfn-output");return cfn_output_1=()=>tmp,tmp},deps_1=()=>{var tmp=require("./deps");return deps_1=()=>tmp,tmp},fs_1=()=>{var tmp=require("./fs");return fs_1=()=>tmp,tmp},names_1=()=>{var tmp=require("./names");return names_1=()=>tmp,tmp},reference_1=()=>{var tmp=require("./reference");return reference_1=()=>tmp,tmp},stack_synthesizers_1=()=>{var tmp=require("./stack-synthesizers");return stack_synthesizers_1=()=>tmp,tmp},string_specializer_1=()=>{var tmp=require("./helpers-internal/string-specializer");return string_specializer_1=()=>tmp,tmp},stage_1=()=>{var tmp=require("./stage");return stage_1=()=>tmp,tmp},tag_manager_1=()=>{var tmp=require("./tag-manager");return tag_manager_1=()=>tmp,tmp},token_1=()=>{var tmp=require("./token");return token_1=()=>tmp,tmp},refs_1=()=>{var tmp=require("./private/refs");return refs_1=()=>tmp,tmp},region_info_1=()=>{var tmp=require("../../region-info");return region_info_1=()=>tmp,tmp},region_lookup_1=()=>{var tmp=require("./private/region-lookup");return region_lookup_1=()=>tmp,tmp},unique_resource_name_1=()=>{var tmp=require("./private/unique-resource-name");return unique_resource_name_1=()=>tmp,tmp},private_context_1=()=>{var tmp=require("./private/private-context");return private_context_1=()=>tmp,tmp};
