"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.addStackArtifactToAssembly=addStackArtifactToAssembly,exports.contentHash=contentHash,exports.assertBound=assertBound;var crypto=()=>{var tmp=require("crypto");return crypto=()=>tmp,tmp},constructs_1=()=>{var tmp=require("constructs");return constructs_1=()=>tmp,tmp},cxschema=()=>{var tmp=require("../../../cloud-assembly-schema");return cxschema=()=>tmp,tmp},stack_1=()=>{var tmp=require("../stack");return stack_1=()=>tmp,tmp},token_1=()=>{var tmp=require("../token");return token_1=()=>tmp,tmp};function addStackArtifactToAssembly(session,stack,stackProps,additionalStackDependencies){const stackTags=stack.tags.tagValues();if(Object.entries(stackTags).length>0){const resolvedTags=Object.entries(stackTags).filter(([k,v])=>!(token_1().Token.isUnresolved(k)||token_1().Token.isUnresolved(v))),unresolvedTags=Object.entries(stackTags).filter(([k,v])=>token_1().Token.isUnresolved(k)||token_1().Token.isUnresolved(v));if(unresolvedTags.length>0){const rendered=unresolvedTags.map(([k,v])=>`${token_1().Token.isUnresolved(k)?"<TOKEN>":k}=${token_1().Token.isUnresolved(v)?"<TOKEN>":v}`).join(", ");stack.node.addMetadata(cxschema().ArtifactMetadataEntryType.WARN,`Ignoring stack tags that contain deploy-time values (found: ${rendered}). Apply tags containing deploy-time values to resources only, avoid tagging stacks (for example using { excludeResourceTypes: ['aws:cdk:stack'] }).`)}resolvedTags.length>0&&stack.node.addMetadata(cxschema().ArtifactMetadataEntryType.STACK_TAGS,resolvedTags.map(([key,value])=>({Key:key,Value:value})))}const deps=[...stack.dependencies.map(s=>s.artifactId),...additionalStackDependencies],meta=collectStackMetadata(stack),stackNameProperty=stack.stackName===stack.artifactId?{}:{stackName:stack.stackName},properties={templateFile:stack.templateFile,terminationProtection:stack.terminationProtection,tags:nonEmptyDict(stackTags),validateOnSynth:session.validateOnSynth,notificationArns:stack._notificationArns,...stackProps,...stackNameProperty};session.assembly.addArtifact(stack.artifactId,{type:cxschema().ArtifactType.AWS_CLOUDFORMATION_STACK,environment:stack.environment,properties,dependencies:deps.length>0?deps:void 0,metadata:Object.keys(meta).length>0?meta:void 0,displayName:stack.node.path})}function collectStackMetadata(stack){const output={};return visit(stack),output;function visit(node){if(findParentStack(node)===stack){node.node.metadata.length>0&&(output[constructs_1().Node.PATH_SEP+node.node.path]=node.node.metadata.map(md=>[cxschema().ArtifactMetadataEntryType.ERROR,cxschema().ArtifactMetadataEntryType.WARN,cxschema().ArtifactMetadataEntryType.INFO].includes(md.type)?md:stack.resolve(md)));for(const child of node.node.children)visit(child)}}function findParentStack(node){if(stack_1().Stack.isStack(node)&&node.nestedStackParent===void 0)return node;if(node.node.scope)return findParentStack(node.node.scope)}}function contentHash(content){return crypto().createHash("sha256").update(content).digest("hex")}function assertBound(x){if(x===null&&x===void 0)throw new Error("You must call bindStack() first")}function nonEmptyDict(xs){return Object.keys(xs).length>0?xs:void 0}
