"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.VALIDATION_SUCCESS=exports.ValidationResults=exports.ValidationResult=exports.numberToCloudFormation=exports.objectToCloudFormation=exports.booleanToCloudFormation=exports.stringToCloudFormation=void 0,exports.dateToCloudFormation=dateToCloudFormation,exports.cfnTagToCloudFormation=cfnTagToCloudFormation,exports.listMapper=listMapper,exports.hashMapper=hashMapper,exports.unionMapper=unionMapper,exports.canInspect=canInspect,exports.validateString=validateString,exports.validateNumber=validateNumber,exports.validateBoolean=validateBoolean,exports.validateDate=validateDate,exports.validateObject=validateObject,exports.validateCfnTag=validateCfnTag,exports.listValidator=listValidator,exports.hashValidator=hashValidator,exports.propertyValidator=propertyValidator,exports.requiredValidator=requiredValidator,exports.requireProperty=requireProperty,exports.unionValidator=unionValidator;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");function identity(x){return x}exports.stringToCloudFormation=identity,exports.booleanToCloudFormation=identity,exports.objectToCloudFormation=identity,exports.numberToCloudFormation=identity;function dateToCloudFormation(x){if(x)return`${x.getUTCFullYear()}-${pad(x.getUTCMonth()+1)}-${pad(x.getUTCDate())}T${pad(x.getUTCHours())}:${pad(x.getUTCMinutes())}:${pad(x.getUTCSeconds())}Z`}function pad(x){return x<10?"0"+x.toString():x.toString()}function cfnTagToCloudFormation(x){return canInspect(x)?{Key:x.key,Value:x.value}:x}function listMapper(elementMapper){return x=>canInspect(x)?x.map(elementMapper):x}function hashMapper(elementMapper){return x=>{if(!canInspect(x))return x;const ret={};return Object.keys(x).forEach(key=>{ret[key]=elementMapper(x[key])}),ret}}function unionMapper(validators,mappers){if(validators.length!==mappers.length)throw Error("Not the same amount of validators and mappers passed to unionMapper()");return x=>{if(!canInspect(x))return x;for(let i=0;i<validators.length;i++)if(validators[i](x).isSuccess)return mappers[i](x);throw new TypeError("No validators matched in the union()")}}class ValidationResult{constructor(errorMessage="",results=new ValidationResults){this.errorMessage=errorMessage,this.results=results;try{jsiiDeprecationWarnings().aws_cdk_lib_ValidationResults(results)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,ValidationResult),error}}get isSuccess(){return!this.errorMessage&&this.results.isSuccess}assertSuccess(){if(!this.isSuccess){let message=this.errorTree();throw message=message.slice(0,1).toUpperCase()+message.slice(1),new CfnSynthesisError(message)}}errorTree(){const childMessages=this.results.errorTreeList();return this.errorMessage+(childMessages.length?`
  ${childMessages.replace(/\n/g,`
  `)}`:"")}prefix(message){return this.isSuccess?this:new ValidationResult(`${message}: ${this.errorMessage}`,this.results)}}exports.ValidationResult=ValidationResult,_a=JSII_RTTI_SYMBOL_1,ValidationResult[_a]={fqn:"aws-cdk-lib.ValidationResult",version:"2.188.0"};class ValidationResults{constructor(results=[]){this.results=results}collect(result){try{jsiiDeprecationWarnings().aws_cdk_lib_ValidationResult(result)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.collect),error}result.isSuccess||this.results.push(result)}get isSuccess(){return this.results.every(x=>x.isSuccess)}errorTreeList(){return this.results.map(child=>child.errorTree()).join(`
`)}wrap(message){return this.isSuccess?exports.VALIDATION_SUCCESS:new ValidationResult(message,this)}}exports.ValidationResults=ValidationResults,_b=JSII_RTTI_SYMBOL_1,ValidationResults[_b]={fqn:"aws-cdk-lib.ValidationResults",version:"2.188.0"},exports.VALIDATION_SUCCESS=new ValidationResult;function canInspect(x){return x!=null&&!isCloudFormationIntrinsic(x)&&!isCloudFormationDynamicReference(x)}function validateString(x){return canInspect(x)&&typeof x!="string"?new ValidationResult(`${JSON.stringify(x)} should be a string`):exports.VALIDATION_SUCCESS}function validateNumber(x){return canInspect(x)&&typeof x!="number"?new ValidationResult(`${JSON.stringify(x)} should be a number`):exports.VALIDATION_SUCCESS}function validateBoolean(x){return canInspect(x)&&typeof x!="boolean"?new ValidationResult(`${JSON.stringify(x)} should be a boolean`):exports.VALIDATION_SUCCESS}function validateDate(x){return canInspect(x)&&!(x instanceof Date)?new ValidationResult(`${JSON.stringify(x)} should be a Date`):x!==void 0&&isNaN(x.getTime())?new ValidationResult("got an unparseable Date"):exports.VALIDATION_SUCCESS}function validateObject(x){return canInspect(x)&&typeof x!="object"?new ValidationResult(`${JSON.stringify(x)} should be an 'object'`):exports.VALIDATION_SUCCESS}function validateCfnTag(x){return canInspect(x)&&(x.key==null||x.value==null)?new ValidationResult(`${JSON.stringify(x)} should have a 'key' and a 'value' property`):exports.VALIDATION_SUCCESS}function listValidator(elementValidator){return x=>{if(!canInspect(x))return exports.VALIDATION_SUCCESS;if(!x.forEach)return new ValidationResult(`${JSON.stringify(x)} should be a list`);for(let i=0;i<x.length;i++){const element=x[i],result=elementValidator(element);if(!result.isSuccess)return result.prefix(`element ${i}`)}return exports.VALIDATION_SUCCESS}}function hashValidator(elementValidator){return x=>{if(!canInspect(x))return exports.VALIDATION_SUCCESS;for(const key of Object.keys(x)){const result=elementValidator(x[key]);if(!result.isSuccess)return result.prefix(`element '${key}'`)}return exports.VALIDATION_SUCCESS}}function propertyValidator(propName,validator){return x=>validator(x).prefix(propName)}function requiredValidator(x){return x==null?new ValidationResult("required but missing"):exports.VALIDATION_SUCCESS}function requireProperty(props,name,context){const value=props[name];if(value==null)throw new Error(`${context.toString()} is missing required property: ${name}`);return value}function unionValidator(...validators){return x=>{const results=new ValidationResults;let eitherOr="either";for(const validator of validators){const result=validator(x);if(result.isSuccess)return result;results.collect(result.prefix(eitherOr)),eitherOr="or"}return results.wrap("not one of the possible types")}}function isCloudFormationIntrinsic(x){if(typeof x!="object")return!1;const keys=Object.keys(x);return keys.length!==1?!1:keys[0]==="Ref"||keys[0].slice(0,4)==="Fn::"}function isCloudFormationDynamicReference(x){return typeof x=="string"&&x.startsWith("{{resolve:")&&x.endsWith("}}")}class CfnSynthesisError extends Error{constructor(){super(...arguments),this.type="CfnSynthesisError"}}
