"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.STRING_LIST_REFERENCE_DELIMITER=void 0,exports.resolveReferences=resolveReferences,exports.getExportable=getExportable,exports.referenceNestedStackValueInParent=referenceNestedStackValueInParent;var cfn_reference_1=()=>{var tmp=require("./cfn-reference");return cfn_reference_1=()=>tmp,tmp},resolve_1=()=>{var tmp=require("./resolve");return resolve_1=()=>tmp,tmp},uniqueid_1=()=>{var tmp=require("./uniqueid");return uniqueid_1=()=>tmp,tmp},cxapi=()=>{var tmp=require("../../../cx-api");return cxapi=()=>tmp,tmp},cfn_element_1=()=>{var tmp=require("../cfn-element");return cfn_element_1=()=>tmp,tmp},cfn_fn_1=()=>{var tmp=require("../cfn-fn");return cfn_fn_1=()=>tmp,tmp},cfn_output_1=()=>{var tmp=require("../cfn-output");return cfn_output_1=()=>tmp,tmp},cfn_parameter_1=()=>{var tmp=require("../cfn-parameter");return cfn_parameter_1=()=>tmp,tmp},export_writer_provider_1=()=>{var tmp=require("../custom-resource-provider/cross-region-export-providers/export-writer-provider");return export_writer_provider_1=()=>tmp,tmp},names_1=()=>{var tmp=require("../names");return names_1=()=>tmp,tmp},stack_1=()=>{var tmp=require("../stack");return stack_1=()=>tmp,tmp},token_1=()=>{var tmp=require("../token");return token_1=()=>tmp,tmp},type_hints_1=()=>{var tmp=require("../type-hints");return type_hints_1=()=>tmp,tmp};exports.STRING_LIST_REFERENCE_DELIMITER="||";function resolveReferences(scope){const edges=findAllReferences(scope);for(const{source,value}of edges){const consumer=stack_1().Stack.of(source);if(!value.hasValueForStack(consumer)){const resolved=resolveValue(consumer,value);value.assignValueForStack(consumer,resolved)}}}function resolveValue(consumer,reference){const producer=stack_1().Stack.of(reference.target),producerAccount=token_1().Token.isUnresolved(producer.account)?cxapi().UNKNOWN_ACCOUNT:producer.account,producerRegion=token_1().Token.isUnresolved(producer.region)?cxapi().UNKNOWN_REGION:producer.region,consumerAccount=token_1().Token.isUnresolved(consumer.account)?cxapi().UNKNOWN_ACCOUNT:consumer.account,consumerRegion=token_1().Token.isUnresolved(consumer.region)?cxapi().UNKNOWN_REGION:consumer.region;if(producer===consumer)return reference;if(producer.node.root!==consumer.node.root)throw new Error("Cannot reference across apps. Consuming and producing stacks must be defined within the same CDK app.");if(producerAccount!==consumerAccount)throw new Error(`Stack "${consumer.node.path}" cannot reference ${renderReference(reference)} in stack "${producer.node.path}". Cross stack references are only supported for stacks deployed to the same account or between nested stacks and their parent stack`);if(producerRegion!==consumerRegion&&!consumer._crossRegionReferences)throw new Error(`Stack "${consumer.node.path}" cannot reference ${renderReference(reference)} in stack "${producer.node.path}". Cross stack references are only supported for stacks deployed to the same environment or between nested stacks and their parent stack. Set crossRegionReferences=true to enable cross region references`);if(consumer.nestedStackParent&&isNested(consumer,producer)){const parameterValue=resolveValue(consumer.nestedStackParent,reference);return createNestedStackParameter(consumer,reference,parameterValue)}if(producer.nested){const outputValue=createNestedStackOutput(producer,reference),resolvedValue=resolveValue(consumer,outputValue);return reference.typeHint===type_hints_1().ResolutionTypeHint.STRING_LIST?token_1().Tokenization.reverseList(cfn_fn_1().Fn.split(exports.STRING_LIST_REFERENCE_DELIMITER,token_1().Token.asString(resolvedValue))):resolvedValue}if(producerRegion!==consumerRegion&&consumer._crossRegionReferences){if(producerRegion===cxapi().UNKNOWN_REGION||consumerRegion===cxapi().UNKNOWN_REGION)throw new Error(`Stack "${consumer.node.path}" cannot reference ${renderReference(reference)} in stack "${producer.node.path}". Cross stack/region references are only supported for stacks with an explicit region defined. `);return consumer.addDependency(producer,`${consumer.node.path} -> ${reference.target.node.path}.${reference.displayName}`),createCrossRegionImportValue(reference,consumer)}return consumer.addDependency(producer,`${consumer.node.path} -> ${reference.target.node.path}.${reference.displayName}`),createImportValue(reference)}function renderReference(ref){return`{${ref.target.node.path}[${ref.displayName}]}`}function findAllReferences(root){const result=new Array;for(const consumer of root.node.findAll())if(cfn_element_1().CfnElement.isCfnElement(consumer))try{const tokens=(0,resolve_1().findTokens)(consumer,()=>consumer._toCloudFormation());for(const token of tokens)cfn_reference_1().CfnReference.isCfnReference(token)&&result.push({source:consumer,value:token})}catch(e){if(e.type==="CfnSynthesisError")continue;throw e}return result}function createImportValue(reference){const exportingStack=stack_1().Stack.of(reference.target);let importExpr;return reference.typeHint===type_hints_1().ResolutionTypeHint.STRING_LIST?(importExpr=exportingStack.exportStringListValue(reference),token_1().Tokenization.reverseList(importExpr)):(importExpr=exportingStack.exportValue(reference),token_1().Tokenization.reverseCompleteString(importExpr))}function createCrossRegionImportValue(reference,importStack){const referenceStack=stack_1().Stack.of(reference.target),exportingStack=referenceStack.nestedStackParent??referenceStack,exportable=getExportable(exportingStack,reference),id=JSON.stringify(exportingStack.resolve(exportable)),exportName=generateExportName(importStack,reference,id);if(token_1().Token.isUnresolved(exportName))throw new Error(`unresolved token in generated export name: ${JSON.stringify(exportingStack.resolve(exportName))}`);const writerConstructName=(0,uniqueid_1().makeUniqueId)(["ExportsWriter",importStack.region]),exported=export_writer_provider_1().ExportWriter.getOrCreate(exportingStack,writerConstructName,{region:importStack.region}).exportValue(exportName,reference,importStack);return importStack.nestedStackParent?createNestedStackParameter(importStack,exported,exported):exported}function generateExportName(importStack,reference,id){const referenceStack=stack_1().Stack.of(reference.target),components=[referenceStack.stackName??"",referenceStack.region,id],prefix=`${importStack.nestedStackParent?.stackName??importStack.stackName}/`,localPart=(0,uniqueid_1().makeUniqueId)(components);return prefix+localPart.slice(Math.max(0,localPart.length-900+prefix.length))}function getExportable(stack,reference){return cfn_element_1().CfnElement.isCfnElement(reference.target)&&reference.target._lockLogicalId(),referenceNestedStackValueInParent(reference,stack)}function createNestedStackParameter(nested,reference,value){const paramId=generateUniqueId(nested,reference,"reference-to-");let param=nested.node.tryFindChild(paramId);if(!param){if(param=new(cfn_parameter_1()).CfnParameter(nested,paramId,{type:"String"}),!("setParameter"in nested))throw new Error('assertion failed: nested stack should have a "setParameter" method');nested.setParameter(param.logicalId,token_1().Token.asString(value))}return param.value}function createNestedStackOutput(producer,reference){const outputId=generateUniqueId(producer,reference);let output=producer.node.tryFindChild(outputId);if(output||(reference.typeHint===type_hints_1().ResolutionTypeHint.STRING_LIST?output=new(cfn_output_1()).CfnOutput(producer,outputId,{value:cfn_fn_1().Fn.join(exports.STRING_LIST_REFERENCE_DELIMITER,token_1().Token.asList(reference))}):output=new(cfn_output_1()).CfnOutput(producer,outputId,{value:token_1().Token.asString(reference)})),!producer.nestedStackResource)throw new Error("assertion failed");return producer.nestedStackResource.getAtt(`Outputs.${output.logicalId}`)}function referenceNestedStackValueInParent(reference,targetStack){let currentStack=stack_1().Stack.of(reference.target);if(currentStack!==targetStack&&!isNested(currentStack,targetStack))throw new Error(`Referenced resource must be in stack '${targetStack.node.path}', got '${reference.target.node.path}'`);const isNestedListReference=currentStack!==targetStack&&reference.typeHint===type_hints_1().ResolutionTypeHint.STRING_LIST;for(;currentStack!==targetStack;)reference=createNestedStackOutput(stack_1().Stack.of(reference.target),reference),currentStack=stack_1().Stack.of(reference.target);return isNestedListReference?token_1().Tokenization.reverseList(cfn_fn_1().Fn.split(exports.STRING_LIST_REFERENCE_DELIMITER,token_1().Token.asString(reference))):reference}function isNested(nested,parent){return nested.nestedStackParent===parent?!0:nested.nestedStackParent?isNested(nested.nestedStackParent,parent):!1}function generateUniqueId(stack,ref,prefix=""){return stack.resolve(`${prefix}${names_1().Names.nodeUniqueId(ref.target.node)}${ref.displayName}`)}
