"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.MetadataResource=void 0,exports.formatAnalytics=formatAnalytics;var zlib=()=>{var tmp=require("zlib");return zlib=()=>tmp,tmp},constructs_1=()=>{var tmp=require("constructs");return constructs_1=()=>tmp,tmp},runtime_info_1=()=>{var tmp=require("./runtime-info");return runtime_info_1=()=>tmp,tmp},cxapi=()=>{var tmp=require("../../../cx-api");return cxapi=()=>tmp,tmp},region_info_1=()=>{var tmp=require("../../../region-info");return region_info_1=()=>tmp,tmp},cfn_condition_1=()=>{var tmp=require("../cfn-condition");return cfn_condition_1=()=>tmp,tmp},cfn_fn_1=()=>{var tmp=require("../cfn-fn");return cfn_fn_1=()=>tmp,tmp},cfn_pseudo_1=()=>{var tmp=require("../cfn-pseudo");return cfn_pseudo_1=()=>tmp,tmp},cfn_resource_1=()=>{var tmp=require("../cfn-resource");return cfn_resource_1=()=>tmp,tmp},feature_flags_1=()=>{var tmp=require("../feature-flags");return feature_flags_1=()=>tmp,tmp},lazy_1=()=>{var tmp=require("../lazy");return lazy_1=()=>tmp,tmp},token_1=()=>{var tmp=require("../token");return token_1=()=>tmp,tmp};class MetadataResource extends constructs_1().Construct{constructor(scope,id){super(scope,id);const metadataServiceExists=token_1().Token.isUnresolved(scope.region)||region_info_1().RegionInfo.get(scope.region).cdkMetadataResourceAvailable,enableAdditionalTelemtry=feature_flags_1().FeatureFlags.of(scope).isEnabled(cxapi().ENABLE_ADDITIONAL_METADATA_COLLECTION)??!1;if(metadataServiceExists){const constructInfo=(0,runtime_info_1().constructInfoFromStack)(scope),resource=new(cfn_resource_1()).CfnResource(this,"Default",{type:"AWS::CDK::Metadata",properties:{Analytics:lazy_1().Lazy.string({produce:()=>formatAnalytics(constructInfo,enableAdditionalTelemtry)})}});if(token_1().Token.isUnresolved(scope.region)){const condition=new(cfn_condition_1()).CfnCondition(this,"Condition",{expression:makeCdkMetadataAvailableCondition()});condition.overrideLogicalId("CDKMetadataAvailable"),resource.cfnOptions.condition=condition}}}}exports.MetadataResource=MetadataResource;function makeCdkMetadataAvailableCondition(){return cfn_fn_1().Fn.conditionOr(...region_info_1().RegionInfo.regions.filter(ri=>ri.cdkMetadataResourceAvailable).map(ri=>cfn_fn_1().Fn.conditionEquals(cfn_pseudo_1().Aws.REGION,ri.name)))}class Trie extends Map{}function formatAnalytics(infos,enableAdditionalTelemtry=!1){const trie=new Trie;enableAdditionalTelemtry?infos.forEach(info=>insertFqnInTrie(`${info.version}!${info.fqn}`,trie,info.metadata)):infos.forEach(info=>insertFqnInTrie(`${info.version}!${info.fqn}`,trie));const plaintextEncodedConstructs=prefixEncodeTrie(trie),compressedConstructsBuffer=zlib().gzipSync(Buffer.from(plaintextEncodedConstructs));setGzipOperatingSystemToUnknown(compressedConstructsBuffer);const analyticsString=`v2:deflate64:${compressedConstructsBuffer.toString("base64")}`;if(process.env.CDK_CONTEXT_JSON&&JSON.parse(process.env.CDK_CONTEXT_JSON)["cdk-migrate"]){const compressedAppInfo=zlib().gzipSync(Buffer.from("cdk-migrate")).toString("base64");analyticsString.concat(":",compressedAppInfo)}return analyticsString}function insertFqnInTrie(fqn,trie,metadata){for(const fqnPart of fqn.replace(/[^a-z0-9]/gi,"$& ").split(" ")){const nextLevelTreeRef=trie.get(fqnPart)??new Trie;trie.set(fqnPart,nextLevelTreeRef),trie=nextLevelTreeRef}return metadata&&trie.set(JSON.stringify(metadata),new Trie),trie}function prefixEncodeTrie(trie){let prefixEncoded="",isFirstEntryAtLevel=!0;return[...trie.entries()].forEach(([key,value])=>{isFirstEntryAtLevel||(prefixEncoded+=","),isFirstEntryAtLevel=!1,prefixEncoded+=key,value.size>1?(prefixEncoded+="{",prefixEncoded+=prefixEncodeTrie(value),prefixEncoded+="}"):prefixEncoded+=prefixEncodeTrie(value)}),prefixEncoded}function setGzipOperatingSystemToUnknown(gzipBuffer){if(gzipBuffer[0]!==31||gzipBuffer[1]!==139)throw new Error("Expecting a gzip buffer (must start with 0x1f8b)");gzipBuffer[9]=255}
