"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.MetadataType=void 0,exports.addConstructMetadata=addConstructMetadata,exports.addMethodMetadata=addMethodMetadata,exports.MethodMetadata=MethodMetadata,exports.addMetadata=addMetadata,exports.isResource=isResource,exports.redactMetadata=redactMetadata,exports.redactTelemetryDataHelper=redactTelemetryDataHelper,exports.isEnumValue=isEnumValue;var constructs_1=()=>{var tmp=require("constructs");return constructs_1=()=>tmp,tmp},classes_1=()=>{var tmp=require("./analytics-data-source/classes");return classes_1=()=>tmp,tmp},enums_1=()=>{var tmp=require("./analytics-data-source/enums");return enums_1=()=>tmp,tmp},annotations_1=()=>{var tmp=require("./annotations");return annotations_1=()=>tmp,tmp},constants_1=()=>{var tmp=require("./constants");return constants_1=()=>tmp,tmp},feature_flags_1=()=>{var tmp=require("./feature-flags");return feature_flags_1=()=>tmp,tmp},token_1=()=>{var tmp=require("./token");return token_1=()=>tmp,tmp},cx_api_1=()=>{var tmp=require("../../cx-api");return cx_api_1=()=>tmp,tmp},MetadataType;(function(MetadataType2){MetadataType2.CONSTRUCT="aws:cdk:analytics:construct",MetadataType2.METHOD="aws:cdk:analytics:method",MetadataType2.FEATURE_FLAG="aws:cdk:analytics:featureflag"})(MetadataType||(exports.MetadataType=MetadataType={}));function addConstructMetadata(scope,props){try{addMetadata(scope,MetadataType.CONSTRUCT,props)}catch(e){annotations_1().Annotations.of(scope).addWarningV2("@aws-cdk/core:addConstructMetadataFailed",`Failed to add construct metadata for node [${scope.node.id}]. Reason: ${e}`)}}function addMethodMetadata(scope,methodName,props){try{addMetadata(scope,MetadataType.METHOD,{[methodName]:props})}catch(e){annotations_1().Annotations.of(scope).addWarningV2("@aws-cdk/core:addMethodMetadataFailed",`Failed to add method metadata for node [${scope.node.id}], method name ${methodName}. Reason: ${e}`)}}function MethodMetadata(){return function(_,propertyKey,descriptor){if(!descriptor||typeof descriptor.value!="function")return descriptor;const originalMethod=descriptor.value;return descriptor.value=function(...args){const scope=this;return scope instanceof constructs_1().Construct&&addMethodMetadata(scope,propertyKey.toString(),args),originalMethod.apply(this,args)},descriptor}}function addMetadata(scope,type,props){if(!(feature_flags_1().FeatureFlags.of(scope).isEnabled(cx_api_1().ENABLE_ADDITIONAL_METADATA_COLLECTION)??!1))return;const fqn=Object.getPrototypeOf(scope).constructor[constants_1().JSII_RUNTIME_SYMBOL].fqn;scope.node.addMetadata(type,redactMetadata(fqn,props))}function isResource(construct){return construct!==null&&typeof construct=="object"&&constants_1().RESOURCE_SYMBOL in construct}function redactMetadata(fqn,data){const fqnParts=fqn.replace(/[-_]/g,"-").split(".");if(fqnParts.length!==3)return"*";const module2=fqnParts.slice(0,2).join("."),name=fqnParts[2];if(!Object.keys(classes_1().AWS_CDK_CONSTRUCTOR_PROPS).includes(module2)||!Object.keys(classes_1().AWS_CDK_CONSTRUCTOR_PROPS[module2]).includes(name))return"*";const allowedKeys=classes_1().AWS_CDK_CONSTRUCTOR_PROPS[module2][name];return redactTelemetryDataHelper(allowedKeys,data)}function redactTelemetryDataHelper(allowedKeys,data){if(allowedKeys===void 0)return"*";if(typeof data=="boolean"||isEnumValue(allowedKeys,data))return data;if(typeof data=="string"||typeof data=="number"||data&&token_1().Token.isUnresolved(data))return"*";if(Array.isArray(data))return data.map((item,index)=>Array.isArray(allowedKeys)?redactTelemetryDataHelper(allowedKeys[index],item):redactTelemetryDataHelper(allowedKeys,item));if(data&&Object.keys(data).length>0&&typeof data=="object"){if(constructs_1().Construct.isConstruct(data))return"*";const redactedResult={};for(const[key,value]of Object.entries(data))if(!(key&&token_1().Token.isUnresolved(key))&&allowedKeys&&typeof allowedKeys=="object"){if(!Object.keys(allowedKeys).includes(key))continue;if(allowedKeys[key]==="*"){redactedResult[key]="*";continue}redactedResult[key]=redactTelemetryDataHelper(allowedKeys[key],value)}return redactedResult}return"*"}function isEnumValue(allowedKeys,value){return typeof allowedKeys!="string"||allowedKeys==="*"||!Object.keys(enums_1().AWS_CDK_ENUMS).includes(allowedKeys)?!1:enums_1().AWS_CDK_ENUMS[allowedKeys].includes(value)}
