import { Construct } from 'constructs';
/**
 */
export interface GetContextKeyOptions {
    /**
     * The context provider to query.
     */
    readonly provider: string;
    /**
     * Provider-specific properties.
     */
    readonly props?: {
        [key: string]: any;
    };
    /**
     * Whether to include the stack's account and region automatically.
     *
     * @default true
     */
    readonly includeEnvironment?: boolean;
}
/**
 */
export interface GetContextValueOptions extends GetContextKeyOptions {
    /**
     * The value to return if the lookup has not yet been performed.
     *
     * Upon first synthesis, the lookups has not yet been performed. The
     * `getValue()` operation returns this value instead, so that synthesis can
     * proceed. After synthesis completes the first time, the actual lookup will
     * be performed and synthesis will run again with the *real* value.
     *
     * Dummy values should preferably have valid shapes so that downstream
     * consumers of lookup values don't throw validation exceptions if they
     * encounter a dummy value (or all possible downstream consumers need to
     * effectively check for the well-known shape of the dummy value); throwing an
     * exception would error out the synthesis operation and prevent the lookup
     * and the second, real, synthesis from happening.
     *
     * ## Connection to mustExist
     *
     * `dummyValue` is also used as the official value to return if the lookup has
     * failed and `mustExist == false`.
     */
    readonly dummyValue: any;
    /**
     * Whether the resource must exist
     *
     * If this is set (the default), the query fails if the value or resource we
     * tried to look up doesn't exist.
     *
     * If this is `false` and the value we tried to look up could not be found, the
     * failure is suppressed and `dummyValue` is officially returned instead.
     *
     * When this happens, `dummyValue` is encoded into cached context and it will
     * never be refreshed anymore until the user runs `cdk context --reset <key>`.
     *
     * Note that it is not possible for the CDK app code to make a distinction
     * between "the lookup has not been performed yet" and "the lookup didn't
     * find anything and we returned a default value instead".
     *
     * ## Context providers
     *
     * This feature must explicitly be supported by context providers. It is
     * currently supported by:
     *
     * - KMS key provider
     * - SSM parameter provider
     *
     * ## Note to implementors
     *
     * The dummy value should not be returned for all SDK lookup failures. For
     * example, "no network" or "no credentials" or "malformed query" should
     * not lead to the dummy value being returned. Only the case of "no such
     * resource" should.
     *
     * @default true
     */
    readonly mustExist?: boolean;
    /**
     * Ignore a lookup failure and return the `dummyValue` instead
     *
     * `mustExist` is the recommended alias for this deprecated
     * property (note that its value is reversed).
     *
     * @default false
     * @deprecated Use mustExist instead
     */
    readonly ignoreErrorOnMissingContext?: boolean;
}
/**
 */
export interface GetContextKeyResult {
    readonly key: string;
    readonly props: {
        [key: string]: any;
    };
}
/**
 */
export interface GetContextValueResult {
    readonly value?: any;
}
/**
 * Base class for the model side of context providers
 *
 * Instances of this class communicate with context provider plugins in the 'cdk
 * toolkit' via context variables (input), outputting specialized queries for
 * more context variables (output).
 *
 * ContextProvider needs access to a Construct to hook into the context mechanism.
 *
 */
export declare class ContextProvider {
    /**
     * @returns the context key or undefined if a key cannot be rendered (due to tokens used in any of the props)
     */
    static getKey(scope: Construct, options: GetContextKeyOptions): GetContextKeyResult;
    static getValue(scope: Construct, options: GetContextValueOptions): GetContextValueResult;
    private constructor();
}
