import { Construct } from 'constructs';
import * as iam from '../../../aws-iam';
import * as sfn from '../../../aws-stepfunctions';
interface StepFunctionsInvokeActivityOptions {
    /**
     * Step Functions Activity to invoke
     */
    readonly activity: sfn.IActivity;
}
interface StepFunctionsInvokeActivityJsonPathOptions {
    /**
     * Parameters pass a collection of key-value pairs, either static values or JSONPath expressions that select from the input.
     *
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-parameters
     *
     * @default No parameters
     */
    readonly parameters?: {
        [name: string]: any;
    };
}
/**
 * Properties for invoking an Activity worker using JSONPath
 */
export interface StepFunctionsInvokeActivityJsonPathProps extends sfn.TaskStateJsonPathBaseProps, StepFunctionsInvokeActivityOptions, StepFunctionsInvokeActivityJsonPathOptions {
}
/**
 * Properties for invoking an Activity worker using JSONata
 */
export interface StepFunctionsInvokeActivityJsonataProps extends sfn.TaskStateJsonataBaseProps, StepFunctionsInvokeActivityOptions, sfn.JsonataStateOptions {
}
/**
 * Properties for invoking an Activity worker
 */
export interface StepFunctionsInvokeActivityProps extends sfn.TaskStateBaseProps, StepFunctionsInvokeActivityOptions, StepFunctionsInvokeActivityJsonPathOptions, sfn.JsonataStateOptions {
}
/**
 * A Step Functions Task to invoke an Activity worker.
 *
 * An Activity can be used directly as a Resource.
 */
export declare class StepFunctionsInvokeActivity extends sfn.TaskStateBase {
    private readonly props;
    /**
     * A Step Functions Task using JSONPath to invoke an Activity worker.
     *
     * An Activity can be used directly as a Resource.
     */
    static jsonPath(scope: Construct, id: string, props: StepFunctionsInvokeActivityJsonPathProps): StepFunctionsInvokeActivity;
    /**
     * A Step Functions Task using JSONata to invoke an Activity worker.
     *
     * An Activity can be used directly as a Resource.
     */
    static jsonata(scope: Construct, id: string, props: StepFunctionsInvokeActivityJsonataProps): StepFunctionsInvokeActivity;
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    protected readonly taskPolicies?: iam.PolicyStatement[];
    constructor(scope: Construct, id: string, props: StepFunctionsInvokeActivityProps);
    /**
     * @internal
     */
    protected _renderTask(topLevelQueryLanguage?: sfn.QueryLanguage): any;
    private createPolicyStatements;
}
export {};
