import { Construct } from 'constructs';
import * as iam from '../../../aws-iam';
import * as sfn from '../../../aws-stepfunctions';
interface SageMakerUpdateEndpointOptions {
    /**
     * The name of the new endpoint configuration
     */
    readonly endpointConfigName: string;
    /**
     * The name of the endpoint whose configuration you want to update.
     */
    readonly endpointName: string;
}
/**
 * Properties for updating Amazon SageMaker endpoint using JSONPath
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-sagemaker.html
 */
export interface SageMakerUpdateEndpointJsonPathProps extends sfn.TaskStateJsonPathBaseProps, SageMakerUpdateEndpointOptions {
}
/**
 * Properties for updating Amazon SageMaker endpoint using JSONata
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-sagemaker.html
 */
export interface SageMakerUpdateEndpointJsonataProps extends sfn.TaskStateJsonataBaseProps, SageMakerUpdateEndpointOptions {
}
/**
 * Properties for updating Amazon SageMaker endpoint
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-sagemaker.html
 */
export interface SageMakerUpdateEndpointProps extends sfn.TaskStateBaseProps, SageMakerUpdateEndpointOptions {
}
/**
 * A Step Functions Task to update a SageMaker endpoint
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-sagemaker.html
 */
export declare class SageMakerUpdateEndpoint extends sfn.TaskStateBase {
    private readonly props;
    /**
     * A Step Functions Task using JSONPath to update a SageMaker endpoint
     *
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-sagemaker.html
     */
    static jsonPath(scope: Construct, id: string, props: SageMakerUpdateEndpointJsonPathProps): SageMakerUpdateEndpoint;
    /**
     * A Step Functions Task using JSONata to update a SageMaker endpoint
     *
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-sagemaker.html
     */
    static jsonata(scope: Construct, id: string, props: SageMakerUpdateEndpointJsonataProps): SageMakerUpdateEndpoint;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    constructor(scope: Construct, id: string, props: SageMakerUpdateEndpointProps);
    /**
     * @internal
     */
    protected _renderTask(topLevelQueryLanguage?: sfn.QueryLanguage): any;
    private renderParameters;
    private makePolicyStatements;
}
export {};
