"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.SageMakerCreateTrainingJob=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var base_types_1=()=>{var tmp=require("./base-types");return base_types_1=()=>tmp,tmp},utils_1=()=>{var tmp=require("./private/utils");return utils_1=()=>tmp,tmp},ec2=()=>{var tmp=require("../../../aws-ec2");return ec2=()=>tmp,tmp},iam=()=>{var tmp=require("../../../aws-iam");return iam=()=>tmp,tmp},sfn=()=>{var tmp=require("../../../aws-stepfunctions");return sfn=()=>tmp,tmp},core_1=()=>{var tmp=require("../../../core");return core_1=()=>tmp,tmp},task_utils_1=()=>{var tmp=require("../private/task-utils");return task_utils_1=()=>tmp,tmp};class SageMakerCreateTrainingJob extends sfn().TaskStateBase{static jsonPath(scope,id,props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_stepfunctions_tasks_SageMakerCreateTrainingJobJsonPathProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.jsonPath),error}return new SageMakerCreateTrainingJob(scope,id,props)}static jsonata(scope,id,props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_stepfunctions_tasks_SageMakerCreateTrainingJobJsonataProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.jsonata),error}return new SageMakerCreateTrainingJob(scope,id,{...props,queryLanguage:sfn().QueryLanguage.JSONATA})}constructor(scope,id,props){super(scope,id,props),this.props=props,this.connections=new(ec2()).Connections,this.securityGroups=[];try{jsiiDeprecationWarnings().aws_cdk_lib_aws_stepfunctions_tasks_SageMakerCreateTrainingJobProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,SageMakerCreateTrainingJob),error}if(this.integrationPattern=props.integrationPattern||sfn().IntegrationPattern.REQUEST_RESPONSE,(0,task_utils_1().validatePatternSupported)(this.integrationPattern,SageMakerCreateTrainingJob.SUPPORTED_INTEGRATION_PATTERNS),this.resourceConfig=props.resourceConfig||{instanceCount:1,instanceType:ec2().InstanceType.of(ec2().InstanceClass.M4,ec2().InstanceSize.XLARGE),volumeSize:core_1().Size.gibibytes(10)},this.stoppingCondition=props.stoppingCondition||{maxRuntime:core_1().Duration.hours(1)},!props.algorithmSpecification.algorithmName&&!props.algorithmSpecification.trainingImage)throw new Error("Must define either an algorithm name or training image URI in the algorithm specification");if(props.algorithmSpecification.algorithmName&&props.algorithmSpecification.trainingImage)throw new Error("Cannot define both an algorithm name and training image URI in the algorithm specification");this.validateAlgorithmName(props.algorithmSpecification.algorithmName),this.algorithmSpecification=props.algorithmSpecification.trainingInputMode?props.algorithmSpecification:{...props.algorithmSpecification,trainingInputMode:base_types_1().InputMode.FILE},this.inputDataConfig=props.inputDataConfig?.map(config=>config.dataSource.s3DataSource.s3DataType?config:{...config,dataSource:{s3DataSource:{...config.dataSource.s3DataSource,s3DataType:base_types_1().S3DataType.S3_PREFIX}}}),props.vpcConfig&&(this.vpc=props.vpcConfig.vpc,this.subnets=props.vpcConfig.subnets?this.vpc.selectSubnets(props.vpcConfig.subnets).subnetIds:this.vpc.selectSubnets().subnetIds),this.taskPolicies=this.makePolicyStatements()}get role(){if(this._role===void 0)throw new Error("role not available yet--use the object in a Task first");return this._role}get grantPrincipal(){if(this._grantPrincipal===void 0)throw new Error("Principal not available yet--use the object in a Task first");return this._grantPrincipal}addSecurityGroup(securityGroup){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ec2_ISecurityGroup(securityGroup)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addSecurityGroup),error}this.securityGroups.push(securityGroup)}_renderTask(topLevelQueryLanguage){const queryLanguage=sfn()._getActualQueryLanguage(topLevelQueryLanguage,this.props.queryLanguage);return{Resource:(0,task_utils_1().integrationResourceArn)("sagemaker","createTrainingJob",this.integrationPattern),...this._renderParametersOrArguments(this.renderParameters(),queryLanguage)}}renderParameters(){return{TrainingJobName:this.props.trainingJobName,EnableNetworkIsolation:this.props.enableNetworkIsolation,RoleArn:this._role.roleArn,...this.renderAlgorithmSpecification(this.algorithmSpecification),...this.renderInputDataConfig(this.inputDataConfig),...this.renderOutputDataConfig(this.props.outputDataConfig),...this.renderResourceConfig(this.resourceConfig),...this.renderStoppingCondition(this.stoppingCondition),...this.renderHyperparameters(this.props.hyperparameters),...(0,utils_1().renderTags)(this.props.tags),...this.renderVpcConfig(this.props.vpcConfig),...(0,utils_1().renderEnvironment)(this.props.environment)}}renderAlgorithmSpecification(spec){return{AlgorithmSpecification:{TrainingInputMode:spec.trainingInputMode,...spec.trainingImage?{TrainingImage:spec.trainingImage.bind(this).imageUri}:{},...spec.algorithmName?{AlgorithmName:spec.algorithmName}:{},...spec.metricDefinitions?{MetricDefinitions:spec.metricDefinitions.map(metric=>({Name:metric.name,Regex:metric.regex}))}:{}}}}renderInputDataConfig(config){return config?{InputDataConfig:config.map(channel=>({ChannelName:channel.channelName,DataSource:{S3DataSource:{S3Uri:channel.dataSource.s3DataSource.s3Location.bind(this,{forReading:!0}).uri,S3DataType:channel.dataSource.s3DataSource.s3DataType,...channel.dataSource.s3DataSource.s3DataDistributionType?{S3DataDistributionType:channel.dataSource.s3DataSource.s3DataDistributionType}:{},...channel.dataSource.s3DataSource.attributeNames?{AttributeNames:channel.dataSource.s3DataSource.attributeNames}:{}}},...channel.compressionType?{CompressionType:channel.compressionType}:{},...channel.contentType?{ContentType:channel.contentType}:{},...channel.inputMode?{InputMode:channel.inputMode}:{},...channel.recordWrapperType?{RecordWrapperType:channel.recordWrapperType}:{}}))}:{}}renderOutputDataConfig(config){return{OutputDataConfig:{S3OutputPath:config.s3OutputLocation.bind(this,{forWriting:!0}).uri,...config.encryptionKey?{KmsKeyId:config.encryptionKey.keyArn}:{}}}}renderResourceConfig(config){return{ResourceConfig:{InstanceCount:config.instanceCount,InstanceType:(0,task_utils_1().isJsonPathOrJsonataExpression)(config.instanceType.toString())?config.instanceType.toString():`ml.${config.instanceType}`,VolumeSizeInGB:config.volumeSize.toGibibytes(),...config.volumeEncryptionKey?{VolumeKmsKeyId:config.volumeEncryptionKey.keyArn}:{}}}}renderStoppingCondition(config){return{StoppingCondition:{MaxRuntimeInSeconds:config.maxRuntime&&config.maxRuntime.toSeconds()}}}renderHyperparameters(params){return params?{HyperParameters:params}:{}}renderVpcConfig(config){return config?{VpcConfig:{SecurityGroupIds:core_1().Lazy.list({produce:()=>this.securityGroups.map(sg=>sg.securityGroupId)}),Subnets:this.subnets}}:{}}validateAlgorithmName(algorithmName){if(algorithmName===void 0||core_1().Token.isUnresolved(algorithmName))return;if(algorithmName.length<1||170<algorithmName.length)throw new Error(`Algorithm name length must be between 1 and 170, but got ${algorithmName.length}`);const regex=/^(arn:aws[a-z\-]*:sagemaker:[a-z0-9\-]*:[0-9]{12}:[a-z\-]*\/)?([a-zA-Z0-9]([a-zA-Z0-9-]){0,62})(?<!-)$/;if(!regex.test(algorithmName))throw new Error(`Expected algorithm name to match pattern ${regex.source}, but got ${algorithmName}`)}makePolicyStatements(){this._grantPrincipal=this._role=this.props.role||new(iam()).Role(this,"SagemakerRole",{assumedBy:new(iam()).ServicePrincipal("sagemaker.amazonaws.com"),inlinePolicies:{CreateTrainingJob:new(iam()).PolicyDocument({statements:[new(iam()).PolicyStatement({actions:["cloudwatch:PutMetricData","logs:CreateLogStream","logs:PutLogEvents","logs:CreateLogGroup","logs:DescribeLogStreams","ecr:GetAuthorizationToken",...this.props.vpcConfig?["ec2:CreateNetworkInterface","ec2:CreateNetworkInterfacePermission","ec2:DeleteNetworkInterface","ec2:DeleteNetworkInterfacePermission","ec2:DescribeNetworkInterfaces","ec2:DescribeVpcs","ec2:DescribeDhcpOptions","ec2:DescribeSubnets","ec2:DescribeSecurityGroups"]:[]],resources:["*"]})]})}}),this.props.outputDataConfig.encryptionKey&&this.props.outputDataConfig.encryptionKey.grantEncrypt(this._role),this.props.resourceConfig&&this.props.resourceConfig.volumeEncryptionKey&&this.props.resourceConfig.volumeEncryptionKey.grant(this._role,"kms:CreateGrant"),this.vpc&&this.securityGroup===void 0&&(this.securityGroup=new(ec2()).SecurityGroup(this,"TrainJobSecurityGroup",{vpc:this.vpc}),this.connections.addSecurityGroup(this.securityGroup),this.securityGroups.push(this.securityGroup));const stack=core_1().Stack.of(this),policyStatements=[new(iam()).PolicyStatement({actions:["sagemaker:CreateTrainingJob","sagemaker:DescribeTrainingJob","sagemaker:StopTrainingJob"],resources:[stack.formatArn({service:"sagemaker",resource:"training-job",resourceName:(0,task_utils_1().isJsonPathOrJsonataExpression)(this.props.trainingJobName)?"*":`${this.props.trainingJobName}*`})]}),new(iam()).PolicyStatement({actions:["sagemaker:ListTags"],resources:["*"]}),new(iam()).PolicyStatement({actions:["sagemaker:AddTags"],resources:[stack.formatArn({service:"sagemaker",resource:"training-job",resourceName:sfn().JsonPath.isEncodedJsonPath(this.props.trainingJobName)?"*":`${this.props.trainingJobName}*`})]}),new(iam()).PolicyStatement({actions:["iam:PassRole"],resources:[this._role.roleArn],conditions:{StringEquals:{"iam:PassedToService":"sagemaker.amazonaws.com"}}})];return this.integrationPattern===sfn().IntegrationPattern.RUN_JOB&&policyStatements.push(new(iam()).PolicyStatement({actions:["events:PutTargets","events:PutRule","events:DescribeRule"],resources:[stack.formatArn({service:"events",resource:"rule",resourceName:"StepFunctionsGetEventsForSageMakerTrainingJobsRule"})]})),policyStatements}}exports.SageMakerCreateTrainingJob=SageMakerCreateTrainingJob,_a=JSII_RTTI_SYMBOL_1,SageMakerCreateTrainingJob[_a]={fqn:"aws-cdk-lib.aws_stepfunctions_tasks.SageMakerCreateTrainingJob",version:"2.188.0"},SageMakerCreateTrainingJob.SUPPORTED_INTEGRATION_PATTERNS=[sfn().IntegrationPattern.REQUEST_RESPONSE,sfn().IntegrationPattern.RUN_JOB];
