import { Construct } from 'constructs';
import * as iam from '../../../aws-iam';
import * as sfn from '../../../aws-stepfunctions';
interface SageMakerCreateEndpointOptions {
    /**
     * The name of an endpoint configuration.
     */
    readonly endpointConfigName: string;
    /**
     * The name of the endpoint. The name must be unique within an AWS Region in your AWS account.
     */
    readonly endpointName: string;
    /**
     * Tags to be applied to the endpoint.
     *
     * @default - No tags
     */
    readonly tags?: sfn.TaskInput;
}
/**
 * Properties for creating an Amazon SageMaker endpoint using JSONPath
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-sagemaker.html
 */
export interface SageMakerCreateEndpointJsonPathProps extends sfn.TaskStateJsonPathBaseProps, SageMakerCreateEndpointOptions {
}
/**
 * Properties for creating an Amazon SageMaker endpoint using JSONata
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-sagemaker.html
 */
export interface SageMakerCreateEndpointJsonataProps extends sfn.TaskStateJsonataBaseProps, SageMakerCreateEndpointOptions {
}
/**
 * Properties for creating an Amazon SageMaker endpoint
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-sagemaker.html
 */
export interface SageMakerCreateEndpointProps extends sfn.TaskStateBaseProps, SageMakerCreateEndpointOptions {
}
/**
 * A Step Functions Task to create a SageMaker endpoint
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-sagemaker.html
 */
export declare class SageMakerCreateEndpoint extends sfn.TaskStateBase {
    private readonly props;
    /**
     * A Step Functions Task using JSONPath to create a SageMaker endpoint
     *
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-sagemaker.html
     */
    static jsonPath(scope: Construct, id: string, props: SageMakerCreateEndpointJsonPathProps): SageMakerCreateEndpoint;
    /**
     * A Step Functions Task using JSONata to create a SageMaker endpoint
     *
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-sagemaker.html
     */
    static jsonata(scope: Construct, id: string, props: SageMakerCreateEndpointJsonataProps): SageMakerCreateEndpoint;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    constructor(scope: Construct, id: string, props: SageMakerCreateEndpointProps);
    /**
     * @internal
     */
    protected _renderTask(topLevelQueryLanguage?: sfn.QueryLanguage): any;
    private renderParameters;
    private makePolicyStatements;
}
export {};
