import { Construct } from 'constructs';
import * as iam from '../../../aws-iam';
import * as sfn from '../../../aws-stepfunctions';
interface GlueStartCrawlerRunOptions {
    /**
     * Glue crawler name
     */
    readonly crawlerName: string;
}
/**
 * Properties for starting an AWS Glue Crawler as a task that using JSONPath
 */
export interface GlueStartCrawlerRunJsonPathProps extends sfn.TaskStateJsonPathBaseProps, GlueStartCrawlerRunOptions {
}
/**
 * Properties for starting an AWS Glue Crawler as a task that using JSONata
 */
export interface GlueStartCrawlerRunJsonataProps extends sfn.TaskStateJsonataBaseProps, GlueStartCrawlerRunOptions {
}
/**
 * Properties for starting an AWS Glue Crawler as a task
 */
export interface GlueStartCrawlerRunProps extends sfn.TaskStateBaseProps, GlueStartCrawlerRunOptions {
}
/**
 * Starts an AWS Glue Crawler in a Task state
 *
 * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-StartCrawler
 */
export declare class GlueStartCrawlerRun extends sfn.TaskStateBase {
    private readonly props;
    /**
     * Starts an AWS Glue Crawler using JSONPath in a Task state
     *
     * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-StartCrawler
     */
    static jsonPath(scope: Construct, id: string, props: GlueStartCrawlerRunJsonPathProps): GlueStartCrawlerRun;
    /**
     * Starts an AWS Glue Crawler using JSONata in a Task state
     *
     * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-crawler-crawling.html#aws-glue-api-crawler-crawling-StartCrawler
     */
    static jsonata(scope: Construct, id: string, props: GlueStartCrawlerRunJsonataProps): GlueStartCrawlerRun;
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    constructor(scope: Construct, id: string, props: GlueStartCrawlerRunProps);
    /**
     * @internal
     */
    protected _renderTask(topLevelQueryLanguage?: sfn.QueryLanguage): any;
}
export {};
