import { Construct } from 'constructs';
import * as iam from '../../../aws-iam';
import * as kms from '../../../aws-kms';
import * as sqs from '../../../aws-sqs';
import * as sfn from '../../../aws-stepfunctions';
import { Duration } from '../../../core';
import { Schedule } from '../schedule';
/**
 * The action that EventBridge Scheduler applies to the schedule after the schedule completes invoking the target.
 */
export declare enum ActionAfterCompletion {
    /**
     * Takes no action
     */
    NONE = "NONE",
    /**
     * Deletes the schedule
     */
    DELETE = "DELETE"
}
interface EventBridgeSchedulerCreateScheduleTaskOptions {
    /**
     * Schedule name
     */
    readonly scheduleName: string;
    /**
     * Specifies the action that EventBridge Scheduler applies to the schedule after the schedule completes invoking the target.
     *
     * @default ActionAfterCompletion.NONE
     */
    readonly actionAfterCompletion?: ActionAfterCompletion;
    /**
     * Unique, case-sensitive identifier to ensure the idempotency of the request.
     *
     * @default - Automatically generated
     */
    readonly clientToken?: string;
    /**
     * The description for the schedule.
     *
     * @default - No description
     */
    readonly description?: string;
    /**
     * The date, in UTC, before which the schedule can invoke its target.
     * Depending on the schedule's recurrence expression, invocations might stop on, or before, the EndDate you specify.
     * EventBridge Scheduler ignores EndDate for one-time schedules.
     *
     * @default - No end date
     */
    readonly endDate?: Date;
    /**
     * The maximum time window during which a schedule can be invoked.
     *
     * Minimum value is 1 minute.
     * Maximum value is 1440 minutes (1 day).
     *
     * @default - Flexible time window is not enabled.
     */
    readonly flexibleTimeWindow?: Duration;
    /**
     * The name of the schedule group to associate with this schedule.
     *
     * @default - The default schedule group is used.
     */
    readonly groupName?: string;
    /**
     * The customer managed KMS key that EventBridge Scheduler will use to encrypt and decrypt payload.
     *
     * @see https://docs.aws.amazon.com/scheduler/latest/UserGuide/encryption-rest.html
     *
     * @default - Use automatically generated KMS key
     */
    readonly kmsKey?: kms.IKey;
    /**
     * The schedule that defines when the schedule will trigger.
     *
     * @see https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html
     */
    readonly schedule: Schedule;
    /**
     * The timezone in which the scheduling expression is evaluated.
     *
     * @default - UTC
     */
    readonly timezone?: string;
    /**
     * The date, in UTC, after which the schedule can begin invoking its target.
     * Depending on the schedule's recurrence expression, invocations might occur on, or after, the StartDate you specify.
     * EventBridge Scheduler ignores StartDate for one-time schedules.
     *
     * @default - No start date
     */
    readonly startDate?: Date;
    /**
     * Specifies whether the schedule is enabled or disabled.
     *
     * @default true
     */
    readonly enabled?: boolean;
    /**
     * The schedule's target.
     */
    readonly target: EventBridgeSchedulerTarget;
}
/**
 * Properties for creating an AWS EventBridge Scheduler schedule using JSONPath
 */
export interface EventBridgeSchedulerCreateScheduleTaskJsonPathProps extends sfn.TaskStateJsonPathBaseProps, EventBridgeSchedulerCreateScheduleTaskOptions {
}
/**
 * Properties for creating an AWS EventBridge Scheduler schedule using JSONata
 */
export interface EventBridgeSchedulerCreateScheduleTaskJsonataProps extends sfn.TaskStateJsonataBaseProps, EventBridgeSchedulerCreateScheduleTaskOptions {
}
/**
 * Properties for creating an AWS EventBridge Scheduler schedule
 */
export interface EventBridgeSchedulerCreateScheduleTaskProps extends sfn.TaskStateBaseProps, EventBridgeSchedulerCreateScheduleTaskOptions {
}
/**
 * Properties for `EventBridgeSchedulerTarget`
 *
 * @see https://docs.aws.amazon.com/scheduler/latest/APIReference/API_Target.html#API_Target_Contents
 */
export interface EventBridgeSchedulerTargetProps {
    /**
     * The Amazon Resource Name (ARN) of the target.
     *
     * @see https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets.html
     */
    readonly arn: string;
    /**
     * The IAM role that EventBridge Scheduler will use for this target when the schedule is invoked.
     */
    readonly role: iam.IRole;
    /**
     * The input to the target.
     *
     * @default - EventBridge Scheduler delivers a default notification to the target
     */
    readonly input?: string;
    /**
     * The retry policy settings
     *
     * @default - Do not retry
     */
    readonly retryPolicy?: RetryPolicy;
    /**
     * Dead letter queue for failed events
     *
     * @default - No dead letter queue
     */
    readonly deadLetterQueue?: sqs.IQueue;
}
/**
 * The target that EventBridge Scheduler will invoke
 */
export declare class EventBridgeSchedulerTarget {
    /**
     * The Amazon Resource Name (ARN) of the target
     */
    arn: string;
    /**
     * The IAM role that EventBridge Scheduler will use for this target when the schedule is invoked
     */
    role: iam.IRole;
    /**
     * The input to the target
     */
    input?: string;
    /**
     * The retry policy settings
     */
    retryPolicy?: RetryPolicy;
    /**
     * Dead letter queue for failed events
     */
    deadLetterQueue?: sqs.IQueue;
    constructor(props: EventBridgeSchedulerTargetProps);
    /**
     * return the target object for the EventBridge Scheduler
     */
    renderTargetObject(): any;
    private validateProps;
}
/**
 * The information about the retry policy settings
 */
export interface RetryPolicy {
    /**
     * The maximum number of retry attempts to make before the request fails.
     */
    readonly maximumRetryAttempts: number;
    /**
     * The maximum amount of time to continue to make retry attempts.
     */
    readonly maximumEventAge: Duration;
}
/**
 * Create a new AWS EventBridge Scheduler schedule
 *
 * @see https://docs.aws.amazon.com/scheduler/latest/APIReference/API_CreateSchedule.html
 */
export declare class EventBridgeSchedulerCreateScheduleTask extends sfn.TaskStateBase {
    private readonly props;
    /**
     * Create an AWS EventBridge Scheduler schedule using JSONPath
     */
    static jsonPath(scope: Construct, id: string, props: EventBridgeSchedulerCreateScheduleTaskJsonPathProps): EventBridgeSchedulerCreateScheduleTask;
    /**
     * Create an AWS EventBridge Scheduler schedule using JSONata
     */
    static jsonata(scope: Construct, id: string, props: EventBridgeSchedulerCreateScheduleTaskJsonataProps): EventBridgeSchedulerCreateScheduleTask;
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    constructor(scope: Construct, id: string, props: EventBridgeSchedulerCreateScheduleTaskProps);
    /**
     * @internal
     */
    protected _renderTask(topLevelQueryLanguage?: sfn.QueryLanguage): any;
    private validateProps;
}
export {};
