import { Construct } from 'constructs';
import * as iam from '../../../aws-iam';
import * as sfn from '../../../aws-stepfunctions';
interface EmrContainersDeleteVirtualClusterOptions {
    /**
     * The ID of the virtual cluster that will be deleted.
     */
    readonly virtualClusterId: sfn.TaskInput;
}
/**
 * Properties to define a EMR Containers DeleteVirtualCluster Task using JSONPath
 */
export interface EmrContainersDeleteVirtualClusterJsonPathProps extends sfn.TaskStateJsonPathBaseProps, EmrContainersDeleteVirtualClusterOptions {
}
/**
 * Properties to define a EMR Containers DeleteVirtualCluster Task using JSONata
 */
export interface EmrContainersDeleteVirtualClusterJsonataProps extends sfn.TaskStateJsonataBaseProps, EmrContainersDeleteVirtualClusterOptions {
}
/**
 * Properties to define a EMR Containers DeleteVirtualCluster Task
 */
export interface EmrContainersDeleteVirtualClusterProps extends sfn.TaskStateBaseProps, EmrContainersDeleteVirtualClusterOptions {
}
/**
 * Deletes an EMR Containers virtual cluster as a Task.
 *
 * @see https://docs.amazonaws.cn/en_us/step-functions/latest/dg/connect-emr-eks.html
 */
export declare class EmrContainersDeleteVirtualCluster extends sfn.TaskStateBase {
    private readonly props;
    /**
     * Deletes an EMR Containers virtual cluster as a Task using JSONPath.
     */
    static jsonPath(scope: Construct, id: string, props: EmrContainersDeleteVirtualClusterJsonPathProps): EmrContainersDeleteVirtualCluster;
    /**
     * Deletes an EMR Containers virtual cluster as a Task using JSONata.
     */
    static jsonata(scope: Construct, id: string, props: EmrContainersDeleteVirtualClusterJsonataProps): EmrContainersDeleteVirtualCluster;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    constructor(scope: Construct, id: string, props: EmrContainersDeleteVirtualClusterProps);
    /**
     * @internal
     */
    protected _renderTask(topLevelQueryLanguage?: sfn.QueryLanguage): any;
    private createPolicyStatements;
}
export {};
