import { Construct } from 'constructs';
import * as iam from '../../../aws-iam';
import * as sfn from '../../../aws-stepfunctions';
interface EmrTerminateClusterOptions {
    /**
     * The ClusterId to terminate.
     */
    readonly clusterId: string;
}
/**
 * Properties for EmrTerminateCluster using JSONPath
 *
 */
export interface EmrTerminateClusterJsonPathProps extends sfn.TaskStateJsonPathBaseProps, EmrTerminateClusterOptions {
}
/**
 * Properties for EmrTerminateCluster using JSONata
 *
 */
export interface EmrTerminateClusterJsonataProps extends sfn.TaskStateJsonataBaseProps, EmrTerminateClusterOptions {
}
/**
 * Properties for EmrTerminateCluster
 *
 */
export interface EmrTerminateClusterProps extends sfn.TaskStateBaseProps, EmrTerminateClusterOptions {
}
/**
 * A Step Functions Task to terminate an EMR Cluster.
 *
 */
export declare class EmrTerminateCluster extends sfn.TaskStateBase {
    private readonly props;
    /**
     * A Step Functions Task using JSONPath to terminate an EMR Cluster.
     *
     */
    static jsonPath(scope: Construct, id: string, props: EmrTerminateClusterJsonPathProps): EmrTerminateCluster;
    /**
     * A Step Functions Task using JSONata to terminate an EMR Cluster.
     *
     */
    static jsonata(scope: Construct, id: string, props: EmrTerminateClusterJsonataProps): EmrTerminateCluster;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    protected readonly taskPolicies?: iam.PolicyStatement[];
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    private readonly integrationPattern;
    constructor(scope: Construct, id: string, props: EmrTerminateClusterProps);
    /**
     * @internal
     */
    protected _renderTask(topLevelQueryLanguage?: sfn.QueryLanguage): any;
    /**
     * This generates the PolicyStatements required by the Task to call TerminateCluster.
     */
    private createPolicyStatements;
}
export {};
