import { Construct } from 'constructs';
import * as iam from '../../../aws-iam';
import * as sfn from '../../../aws-stepfunctions';
interface EmrSetClusterTerminationProtectionOptions {
    /**
     * The ClusterId to update.
     */
    readonly clusterId: string;
    /**
     * Termination protection indicator.
     */
    readonly terminationProtected: boolean;
}
/**
 * Properties for EmrSetClusterTerminationProtection using JSONPath
 */
export interface EmrSetClusterTerminationProtectionJsonPathProps extends sfn.TaskStateJsonPathBaseProps, EmrSetClusterTerminationProtectionOptions {
}
/**
 * Properties for EmrSetClusterTerminationProtection using JSONata
 */
export interface EmrSetClusterTerminationProtectionJsonataProps extends sfn.TaskStateJsonataBaseProps, EmrSetClusterTerminationProtectionOptions {
}
/**
 * Properties for EmrSetClusterTerminationProtection
 */
export interface EmrSetClusterTerminationProtectionProps extends sfn.TaskStateBaseProps, EmrSetClusterTerminationProtectionOptions {
}
/**
 * A Step Functions Task to to set Termination Protection on an EMR Cluster.
 */
export declare class EmrSetClusterTerminationProtection extends sfn.TaskStateBase {
    private readonly props;
    /**
     * A Step Functions Task using JSONPath to set Termination Protection on an EMR Cluster.
     */
    static jsonPath(scope: Construct, id: string, props: EmrSetClusterTerminationProtectionJsonPathProps): EmrSetClusterTerminationProtection;
    /**
     * A Step Functions Task using JSONata to set Termination Protection on an EMR Cluster.
     */
    static jsonata(scope: Construct, id: string, props: EmrSetClusterTerminationProtectionJsonataProps): EmrSetClusterTerminationProtection;
    protected readonly taskPolicies?: iam.PolicyStatement[];
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    constructor(scope: Construct, id: string, props: EmrSetClusterTerminationProtectionProps);
    /**
     * @internal
     */
    protected _renderTask(topLevelQueryLanguage?: sfn.QueryLanguage): any;
}
export {};
