import { Construct } from 'constructs';
import * as iam from '../../../aws-iam';
import * as sfn from '../../../aws-stepfunctions';
interface EmrModifyInstanceFleetByNameOptions {
    /**
     * The ClusterId to update.
     */
    readonly clusterId: string;
    /**
     * The InstanceFleetName to update.
     */
    readonly instanceFleetName: string;
    /**
     * The target capacity of On-Demand units for the instance fleet.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceFleetModifyConfig.html
     *
     * @default - None
     */
    readonly targetOnDemandCapacity: number;
    /**
     * The target capacity of Spot units for the instance fleet.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceFleetModifyConfig.html
     *
     * @default - None
     */
    readonly targetSpotCapacity: number;
}
/**
 * Properties for EmrModifyInstanceFleetByName using JSONPath
 */
export interface EmrModifyInstanceFleetByNameJsonPathProps extends sfn.TaskStateJsonPathBaseProps, EmrModifyInstanceFleetByNameOptions {
}
/**
 * Properties for EmrModifyInstanceFleetByName using JSONata
 */
export interface EmrModifyInstanceFleetByNameJsonataProps extends sfn.TaskStateJsonataBaseProps, EmrModifyInstanceFleetByNameOptions {
}
/**
 * Properties for EmrModifyInstanceFleetByName
 */
export interface EmrModifyInstanceFleetByNameProps extends sfn.TaskStateBaseProps, EmrModifyInstanceFleetByNameOptions {
}
/**
 * A Step Functions Task to to modify an InstanceFleet on an EMR Cluster.
 */
export declare class EmrModifyInstanceFleetByName extends sfn.TaskStateBase {
    private readonly props;
    /**
     * A Step Functions Task using JSONPath to to modify an InstanceFleet on an EMR Cluster.
     */
    static jsonPath(scope: Construct, id: string, props: EmrModifyInstanceFleetByNameJsonPathProps): EmrModifyInstanceFleetByName;
    /**
     * A Step Functions Task using JSONata to to modify an InstanceFleet on an EMR Cluster.
     */
    static jsonata(scope: Construct, id: string, props: EmrModifyInstanceFleetByNameJsonataProps): EmrModifyInstanceFleetByName;
    protected readonly taskPolicies?: iam.PolicyStatement[];
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    constructor(scope: Construct, id: string, props: EmrModifyInstanceFleetByNameProps);
    /**
     * @internal
     */
    protected _renderTask(topLevelQueryLanguage?: sfn.QueryLanguage): any;
}
export {};
