import { Construct } from 'constructs';
import * as iam from '../../../aws-iam';
import * as sfn from '../../../aws-stepfunctions';
interface EmrCancelStepOptions {
    /**
     * The ClusterId to update.
     */
    readonly clusterId: string;
    /**
     * The StepId to cancel.
     */
    readonly stepId: string;
}
/**
 * Properties for calling an EMR CancelStep using JSONPath from your
 * state machine.
 */
export interface EmrCancelStepJsonPathProps extends sfn.TaskStateJsonPathBaseProps, EmrCancelStepOptions {
}
/**
 * Properties for calling an EMR CancelStep using JSONata from your
 * state machine.
 */
export interface EmrCancelStepJsonataProps extends sfn.TaskStateJsonataBaseProps, EmrCancelStepOptions {
}
/**
 * Properties for calling an EMR CancelStep from your
 * state machine.
 */
export interface EmrCancelStepProps extends sfn.TaskStateBaseProps, EmrCancelStepOptions {
}
/**
 * A Step Functions task to cancel a Step on an EMR Cluster.
 *
 */
export declare class EmrCancelStep extends sfn.TaskStateBase {
    private readonly props;
    /**
     * A Step Functions task using JSONPath to cancel a Step on an EMR Cluster.
     *
     */
    static jsonPath(scope: Construct, id: string, props: EmrCancelStepJsonPathProps): EmrCancelStep;
    /**
     * A Step Functions task using JSONata to cancel a Step on an EMR Cluster.
     *
     */
    static jsonata(scope: Construct, id: string, props: EmrCancelStepJsonataProps): EmrCancelStep;
    protected readonly taskPolicies?: iam.PolicyStatement[];
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    constructor(scope: Construct, id: string, props: EmrCancelStepProps);
    /**
     * @internal
     */
    protected _renderTask(topLevelQueryLanguage?: sfn.QueryLanguage): any;
}
export {};
