"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.StringListParameter=exports.StringParameter=exports.ParameterTier=exports.ParameterDataType=exports.ParameterType=exports.ParameterValueType=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var ssm=()=>{var tmp=require("./ssm.generated");return ssm=()=>tmp,tmp},util_1=()=>{var tmp=require("./util");return util_1=()=>tmp,tmp},iam=()=>{var tmp=require("../../aws-iam");return iam=()=>tmp,tmp},cxschema=()=>{var tmp=require("../../cloud-assembly-schema");return cxschema=()=>tmp,tmp},core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp},errors_1=()=>{var tmp=require("../../core/lib/errors");return errors_1=()=>tmp,tmp},metadata_resource_1=()=>{var tmp=require("../../core/lib/metadata-resource");return metadata_resource_1=()=>tmp,tmp};class ParameterBase extends core_1().Resource{grantRead(grantee){return this.encryptionKey&&this.encryptionKey.grantDecrypt(grantee),iam().Grant.addToPrincipal({grantee,actions:["ssm:DescribeParameters","ssm:GetParameters","ssm:GetParameter","ssm:GetParameterHistory"],resourceArns:[this.parameterArn]})}grantWrite(grantee){return this.encryptionKey&&this.encryptionKey.grantEncrypt(grantee),iam().Grant.addToPrincipal({grantee,actions:["ssm:PutParameter"],resourceArns:[this.parameterArn]})}}var ParameterValueType;(function(ParameterValueType2){ParameterValueType2.STRING="String",ParameterValueType2.AWS_EC2_AVAILABILITYZONE_NAME="AWS::EC2::AvailabilityZone::Name",ParameterValueType2.AWS_EC2_IMAGE_ID="AWS::EC2::Image::Id",ParameterValueType2.AWS_EC2_INSTANCE_ID="AWS::EC2::Instance::Id",ParameterValueType2.AWS_EC2_KEYPAIR_KEYNAME="AWS::EC2::KeyPair::KeyName",ParameterValueType2.AWS_EC2_SECURITYGROUP_GROUPNAME="AWS::EC2::SecurityGroup::GroupName",ParameterValueType2.AWS_EC2_SECURITYGROUP_ID="AWS::EC2::SecurityGroup::Id",ParameterValueType2.AWS_EC2_SUBNET_ID="AWS::EC2::Subnet::Id",ParameterValueType2.AWS_EC2_VOLUME_ID="AWS::EC2::Volume::Id",ParameterValueType2.AWS_EC2_VPC_ID="AWS::EC2::VPC::Id",ParameterValueType2.AWS_ROUTE53_HOSTEDZONE_ID="AWS::Route53::HostedZone::Id"})(ParameterValueType||(exports.ParameterValueType=ParameterValueType={}));var ParameterType;(function(ParameterType2){ParameterType2.STRING="String",ParameterType2.SECURE_STRING="SecureString",ParameterType2.STRING_LIST="StringList",ParameterType2.AWS_EC2_IMAGE_ID="AWS::EC2::Image::Id"})(ParameterType||(exports.ParameterType=ParameterType={}));var ParameterDataType;(function(ParameterDataType2){ParameterDataType2.TEXT="text",ParameterDataType2.AWS_EC2_IMAGE="aws:ec2:image"})(ParameterDataType||(exports.ParameterDataType=ParameterDataType={}));var ParameterTier;(function(ParameterTier2){ParameterTier2.ADVANCED="Advanced",ParameterTier2.INTELLIGENT_TIERING="Intelligent-Tiering",ParameterTier2.STANDARD="Standard"})(ParameterTier||(exports.ParameterTier=ParameterTier={}));class StringParameter extends ParameterBase{static fromStringParameterName(scope,id,stringParameterName){return this.fromStringParameterAttributes(scope,id,{parameterName:stringParameterName})}static fromStringParameterArn(scope,id,stringParameterArn){if(core_1().Token.isUnresolved(stringParameterArn))throw new(errors_1()).ValidationError("stringParameterArn cannot be an unresolved token",scope);const arnParts=stringParameterArn.split(":"),stackRegion=core_1().Stack.of(scope).region;if(arnParts.length!==6)throw new(errors_1()).ValidationError("unexpected StringParameterArn format",scope);if(core_1().Token.isUnresolved(stackRegion))core_1().Annotations.of(scope).addWarningV2("aws-cdk-lib/aws-ssm:crossAccountReferenceSameRegion","Cross-account references will only work within the same region");else if(!core_1().Token.isUnresolved(stackRegion)&&arnParts[3]!==stackRegion)throw new(errors_1()).ValidationError("stringParameterArn must be in the same region as the stack",scope);const parameterType=ParameterValueType.STRING;let stringValue;stringValue=new(core_1()).CfnParameter(scope,`${id}.Parameter`,{type:`AWS::SSM::Parameter::Value<${parameterType}>`,default:stringParameterArn}).valueAsString;class Import extends ParameterBase{constructor(){super(...arguments),this.parameterName=stringParameterArn.split("/").pop()?.replace(/parameter\/$/,"")??"",this.parameterArn=stringParameterArn,this.parameterType=parameterType,this.stringValue=stringValue}}return new Import(scope,id)}static fromStringParameterAttributes(scope,id,attrs){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ssm_StringParameterAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromStringParameterAttributes),error}if(!attrs.parameterName)throw new(errors_1()).ValidationError("parameterName cannot be an empty string",scope);if(attrs.type&&![ParameterType.STRING,ParameterType.AWS_EC2_IMAGE_ID].includes(attrs.type))throw new(errors_1()).ValidationError(`fromStringParameterAttributes does not support ${attrs.type}. Please use ParameterType.STRING or ParameterType.AWS_EC2_IMAGE_ID`,scope);const type=attrs.type??attrs.valueType??ParameterValueType.STRING,forceDynamicReference=attrs.forceDynamicReference??!1;let stringValue;attrs.version?stringValue=new(core_1()).CfnDynamicReference(core_1().CfnDynamicReferenceService.SSM,`${attrs.parameterName}:${core_1().Tokenization.stringifyNumber(attrs.version)}`).toString():forceDynamicReference?stringValue=new(core_1()).CfnDynamicReference(core_1().CfnDynamicReferenceService.SSM,attrs.parameterName).toString():core_1().Token.isUnresolved(attrs.parameterName)&&core_1().Fn._isFnBase(core_1().Tokenization.reverseString(attrs.parameterName).firstToken)?stringValue=new(core_1()).CfnDynamicReference(core_1().CfnDynamicReferenceService.SSM,attrs.parameterName).toString():stringValue=new(core_1()).CfnParameter(scope,`${id}.Parameter`,{type:`AWS::SSM::Parameter::Value<${type}>`,default:attrs.parameterName}).valueAsString;class Import extends ParameterBase{constructor(){super(...arguments),this.parameterName=attrs.parameterName,this.parameterArn=(0,util_1().arnForParameterName)(this,attrs.parameterName,{simpleName:attrs.simpleName}),this.parameterType=ParameterType.STRING,this.stringValue=stringValue}}return new Import(scope,id)}static fromSecureStringParameterAttributes(scope,id,attrs){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ssm_SecureStringParameterAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromSecureStringParameterAttributes),error}const version=attrs.version?core_1().Tokenization.stringifyNumber(attrs.version):"",stringValue=new(core_1()).CfnDynamicReference(core_1().CfnDynamicReferenceService.SSM_SECURE,version?`${attrs.parameterName}:${version}`:attrs.parameterName).toString();class Import extends ParameterBase{constructor(){super(...arguments),this.parameterName=attrs.parameterName,this.parameterArn=(0,util_1().arnForParameterName)(this,attrs.parameterName,{simpleName:attrs.simpleName}),this.parameterType=ParameterType.SECURE_STRING,this.stringValue=stringValue,this.encryptionKey=attrs.encryptionKey}}return new Import(scope,id)}static valueFromLookup(scope,parameterName,defaultValue){return core_1().ContextProvider.getValue(scope,{provider:cxschema().ContextProvider.SSM_PARAMETER_PROVIDER,props:{parameterName},dummyValue:defaultValue||`dummy-value-for-${parameterName}`,mustExist:defaultValue===void 0}).value}static valueForStringParameter(scope,parameterName,version){return StringParameter.valueForTypedStringParameterV2(scope,parameterName,ParameterValueType.STRING,version)}static valueForTypedStringParameterV2(scope,parameterName,type=ParameterValueType.STRING,version){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ssm_ParameterValueType(type)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.valueForTypedStringParameterV2),error}const stack=core_1().Stack.of(scope),id=makeIdentityForImportedValue(parameterName),exists=stack.node.tryFindChild(id);return exists?exists.stringValue:this.fromStringParameterAttributes(stack,id,{parameterName,version,valueType:type}).stringValue}static valueForTypedStringParameter(scope,parameterName,type=ParameterType.STRING,version){try{jsiiDeprecationWarnings().print("aws-cdk-lib.aws_ssm.StringParameter#valueForTypedStringParameter","- use valueForTypedStringParameterV2 instead"),jsiiDeprecationWarnings().aws_cdk_lib_aws_ssm_ParameterType(type)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.valueForTypedStringParameter),error}if(type===ParameterType.STRING_LIST)throw new(errors_1()).ValidationError("valueForTypedStringParameter does not support STRING_LIST, use valueForTypedListParameter instead",scope);const stack=core_1().Stack.of(scope),id=makeIdentityForImportedValue(parameterName),exists=stack.node.tryFindChild(id);return exists?exists.stringValue:this.fromStringParameterAttributes(stack,id,{parameterName,version,type}).stringValue}static valueForSecureStringParameter(scope,parameterName,version){try{jsiiDeprecationWarnings().print("aws-cdk-lib.aws_ssm.StringParameter#valueForSecureStringParameter","Use `SecretValue.ssmSecure()` instead, it will correctly type the imported value as a `SecretValue` and allow importing without version. `SecretValue` lives in the core `aws-cdk-lib` module.")}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.valueForSecureStringParameter),error}const stack=core_1().Stack.of(scope),id=makeIdentityForImportedValue(parameterName),exists=stack.node.tryFindChild(id);return exists?exists.stringValue:this.fromSecureStringParameterAttributes(stack,id,{parameterName,version}).stringValue}constructor(scope,id,props){super(scope,id,{physicalName:props.parameterName});try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ssm_StringParameterProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,StringParameter),error}if((0,metadata_resource_1().addConstructMetadata)(this,props),props.allowedPattern&&_assertValidValue(this,props.stringValue,props.allowedPattern),validateParameterName(this,this.physicalName),props.description&&props.description?.length>1024)throw new(errors_1()).ValidationError("Description cannot be longer than 1024 characters.",this);if(props.type&&props.type===ParameterType.AWS_EC2_IMAGE_ID)throw new(errors_1()).ValidationError("The type must either be ParameterType.STRING or ParameterType.STRING_LIST. Did you mean to set dataType: ParameterDataType.AWS_EC2_IMAGE instead?",this);const resource=new(ssm()).CfnParameter(this,"Resource",{allowedPattern:props.allowedPattern,description:props.description,name:this.physicalName,tier:props.tier,type:props.type||ParameterType.STRING,dataType:props.dataType,value:props.stringValue});this.parameterName=this.getResourceNameAttribute(resource.ref),this.parameterArn=(0,util_1().arnForParameterName)(this,this.parameterName,{physicalName:props.parameterName||util_1().AUTOGEN_MARKER,simpleName:props.simpleName}),this.parameterType=resource.attrType,this.stringValue=resource.attrValue}}exports.StringParameter=StringParameter,_a=JSII_RTTI_SYMBOL_1,StringParameter[_a]={fqn:"aws-cdk-lib.aws_ssm.StringParameter",version:"2.188.0"};class StringListParameter extends ParameterBase{static fromStringListParameterName(scope,id,stringListParameterName){class Import extends ParameterBase{constructor(){super(...arguments),this.parameterName=stringListParameterName,this.parameterArn=(0,util_1().arnForParameterName)(this,this.parameterName),this.parameterType=ParameterType.STRING_LIST,this.stringListValue=core_1().Fn.split(",",new(core_1()).CfnDynamicReference(core_1().CfnDynamicReferenceService.SSM,stringListParameterName).toString())}}return new Import(scope,id)}static fromListParameterAttributes(scope,id,attrs){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ssm_ListParameterAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromListParameterAttributes),error}if(!attrs.parameterName)throw new(errors_1()).ValidationError("parameterName cannot be an empty string",scope);const valueType=`List<${attrs.elementType??ParameterValueType.STRING}>`,stringValue=attrs.version?new(core_1()).CfnDynamicReference(core_1().CfnDynamicReferenceService.SSM,`${attrs.parameterName}:${core_1().Tokenization.stringifyNumber(attrs.version)}`).toStringList():new(core_1()).CfnParameter(scope,`${id}.Parameter`,{type:`AWS::SSM::Parameter::Value<${valueType}>`,default:attrs.parameterName}).valueAsList;class Import extends ParameterBase{constructor(){super(...arguments),this.parameterName=attrs.parameterName,this.parameterArn=(0,util_1().arnForParameterName)(this,attrs.parameterName,{simpleName:attrs.simpleName}),this.parameterType=valueType,this.stringListValue=stringValue}}return new Import(scope,id)}static valueForTypedListParameter(scope,parameterName,type=ParameterValueType.STRING,version){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ssm_ParameterValueType(type)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.valueForTypedListParameter),error}const stack=core_1().Stack.of(scope),id=makeIdentityForImportedValue(parameterName),exists=stack.node.tryFindChild(id);return exists?exists.stringListValue:this.fromListParameterAttributes(stack,id,{parameterName,elementType:type,version}).stringListValue}constructor(scope,id,props){super(scope,id,{physicalName:props.parameterName});try{jsiiDeprecationWarnings().aws_cdk_lib_aws_ssm_StringListParameterProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,StringListParameter),error}if((0,metadata_resource_1().addConstructMetadata)(this,props),props.stringListValue.find(str=>!core_1().Token.isUnresolved(str)&&str.indexOf(",")!==-1))throw new(errors_1()).ValidationError("Values of a StringList SSM Parameter cannot contain the ',' character. Use a string parameter instead.",this);if(props.allowedPattern&&!core_1().Token.isUnresolved(props.stringListValue)&&props.stringListValue.forEach(str=>_assertValidValue(this,str,props.allowedPattern)),validateParameterName(this,this.physicalName),props.description&&props.description?.length>1024)throw new(errors_1()).ValidationError("Description cannot be longer than 1024 characters.",this);const resource=new(ssm()).CfnParameter(this,"Resource",{allowedPattern:props.allowedPattern,description:props.description,name:this.physicalName,tier:props.tier,type:ParameterType.STRING_LIST,value:core_1().Fn.join(",",props.stringListValue)});this.parameterName=this.getResourceNameAttribute(resource.ref),this.parameterArn=(0,util_1().arnForParameterName)(this,this.parameterName,{physicalName:props.parameterName||util_1().AUTOGEN_MARKER,simpleName:props.simpleName}),this.parameterType=resource.attrType,this.stringListValue=core_1().Fn.split(",",resource.attrValue)}}exports.StringListParameter=StringListParameter,_b=JSII_RTTI_SYMBOL_1,StringListParameter[_b]={fqn:"aws-cdk-lib.aws_ssm.StringListParameter",version:"2.188.0"};function _assertValidValue(scope,value,allowedPattern){if(!(core_1().Token.isUnresolved(value)||core_1().Token.isUnresolved(allowedPattern))&&!new RegExp(allowedPattern).test(value))throw new(errors_1()).ValidationError(`The supplied value (${value}) does not match the specified allowedPattern (${allowedPattern})`,scope)}function makeIdentityForImportedValue(parameterName){return`SsmParameterValue:${parameterName}:C96584B6-F00A-464E-AD19-53AFF4B05118`}function validateParameterName(scope,parameterName){if(!core_1().Token.isUnresolved(parameterName)){if(parameterName.length>2048)throw new(errors_1()).ValidationError("name cannot be longer than 2048 characters.",scope);if(!parameterName.match(/^[\/\w.-]+$/))throw new(errors_1()).ValidationError(`name must only contain letters, numbers, and the following 4 symbols .-_/; got ${parameterName}`,scope)}}
