"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.validateQueueProps=validateQueueProps,exports.validateRedriveAllowPolicy=validateRedriveAllowPolicy;var index_1=()=>{var tmp=require("./index");return index_1=()=>tmp,tmp},core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp},helpers_internal_1=()=>{var tmp=require("../../core/lib/helpers-internal");return helpers_internal_1=()=>tmp,tmp};function validateRange(value,minValue,maxValue){return value!==void 0&&!core_1().Token.isUnresolved(value)&&(value<minValue||value>maxValue)}const queueValidationRules=[{condition:props=>validateRange(props.deliveryDelay?.toSeconds(),0,900),message:props=>`delivery delay must be between 0 and 900 seconds, but ${props.deliveryDelay?.toSeconds()} was provided`},{condition:props=>validateRange(props.maxMessageSizeBytes,1024,262144),message:props=>`maximum message size must be between 1,024 and 262,144 bytes, but ${props.maxMessageSizeBytes} was provided`},{condition:props=>validateRange(props.retentionPeriod?.toSeconds(),60,1209600),message:props=>`message retention period must be between 60 and 1,209,600 seconds, but ${props.retentionPeriod?.toSeconds()} was provided`},{condition:props=>validateRange(props.receiveMessageWaitTime?.toSeconds(),0,20),message:props=>`receive wait time must be between 0 and 20 seconds, but ${props.receiveMessageWaitTime?.toSeconds()} was provided`},{condition:props=>validateRange(props.visibilityTimeout?.toSeconds(),0,43200),message:props=>`visibility timeout must be between 0 and 43,200 seconds, but ${props.visibilityTimeout?.toSeconds()} was provided`},{condition:props=>validateRange(props.deadLetterQueue?.maxReceiveCount,1,Number.MAX_SAFE_INTEGER),message:props=>`dead letter target maximum receive count must be 1 or more, but ${props.deadLetterQueue?.maxReceiveCount} was provided`}],redriveValidationRules=[{condition:({redrivePermission,sourceQueues})=>redrivePermission===index_1().RedrivePermission.BY_QUEUE&&(!sourceQueues||sourceQueues.length===0),message:()=>"At least one source queue must be specified when RedrivePermission is set to 'byQueue'"},{condition:({redrivePermission,sourceQueues})=>!!(redrivePermission===index_1().RedrivePermission.BY_QUEUE&&sourceQueues&&sourceQueues.length>10),message:()=>"Up to 10 sourceQueues can be specified. Set RedrivePermission to 'allowAll' to specify more"},{condition:({redrivePermission,sourceQueues})=>!!((redrivePermission===index_1().RedrivePermission.ALLOW_ALL||redrivePermission===index_1().RedrivePermission.DENY_ALL)&&sourceQueues),message:()=>"sourceQueues cannot be configured when RedrivePermission is set to 'allowAll' or 'denyAll'"}];function validateQueueProps(scope,props){(0,helpers_internal_1().validateAllProps)(scope,index_1().Queue.name,props,queueValidationRules)}function validateRedriveAllowPolicy(scope,policy){(0,helpers_internal_1().validateAllProps)(scope,index_1().Queue.name,policy,redriveValidationRules)}
