"use strict";var __decorate=exports&&exports.__decorate||function(decorators,target,key,desc){var c=arguments.length,r=c<3?target:desc===null?desc=Object.getOwnPropertyDescriptor(target,key):desc,d;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")r=Reflect.decorate(decorators,target,key,desc);else for(var i=decorators.length-1;i>=0;i--)(d=decorators[i])&&(r=(c<3?d(r):c>3?d(target,key,r):d(target,key))||r);return c>3&&r&&Object.defineProperty(target,key,r),r},_a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Topic=exports.TracingConfig=exports.LoggingProtocol=exports.FifoThroughputScope=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var sns_generated_1=()=>{var tmp=require("./sns.generated");return sns_generated_1=()=>tmp,tmp},topic_base_1=()=>{var tmp=require("./topic-base");return topic_base_1=()=>tmp,tmp},aws_kms_1=()=>{var tmp=require("../../aws-kms");return aws_kms_1=()=>tmp,tmp},core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp},errors_1=()=>{var tmp=require("../../core/lib/errors");return errors_1=()=>tmp,tmp},metadata_resource_1=()=>{var tmp=require("../../core/lib/metadata-resource");return metadata_resource_1=()=>tmp,tmp},FifoThroughputScope;(function(FifoThroughputScope2){FifoThroughputScope2.TOPIC="Topic",FifoThroughputScope2.MESSAGE_GROUP="MessageGroup"})(FifoThroughputScope||(exports.FifoThroughputScope=FifoThroughputScope={}));var LoggingProtocol;(function(LoggingProtocol2){LoggingProtocol2.HTTP="http/s",LoggingProtocol2.SQS="sqs",LoggingProtocol2.LAMBDA="lambda",LoggingProtocol2.FIREHOSE="firehose",LoggingProtocol2.APPLICATION="application"})(LoggingProtocol||(exports.LoggingProtocol=LoggingProtocol={}));var TracingConfig;(function(TracingConfig2){TracingConfig2.PASS_THROUGH="PassThrough",TracingConfig2.ACTIVE="Active"})(TracingConfig||(exports.TracingConfig=TracingConfig={}));class Topic extends topic_base_1().TopicBase{static fromTopicArn(scope,id,topicArn){return Topic.fromTopicAttributes(scope,id,{topicArn})}static fromTopicAttributes(scope,id,attrs){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_sns_TopicAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromTopicAttributes),error}const topicName=core_1().Stack.of(scope).splitArn(attrs.topicArn,core_1().ArnFormat.NO_RESOURCE_NAME).resource,fifo=topicName.endsWith(".fifo");if(attrs.contentBasedDeduplication&&!fifo)throw new(errors_1()).ValidationError("Cannot import topic; contentBasedDeduplication is only available for FIFO SNS topics.",scope);class Import extends topic_base_1().TopicBase{constructor(){super(...arguments),this.topicArn=attrs.topicArn,this.topicName=topicName,this.masterKey=attrs.keyArn?aws_kms_1().Key.fromKeyArn(this,"Key",attrs.keyArn):void 0,this.fifo=fifo,this.contentBasedDeduplication=attrs.contentBasedDeduplication||!1,this.autoCreatePolicy=!1}}return new Import(scope,id,{environmentFromArn:attrs.topicArn})}constructor(scope,id,props={}){super(scope,id,{physicalName:props.topicName}),this.autoCreatePolicy=!0,this.loggingConfigs=[];try{jsiiDeprecationWarnings().aws_cdk_lib_aws_sns_TopicProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Topic),error}if((0,metadata_resource_1().addConstructMetadata)(this,props),this.enforceSSL=props.enforceSSL,props.contentBasedDeduplication&&!props.fifo)throw new(errors_1()).ValidationError("Content based deduplication can only be enabled for FIFO SNS topics.",this);if(props.messageRetentionPeriodInDays&&!props.fifo)throw new(errors_1()).ValidationError("`messageRetentionPeriodInDays` is only valid for FIFO SNS topics.",this);if(props.fifoThroughputScope&&!props.fifo)throw new(errors_1()).ValidationError("`fifoThroughputScope` can only be set for FIFO SNS topics.",this);if(props.messageRetentionPeriodInDays!==void 0&&!core_1().Token.isUnresolved(props.messageRetentionPeriodInDays)&&(!Number.isInteger(props.messageRetentionPeriodInDays)||props.messageRetentionPeriodInDays>365||props.messageRetentionPeriodInDays<1))throw new(errors_1()).ValidationError("`messageRetentionPeriodInDays` must be an integer between 1 and 365",this);props.loggingConfigs&&props.loggingConfigs.forEach(c=>this.addLoggingConfig(c));let cfnTopicName;if(props.fifo&&props.topicName&&!props.topicName.endsWith(".fifo")?cfnTopicName=this.physicalName+".fifo":props.fifo&&!props.topicName?cfnTopicName=`${core_1().Names.uniqueResourceName(this,{maxLength:251,separator:"-"})}.fifo`:cfnTopicName=this.physicalName,props.signatureVersion&&!core_1().Token.isUnresolved(props.signatureVersion)&&props.signatureVersion!=="1"&&props.signatureVersion!=="2")throw new(errors_1()).ValidationError(`signatureVersion must be "1" or "2", received: "${props.signatureVersion}"`,this);if(props.displayName&&!core_1().Token.isUnresolved(props.displayName)&&props.displayName.length>100)throw new(errors_1()).ValidationError(`displayName must be less than or equal to 100 characters, got ${props.displayName.length}`,this);const resource=new(sns_generated_1()).CfnTopic(this,"Resource",{archivePolicy:props.messageRetentionPeriodInDays?{MessageRetentionPeriod:props.messageRetentionPeriodInDays}:void 0,displayName:props.displayName,topicName:cfnTopicName,kmsMasterKeyId:props.masterKey&&props.masterKey.keyArn,contentBasedDeduplication:props.contentBasedDeduplication,fifoTopic:props.fifo,signatureVersion:props.signatureVersion,deliveryStatusLogging:core_1().Lazy.any({produce:()=>this.renderLoggingConfigs()},{omitEmptyArray:!0}),tracingConfig:props.tracingConfig,fifoThroughputScope:props.fifoThroughputScope});this.topicArn=this.getResourceArnAttribute(resource.ref,{service:"sns",resource:this.physicalName}),this.topicName=this.getResourceNameAttribute(resource.attrTopicName),this.masterKey=props.masterKey,this.fifo=props.fifo||!1,this.contentBasedDeduplication=props.contentBasedDeduplication||!1,this.enforceSSL&&this.addSSLPolicy()}renderLoggingConfigs(){const renderLoggingConfig=spec=>{if(spec.successFeedbackSampleRate!==void 0){const rate=spec.successFeedbackSampleRate;if(!Number.isInteger(rate)||rate<0||rate>100)throw new(errors_1()).ValidationError("Success feedback sample rate must be an integer between 0 and 100",this)}return{protocol:spec.protocol,failureFeedbackRoleArn:spec.failureFeedbackRole?.roleArn,successFeedbackRoleArn:spec.successFeedbackRole?.roleArn,successFeedbackSampleRate:spec.successFeedbackSampleRate?.toString()}};return this.loggingConfigs.map(renderLoggingConfig)}addLoggingConfig(config){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_sns_LoggingConfig(config)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addLoggingConfig),error}this.loggingConfigs.push(config)}}exports.Topic=Topic,_a=JSII_RTTI_SYMBOL_1,Topic[_a]={fqn:"aws-cdk-lib.aws_sns.Topic",version:"2.188.0"},__decorate([(0,metadata_resource_1().MethodMetadata)()],Topic.prototype,"addLoggingConfig",null);
