"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.SqsSubscription=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var constructs_1=()=>{var tmp=require("constructs");return constructs_1=()=>tmp,tmp},iam=()=>{var tmp=require("../../aws-iam");return iam=()=>tmp,tmp},sns=()=>{var tmp=require("../../aws-sns");return sns=()=>tmp,tmp},sqs=()=>{var tmp=require("../../aws-sqs");return sqs=()=>tmp,tmp},core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp},cxapi=()=>{var tmp=require("../../cx-api");return cxapi=()=>tmp,tmp};class SqsSubscription{constructor(queue,props={}){this.queue=queue,this.props=props;try{jsiiDeprecationWarnings().aws_cdk_lib_aws_sqs_IQueue(queue),jsiiDeprecationWarnings().aws_cdk_lib_aws_sns_subscriptions_SqsSubscriptionProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,SqsSubscription),error}}bind(topic){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_sns_ITopic(topic)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bind),error}if(!constructs_1().Construct.isConstruct(this.queue))throw new Error("The supplied Queue object must be an instance of Construct");const snsServicePrincipal=new(iam()).ServicePrincipal("sns.amazonaws.com");if(this.queue.encryptionType===sqs().QueueEncryption.KMS_MANAGED)throw new Error("SQS queue encrypted by AWS managed KMS key cannot be used as SNS subscription");if(this.props.deadLetterQueue&&this.props.deadLetterQueue.encryptionType===sqs().QueueEncryption.KMS_MANAGED)throw new Error("SQS queue encrypted by AWS managed KMS key cannot be used as dead-letter queue");const queuePolicyDependable=this.queue.addToResourcePolicy(new(iam()).PolicyStatement({resources:[this.queue.queueArn],actions:["sqs:SendMessage"],principals:[snsServicePrincipal],conditions:{ArnEquals:{"aws:SourceArn":topic.topicArn}}})).policyDependable;return this.queue.encryptionMasterKey&&this.queue.encryptionMasterKey.addToResourcePolicy(new(iam()).PolicyStatement({resources:["*"],actions:["kms:Decrypt","kms:GenerateDataKey"],principals:[snsServicePrincipal],conditions:core_1().FeatureFlags.of(topic).isEnabled(cxapi().SNS_SUBSCRIPTIONS_SQS_DECRYPTION_POLICY)?{ArnEquals:{"aws:SourceArn":topic.topicArn}}:void 0})),topic instanceof sns().Topic&&topic.stack!==this.queue.stack&&this.queue.stack.addDependency(topic.stack),{subscriberScope:this.queue,subscriberId:core_1().Names.nodeUniqueId(topic.node),endpoint:this.queue.queueArn,protocol:sns().SubscriptionProtocol.SQS,rawMessageDelivery:this.props.rawMessageDelivery,filterPolicy:this.props.filterPolicy,filterPolicyWithMessageBody:this.props.filterPolicyWithMessageBody,region:this.regionFromArn(topic),deadLetterQueue:this.props.deadLetterQueue,subscriptionDependency:queuePolicyDependable}}regionFromArn(topic){return topic instanceof sns().Topic?topic.stack!==this.queue.stack&&!core_1().Token.isUnresolved(topic.env.region)&&topic.env.region!==this.queue.env.region?topic.env.region:void 0:core_1().Stack.of(topic).splitArn(topic.topicArn,core_1().ArnFormat.SLASH_RESOURCE_NAME).region}}exports.SqsSubscription=SqsSubscription,_a=JSII_RTTI_SYMBOL_1,SqsSubscription[_a]={fqn:"aws-cdk-lib.aws_sns_subscriptions.SqsSubscription",version:"2.188.0"};
