"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.ProductStackSynthesizer=void 0;var aws_s3_1=()=>{var tmp=require("../../../aws-s3");return aws_s3_1=()=>tmp,tmp},aws_s3_deployment_1=()=>{var tmp=require("../../../aws-s3-deployment");return aws_s3_deployment_1=()=>tmp,tmp},cdk=()=>{var tmp=require("../../../core");return cdk=()=>tmp,tmp};class ProductStackSynthesizer extends cdk().StackSynthesizer{constructor(props){super(),this.parentStack=props.parentStack,this.assetBucket=props.assetBucket,this.serverSideEncryption=props.serverSideEncryption,this.serverSideEncryptionAwsKmsKeyId=props.serverSideEncryptionAwsKmsKeyId,this.memoryLimit=props.memoryLimit,this.assetBucket&&!cdk().Resource.isOwnedResource(this.assetBucket)&&cdk().Annotations.of(this.parentStack).addWarningV2("@aws-cdk/aws-servicecatalog:assetsManuallyAddBucketPermissions","[WARNING] Bucket Policy Permissions cannot be added to referenced Bucket. Please make sure your bucket has the correct permissions")}addFileAsset(asset){if(!this.assetBucket)throw new Error("An Asset Bucket must be provided to use Assets");const location=this.parentStack.synthesizer.addFileAsset(asset);this.parentAssetBucket||(this.parentAssetBucket=aws_s3_1().Bucket.fromBucketName(this.boundStack,"ParentAssetBucket",location.bucketName));const objectKey=location.objectKey,source=aws_s3_deployment_1().Source.bucket(this.parentAssetBucket,location.objectKey);if(this.serverSideEncryption===aws_s3_deployment_1().ServerSideEncryption.AWS_KMS&&!this.serverSideEncryptionAwsKmsKeyId)throw new Error("A KMS Key must be provided to use SSE_KMS");if(this.serverSideEncryption!==aws_s3_deployment_1().ServerSideEncryption.AWS_KMS&&this.serverSideEncryptionAwsKmsKeyId)throw new Error("A SSE_KMS encryption must be enabled if you provide KMS Key");const deploymentScope=this.assetBucket,deploymentCid="ProductAssetsDeployment";(deploymentScope.node.tryFindChild(deploymentCid)??new(aws_s3_deployment_1()).BucketDeployment(deploymentScope,deploymentCid,{sources:[source],destinationBucket:this.assetBucket,extract:!1,prune:!1,retainOnDelete:!0,serverSideEncryption:this.serverSideEncryption,serverSideEncryptionAwsKmsKeyId:this.serverSideEncryptionAwsKmsKeyId,memoryLimit:this.memoryLimit,outputObjectKeys:!1})).addSource(source);const bucketName=this.physicalNameOfBucket(this.assetBucket);if(!asset.fileName)throw new Error("Asset file name is undefined");const s3ObjectUrl=`s3://${bucketName}/${objectKey}`,httpUrl=`https://s3.${bucketName}/${objectKey}`;return{bucketName,objectKey,httpUrl,s3ObjectUrl,s3Url:httpUrl}}physicalNameOfBucket(bucket){let resolvedName;if(cdk().Resource.isOwnedResource(bucket)?resolvedName=cdk().Stack.of(bucket).resolve(bucket.node.defaultChild.bucketName):resolvedName=bucket.bucketName,resolvedName===void 0)throw new Error("A bucketName must be provided to use Assets");return resolvedName}addDockerImageAsset(_asset){throw new Error("Service Catalog Product Stacks cannot use Assets")}synthesize(session){this.synthesizeTemplate(session)}}exports.ProductStackSynthesizer=ProductStackSynthesizer;
