"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Schedule=exports.TimeWindow=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var scheduler_generated_1=()=>{var tmp=require("./scheduler.generated");return scheduler_generated_1=()=>tmp,tmp},cloudwatch=()=>{var tmp=require("../../aws-cloudwatch");return cloudwatch=()=>tmp,tmp},core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp},metadata_resource_1=()=>{var tmp=require("../../core/lib/metadata-resource");return metadata_resource_1=()=>tmp,tmp};class TimeWindow{static off(){return new TimeWindow("OFF")}static flexible(maxWindow){try{jsiiDeprecationWarnings().aws_cdk_lib_Duration(maxWindow)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.flexible),error}if(maxWindow.toMinutes()<1||maxWindow.toMinutes()>1440)throw new Error(`The provided duration must be between 1 minute and 1440 minutes, got ${maxWindow.toMinutes()}`);return new TimeWindow("FLEXIBLE",maxWindow)}constructor(mode,maxWindow){this.mode=mode,this.maxWindow=maxWindow}}exports.TimeWindow=TimeWindow,_a=JSII_RTTI_SYMBOL_1,TimeWindow[_a]={fqn:"aws-cdk-lib.aws_scheduler.TimeWindow",version:"2.188.0"};class Schedule extends core_1().Resource{static metricAll(metricName,props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricAll),error}return new(cloudwatch()).Metric({namespace:"AWS/Scheduler",metricName,statistic:"sum",...props})}static metricAllThrottled(props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricAllThrottled),error}return this.metricAll("InvocationThrottleCount",props)}static metricAllAttempts(props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricAllAttempts),error}return this.metricAll("InvocationAttemptCount",props)}static metricAllErrors(props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricAllErrors),error}return this.metricAll("TargetErrorCount",props)}static metricAllTargetThrottled(props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricAllTargetThrottled),error}return this.metricAll("TargetErrorThrottledCount",props)}static metricAllDropped(props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricAllDropped),error}return this.metricAll("InvocationDroppedCount",props)}static metricAllSentToDLQ(props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricAllSentToDLQ),error}return this.metricAll("InvocationsSentToDeadLetterCount",props)}static metricAllFailedToBeSentToDLQ(errorCode,props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricAllFailedToBeSentToDLQ),error}return errorCode?this.metricAll(`InvocationsFailedToBeSentToDeadLetterCount_${errorCode}`,props):this.metricAll("InvocationsFailedToBeSentToDeadLetterCount",props)}static metricAllSentToDLQTruncated(props){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_cloudwatch_MetricOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.metricAllSentToDLQTruncated),error}return this.metricAll("InvocationsSentToDeadLetterCount_Truncated_MessageSizeExceeded",props)}static fromScheduleArn(scope,id,scheduleArn){class Import extends core_1().Resource{constructor(){super(...arguments),this.scheduleArn=scheduleArn,this.scheduleName=core_1().Arn.split(scheduleArn,core_1().ArnFormat.SLASH_RESOURCE_NAME).resourceName.split("/")[1]}}return new Import(scope,id)}constructor(scope,id,props){super(scope,id,{physicalName:props.scheduleName});try{jsiiDeprecationWarnings().aws_cdk_lib_aws_scheduler_ScheduleProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Schedule),error}(0,metadata_resource_1().addConstructMetadata)(this,props),this.scheduleGroup=props.scheduleGroup;const targetConfig=props.target.bind(this);this.key=props.key,this.key&&this.key.grantDecrypt(targetConfig.role),this.retryPolicy=targetConfig.retryPolicy;const flexibleTimeWindow=props.timeWindow??TimeWindow.off();if(this.validateTimeFrame(props.start,props.end),props.scheduleName&&!core_1().Token.isUnresolved(props.scheduleName)&&props.scheduleName.length>64)throw new Error(`scheduleName cannot be longer than 64 characters, got: ${props.scheduleName.length}`);const resource=new(scheduler_generated_1()).CfnSchedule(this,"Resource",{name:this.physicalName,flexibleTimeWindow:{mode:flexibleTimeWindow.mode,maximumWindowInMinutes:flexibleTimeWindow.maxWindow?.toMinutes()},scheduleExpression:props.schedule.expressionString,scheduleExpressionTimezone:props.schedule.timeZone?.timezoneName,groupName:this.scheduleGroup?.scheduleGroupName,state:props.enabled??!0?"ENABLED":"DISABLED",kmsKeyArn:this.key?.keyArn,target:{arn:targetConfig.arn,roleArn:targetConfig.role.roleArn,input:targetConfig.input?.bind(this),deadLetterConfig:targetConfig.deadLetterConfig,retryPolicy:this.renderRetryPolicy(),ecsParameters:targetConfig.ecsParameters,kinesisParameters:targetConfig.kinesisParameters,eventBridgeParameters:targetConfig.eventBridgeParameters,sageMakerPipelineParameters:targetConfig.sageMakerPipelineParameters,sqsParameters:targetConfig.sqsParameters},startDate:props.start?.toISOString(),endDate:props.end?.toISOString(),description:props.description});this.scheduleName=this.getResourceNameAttribute(resource.ref),this.scheduleArn=this.getResourceArnAttribute(resource.attrArn,{service:"scheduler",resource:"schedule",resourceName:`${this.scheduleGroup?.scheduleGroupName??"default"}/${this.physicalName}`})}renderRetryPolicy(){const policy={...this.retryPolicy};if(policy.maximumEventAgeInSeconds&&(policy.maximumEventAgeInSeconds<60||policy.maximumEventAgeInSeconds>86400))throw new Error(`maximumEventAgeInSeconds must be between 60 and 86400, got ${policy.maximumEventAgeInSeconds}`);if(policy.maximumRetryAttempts&&(policy.maximumRetryAttempts<0||policy.maximumRetryAttempts>185))throw new Error(`maximumRetryAttempts must be between 0 and 185, got ${policy.maximumRetryAttempts}`);return Object.values(policy).every(value=>value===void 0)?void 0:policy}validateTimeFrame(start,end){if(start&&end&&start>=end)throw new Error(`start must precede end, got start: ${start.toISOString()}, end: ${end.toISOString()}`)}}exports.Schedule=Schedule,_b=JSII_RTTI_SYMBOL_1,Schedule[_b]={fqn:"aws-cdk-lib.aws_scheduler.Schedule",version:"2.188.0"};
