"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.ScheduleGroup=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var scheduler_generated_1=()=>{var tmp=require("./scheduler.generated");return scheduler_generated_1=()=>tmp,tmp},cloudwatch=()=>{var tmp=require("../../aws-cloudwatch");return cloudwatch=()=>tmp,tmp},iam=()=>{var tmp=require("../../aws-iam");return iam=()=>tmp,tmp},core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp},metadata_resource_1=()=>{var tmp=require("../../core/lib/metadata-resource");return metadata_resource_1=()=>tmp,tmp};class ScheduleGroupBase extends core_1().Resource{metric(metricName,props){return new(cloudwatch()).Metric({namespace:"AWS/Scheduler",metricName,dimensionsMap:{ScheduleGroup:this.scheduleGroupName},statistic:"sum",...props}).attachTo(this)}metricThrottled(props){return this.metric("InvocationThrottleCount",props)}metricAttempts(props){return this.metric("InvocationAttemptCount",props)}metricTargetErrors(props){return this.metric("TargetErrorCount",props)}metricTargetThrottled(props){return this.metric("TargetErrorThrottledCount",props)}metricDropped(props){return this.metric("InvocationDroppedCount",props)}metricSentToDLQ(props){return this.metric("InvocationsSentToDeadLetterCount",props)}metricFailedToBeSentToDLQ(errorCode,props){return errorCode?this.metric(`InvocationsFailedToBeSentToDeadLetterCount_${errorCode}`,props):this.metric("InvocationsFailedToBeSentToDeadLetterCount",props)}metricSentToDLQTruncated(props){return this.metric("InvocationsSentToDeadLetterCount_Truncated_MessageSizeExceeded",props)}grant(grantee,...actions){return iam().Grant.addToPrincipal({grantee,actions,resourceArns:[this.scheduleGroupArn],scope:this})}arnForScheduleInGroup(scheduleName){return core_1().Arn.format({region:this.env.region,account:this.env.account,partition:core_1().Aws.PARTITION,service:"scheduler",resource:"schedule",resourceName:this.scheduleGroupName+"/"+scheduleName})}grantReadSchedules(identity){return iam().Grant.addToPrincipal({grantee:identity,actions:["scheduler:GetSchedule","scheduler:ListSchedules"],resourceArns:[this.arnForScheduleInGroup("*")],scope:this})}grantWriteSchedules(identity){return iam().Grant.addToPrincipal({grantee:identity,actions:["scheduler:CreateSchedule","scheduler:UpdateSchedule"],resourceArns:[this.arnForScheduleInGroup("*")],scope:this})}grantDeleteSchedules(identity){return iam().Grant.addToPrincipal({grantee:identity,actions:["scheduler:DeleteSchedule"],resourceArns:[this.arnForScheduleInGroup("*")],scope:this})}}class ScheduleGroup extends ScheduleGroupBase{static fromScheduleGroupArn(scope,id,scheduleGroupArn){const scheduleGroupName=core_1().Stack.of(scope).splitArn(scheduleGroupArn,core_1().ArnFormat.SLASH_RESOURCE_NAME).resourceName;class Import extends ScheduleGroupBase{constructor(){super(...arguments),this.scheduleGroupName=scheduleGroupName,this.scheduleGroupArn=scheduleGroupArn}}return new Import(scope,id)}static fromDefaultScheduleGroup(scope,id){return ScheduleGroup.fromScheduleGroupName(scope,id,"default")}static fromScheduleGroupName(scope,id,scheduleGroupName){const groupArn=core_1().Stack.of(scope).formatArn({service:"scheduler",resource:"schedule-group",resourceName:scheduleGroupName});return ScheduleGroup.fromScheduleGroupArn(scope,id,groupArn)}constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings().aws_cdk_lib_aws_scheduler_ScheduleGroupProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,ScheduleGroup),error}(0,metadata_resource_1().addConstructMetadata)(this,props),this.scheduleGroupName=props?.scheduleGroupName??core_1().Names.uniqueResourceName(this,{maxLength:64,separator:"-"});const resource=new(scheduler_generated_1()).CfnScheduleGroup(this,"Resource",{name:this.scheduleGroupName});resource.applyRemovalPolicy(props?.removalPolicy),this.scheduleGroupArn=this.getResourceArnAttribute(resource.attrArn,{service:"scheduler",resource:"schedule-group",resourceName:this.scheduleGroupName})}}exports.ScheduleGroup=ScheduleGroup,_a=JSII_RTTI_SYMBOL_1,ScheduleGroup[_a]={fqn:"aws-cdk-lib.aws_scheduler.ScheduleGroup",version:"2.188.0"};
