import { ISchedule } from './schedule';
/**
 * The text or well-formed JSON input passed to the target of the schedule.
 * Tokens and ContextAttribute may be used in the input.
 */
export declare abstract class ScheduleTargetInput {
    /**
     * Pass simple text to the target. For passing complex values like JSON object to a target use method
     * `ScheduleTargetInput.fromObject()` instead.
     *
     * @param text Text to use as the input for the target
     */
    static fromText(text: string): ScheduleTargetInput;
    /**
     * Pass a JSON object to the target. The object will be transformed into a well-formed JSON string in the final template.
     *
     * @param obj object to use to convert to JSON to use as input for the target
     */
    static fromObject(obj: any): ScheduleTargetInput;
    protected constructor();
    /**
     * Return the input properties for this input object
     */
    abstract bind(schedule: ISchedule): string;
}
/**
 * A set of convenient static methods representing the Scheduler Context Attributes.
 * These Context Attributes keywords can be used inside a ScheduleTargetInput.
 *
 * @see https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-schedule-context-attributes.html
 */
export declare class ContextAttribute {
    readonly name: string;
    /**
     * The ARN of the schedule.
     */
    static get scheduleArn(): string;
    /**
     * The time you specified for the schedule to invoke its target, for example,
     * 2022-03-22T18:59:43Z.
     */
    static get scheduledTime(): string;
    /**
     * The unique ID that EventBridge Scheduler assigns for each attempted invocation of
     * a target, for example, d32c5kddcf5bb8c3.
     */
    static get executionId(): string;
    /**
     * A counter that identifies the attempt number for the current invocation, for
     * example, 1.
     */
    static get attemptNumber(): string;
    /**
     * Escape hatch for other Context Attributes that may be added in the future
     *
     * @param name - name will replace xxx in <aws.scheduler.xxx>
     */
    static fromName(name: string): string;
    private constructor();
    /**
     * Convert the path to the field in the event pattern to JSON
     */
    toString(): string;
}
