import { ScheduleTargetBase, ScheduleTargetBaseProps } from './target';
import { IRole, PolicyStatement } from '../../aws-iam';
import { IScheduleTarget } from '../../aws-scheduler';
/**
 * Properties for a Universal Target
 */
export interface UniversalTargetProps extends ScheduleTargetBaseProps {
    /**
     * The AWS service to call.
     *
     * This must be in lowercase.
     */
    readonly service: string;
    /**
     * The API action to call. Must be camelCase.
     *
     * You cannot use read-only API actions such as common GET operations.
     *
     * @see https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets-universal.html#unsupported-api-actions
     */
    readonly action: string;
    /**
     * The IAM policy statements needed to invoke the target. These statements are attached to the Scheduler's role.
     *
     * Note that the default may not be the correct actions as not all AWS services follows the same IAM action pattern, or there may be more actions needed to invoke the target.
     *
     * @default - Policy with `service:action` action only.
     */
    readonly policyStatements?: PolicyStatement[];
}
/**
 * Use a wider set of AWS API as a target for AWS EventBridge Scheduler.
 *
 * @see https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets-universal.html
 */
export declare class Universal extends ScheduleTargetBase implements IScheduleTarget {
    private readonly props;
    constructor(props: UniversalTargetProps);
    protected addTargetActionToRole(role: IRole): void;
}
