"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.ScheduleTargetBase=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var iam=()=>{var tmp=require("../../aws-iam");return iam=()=>tmp,tmp},core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp},helpers_internal_1=()=>{var tmp=require("../../core/lib/helpers-internal");return helpers_internal_1=()=>tmp,tmp};class ScheduleTargetBase{constructor(baseProps,targetArn){this.baseProps=baseProps,this.targetArn=targetArn;try{jsiiDeprecationWarnings().aws_cdk_lib_aws_scheduler_targets_ScheduleTargetBaseProps(baseProps)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,ScheduleTargetBase),error}}bindBaseTargetConfig(_schedule){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_scheduler_ISchedule(_schedule)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bindBaseTargetConfig),error}const role=this.baseProps.role??this.createOrGetScheduleTargetRole(_schedule,this.targetArn);return this.addTargetActionToRole(role),this.baseProps.deadLetterQueue&&this.addDeadLetterQueueActionToRole(role,this.baseProps.deadLetterQueue),{arn:this.targetArn,role,deadLetterConfig:this.baseProps.deadLetterQueue?{arn:this.baseProps.deadLetterQueue.queueArn}:void 0,retryPolicy:this.renderRetryPolicy(this.baseProps.maxEventAge,this.baseProps.retryAttempts),input:this.baseProps.input}}bind(schedule){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_scheduler_ISchedule(schedule)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bind),error}return this.bindBaseTargetConfig(schedule)}createOrGetScheduleTargetRole(schedule,targetArn){const stack=core_1().Stack.of(schedule),arn=core_1().Token.isUnresolved(targetArn)?JSON.stringify(stack.resolve(targetArn)):targetArn,id="SchedulerRoleForTarget-"+(0,helpers_internal_1().md5hash)(arn).slice(0,6),existingRole=stack.node.tryFindChild(id),principal=new(iam()).ServicePrincipal("scheduler.amazonaws.com",{conditions:{StringEquals:{"aws:SourceAccount":schedule.env.account,"aws:SourceArn":schedule.scheduleGroup?.scheduleGroupArn??core_1().Stack.of(schedule).formatArn({service:"scheduler",resource:"schedule-group",region:schedule.env.region,account:schedule.env.account,resourceName:schedule.scheduleGroup?.scheduleGroupName??"default"})}}});return existingRole?(existingRole.assumeRolePolicy?.addStatements(new(iam()).PolicyStatement({effect:iam().Effect.ALLOW,principals:[principal],actions:["sts:AssumeRole"]})),existingRole):new(iam()).Role(stack,id,{roleName:core_1().PhysicalName.GENERATE_IF_NEEDED,assumedBy:principal})}addDeadLetterQueueActionToRole(role,queue){role.addToPrincipalPolicy(new(iam()).PolicyStatement({actions:["sqs:SendMessage"],resources:[queue.queueArn]}))}renderRetryPolicy(maximumEventAge,maximumRetryAttempts){const maxMaxAge=core_1().Duration.days(1).toSeconds(),minMaxAge=core_1().Duration.minutes(1).toSeconds();let maxAge=maxMaxAge;if(maximumEventAge){if(maxAge=maximumEventAge.toSeconds({integral:!0}),maxAge>maxMaxAge)throw new Error("Maximum event age is 1 day");if(maxAge<minMaxAge)throw new Error("Minimum event age is 1 minute")}let maxAttempts=185;if(typeof maximumRetryAttempts<"u"){if(maximumRetryAttempts<0)throw Error("Number of retry attempts should be greater or equal than 0");if(maximumRetryAttempts>185)throw Error("Number of retry attempts should be less or equal than 185");maxAttempts=maximumRetryAttempts}return{maximumEventAgeInSeconds:maxAge,maximumRetryAttempts:maxAttempts}}}exports.ScheduleTargetBase=ScheduleTargetBase,_a=JSII_RTTI_SYMBOL_1,ScheduleTargetBase[_a]={fqn:"aws-cdk-lib.aws_scheduler_targets.ScheduleTargetBase",version:"2.188.0"};
