import { ScheduleTargetBase, ScheduleTargetBaseProps } from './target';
import { IRole } from '../../aws-iam';
import { IScheduleTarget } from '../../aws-scheduler';
import * as sns from '../../aws-sns';
/**
 * Use an Amazon SNS topic as a target for AWS EventBridge Scheduler.
 */
export declare class SnsPublish extends ScheduleTargetBase implements IScheduleTarget {
    private readonly topic;
    constructor(topic: sns.ITopic, props?: ScheduleTargetBaseProps);
    protected addTargetActionToRole(role: IRole): void;
}
