import { ScheduleTargetBase, ScheduleTargetBaseProps } from './target';
import { IRole } from '../../aws-iam';
import * as kinesis from '../../aws-kinesis';
import { ISchedule, IScheduleTarget, ScheduleTargetConfig } from '../../aws-scheduler';
/**
 * Properties for a Kinesis Data Streams Target
 */
export interface KinesisStreamPutRecordProps extends ScheduleTargetBaseProps {
    /**
     * The shard to which EventBridge Scheduler sends the event.
     *
     * The length must be between 1 and 256.
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-scheduler-schedule-kinesisparameters.html
     */
    readonly partitionKey: string;
}
/**
 * Use an Amazon Kinesis Data Streams as a target for AWS EventBridge Scheduler.
 */
export declare class KinesisStreamPutRecord extends ScheduleTargetBase implements IScheduleTarget {
    private readonly stream;
    private readonly props;
    constructor(stream: kinesis.IStream, props: KinesisStreamPutRecordProps);
    protected addTargetActionToRole(role: IRole): void;
    protected bindBaseTargetConfig(_schedule: ISchedule): ScheduleTargetConfig;
}
