"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.validateZoneName=validateZoneName,exports.determineFullyQualifiedDomainName=determineFullyQualifiedDomainName,exports.makeHostedZoneArn=makeHostedZoneArn,exports.makeGrantDelegation=makeGrantDelegation;var iam=()=>{var tmp=require("../../aws-iam");return iam=()=>tmp,tmp},core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp};function validateZoneName(zoneName){if(zoneName.length>255)throw new ValidationError("zone name cannot be more than 255 bytes long");if(zoneName.split(".").find(label=>label.length>63))throw new ValidationError("zone name labels cannot be more than 63 bytes long");if(!zoneName.match(/^[a-z0-9!"#$%&'()*+,/:;<=>?@[\\\]^_`{|}~.-]+$/i))throw new ValidationError("zone names can only contain a-z, 0-9, -, ! \" # $ % & ' ( ) * + , - / : ; < = > ? @ [  ] ^ _ ` { | } ~ .")}class ValidationError extends Error{constructor(message){super(message)}}function determineFullyQualifiedDomainName(providedName,hostedZone){if(providedName.endsWith("."))return providedName;const hostedZoneName=hostedZone.zoneName.endsWith(".")?hostedZone.zoneName.substring(0,hostedZone.zoneName.length-1):hostedZone.zoneName,suffix=`.${hostedZoneName}`;return providedName.endsWith(suffix)||providedName===hostedZoneName?`${providedName}.`:`${providedName}${suffix}.`}function makeHostedZoneArn(construct,hostedZoneId){return core_1().Stack.of(construct).formatArn({account:"",region:"",service:"route53",resource:"hostedzone",resourceName:hostedZoneId})}function makeGrantDelegation(grantee,hostedZoneArn){const g1=iam().Grant.addToPrincipal({grantee,actions:["route53:ChangeResourceRecordSets"],resourceArns:[hostedZoneArn],conditions:{"ForAllValues:StringEquals":{"route53:ChangeResourceRecordSetsRecordTypes":["NS"],"route53:ChangeResourceRecordSetsActions":["UPSERT","DELETE"]}}}),g2=iam().Grant.addToPrincipal({grantee,actions:["route53:ListHostedZonesByName"],resourceArns:["*"]});return g1.combine(g2)}
