"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Continent=exports.GeoLocation=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var errors_1=()=>{var tmp=require("../../core/lib/errors");return errors_1=()=>tmp,tmp};class GeoLocation{static continent(continentCode){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_route53_Continent(continentCode)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.continent),error}return new GeoLocation(continentCode,void 0,void 0)}static country(countryCode){return new GeoLocation(void 0,countryCode,void 0)}static subdivision(subdivisionCode,countryCode="US"){return new GeoLocation(void 0,countryCode,subdivisionCode)}static default(){return new GeoLocation(void 0,"*",void 0)}static validateCountry(country){if(!GeoLocation.COUNTRY_REGEX.test(country))throw new(errors_1()).UnscopedValidationError(`Invalid country format for country: ${country}, country should be two-letter and uppercase country ISO 3166-1-alpha-2 code`)}static validateCountryForSubdivision(country){if(!GeoLocation.COUNTRY_FOR_SUBDIVISION_REGEX.test(country))throw new(errors_1()).UnscopedValidationError(`Invalid country for subdivisions geolocation: ${country}, only UA (Ukraine) and US (United states) are supported`)}static validateSubDivision(subDivision){if(!GeoLocation.SUBDIVISION_REGEX.test(subDivision))throw new(errors_1()).UnscopedValidationError(`Invalid subdivision format for subdivision: ${subDivision}, subdivision should be alphanumeric and between 1 and 3 characters`)}constructor(continentCode,countryCode,subdivisionCode){this.continentCode=continentCode,this.countryCode=countryCode,this.subdivisionCode=subdivisionCode,subdivisionCode&&countryCode&&(GeoLocation.validateCountryForSubdivision(countryCode),GeoLocation.validateSubDivision(subdivisionCode)),countryCode&&GeoLocation.validateCountry(countryCode)}}exports.GeoLocation=GeoLocation,_a=JSII_RTTI_SYMBOL_1,GeoLocation[_a]={fqn:"aws-cdk-lib.aws_route53.GeoLocation",version:"2.188.0"},GeoLocation.COUNTRY_REGEX=/(^[A-Z]{2}|^\*{1})$/,GeoLocation.COUNTRY_FOR_SUBDIVISION_REGEX=/\b(?:UA|US)\b/,GeoLocation.SUBDIVISION_REGEX=/^[A-Z0-9]{1,3}$/;var Continent;(function(Continent2){Continent2.AFRICA="AF",Continent2.ANTARCTICA="AN",Continent2.ASIA="AS",Continent2.EUROPE="EU",Continent2.OCEANIA="OC",Continent2.NORTH_AMERICA="NA",Continent2.SOUTH_AMERICA="SA"})(Continent||(exports.Continent=Continent={}));
