import { GraphqlApi } from '../../aws-appsync';
import { AliasRecordTargetConfig, IAliasRecordTarget, IHostedZone, IRecordSet } from '../../aws-route53';
/**
 * Defines an AppSync Graphql API as the alias target. Requires that the domain
 * name will be defined through `GraphqlApiProps.domainName`.
 */
export declare class AppSyncTarget implements IAliasRecordTarget {
    private readonly graphqlApi;
    constructor(graphqlApi: GraphqlApi);
    bind(_record: IRecordSet, _zone?: IHostedZone): AliasRecordTargetConfig;
}
