"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.validateDatabaseClusterProps=validateDatabaseClusterProps;var cluster_1=()=>{var tmp=require("./cluster");return cluster_1=()=>tmp,tmp},props_1=()=>{var tmp=require("./props");return props_1=()=>tmp,tmp},helpers_internal_1=()=>{var tmp=require("../../core/lib/helpers-internal");return helpers_internal_1=()=>tmp,tmp};const standardDatabaseRules=[{condition:props=>props.enablePerformanceInsights===!1&&(props.performanceInsightRetention!==void 0||props.performanceInsightEncryptionKey!==void 0||props.databaseInsightsMode===cluster_1().DatabaseInsightsMode.ADVANCED),message:()=>"`enablePerformanceInsights` disabled, but `performanceInsightRetention` or `performanceInsightEncryptionKey` was set, or `databaseInsightsMode` was set to '${DatabaseInsightsMode.ADVANCED}'"},{condition:props=>props.databaseInsightsMode===cluster_1().DatabaseInsightsMode.ADVANCED&&props.performanceInsightRetention!==props_1().PerformanceInsightRetention.MONTHS_15,message:()=>"`performanceInsightRetention` must be set to '${PerformanceInsightRetention.MONTHS_15}' when `databaseInsightsMode` is set to '${DatabaseInsightsMode.ADVANCED}'"},{condition:props=>props.databaseInsightsMode!==void 0&&!props.engine.engineType.startsWith("aurora"),message:()=>"`performanceInsightEncryptionKey` must be set when `databaseInsightsMode` is set to '${DatabaseInsightsMode.ADVANCED}'"},{condition:props=>props.replicationSourceIdentifier!==void 0&&props.credentials!==void 0,message:()=>"Cannot specify both `replicationSourceIdentifier` and `credentials`. The value is inherited from the source DB cluster"}],limitlessDatabaseRules=[{condition:props=>!props.enablePerformanceInsights,message:()=>"Performance Insights must be enabled for Aurora Limitless Database"},{condition:props=>!props.performanceInsightRetention||props.performanceInsightRetention<props_1().PerformanceInsightRetention.MONTHS_1,message:()=>"Performance Insights retention period must be set to at least 31 days for Aurora Limitless Database"},{condition:props=>!props.monitoringInterval||!props.enableClusterLevelEnhancedMonitoring,message:()=>"Cluster level enhanced monitoring must be set for Aurora Limitless Database. Please set 'monitoringInterval' and enable 'enableClusterLevelEnhancedMonitoring'"},{condition:props=>!!(props.writer||props.readers),message:()=>"Aurora Limitless Database does not support reader or writer instances"},{condition:props=>!props.engine.engineVersion?.fullVersion?.endsWith("limitless"),message:props=>`Aurora Limitless Database requires an engine version that supports it, got: ${props.engine.engineVersion?.fullVersion}`},{condition:props=>props.storageType!==cluster_1().DBClusterStorageType.AURORA_IOPT1,message:props=>`Aurora Limitless Database requires I/O optimized storage type, got: ${props.storageType}`},{condition:props=>props.cloudwatchLogsExports===void 0||props.cloudwatchLogsExports.length===0,message:()=>"Aurora Limitless Database requires CloudWatch Logs exports to be set"}];function validateDatabaseClusterProps(scope,props){const applicableRules=props.clusterScailabilityType===cluster_1().ClusterScailabilityType.LIMITLESS?[...standardDatabaseRules,...limitlessDatabaseRules]:standardDatabaseRules;(0,helpers_internal_1().validateAllProps)(scope,cluster_1().DatabaseCluster.name,props,applicableRules)}
