"use strict";var __decorate=exports&&exports.__decorate||function(decorators,target,key,desc){var c=arguments.length,r=c<3?target:desc===null?desc=Object.getOwnPropertyDescriptor(target,key):desc,d;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")r=Reflect.decorate(decorators,target,key,desc);else for(var i=decorators.length-1;i>=0;i--)(d=decorators[i])&&(r=(c<3?d(r):c>3?d(target,key,r):d(target,key))||r);return c>3&&r&&Object.defineProperty(target,key,r),r},_a,_b,_c;Object.defineProperty(exports,"__esModule",{value:!0}),exports.DatabaseProxy=exports.ProxyTarget=exports.SessionPinningFilter=exports.ClientPasswordAuthType=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var util_1=()=>{var tmp=require("./private/util");return util_1=()=>tmp,tmp},rds_generated_1=()=>{var tmp=require("./rds.generated");return rds_generated_1=()=>tmp,tmp},ec2=()=>{var tmp=require("../../aws-ec2");return ec2=()=>tmp,tmp},iam=()=>{var tmp=require("../../aws-iam");return iam=()=>tmp,tmp},secretsmanager=()=>{var tmp=require("../../aws-secretsmanager");return secretsmanager=()=>tmp,tmp},cdk=()=>{var tmp=require("../../core");return cdk=()=>tmp,tmp},errors_1=()=>{var tmp=require("../../core/lib/errors");return errors_1=()=>tmp,tmp},metadata_resource_1=()=>{var tmp=require("../../core/lib/metadata-resource");return metadata_resource_1=()=>tmp,tmp},cxapi=()=>{var tmp=require("../../cx-api");return cxapi=()=>tmp,tmp},ClientPasswordAuthType;(function(ClientPasswordAuthType2){ClientPasswordAuthType2.MYSQL_NATIVE_PASSWORD="MYSQL_NATIVE_PASSWORD",ClientPasswordAuthType2.POSTGRES_SCRAM_SHA_256="POSTGRES_SCRAM_SHA_256",ClientPasswordAuthType2.POSTGRES_MD5="POSTGRES_MD5",ClientPasswordAuthType2.SQL_SERVER_AUTHENTICATION="SQL_SERVER_AUTHENTICATION"})(ClientPasswordAuthType||(exports.ClientPasswordAuthType=ClientPasswordAuthType={}));class SessionPinningFilter{static of(filterName){return new SessionPinningFilter(filterName)}constructor(filterName){this.filterName=filterName}}exports.SessionPinningFilter=SessionPinningFilter,_a=JSII_RTTI_SYMBOL_1,SessionPinningFilter[_a]={fqn:"aws-cdk-lib.aws_rds.SessionPinningFilter",version:"2.188.0"},SessionPinningFilter.EXCLUDE_VARIABLE_SETS=new SessionPinningFilter("EXCLUDE_VARIABLE_SETS");class ProxyTarget{static fromInstance(instance){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_rds_IDatabaseInstance(instance)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromInstance),error}return new ProxyTarget(instance,void 0)}static fromCluster(cluster){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_rds_IDatabaseCluster(cluster)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromCluster),error}return new ProxyTarget(void 0,cluster)}constructor(dbInstance,dbCluster){this.dbInstance=dbInstance,this.dbCluster=dbCluster}bind(proxy){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_rds_DatabaseProxy(proxy)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bind),error}const engine=this.dbInstance?.engine??this.dbCluster?.engine;if(!engine){const errorResource=this.dbCluster??this.dbInstance;throw new(errors_1()).ValidationError(`Could not determine engine for proxy target '${errorResource?.node.path}'. Please provide it explicitly when importing the resource`,proxy)}const engineFamily=engine.engineFamily;if(!engineFamily)throw new(errors_1()).ValidationError(`RDS proxies require an engine family to be specified on the database cluster or instance. No family specified for engine '${(0,util_1().engineDescription)(engine)}'`,proxy);return this.dbCluster?.connections.allowDefaultPortFrom(proxy,"Allow connections to the database Cluster from the Proxy"),this.dbInstance?.connections.allowDefaultPortFrom(proxy,"Allow connections to the database Instance from the Proxy"),{engineFamily,dbClusters:this.dbCluster?[this.dbCluster]:void 0,dbInstances:this.dbInstance?[this.dbInstance]:void 0}}}exports.ProxyTarget=ProxyTarget,_b=JSII_RTTI_SYMBOL_1,ProxyTarget[_b]={fqn:"aws-cdk-lib.aws_rds.ProxyTarget",version:"2.188.0"};class DatabaseProxyBase extends cdk().Resource{grantConnect(grantee,dbUser){if(!dbUser)throw new(errors_1()).ValidationError("For imported Database Proxies, the dbUser is required in grantConnect()",this);const scopeStack=cdk().Stack.of(this),proxyGeneratedId=scopeStack.splitArn(this.dbProxyArn,cdk().ArnFormat.COLON_RESOURCE_NAME).resourceName,userArn=scopeStack.formatArn({service:"rds-db",resource:"dbuser",resourceName:`${proxyGeneratedId}/${dbUser}`,arnFormat:cdk().ArnFormat.COLON_RESOURCE_NAME});return iam().Grant.addToPrincipal({grantee,actions:["rds-db:connect"],resourceArns:[userArn]})}}class DatabaseProxy extends DatabaseProxyBase{static fromDatabaseProxyAttributes(scope,id,attrs){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_rds_DatabaseProxyAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromDatabaseProxyAttributes),error}class Import extends DatabaseProxyBase{constructor(){super(...arguments),this.dbProxyName=attrs.dbProxyName,this.dbProxyArn=attrs.dbProxyArn,this.endpoint=attrs.endpoint}}return new Import(scope,id)}constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings().aws_cdk_lib_aws_rds_DatabaseProxyProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,DatabaseProxy),error}(0,metadata_resource_1().addConstructMetadata)(this,props);const physicalName=props.dbProxyName||(cdk().FeatureFlags.of(this).isEnabled(cxapi().DATABASE_PROXY_UNIQUE_RESOURCE_NAME)?cdk().Names.uniqueResourceName(this,{maxLength:60}):id),role=props.role||new(iam()).Role(this,"IAMRole",{assumedBy:new(iam()).ServicePrincipal("rds.amazonaws.com")});for(const secret of props.secrets)secret.grantRead(role),secret.encryptionKey&&secret.encryptionKey.grantDecrypt(role);const securityGroups=props.securityGroups??[new(ec2()).SecurityGroup(this,"ProxySecurityGroup",{description:"SecurityGroup for Database Proxy",vpc:props.vpc})];this.connections=new(ec2()).Connections({securityGroups});const bindResult=props.proxyTarget.bind(this);if(props.secrets.length<1)throw new(errors_1()).ValidationError("One or more secrets are required.",this);this.secrets=props.secrets,this.validateClientPasswordAuthType(bindResult.engineFamily,props.clientPasswordAuthType),this.resource=new(rds_generated_1()).CfnDBProxy(this,"Resource",{auth:props.secrets.map(_=>({authScheme:"SECRETS",clientPasswordAuthType:props.clientPasswordAuthType,iamAuth:props.iamAuth?"REQUIRED":"DISABLED",secretArn:_.secretArn})),dbProxyName:physicalName,debugLogging:props.debugLogging,engineFamily:bindResult.engineFamily,idleClientTimeout:props.idleClientTimeout?.toSeconds(),requireTls:props.requireTLS??!0,roleArn:role.roleArn,vpcSecurityGroupIds:cdk().Lazy.list({produce:()=>this.connections.securityGroups.map(_=>_.securityGroupId)}),vpcSubnetIds:props.vpc.selectSubnets(props.vpcSubnets).subnetIds}),this.dbProxyName=this.resource.ref,this.dbProxyArn=this.resource.attrDbProxyArn,this.endpoint=this.resource.attrEndpoint;let dbInstanceIdentifiers;bindResult.dbInstances&&(dbInstanceIdentifiers=[bindResult.dbInstances[0].instanceIdentifier]);let dbClusterIdentifiers;if(bindResult.dbClusters&&(dbClusterIdentifiers=bindResult.dbClusters.map(c=>c.clusterIdentifier)),dbInstanceIdentifiers&&dbClusterIdentifiers)throw new(errors_1()).ValidationError("Cannot specify both dbInstanceIdentifiers and dbClusterIdentifiers",this);const proxyTargetGroup=new(rds_generated_1()).CfnDBProxyTargetGroup(this,"ProxyTargetGroup",{targetGroupName:"default",dbProxyName:this.dbProxyName,dbInstanceIdentifiers,dbClusterIdentifiers,connectionPoolConfigurationInfo:toConnectionPoolConfigurationInfo(props)});bindResult.dbClusters?.forEach(cluster=>{cluster.node.children.forEach(child=>{child instanceof rds_generated_1().CfnDBInstance&&proxyTargetGroup.addDependency(child);const resource=child.node.defaultChild;resource instanceof rds_generated_1().CfnDBInstance&&proxyTargetGroup.addDependency(resource)});const clusterResource=cluster.node.defaultChild;clusterResource&&cdk().CfnResource.isCfnResource(clusterResource)&&proxyTargetGroup.addDependency(clusterResource)})}asSecretAttachmentTarget(){return{targetId:this.dbProxyName,targetType:secretsmanager().AttachmentTargetType.RDS_DB_PROXY}}grantConnect(grantee,dbUser){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_iam_IGrantable(grantee)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.grantConnect),error}if(!dbUser){if(this.secrets.length>1)throw new(errors_1()).ValidationError("When the Proxy contains multiple Secrets, you must pass a dbUser explicitly to grantConnect()",this);dbUser=this.secrets[0].secretValueFromJson("username").unsafeUnwrap()}return super.grantConnect(grantee,dbUser)}validateClientPasswordAuthType(engineFamily,clientPasswordAuthType){if(!(!clientPasswordAuthType||cdk().Token.isUnresolved(clientPasswordAuthType))){if(clientPasswordAuthType===ClientPasswordAuthType.MYSQL_NATIVE_PASSWORD&&engineFamily!=="MYSQL")throw new(errors_1()).ValidationError(`${ClientPasswordAuthType.MYSQL_NATIVE_PASSWORD} client password authentication type requires MYSQL engineFamily, got ${engineFamily}`,this);if(clientPasswordAuthType===ClientPasswordAuthType.POSTGRES_SCRAM_SHA_256&&engineFamily!=="POSTGRESQL")throw new(errors_1()).ValidationError(`${ClientPasswordAuthType.POSTGRES_SCRAM_SHA_256} client password authentication type requires POSTGRESQL engineFamily, got ${engineFamily}`,this);if(clientPasswordAuthType===ClientPasswordAuthType.POSTGRES_MD5&&engineFamily!=="POSTGRESQL")throw new(errors_1()).ValidationError(`${ClientPasswordAuthType.POSTGRES_MD5} client password authentication type requires POSTGRESQL engineFamily, got ${engineFamily}`,this);if(clientPasswordAuthType===ClientPasswordAuthType.SQL_SERVER_AUTHENTICATION&&engineFamily!=="SQLSERVER")throw new(errors_1()).ValidationError(`${ClientPasswordAuthType.SQL_SERVER_AUTHENTICATION} client password authentication type requires SQLSERVER engineFamily, got ${engineFamily}`,this)}}}exports.DatabaseProxy=DatabaseProxy,_c=JSII_RTTI_SYMBOL_1,DatabaseProxy[_c]={fqn:"aws-cdk-lib.aws_rds.DatabaseProxy",version:"2.188.0"},__decorate([(0,metadata_resource_1().MethodMetadata)()],DatabaseProxy.prototype,"asSecretAttachmentTarget",null),__decorate([(0,metadata_resource_1().MethodMetadata)()],DatabaseProxy.prototype,"grantConnect",null);function toConnectionPoolConfigurationInfo(props){return{connectionBorrowTimeout:props.borrowTimeout?.toSeconds(),initQuery:props.initQuery,maxConnectionsPercent:props.maxConnectionsPercent,maxIdleConnectionsPercent:props.maxIdleConnectionsPercent,sessionPinningFilters:props.sessionPinningFilters?.map(_=>_.filterName)}}
