import * as cdk from "../../core";
import * as constructs from "constructs";
import * as cfn_parse from "../../core/lib/helpers-internal";
/**
 * Creates a Recycle Bin retention rule. You can create two types of retention rules:.
 *
 * - *Tag-level retention rules* - These retention rules use resource tags to identify the resources to protect. For each retention rule, you specify one or more tag key and value pairs. Resources (of the specified type) that have at least one of these tag key and value pairs are automatically retained in the Recycle Bin upon deletion. Use this type of retention rule to protect specific resources in your account based on their tags.
 * - *Region-level retention rules* - These retention rules, by default, apply to all of the resources (of the specified type) in the Region, even if the resources are not tagged. However, you can specify exclusion tags to exclude resources that have specific tags. Use this type of retention rule to protect all resources of a specific type in a Region.
 *
 * For more information, see [Create Recycle Bin retention rules](https://docs.aws.amazon.com/ebs/latest/userguide/recycle-bin.html) in the *Amazon EBS User Guide* .
 *
 * @cloudformationResource AWS::Rbin::Rule
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rbin-rule.html
 */
export declare class CfnRule extends cdk.CfnResource implements cdk.IInspectable, cdk.ITaggableV2 {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME: string;
    /**
     * Build a CfnRule from CloudFormation properties
     *
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: constructs.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRule;
    /**
     * The Amazon Resource Name (ARN) of the retention rule.
     *
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * The unique ID of the retention rule.
     *
     * @cloudformationAttribute Identifier
     */
    readonly attrIdentifier: string;
    /**
     * [Region-level retention rules only] The lock state for the retention rule.
     *
     * - `locked` - The retention rule is locked and can't be modified or deleted.
     * - `pending_unlock` - The retention rule has been unlocked but it is still within the unlock delay period. The retention rule can be modified or deleted only after the unlock delay period has expired.
     * - `unlocked` - The retention rule is unlocked and it can be modified or deleted by any user with the required permissions.
     * - `null` - The retention rule has never been locked. Once a retention rule has been locked, it can transition between the `locked` and `unlocked` states only; it can never transition back to `null` .
     *
     * @cloudformationAttribute LockState
     */
    readonly attrLockState: string;
    /**
     * Tag Manager which manages the tags for this resource
     */
    readonly cdkTagManager: cdk.TagManager;
    /**
     * The retention rule description.
     */
    description?: string;
    /**
     * [Region-level retention rules only] Specifies the exclusion tags to use to identify resources that are to be excluded, or ignored, by a Region-level retention rule.
     */
    excludeResourceTags?: Array<cdk.IResolvable | CfnRule.ResourceTagProperty> | cdk.IResolvable;
    /**
     * Information about the retention rule lock configuration.
     */
    lockConfiguration?: cdk.IResolvable | CfnRule.UnlockDelayProperty;
    /**
     * [Tag-level retention rules only] Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule.
     */
    resourceTags?: Array<cdk.IResolvable | CfnRule.ResourceTagProperty> | cdk.IResolvable;
    /**
     * The resource type to be retained by the retention rule.
     */
    resourceType: string;
    /**
     * Information about the retention period for which the retention rule is to retain resources.
     */
    retentionPeriod: cdk.IResolvable | CfnRule.RetentionPeriodProperty;
    /**
     * The state of the retention rule.
     */
    status?: string;
    /**
     * Information about the tags to assign to the retention rule.
     */
    tags?: Array<cdk.CfnTag>;
    /**
     * @param scope Scope in which this resource is defined
     * @param id Construct identifier for this resource (unique in its scope)
     * @param props Resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnRuleProps);
    protected get cfnProperties(): Record<string, any>;
    /**
     * Examines the CloudFormation resource and discloses attributes
     *
     * @param inspector tree inspector to collect and process attributes
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected renderProperties(props: Record<string, any>): Record<string, any>;
}
export declare namespace CfnRule {
    /**
     * [Tag-level retention rules only] Information about the resource tags used to identify resources that are retained by the retention rule.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rbin-rule-resourcetag.html
     */
    interface ResourceTagProperty {
        /**
         * The tag key.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rbin-rule-resourcetag.html#cfn-rbin-rule-resourcetag-resourcetagkey
         */
        readonly resourceTagKey: string;
        /**
         * The tag value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rbin-rule-resourcetag.html#cfn-rbin-rule-resourcetag-resourcetagvalue
         */
        readonly resourceTagValue: string;
    }
    /**
     * Information about the retention period for which the retention rule is to retain resources.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rbin-rule-retentionperiod.html
     */
    interface RetentionPeriodProperty {
        /**
         * The unit of time in which the retention period is measured.
         *
         * Currently, only `DAYS` is supported.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rbin-rule-retentionperiod.html#cfn-rbin-rule-retentionperiod-retentionperiodunit
         */
        readonly retentionPeriodUnit: string;
        /**
         * The period value for which the retention rule is to retain resources.
         *
         * The period is measured using the unit specified for *RetentionPeriodUnit* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rbin-rule-retentionperiod.html#cfn-rbin-rule-retentionperiod-retentionperiodvalue
         */
        readonly retentionPeriodValue: number;
    }
    /**
     * Information about the retention rule unlock delay.
     *
     * The unlock delay is the period after which a retention rule can be modified or edited after it has been unlocked by a user with the required permissions. The retention rule can't be modified or deleted during the unlock delay.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rbin-rule-unlockdelay.html
     */
    interface UnlockDelayProperty {
        /**
         * The unit of time in which to measure the unlock delay.
         *
         * Currently, the unlock delay can be measure only in days.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rbin-rule-unlockdelay.html#cfn-rbin-rule-unlockdelay-unlockdelayunit
         */
        readonly unlockDelayUnit?: string;
        /**
         * The unlock delay period, measured in the unit specified for *UnlockDelayUnit* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rbin-rule-unlockdelay.html#cfn-rbin-rule-unlockdelay-unlockdelayvalue
         */
        readonly unlockDelayValue?: number;
    }
}
/**
 * Properties for defining a `CfnRule`
 *
 * @struct
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rbin-rule.html
 */
export interface CfnRuleProps {
    /**
     * The retention rule description.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rbin-rule.html#cfn-rbin-rule-description
     */
    readonly description?: string;
    /**
     * [Region-level retention rules only] Specifies the exclusion tags to use to identify resources that are to be excluded, or ignored, by a Region-level retention rule.
     *
     * Resources that have any of these tags are not retained by the retention rule upon deletion.
     *
     * You can't specify exclusion tags for tag-level retention rules.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rbin-rule.html#cfn-rbin-rule-excluderesourcetags
     */
    readonly excludeResourceTags?: Array<cdk.IResolvable | CfnRule.ResourceTagProperty> | cdk.IResolvable;
    /**
     * Information about the retention rule lock configuration.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rbin-rule.html#cfn-rbin-rule-lockconfiguration
     */
    readonly lockConfiguration?: cdk.IResolvable | CfnRule.UnlockDelayProperty;
    /**
     * [Tag-level retention rules only] Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule.
     *
     * For tag-level retention rules, only deleted resources, of the specified resource type, that have one or more of the specified tag key and value pairs are retained. If a resource is deleted, but it does not have any of the specified tag key and value pairs, it is immediately deleted without being retained by the retention rule.
     *
     * You can add the same tag key and value pair to a maximum or five retention rules.
     *
     * To create a Region-level retention rule, omit this parameter. A Region-level retention rule does not have any resource tags specified. It retains all deleted resources of the specified resource type in the Region in which the rule is created, even if the resources are not tagged.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rbin-rule.html#cfn-rbin-rule-resourcetags
     */
    readonly resourceTags?: Array<cdk.IResolvable | CfnRule.ResourceTagProperty> | cdk.IResolvable;
    /**
     * The resource type to be retained by the retention rule.
     *
     * Currently, only Amazon EBS snapshots and EBS-backed AMIs are supported. To retain snapshots, specify `EBS_SNAPSHOT` . To retain EBS-backed AMIs, specify `EC2_IMAGE` .
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rbin-rule.html#cfn-rbin-rule-resourcetype
     */
    readonly resourceType: string;
    /**
     * Information about the retention period for which the retention rule is to retain resources.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rbin-rule.html#cfn-rbin-rule-retentionperiod
     */
    readonly retentionPeriod: cdk.IResolvable | CfnRule.RetentionPeriodProperty;
    /**
     * The state of the retention rule.
     *
     * Only retention rules that are in the `available` state retain resources.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rbin-rule.html#cfn-rbin-rule-status
     */
    readonly status?: string;
    /**
     * Information about the tags to assign to the retention rule.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rbin-rule.html#cfn-rbin-rule-tags
     */
    readonly tags?: Array<cdk.CfnTag>;
}
