import * as cdk from "../../core";
import * as constructs from "constructs";
import * as cfn_parse from "../../core/lib/helpers-internal";
/**
 * Creates an analysis in Amazon QuickSight.
 *
 * @cloudformationResource AWS::QuickSight::Analysis
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export declare class CfnAnalysis extends cdk.CfnResource implements cdk.IInspectable, cdk.ITaggable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME: string;
    /**
     * Build a CfnAnalysis from CloudFormation properties
     *
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: constructs.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAnalysis;
    /**
     * The Amazon Resource Name (ARN) of the analysis.
     *
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * The time that the analysis was created.
     *
     * @cloudformationAttribute CreatedTime
     */
    readonly attrCreatedTime: string;
    /**
     * The ARNs of the datasets of the analysis.
     *
     * @cloudformationAttribute DataSetArns
     */
    readonly attrDataSetArns: Array<string>;
    /**
     * @cloudformationAttribute Errors
     */
    readonly attrErrors: cdk.IResolvable;
    /**
     * The time that the analysis was last updated.
     *
     * @cloudformationAttribute LastUpdatedTime
     */
    readonly attrLastUpdatedTime: string;
    /**
     * @cloudformationAttribute Sheets
     */
    readonly attrSheets: cdk.IResolvable;
    /**
     * The ID for the analysis that you're creating.
     */
    analysisId: string;
    /**
     * The ID of the AWS account where you are creating an analysis.
     */
    awsAccountId: string;
    definition?: CfnAnalysis.AnalysisDefinitionProperty | cdk.IResolvable;
    /**
     * Errors associated with the analysis.
     */
    errors?: Array<CfnAnalysis.AnalysisErrorProperty | cdk.IResolvable> | cdk.IResolvable;
    folderArns?: Array<string>;
    /**
     * A descriptive name for the analysis that you're creating.
     */
    name: string;
    /**
     * The parameter names and override values that you want to use.
     */
    parameters?: cdk.IResolvable | CfnAnalysis.ParametersProperty;
    /**
     * A structure that describes the principals and the resource-level permissions on an analysis.
     */
    permissions?: Array<cdk.IResolvable | CfnAnalysis.ResourcePermissionProperty> | cdk.IResolvable;
    /**
     * A list of the associated sheets with the unique identifier and name of each sheet.
     */
    sheets?: Array<cdk.IResolvable | CfnAnalysis.SheetProperty> | cdk.IResolvable;
    /**
     * A source entity to use for the analysis that you're creating.
     */
    sourceEntity?: CfnAnalysis.AnalysisSourceEntityProperty | cdk.IResolvable;
    /**
     * Status associated with the analysis.
     */
    status?: string;
    /**
     * Tag Manager which manages the tags for this resource
     */
    readonly tags: cdk.TagManager;
    /**
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the analysis.
     */
    tagsRaw?: Array<cdk.CfnTag>;
    /**
     * The ARN for the theme to apply to the analysis that you're creating.
     */
    themeArn?: string;
    /**
     * The option to relax the validation that is required to create and update analyses, dashboards, and templates with definition objects.
     */
    validationStrategy?: cdk.IResolvable | CfnAnalysis.ValidationStrategyProperty;
    /**
     * @param scope Scope in which this resource is defined
     * @param id Construct identifier for this resource (unique in its scope)
     * @param props Resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnAnalysisProps);
    protected get cfnProperties(): Record<string, any>;
    /**
     * Examines the CloudFormation resource and discloses attributes
     *
     * @param inspector tree inspector to collect and process attributes
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected renderProperties(props: Record<string, any>): Record<string, any>;
}
export declare namespace CfnAnalysis {
    /**
     * A list of Amazon QuickSight parameters and the list's override values.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameters.html
     */
    interface ParametersProperty {
        /**
         * The parameters that have a data type of date-time.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameters.html#cfn-quicksight-analysis-parameters-datetimeparameters
         */
        readonly dateTimeParameters?: Array<CfnAnalysis.DateTimeParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The parameters that have a data type of decimal.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameters.html#cfn-quicksight-analysis-parameters-decimalparameters
         */
        readonly decimalParameters?: Array<CfnAnalysis.DecimalParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The parameters that have a data type of integer.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameters.html#cfn-quicksight-analysis-parameters-integerparameters
         */
        readonly integerParameters?: Array<CfnAnalysis.IntegerParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The parameters that have a data type of string.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameters.html#cfn-quicksight-analysis-parameters-stringparameters
         */
        readonly stringParameters?: Array<cdk.IResolvable | CfnAnalysis.StringParameterProperty> | cdk.IResolvable;
    }
    /**
     * A string parameter.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringparameter.html
     */
    interface StringParameterProperty {
        /**
         * A display name for a string parameter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringparameter.html#cfn-quicksight-analysis-stringparameter-name
         */
        readonly name: string;
        /**
         * The values of a string parameter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringparameter.html#cfn-quicksight-analysis-stringparameter-values
         */
        readonly values: Array<string>;
    }
    /**
     * A decimal parameter.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameter.html
     */
    interface DecimalParameterProperty {
        /**
         * A display name for the decimal parameter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameter.html#cfn-quicksight-analysis-decimalparameter-name
         */
        readonly name: string;
        /**
         * The values for the decimal parameter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameter.html#cfn-quicksight-analysis-decimalparameter-values
         */
        readonly values: Array<number> | cdk.IResolvable;
    }
    /**
     * An integer parameter.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integerparameter.html
     */
    interface IntegerParameterProperty {
        /**
         * The name of the integer parameter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integerparameter.html#cfn-quicksight-analysis-integerparameter-name
         */
        readonly name: string;
        /**
         * The values for the integer parameter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integerparameter.html#cfn-quicksight-analysis-integerparameter-values
         */
        readonly values: Array<number> | cdk.IResolvable;
    }
    /**
     * A date-time parameter.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameter.html
     */
    interface DateTimeParameterProperty {
        /**
         * A display name for the date-time parameter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameter.html#cfn-quicksight-analysis-datetimeparameter-name
         */
        readonly name: string;
        /**
         * The values for the date-time parameter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameter.html#cfn-quicksight-analysis-datetimeparameter-values
         */
        readonly values: Array<string>;
    }
    /**
     * The source entity of an analysis.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourceentity.html
     */
    interface AnalysisSourceEntityProperty {
        /**
         * The source template for the source entity of the analysis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourceentity.html#cfn-quicksight-analysis-analysissourceentity-sourcetemplate
         */
        readonly sourceTemplate?: CfnAnalysis.AnalysisSourceTemplateProperty | cdk.IResolvable;
    }
    /**
     * The source template of an analysis.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourcetemplate.html
     */
    interface AnalysisSourceTemplateProperty {
        /**
         * The Amazon Resource Name (ARN) of the source template of an analysis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourcetemplate.html#cfn-quicksight-analysis-analysissourcetemplate-arn
         */
        readonly arn: string;
        /**
         * The dataset references of the source template of an analysis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourcetemplate.html#cfn-quicksight-analysis-analysissourcetemplate-datasetreferences
         */
        readonly dataSetReferences: Array<CfnAnalysis.DataSetReferenceProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * Dataset reference.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datasetreference.html
     */
    interface DataSetReferenceProperty {
        /**
         * Dataset Amazon Resource Name (ARN).
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datasetreference.html#cfn-quicksight-analysis-datasetreference-datasetarn
         */
        readonly dataSetArn: string;
        /**
         * Dataset placeholder.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datasetreference.html#cfn-quicksight-analysis-datasetreference-datasetplaceholder
         */
        readonly dataSetPlaceholder: string;
    }
    /**
     * The definition of an analysis.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html
     */
    interface AnalysisDefinitionProperty {
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-analysisdefaults
         */
        readonly analysisDefaults?: CfnAnalysis.AnalysisDefaultsProperty | cdk.IResolvable;
        /**
         * An array of calculated field definitions for the analysis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-calculatedfields
         */
        readonly calculatedFields?: Array<CfnAnalysis.CalculatedFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * An array of analysis-level column configurations.
         *
         * Column configurations can be used to set default formatting for a column to be used throughout an analysis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-columnconfigurations
         */
        readonly columnConfigurations?: Array<CfnAnalysis.ColumnConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * An array of dataset identifier declarations.
         *
         * This mapping allows the usage of dataset identifiers instead of dataset ARNs throughout analysis sub-structures.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-datasetidentifierdeclarations
         */
        readonly dataSetIdentifierDeclarations: Array<CfnAnalysis.DataSetIdentifierDeclarationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * Filter definitions for an analysis.
         *
         * For more information, see [Filtering Data in Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/adding-a-filter.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-filtergroups
         */
        readonly filterGroups?: Array<CfnAnalysis.FilterGroupProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * An array of option definitions for an analysis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-options
         */
        readonly options?: CfnAnalysis.AssetOptionsProperty | cdk.IResolvable;
        /**
         * An array of parameter declarations for an analysis.
         *
         * Parameters are named variables that can transfer a value for use by an action or an object.
         *
         * For more information, see [Parameters in Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-parameterdeclarations
         */
        readonly parameterDeclarations?: Array<cdk.IResolvable | CfnAnalysis.ParameterDeclarationProperty> | cdk.IResolvable;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-queryexecutionoptions
         */
        readonly queryExecutionOptions?: cdk.IResolvable | CfnAnalysis.QueryExecutionOptionsProperty;
        /**
         * An array of sheet definitions for an analysis.
         *
         * Each `SheetDefinition` provides detailed information about a sheet within this analysis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-sheets
         */
        readonly sheets?: Array<cdk.IResolvable | CfnAnalysis.SheetDefinitionProperty> | cdk.IResolvable;
        /**
         * The static files for the definition.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html#cfn-quicksight-analysis-analysisdefinition-staticfiles
         */
        readonly staticFiles?: Array<cdk.IResolvable | CfnAnalysis.StaticFileProperty> | cdk.IResolvable;
    }
    /**
     * A grouping of individual filters. Filter groups are applied to the same group of visuals.
     *
     * For more information, see [Adding filter conditions (group filters) with AND and OR operators](https://docs.aws.amazon.com/quicksight/latest/user/add-a-compound-filter.html) in the *Amazon QuickSight User Guide* .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtergroup.html
     */
    interface FilterGroupProperty {
        /**
         * The filter new feature which can apply filter group to all data sets. Choose one of the following options:.
         *
         * - `ALL_DATASETS`
         * - `SINGLE_DATASET`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtergroup.html#cfn-quicksight-analysis-filtergroup-crossdataset
         */
        readonly crossDataset: string;
        /**
         * The value that uniquely identifies a `FilterGroup` within a dashboard, template, or analysis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtergroup.html#cfn-quicksight-analysis-filtergroup-filtergroupid
         */
        readonly filterGroupId: string;
        /**
         * The list of filters that are present in a `FilterGroup` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtergroup.html#cfn-quicksight-analysis-filtergroup-filters
         */
        readonly filters: Array<CfnAnalysis.FilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The configuration that specifies what scope to apply to a `FilterGroup` .
         *
         * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtergroup.html#cfn-quicksight-analysis-filtergroup-scopeconfiguration
         */
        readonly scopeConfiguration: CfnAnalysis.FilterScopeConfigurationProperty | cdk.IResolvable;
        /**
         * The status of the `FilterGroup` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtergroup.html#cfn-quicksight-analysis-filtergroup-status
         */
        readonly status?: string;
    }
    /**
     * With a `Filter` , you can remove portions of data from a particular visual or view.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filter.html
     */
    interface FilterProperty {
        /**
         * A `CategoryFilter` filters text values.
         *
         * For more information, see [Adding text filters](https://docs.aws.amazon.com/quicksight/latest/user/add-a-text-filter-data-prep.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filter.html#cfn-quicksight-analysis-filter-categoryfilter
         */
        readonly categoryFilter?: CfnAnalysis.CategoryFilterProperty | cdk.IResolvable;
        /**
         * A `NestedFilter` filters data with a subset of data that is defined by the nested inner filter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filter.html#cfn-quicksight-analysis-filter-nestedfilter
         */
        readonly nestedFilter?: cdk.IResolvable | CfnAnalysis.NestedFilterProperty;
        /**
         * A `NumericEqualityFilter` filters numeric values that equal or do not equal a given numeric value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filter.html#cfn-quicksight-analysis-filter-numericequalityfilter
         */
        readonly numericEqualityFilter?: cdk.IResolvable | CfnAnalysis.NumericEqualityFilterProperty;
        /**
         * A `NumericRangeFilter` filters numeric values that are either inside or outside a given numeric range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filter.html#cfn-quicksight-analysis-filter-numericrangefilter
         */
        readonly numericRangeFilter?: cdk.IResolvable | CfnAnalysis.NumericRangeFilterProperty;
        /**
         * A `RelativeDatesFilter` filters date values that are relative to a given date.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filter.html#cfn-quicksight-analysis-filter-relativedatesfilter
         */
        readonly relativeDatesFilter?: cdk.IResolvable | CfnAnalysis.RelativeDatesFilterProperty;
        /**
         * A `TimeEqualityFilter` filters date-time values that equal or do not equal a given date/time value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filter.html#cfn-quicksight-analysis-filter-timeequalityfilter
         */
        readonly timeEqualityFilter?: cdk.IResolvable | CfnAnalysis.TimeEqualityFilterProperty;
        /**
         * A `TimeRangeFilter` filters date-time values that are either inside or outside a given date/time range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filter.html#cfn-quicksight-analysis-filter-timerangefilter
         */
        readonly timeRangeFilter?: cdk.IResolvable | CfnAnalysis.TimeRangeFilterProperty;
        /**
         * A `TopBottomFilter` filters data to the top or bottom values for a given column.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filter.html#cfn-quicksight-analysis-filter-topbottomfilter
         */
        readonly topBottomFilter?: cdk.IResolvable | CfnAnalysis.TopBottomFilterProperty;
    }
    /**
     * A `NumericEqualityFilter` filters values that are equal to the specified value.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericequalityfilter.html
     */
    interface NumericEqualityFilterProperty {
        /**
         * The aggregation function of the filter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericequalityfilter.html#cfn-quicksight-analysis-numericequalityfilter-aggregationfunction
         */
        readonly aggregationFunction?: CfnAnalysis.AggregationFunctionProperty | cdk.IResolvable;
        /**
         * The column that the filter is applied to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericequalityfilter.html#cfn-quicksight-analysis-numericequalityfilter-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The default configurations for the associated controls.
         *
         * This applies only for filters that are scoped to multiple sheets.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericequalityfilter.html#cfn-quicksight-analysis-numericequalityfilter-defaultfiltercontrolconfiguration
         */
        readonly defaultFilterControlConfiguration?: CfnAnalysis.DefaultFilterControlConfigurationProperty | cdk.IResolvable;
        /**
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericequalityfilter.html#cfn-quicksight-analysis-numericequalityfilter-filterid
         */
        readonly filterId: string;
        /**
         * The match operator that is used to determine if a filter should be applied.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericequalityfilter.html#cfn-quicksight-analysis-numericequalityfilter-matchoperator
         */
        readonly matchOperator: string;
        /**
         * This option determines how null values should be treated when filtering data.
         *
         * - `ALL_VALUES` : Include null values in filtered results.
         * - `NULLS_ONLY` : Only include null values in filtered results.
         * - `NON_NULLS_ONLY` : Exclude null values from filtered results.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericequalityfilter.html#cfn-quicksight-analysis-numericequalityfilter-nulloption
         */
        readonly nullOption: string;
        /**
         * The parameter whose value should be used for the filter value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericequalityfilter.html#cfn-quicksight-analysis-numericequalityfilter-parametername
         */
        readonly parameterName?: string;
        /**
         * Select all of the values. Null is not the assigned value of select all.
         *
         * - `FILTER_ALL_VALUES`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericequalityfilter.html#cfn-quicksight-analysis-numericequalityfilter-selectalloptions
         */
        readonly selectAllOptions?: string;
        /**
         * The input value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericequalityfilter.html#cfn-quicksight-analysis-numericequalityfilter-value
         */
        readonly value?: number;
    }
    /**
     * An aggregation function aggregates values from a dimension or measure.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationfunction.html
     */
    interface AggregationFunctionProperty {
        /**
         * Aggregation for attributes.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationfunction.html#cfn-quicksight-analysis-aggregationfunction-attributeaggregationfunction
         */
        readonly attributeAggregationFunction?: CfnAnalysis.AttributeAggregationFunctionProperty | cdk.IResolvable;
        /**
         * Aggregation for categorical values.
         *
         * - `COUNT` : Aggregate by the total number of values, including duplicates.
         * - `DISTINCT_COUNT` : Aggregate by the total number of distinct values.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationfunction.html#cfn-quicksight-analysis-aggregationfunction-categoricalaggregationfunction
         */
        readonly categoricalAggregationFunction?: string;
        /**
         * Aggregation for date values.
         *
         * - `COUNT` : Aggregate by the total number of values, including duplicates.
         * - `DISTINCT_COUNT` : Aggregate by the total number of distinct values.
         * - `MIN` : Select the smallest date value.
         * - `MAX` : Select the largest date value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationfunction.html#cfn-quicksight-analysis-aggregationfunction-dateaggregationfunction
         */
        readonly dateAggregationFunction?: string;
        /**
         * Aggregation for numerical values.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationfunction.html#cfn-quicksight-analysis-aggregationfunction-numericalaggregationfunction
         */
        readonly numericalAggregationFunction?: cdk.IResolvable | CfnAnalysis.NumericalAggregationFunctionProperty;
    }
    /**
     * Aggregation for attributes.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-attributeaggregationfunction.html
     */
    interface AttributeAggregationFunctionProperty {
        /**
         * The built-in aggregation functions for attributes.
         *
         * - `UNIQUE_VALUE` : Returns the unique value for a field, aggregated by the dimension fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-attributeaggregationfunction.html#cfn-quicksight-analysis-attributeaggregationfunction-simpleattributeaggregation
         */
        readonly simpleAttributeAggregation?: string;
        /**
         * Used by the `UNIQUE_VALUE` aggregation function.
         *
         * If there are multiple values for the field used by the aggregation, the value for this property will be returned instead. Defaults to '*'.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-attributeaggregationfunction.html#cfn-quicksight-analysis-attributeaggregationfunction-valueformultiplevalues
         */
        readonly valueForMultipleValues?: string;
    }
    /**
     * Aggregation for numerical values.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericalaggregationfunction.html
     */
    interface NumericalAggregationFunctionProperty {
        /**
         * An aggregation based on the percentile of values in a dimension or measure.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericalaggregationfunction.html#cfn-quicksight-analysis-numericalaggregationfunction-percentileaggregation
         */
        readonly percentileAggregation?: cdk.IResolvable | CfnAnalysis.PercentileAggregationProperty;
        /**
         * Built-in aggregation functions for numerical values.
         *
         * - `SUM` : The sum of a dimension or measure.
         * - `AVERAGE` : The average of a dimension or measure.
         * - `MIN` : The minimum value of a dimension or measure.
         * - `MAX` : The maximum value of a dimension or measure.
         * - `COUNT` : The count of a dimension or measure.
         * - `DISTINCT_COUNT` : The count of distinct values in a dimension or measure.
         * - `VAR` : The variance of a dimension or measure.
         * - `VARP` : The partitioned variance of a dimension or measure.
         * - `STDEV` : The standard deviation of a dimension or measure.
         * - `STDEVP` : The partitioned standard deviation of a dimension or measure.
         * - `MEDIAN` : The median value of a dimension or measure.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericalaggregationfunction.html#cfn-quicksight-analysis-numericalaggregationfunction-simplenumericalaggregation
         */
        readonly simpleNumericalAggregation?: string;
    }
    /**
     * An aggregation based on the percentile of values in a dimension or measure.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-percentileaggregation.html
     */
    interface PercentileAggregationProperty {
        /**
         * The percentile value.
         *
         * This value can be any numeric constant 0–100. A percentile value of 50 computes the median value of the measure.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-percentileaggregation.html#cfn-quicksight-analysis-percentileaggregation-percentilevalue
         */
        readonly percentileValue?: number;
    }
    /**
     * A column of a data set.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnidentifier.html
     */
    interface ColumnIdentifierProperty {
        /**
         * The name of the column.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnidentifier.html#cfn-quicksight-analysis-columnidentifier-columnname
         */
        readonly columnName: string;
        /**
         * The data set that the column belongs to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnidentifier.html#cfn-quicksight-analysis-columnidentifier-datasetidentifier
         */
        readonly dataSetIdentifier: string;
    }
    /**
     * The default configuration for all dependent controls of the filter.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfiltercontrolconfiguration.html
     */
    interface DefaultFilterControlConfigurationProperty {
        /**
         * The control option for the `DefaultFilterControlConfiguration` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfiltercontrolconfiguration.html#cfn-quicksight-analysis-defaultfiltercontrolconfiguration-controloptions
         */
        readonly controlOptions: CfnAnalysis.DefaultFilterControlOptionsProperty | cdk.IResolvable;
        /**
         * The title of the `DefaultFilterControlConfiguration` .
         *
         * This title is shared by all controls that are tied to this filter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfiltercontrolconfiguration.html#cfn-quicksight-analysis-defaultfiltercontrolconfiguration-title
         */
        readonly title: string;
    }
    /**
     * The option that corresponds to the control type of the filter.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfiltercontroloptions.html
     */
    interface DefaultFilterControlOptionsProperty {
        /**
         * The default options that correspond to the filter control type of a `DateTimePicker` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfiltercontroloptions.html#cfn-quicksight-analysis-defaultfiltercontroloptions-defaultdatetimepickeroptions
         */
        readonly defaultDateTimePickerOptions?: CfnAnalysis.DefaultDateTimePickerControlOptionsProperty | cdk.IResolvable;
        /**
         * The default options that correspond to the `Dropdown` filter control type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfiltercontroloptions.html#cfn-quicksight-analysis-defaultfiltercontroloptions-defaultdropdownoptions
         */
        readonly defaultDropdownOptions?: CfnAnalysis.DefaultFilterDropDownControlOptionsProperty | cdk.IResolvable;
        /**
         * The default options that correspond to the `List` filter control type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfiltercontroloptions.html#cfn-quicksight-analysis-defaultfiltercontroloptions-defaultlistoptions
         */
        readonly defaultListOptions?: CfnAnalysis.DefaultFilterListControlOptionsProperty | cdk.IResolvable;
        /**
         * The default options that correspond to the `RelativeDateTime` filter control type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfiltercontroloptions.html#cfn-quicksight-analysis-defaultfiltercontroloptions-defaultrelativedatetimeoptions
         */
        readonly defaultRelativeDateTimeOptions?: CfnAnalysis.DefaultRelativeDateTimeControlOptionsProperty | cdk.IResolvable;
        /**
         * The default options that correspond to the `Slider` filter control type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfiltercontroloptions.html#cfn-quicksight-analysis-defaultfiltercontroloptions-defaultslideroptions
         */
        readonly defaultSliderOptions?: CfnAnalysis.DefaultSliderControlOptionsProperty | cdk.IResolvable;
        /**
         * The default options that correspond to the `TextArea` filter control type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfiltercontroloptions.html#cfn-quicksight-analysis-defaultfiltercontroloptions-defaulttextareaoptions
         */
        readonly defaultTextAreaOptions?: CfnAnalysis.DefaultTextAreaControlOptionsProperty | cdk.IResolvable;
        /**
         * The default options that correspond to the `TextField` filter control type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfiltercontroloptions.html#cfn-quicksight-analysis-defaultfiltercontroloptions-defaulttextfieldoptions
         */
        readonly defaultTextFieldOptions?: CfnAnalysis.DefaultTextFieldControlOptionsProperty | cdk.IResolvable;
    }
    /**
     * The default options that correspond to the `Slider` filter control type.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultslidercontroloptions.html
     */
    interface DefaultSliderControlOptionsProperty {
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultslidercontroloptions.html#cfn-quicksight-analysis-defaultslidercontroloptions-displayoptions
         */
        readonly displayOptions?: cdk.IResolvable | CfnAnalysis.SliderControlDisplayOptionsProperty;
        /**
         * The larger value that is displayed at the right of the slider.
         *
         * @default - 0
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultslidercontroloptions.html#cfn-quicksight-analysis-defaultslidercontroloptions-maximumvalue
         */
        readonly maximumValue: number;
        /**
         * The smaller value that is displayed at the left of the slider.
         *
         * @default - 0
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultslidercontroloptions.html#cfn-quicksight-analysis-defaultslidercontroloptions-minimumvalue
         */
        readonly minimumValue: number;
        /**
         * The number of increments that the slider bar is divided into.
         *
         * @default - 0
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultslidercontroloptions.html#cfn-quicksight-analysis-defaultslidercontroloptions-stepsize
         */
        readonly stepSize: number;
        /**
         * The type of the `DefaultSliderControlOptions` . Choose one of the following options:.
         *
         * - `SINGLE_POINT` : Filter against(equals) a single data point.
         * - `RANGE` : Filter data that is in a specified range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultslidercontroloptions.html#cfn-quicksight-analysis-defaultslidercontroloptions-type
         */
        readonly type?: string;
    }
    /**
     * The display options of a control.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-slidercontroldisplayoptions.html
     */
    interface SliderControlDisplayOptionsProperty {
        /**
         * The configuration of info icon label options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-slidercontroldisplayoptions.html#cfn-quicksight-analysis-slidercontroldisplayoptions-infoiconlabeloptions
         */
        readonly infoIconLabelOptions?: cdk.IResolvable | CfnAnalysis.SheetControlInfoIconLabelOptionsProperty;
        /**
         * The options to configure the title visibility, name, and font size.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-slidercontroldisplayoptions.html#cfn-quicksight-analysis-slidercontroldisplayoptions-titleoptions
         */
        readonly titleOptions?: cdk.IResolvable | CfnAnalysis.LabelOptionsProperty;
    }
    /**
     * The share label options for the labels.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-labeloptions.html
     */
    interface LabelOptionsProperty {
        /**
         * The text for the label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-labeloptions.html#cfn-quicksight-analysis-labeloptions-customlabel
         */
        readonly customLabel?: string;
        /**
         * The font configuration of the label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-labeloptions.html#cfn-quicksight-analysis-labeloptions-fontconfiguration
         */
        readonly fontConfiguration?: CfnAnalysis.FontConfigurationProperty | cdk.IResolvable;
        /**
         * Determines whether or not the label is visible.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-labeloptions.html#cfn-quicksight-analysis-labeloptions-visibility
         */
        readonly visibility?: string;
    }
    /**
     * Configures the display properties of the given text.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fontconfiguration.html
     */
    interface FontConfigurationProperty {
        /**
         * Determines the color of the text.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fontconfiguration.html#cfn-quicksight-analysis-fontconfiguration-fontcolor
         */
        readonly fontColor?: string;
        /**
         * Determines the appearance of decorative lines on the text.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fontconfiguration.html#cfn-quicksight-analysis-fontconfiguration-fontdecoration
         */
        readonly fontDecoration?: string;
        /**
         * The font family that you want to use.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fontconfiguration.html#cfn-quicksight-analysis-fontconfiguration-fontfamily
         */
        readonly fontFamily?: string;
        /**
         * The option that determines the text display size.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fontconfiguration.html#cfn-quicksight-analysis-fontconfiguration-fontsize
         */
        readonly fontSize?: CfnAnalysis.FontSizeProperty | cdk.IResolvable;
        /**
         * Determines the text display face that is inherited by the given font family.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fontconfiguration.html#cfn-quicksight-analysis-fontconfiguration-fontstyle
         */
        readonly fontStyle?: string;
        /**
         * The option that determines the text display weight, or boldness.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fontconfiguration.html#cfn-quicksight-analysis-fontconfiguration-fontweight
         */
        readonly fontWeight?: CfnAnalysis.FontWeightProperty | cdk.IResolvable;
    }
    /**
     * The option that determines the text display size.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fontsize.html
     */
    interface FontSizeProperty {
        /**
         * The font size that you want to use in px.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fontsize.html#cfn-quicksight-analysis-fontsize-absolute
         */
        readonly absolute?: string;
        /**
         * The lexical name for the text size, proportional to its surrounding context.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fontsize.html#cfn-quicksight-analysis-fontsize-relative
         */
        readonly relative?: string;
    }
    /**
     * The option that determines the text display weight, or boldness.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fontweight.html
     */
    interface FontWeightProperty {
        /**
         * The lexical name for the level of boldness of the text display.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fontweight.html#cfn-quicksight-analysis-fontweight-name
         */
        readonly name?: string;
    }
    /**
     * A control to display info icons for filters and parameters.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetcontrolinfoiconlabeloptions.html
     */
    interface SheetControlInfoIconLabelOptionsProperty {
        /**
         * The text content of info icon.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetcontrolinfoiconlabeloptions.html#cfn-quicksight-analysis-sheetcontrolinfoiconlabeloptions-infoicontext
         */
        readonly infoIconText?: string;
        /**
         * The visibility configuration of info icon label options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetcontrolinfoiconlabeloptions.html#cfn-quicksight-analysis-sheetcontrolinfoiconlabeloptions-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The default options that correspond to the `RelativeDateTime` filter control type.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultrelativedatetimecontroloptions.html
     */
    interface DefaultRelativeDateTimeControlOptionsProperty {
        /**
         * The visibility configuration of the Apply button on a `RelativeDateTimeControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultrelativedatetimecontroloptions.html#cfn-quicksight-analysis-defaultrelativedatetimecontroloptions-commitmode
         */
        readonly commitMode?: string;
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultrelativedatetimecontroloptions.html#cfn-quicksight-analysis-defaultrelativedatetimecontroloptions-displayoptions
         */
        readonly displayOptions?: cdk.IResolvable | CfnAnalysis.RelativeDateTimeControlDisplayOptionsProperty;
    }
    /**
     * The display options of a control.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-relativedatetimecontroldisplayoptions.html
     */
    interface RelativeDateTimeControlDisplayOptionsProperty {
        /**
         * Customize how dates are formatted in controls.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-relativedatetimecontroldisplayoptions.html#cfn-quicksight-analysis-relativedatetimecontroldisplayoptions-datetimeformat
         */
        readonly dateTimeFormat?: string;
        /**
         * The configuration of info icon label options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-relativedatetimecontroldisplayoptions.html#cfn-quicksight-analysis-relativedatetimecontroldisplayoptions-infoiconlabeloptions
         */
        readonly infoIconLabelOptions?: cdk.IResolvable | CfnAnalysis.SheetControlInfoIconLabelOptionsProperty;
        /**
         * The options to configure the title visibility, name, and font size.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-relativedatetimecontroldisplayoptions.html#cfn-quicksight-analysis-relativedatetimecontroldisplayoptions-titleoptions
         */
        readonly titleOptions?: cdk.IResolvable | CfnAnalysis.LabelOptionsProperty;
    }
    /**
     * The default options that correspond to the `TextField` filter control type.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaulttextfieldcontroloptions.html
     */
    interface DefaultTextFieldControlOptionsProperty {
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaulttextfieldcontroloptions.html#cfn-quicksight-analysis-defaulttextfieldcontroloptions-displayoptions
         */
        readonly displayOptions?: cdk.IResolvable | CfnAnalysis.TextFieldControlDisplayOptionsProperty;
    }
    /**
     * The display options of a control.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-textfieldcontroldisplayoptions.html
     */
    interface TextFieldControlDisplayOptionsProperty {
        /**
         * The configuration of info icon label options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-textfieldcontroldisplayoptions.html#cfn-quicksight-analysis-textfieldcontroldisplayoptions-infoiconlabeloptions
         */
        readonly infoIconLabelOptions?: cdk.IResolvable | CfnAnalysis.SheetControlInfoIconLabelOptionsProperty;
        /**
         * The configuration of the placeholder options in a text field control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-textfieldcontroldisplayoptions.html#cfn-quicksight-analysis-textfieldcontroldisplayoptions-placeholderoptions
         */
        readonly placeholderOptions?: cdk.IResolvable | CfnAnalysis.TextControlPlaceholderOptionsProperty;
        /**
         * The options to configure the title visibility, name, and font size.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-textfieldcontroldisplayoptions.html#cfn-quicksight-analysis-textfieldcontroldisplayoptions-titleoptions
         */
        readonly titleOptions?: cdk.IResolvable | CfnAnalysis.LabelOptionsProperty;
    }
    /**
     * The configuration of the placeholder options in a text control.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-textcontrolplaceholderoptions.html
     */
    interface TextControlPlaceholderOptionsProperty {
        /**
         * The visibility configuration of the placeholder options in a text control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-textcontrolplaceholderoptions.html#cfn-quicksight-analysis-textcontrolplaceholderoptions-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The default options that correspond to the `TextArea` filter control type.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaulttextareacontroloptions.html
     */
    interface DefaultTextAreaControlOptionsProperty {
        /**
         * The delimiter that is used to separate the lines in text.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaulttextareacontroloptions.html#cfn-quicksight-analysis-defaulttextareacontroloptions-delimiter
         */
        readonly delimiter?: string;
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaulttextareacontroloptions.html#cfn-quicksight-analysis-defaulttextareacontroloptions-displayoptions
         */
        readonly displayOptions?: cdk.IResolvable | CfnAnalysis.TextAreaControlDisplayOptionsProperty;
    }
    /**
     * The display options of a control.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-textareacontroldisplayoptions.html
     */
    interface TextAreaControlDisplayOptionsProperty {
        /**
         * The configuration of info icon label options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-textareacontroldisplayoptions.html#cfn-quicksight-analysis-textareacontroldisplayoptions-infoiconlabeloptions
         */
        readonly infoIconLabelOptions?: cdk.IResolvable | CfnAnalysis.SheetControlInfoIconLabelOptionsProperty;
        /**
         * The configuration of the placeholder options in a text area control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-textareacontroldisplayoptions.html#cfn-quicksight-analysis-textareacontroldisplayoptions-placeholderoptions
         */
        readonly placeholderOptions?: cdk.IResolvable | CfnAnalysis.TextControlPlaceholderOptionsProperty;
        /**
         * The options to configure the title visibility, name, and font size.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-textareacontroldisplayoptions.html#cfn-quicksight-analysis-textareacontroldisplayoptions-titleoptions
         */
        readonly titleOptions?: cdk.IResolvable | CfnAnalysis.LabelOptionsProperty;
    }
    /**
     * The default options that correspond to the `Dropdown` filter control type.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfilterdropdowncontroloptions.html
     */
    interface DefaultFilterDropDownControlOptionsProperty {
        /**
         * The visibility configuration of the Apply button on a `FilterDropDownControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfilterdropdowncontroloptions.html#cfn-quicksight-analysis-defaultfilterdropdowncontroloptions-commitmode
         */
        readonly commitMode?: string;
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfilterdropdowncontroloptions.html#cfn-quicksight-analysis-defaultfilterdropdowncontroloptions-displayoptions
         */
        readonly displayOptions?: CfnAnalysis.DropDownControlDisplayOptionsProperty | cdk.IResolvable;
        /**
         * A list of selectable values that are used in a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfilterdropdowncontroloptions.html#cfn-quicksight-analysis-defaultfilterdropdowncontroloptions-selectablevalues
         */
        readonly selectableValues?: CfnAnalysis.FilterSelectableValuesProperty | cdk.IResolvable;
        /**
         * The type of the `FilterDropDownControl` . Choose one of the following options:.
         *
         * - `MULTI_SELECT` : The user can select multiple entries from a dropdown menu.
         * - `SINGLE_SELECT` : The user can select a single entry from a dropdown menu.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfilterdropdowncontroloptions.html#cfn-quicksight-analysis-defaultfilterdropdowncontroloptions-type
         */
        readonly type?: string;
    }
    /**
     * The display options of a control.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-dropdowncontroldisplayoptions.html
     */
    interface DropDownControlDisplayOptionsProperty {
        /**
         * The configuration of info icon label options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-dropdowncontroldisplayoptions.html#cfn-quicksight-analysis-dropdowncontroldisplayoptions-infoiconlabeloptions
         */
        readonly infoIconLabelOptions?: cdk.IResolvable | CfnAnalysis.SheetControlInfoIconLabelOptionsProperty;
        /**
         * The configuration of the `Select all` options in a dropdown control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-dropdowncontroldisplayoptions.html#cfn-quicksight-analysis-dropdowncontroldisplayoptions-selectalloptions
         */
        readonly selectAllOptions?: cdk.IResolvable | CfnAnalysis.ListControlSelectAllOptionsProperty;
        /**
         * The options to configure the title visibility, name, and font size.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-dropdowncontroldisplayoptions.html#cfn-quicksight-analysis-dropdowncontroldisplayoptions-titleoptions
         */
        readonly titleOptions?: cdk.IResolvable | CfnAnalysis.LabelOptionsProperty;
    }
    /**
     * The configuration of the `Select all` options in a list control.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-listcontrolselectalloptions.html
     */
    interface ListControlSelectAllOptionsProperty {
        /**
         * The visibility configuration of the `Select all` options in a list control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-listcontrolselectalloptions.html#cfn-quicksight-analysis-listcontrolselectalloptions-visibility
         */
        readonly visibility?: string;
    }
    /**
     * A list of selectable values that are used in a control.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterselectablevalues.html
     */
    interface FilterSelectableValuesProperty {
        /**
         * The values that are used in the `FilterSelectableValues` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterselectablevalues.html#cfn-quicksight-analysis-filterselectablevalues-values
         */
        readonly values?: Array<string>;
    }
    /**
     * The default options that correspond to the filter control type of a `DateTimePicker` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultdatetimepickercontroloptions.html
     */
    interface DefaultDateTimePickerControlOptionsProperty {
        /**
         * The visibility configuration of the Apply button on a `DateTimePickerControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultdatetimepickercontroloptions.html#cfn-quicksight-analysis-defaultdatetimepickercontroloptions-commitmode
         */
        readonly commitMode?: string;
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultdatetimepickercontroloptions.html#cfn-quicksight-analysis-defaultdatetimepickercontroloptions-displayoptions
         */
        readonly displayOptions?: CfnAnalysis.DateTimePickerControlDisplayOptionsProperty | cdk.IResolvable;
        /**
         * The date time picker type of the `DefaultDateTimePickerControlOptions` . Choose one of the following options:.
         *
         * - `SINGLE_VALUED` : The filter condition is a fixed date.
         * - `DATE_RANGE` : The filter condition is a date time range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultdatetimepickercontroloptions.html#cfn-quicksight-analysis-defaultdatetimepickercontroloptions-type
         */
        readonly type?: string;
    }
    /**
     * The display options of a control.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimepickercontroldisplayoptions.html
     */
    interface DateTimePickerControlDisplayOptionsProperty {
        /**
         * The date icon visibility of the `DateTimePickerControlDisplayOptions` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimepickercontroldisplayoptions.html#cfn-quicksight-analysis-datetimepickercontroldisplayoptions-dateiconvisibility
         */
        readonly dateIconVisibility?: string;
        /**
         * Customize how dates are formatted in controls.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimepickercontroldisplayoptions.html#cfn-quicksight-analysis-datetimepickercontroldisplayoptions-datetimeformat
         */
        readonly dateTimeFormat?: string;
        /**
         * The helper text visibility of the `DateTimePickerControlDisplayOptions` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimepickercontroldisplayoptions.html#cfn-quicksight-analysis-datetimepickercontroldisplayoptions-helpertextvisibility
         */
        readonly helperTextVisibility?: string;
        /**
         * The configuration of info icon label options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimepickercontroldisplayoptions.html#cfn-quicksight-analysis-datetimepickercontroldisplayoptions-infoiconlabeloptions
         */
        readonly infoIconLabelOptions?: cdk.IResolvable | CfnAnalysis.SheetControlInfoIconLabelOptionsProperty;
        /**
         * The options to configure the title visibility, name, and font size.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimepickercontroldisplayoptions.html#cfn-quicksight-analysis-datetimepickercontroldisplayoptions-titleoptions
         */
        readonly titleOptions?: cdk.IResolvable | CfnAnalysis.LabelOptionsProperty;
    }
    /**
     * The default options that correspond to the `List` filter control type.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfilterlistcontroloptions.html
     */
    interface DefaultFilterListControlOptionsProperty {
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfilterlistcontroloptions.html#cfn-quicksight-analysis-defaultfilterlistcontroloptions-displayoptions
         */
        readonly displayOptions?: cdk.IResolvable | CfnAnalysis.ListControlDisplayOptionsProperty;
        /**
         * A list of selectable values that are used in a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfilterlistcontroloptions.html#cfn-quicksight-analysis-defaultfilterlistcontroloptions-selectablevalues
         */
        readonly selectableValues?: CfnAnalysis.FilterSelectableValuesProperty | cdk.IResolvable;
        /**
         * The type of the `DefaultFilterListControlOptions` . Choose one of the following options:.
         *
         * - `MULTI_SELECT` : The user can select multiple entries from the list.
         * - `SINGLE_SELECT` : The user can select a single entry from the list.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfilterlistcontroloptions.html#cfn-quicksight-analysis-defaultfilterlistcontroloptions-type
         */
        readonly type?: string;
    }
    /**
     * The display options of a control.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-listcontroldisplayoptions.html
     */
    interface ListControlDisplayOptionsProperty {
        /**
         * The configuration of info icon label options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-listcontroldisplayoptions.html#cfn-quicksight-analysis-listcontroldisplayoptions-infoiconlabeloptions
         */
        readonly infoIconLabelOptions?: cdk.IResolvable | CfnAnalysis.SheetControlInfoIconLabelOptionsProperty;
        /**
         * The configuration of the search options in a list control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-listcontroldisplayoptions.html#cfn-quicksight-analysis-listcontroldisplayoptions-searchoptions
         */
        readonly searchOptions?: cdk.IResolvable | CfnAnalysis.ListControlSearchOptionsProperty;
        /**
         * The configuration of the `Select all` options in a list control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-listcontroldisplayoptions.html#cfn-quicksight-analysis-listcontroldisplayoptions-selectalloptions
         */
        readonly selectAllOptions?: cdk.IResolvable | CfnAnalysis.ListControlSelectAllOptionsProperty;
        /**
         * The options to configure the title visibility, name, and font size.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-listcontroldisplayoptions.html#cfn-quicksight-analysis-listcontroldisplayoptions-titleoptions
         */
        readonly titleOptions?: cdk.IResolvable | CfnAnalysis.LabelOptionsProperty;
    }
    /**
     * The configuration of the search options in a list control.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-listcontrolsearchoptions.html
     */
    interface ListControlSearchOptionsProperty {
        /**
         * The visibility configuration of the search options in a list control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-listcontrolsearchoptions.html#cfn-quicksight-analysis-listcontrolsearchoptions-visibility
         */
        readonly visibility?: string;
    }
    /**
     * A `NumericRangeFilter` filters values that are within the value range.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericrangefilter.html
     */
    interface NumericRangeFilterProperty {
        /**
         * The aggregation function of the filter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericrangefilter.html#cfn-quicksight-analysis-numericrangefilter-aggregationfunction
         */
        readonly aggregationFunction?: CfnAnalysis.AggregationFunctionProperty | cdk.IResolvable;
        /**
         * The column that the filter is applied to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericrangefilter.html#cfn-quicksight-analysis-numericrangefilter-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The default configurations for the associated controls.
         *
         * This applies only for filters that are scoped to multiple sheets.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericrangefilter.html#cfn-quicksight-analysis-numericrangefilter-defaultfiltercontrolconfiguration
         */
        readonly defaultFilterControlConfiguration?: CfnAnalysis.DefaultFilterControlConfigurationProperty | cdk.IResolvable;
        /**
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericrangefilter.html#cfn-quicksight-analysis-numericrangefilter-filterid
         */
        readonly filterId: string;
        /**
         * Determines whether the maximum value in the filter value range should be included in the filtered results.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericrangefilter.html#cfn-quicksight-analysis-numericrangefilter-includemaximum
         */
        readonly includeMaximum?: boolean | cdk.IResolvable;
        /**
         * Determines whether the minimum value in the filter value range should be included in the filtered results.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericrangefilter.html#cfn-quicksight-analysis-numericrangefilter-includeminimum
         */
        readonly includeMinimum?: boolean | cdk.IResolvable;
        /**
         * This option determines how null values should be treated when filtering data.
         *
         * - `ALL_VALUES` : Include null values in filtered results.
         * - `NULLS_ONLY` : Only include null values in filtered results.
         * - `NON_NULLS_ONLY` : Exclude null values from filtered results.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericrangefilter.html#cfn-quicksight-analysis-numericrangefilter-nulloption
         */
        readonly nullOption: string;
        /**
         * The maximum value for the filter value range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericrangefilter.html#cfn-quicksight-analysis-numericrangefilter-rangemaximum
         */
        readonly rangeMaximum?: cdk.IResolvable | CfnAnalysis.NumericRangeFilterValueProperty;
        /**
         * The minimum value for the filter value range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericrangefilter.html#cfn-quicksight-analysis-numericrangefilter-rangeminimum
         */
        readonly rangeMinimum?: cdk.IResolvable | CfnAnalysis.NumericRangeFilterValueProperty;
        /**
         * Select all of the values. Null is not the assigned value of select all.
         *
         * - `FILTER_ALL_VALUES`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericrangefilter.html#cfn-quicksight-analysis-numericrangefilter-selectalloptions
         */
        readonly selectAllOptions?: string;
    }
    /**
     * The value input pf the numeric range filter.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericrangefiltervalue.html
     */
    interface NumericRangeFilterValueProperty {
        /**
         * The parameter that is used in the numeric range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericrangefiltervalue.html#cfn-quicksight-analysis-numericrangefiltervalue-parameter
         */
        readonly parameter?: string;
        /**
         * The static value of the numeric range filter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericrangefiltervalue.html#cfn-quicksight-analysis-numericrangefiltervalue-staticvalue
         */
        readonly staticValue?: number;
    }
    /**
     * A `TimeRangeFilter` filters values that are between two specified values.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timerangefilter.html
     */
    interface TimeRangeFilterProperty {
        /**
         * The column that the filter is applied to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timerangefilter.html#cfn-quicksight-analysis-timerangefilter-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The default configurations for the associated controls.
         *
         * This applies only for filters that are scoped to multiple sheets.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timerangefilter.html#cfn-quicksight-analysis-timerangefilter-defaultfiltercontrolconfiguration
         */
        readonly defaultFilterControlConfiguration?: CfnAnalysis.DefaultFilterControlConfigurationProperty | cdk.IResolvable;
        /**
         * The exclude period of the time range filter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timerangefilter.html#cfn-quicksight-analysis-timerangefilter-excludeperiodconfiguration
         */
        readonly excludePeriodConfiguration?: CfnAnalysis.ExcludePeriodConfigurationProperty | cdk.IResolvable;
        /**
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timerangefilter.html#cfn-quicksight-analysis-timerangefilter-filterid
         */
        readonly filterId: string;
        /**
         * Determines whether the maximum value in the filter value range should be included in the filtered results.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timerangefilter.html#cfn-quicksight-analysis-timerangefilter-includemaximum
         */
        readonly includeMaximum?: boolean | cdk.IResolvable;
        /**
         * Determines whether the minimum value in the filter value range should be included in the filtered results.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timerangefilter.html#cfn-quicksight-analysis-timerangefilter-includeminimum
         */
        readonly includeMinimum?: boolean | cdk.IResolvable;
        /**
         * This option determines how null values should be treated when filtering data.
         *
         * - `ALL_VALUES` : Include null values in filtered results.
         * - `NULLS_ONLY` : Only include null values in filtered results.
         * - `NON_NULLS_ONLY` : Exclude null values from filtered results.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timerangefilter.html#cfn-quicksight-analysis-timerangefilter-nulloption
         */
        readonly nullOption: string;
        /**
         * The maximum value for the filter value range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timerangefilter.html#cfn-quicksight-analysis-timerangefilter-rangemaximumvalue
         */
        readonly rangeMaximumValue?: cdk.IResolvable | CfnAnalysis.TimeRangeFilterValueProperty;
        /**
         * The minimum value for the filter value range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timerangefilter.html#cfn-quicksight-analysis-timerangefilter-rangeminimumvalue
         */
        readonly rangeMinimumValue?: cdk.IResolvable | CfnAnalysis.TimeRangeFilterValueProperty;
        /**
         * The level of time precision that is used to aggregate `DateTime` values.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timerangefilter.html#cfn-quicksight-analysis-timerangefilter-timegranularity
         */
        readonly timeGranularity?: string;
    }
    /**
     * The value of a time range filter.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timerangefiltervalue.html
     */
    interface TimeRangeFilterValueProperty {
        /**
         * The parameter type input value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timerangefiltervalue.html#cfn-quicksight-analysis-timerangefiltervalue-parameter
         */
        readonly parameter?: string;
        /**
         * The rolling date input value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timerangefiltervalue.html#cfn-quicksight-analysis-timerangefiltervalue-rollingdate
         */
        readonly rollingDate?: cdk.IResolvable | CfnAnalysis.RollingDateConfigurationProperty;
        /**
         * The static input value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timerangefiltervalue.html#cfn-quicksight-analysis-timerangefiltervalue-staticvalue
         */
        readonly staticValue?: string;
    }
    /**
     * The rolling date configuration of a date time filter.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-rollingdateconfiguration.html
     */
    interface RollingDateConfigurationProperty {
        /**
         * The data set that is used in the rolling date configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-rollingdateconfiguration.html#cfn-quicksight-analysis-rollingdateconfiguration-datasetidentifier
         */
        readonly dataSetIdentifier?: string;
        /**
         * The expression of the rolling date configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-rollingdateconfiguration.html#cfn-quicksight-analysis-rollingdateconfiguration-expression
         */
        readonly expression: string;
    }
    /**
     * The exclude period of `TimeRangeFilter` or `RelativeDatesFilter` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-excludeperiodconfiguration.html
     */
    interface ExcludePeriodConfigurationProperty {
        /**
         * The amount or number of the exclude period.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-excludeperiodconfiguration.html#cfn-quicksight-analysis-excludeperiodconfiguration-amount
         */
        readonly amount: number;
        /**
         * The granularity or unit (day, month, year) of the exclude period.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-excludeperiodconfiguration.html#cfn-quicksight-analysis-excludeperiodconfiguration-granularity
         */
        readonly granularity: string;
        /**
         * The status of the exclude period. Choose from the following options:.
         *
         * - `ENABLED`
         * - `DISABLED`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-excludeperiodconfiguration.html#cfn-quicksight-analysis-excludeperiodconfiguration-status
         */
        readonly status?: string;
    }
    /**
     * A `RelativeDatesFilter` filters relative dates values.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-relativedatesfilter.html
     */
    interface RelativeDatesFilterProperty {
        /**
         * The date configuration of the filter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-relativedatesfilter.html#cfn-quicksight-analysis-relativedatesfilter-anchordateconfiguration
         */
        readonly anchorDateConfiguration: CfnAnalysis.AnchorDateConfigurationProperty | cdk.IResolvable;
        /**
         * The column that the filter is applied to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-relativedatesfilter.html#cfn-quicksight-analysis-relativedatesfilter-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The default configurations for the associated controls.
         *
         * This applies only for filters that are scoped to multiple sheets.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-relativedatesfilter.html#cfn-quicksight-analysis-relativedatesfilter-defaultfiltercontrolconfiguration
         */
        readonly defaultFilterControlConfiguration?: CfnAnalysis.DefaultFilterControlConfigurationProperty | cdk.IResolvable;
        /**
         * The configuration for the exclude period of the filter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-relativedatesfilter.html#cfn-quicksight-analysis-relativedatesfilter-excludeperiodconfiguration
         */
        readonly excludePeriodConfiguration?: CfnAnalysis.ExcludePeriodConfigurationProperty | cdk.IResolvable;
        /**
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-relativedatesfilter.html#cfn-quicksight-analysis-relativedatesfilter-filterid
         */
        readonly filterId: string;
        /**
         * The minimum granularity (period granularity) of the relative dates filter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-relativedatesfilter.html#cfn-quicksight-analysis-relativedatesfilter-minimumgranularity
         */
        readonly minimumGranularity?: string;
        /**
         * This option determines how null values should be treated when filtering data.
         *
         * - `ALL_VALUES` : Include null values in filtered results.
         * - `NULLS_ONLY` : Only include null values in filtered results.
         * - `NON_NULLS_ONLY` : Exclude null values from filtered results.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-relativedatesfilter.html#cfn-quicksight-analysis-relativedatesfilter-nulloption
         */
        readonly nullOption: string;
        /**
         * The parameter whose value should be used for the filter value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-relativedatesfilter.html#cfn-quicksight-analysis-relativedatesfilter-parametername
         */
        readonly parameterName?: string;
        /**
         * The range date type of the filter. Choose one of the options below:.
         *
         * - `PREVIOUS`
         * - `THIS`
         * - `LAST`
         * - `NOW`
         * - `NEXT`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-relativedatesfilter.html#cfn-quicksight-analysis-relativedatesfilter-relativedatetype
         */
        readonly relativeDateType: string;
        /**
         * The date value of the filter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-relativedatesfilter.html#cfn-quicksight-analysis-relativedatesfilter-relativedatevalue
         */
        readonly relativeDateValue?: number;
        /**
         * The level of time precision that is used to aggregate `DateTime` values.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-relativedatesfilter.html#cfn-quicksight-analysis-relativedatesfilter-timegranularity
         */
        readonly timeGranularity: string;
    }
    /**
     * The date configuration of the filter.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-anchordateconfiguration.html
     */
    interface AnchorDateConfigurationProperty {
        /**
         * The options for the date configuration. Choose one of the options below:.
         *
         * - `NOW`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-anchordateconfiguration.html#cfn-quicksight-analysis-anchordateconfiguration-anchoroption
         */
        readonly anchorOption?: string;
        /**
         * The name of the parameter that is used for the anchor date configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-anchordateconfiguration.html#cfn-quicksight-analysis-anchordateconfiguration-parametername
         */
        readonly parameterName?: string;
    }
    /**
     * A `TopBottomFilter` filters values that are at the top or the bottom.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottomfilter.html
     */
    interface TopBottomFilterProperty {
        /**
         * The aggregation and sort configuration of the top bottom filter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottomfilter.html#cfn-quicksight-analysis-topbottomfilter-aggregationsortconfigurations
         */
        readonly aggregationSortConfigurations: Array<CfnAnalysis.AggregationSortConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The column that the filter is applied to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottomfilter.html#cfn-quicksight-analysis-topbottomfilter-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The default configurations for the associated controls.
         *
         * This applies only for filters that are scoped to multiple sheets.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottomfilter.html#cfn-quicksight-analysis-topbottomfilter-defaultfiltercontrolconfiguration
         */
        readonly defaultFilterControlConfiguration?: CfnAnalysis.DefaultFilterControlConfigurationProperty | cdk.IResolvable;
        /**
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottomfilter.html#cfn-quicksight-analysis-topbottomfilter-filterid
         */
        readonly filterId: string;
        /**
         * The number of items to include in the top bottom filter results.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottomfilter.html#cfn-quicksight-analysis-topbottomfilter-limit
         */
        readonly limit?: number;
        /**
         * The parameter whose value should be used for the filter value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottomfilter.html#cfn-quicksight-analysis-topbottomfilter-parametername
         */
        readonly parameterName?: string;
        /**
         * The level of time precision that is used to aggregate `DateTime` values.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottomfilter.html#cfn-quicksight-analysis-topbottomfilter-timegranularity
         */
        readonly timeGranularity?: string;
    }
    /**
     * The configuration options to sort aggregated values.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationsortconfiguration.html
     */
    interface AggregationSortConfigurationProperty {
        /**
         * The function that aggregates the values in `Column` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationsortconfiguration.html#cfn-quicksight-analysis-aggregationsortconfiguration-aggregationfunction
         */
        readonly aggregationFunction?: CfnAnalysis.AggregationFunctionProperty | cdk.IResolvable;
        /**
         * The column that determines the sort order of aggregated values.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationsortconfiguration.html#cfn-quicksight-analysis-aggregationsortconfiguration-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The sort direction of values.
         *
         * - `ASC` : Sort in ascending order.
         * - `DESC` : Sort in descending order.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationsortconfiguration.html#cfn-quicksight-analysis-aggregationsortconfiguration-sortdirection
         */
        readonly sortDirection: string;
    }
    /**
     * A `TimeEqualityFilter` filters values that are equal to a given value.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timeequalityfilter.html
     */
    interface TimeEqualityFilterProperty {
        /**
         * The column that the filter is applied to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timeequalityfilter.html#cfn-quicksight-analysis-timeequalityfilter-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The default configurations for the associated controls.
         *
         * This applies only for filters that are scoped to multiple sheets.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timeequalityfilter.html#cfn-quicksight-analysis-timeequalityfilter-defaultfiltercontrolconfiguration
         */
        readonly defaultFilterControlConfiguration?: CfnAnalysis.DefaultFilterControlConfigurationProperty | cdk.IResolvable;
        /**
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timeequalityfilter.html#cfn-quicksight-analysis-timeequalityfilter-filterid
         */
        readonly filterId: string;
        /**
         * The parameter whose value should be used for the filter value.
         *
         * This field is mutually exclusive to `Value` and `RollingDate` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timeequalityfilter.html#cfn-quicksight-analysis-timeequalityfilter-parametername
         */
        readonly parameterName?: string;
        /**
         * The rolling date input for the `TimeEquality` filter.
         *
         * This field is mutually exclusive to `Value` and `ParameterName` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timeequalityfilter.html#cfn-quicksight-analysis-timeequalityfilter-rollingdate
         */
        readonly rollingDate?: cdk.IResolvable | CfnAnalysis.RollingDateConfigurationProperty;
        /**
         * The level of time precision that is used to aggregate `DateTime` values.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timeequalityfilter.html#cfn-quicksight-analysis-timeequalityfilter-timegranularity
         */
        readonly timeGranularity?: string;
        /**
         * The value of a `TimeEquality` filter.
         *
         * This field is mutually exclusive to `RollingDate` and `ParameterName` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timeequalityfilter.html#cfn-quicksight-analysis-timeequalityfilter-value
         */
        readonly value?: string;
    }
    /**
     * A `CategoryFilter` filters text values.
     *
     * For more information, see [Adding text filters](https://docs.aws.amazon.com/quicksight/latest/user/add-a-text-filter-data-prep.html) in the *Amazon QuickSight User Guide* .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilter.html
     */
    interface CategoryFilterProperty {
        /**
         * The column that the filter is applied to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilter.html#cfn-quicksight-analysis-categoryfilter-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The configuration for a `CategoryFilter` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilter.html#cfn-quicksight-analysis-categoryfilter-configuration
         */
        readonly configuration: CfnAnalysis.CategoryFilterConfigurationProperty | cdk.IResolvable;
        /**
         * The default configurations for the associated controls.
         *
         * This applies only for filters that are scoped to multiple sheets.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilter.html#cfn-quicksight-analysis-categoryfilter-defaultfiltercontrolconfiguration
         */
        readonly defaultFilterControlConfiguration?: CfnAnalysis.DefaultFilterControlConfigurationProperty | cdk.IResolvable;
        /**
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilter.html#cfn-quicksight-analysis-categoryfilter-filterid
         */
        readonly filterId: string;
    }
    /**
     * The configuration for a `CategoryFilter` .
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilterconfiguration.html
     */
    interface CategoryFilterConfigurationProperty {
        /**
         * A custom filter that filters based on a single value.
         *
         * This filter can be partially matched.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilterconfiguration.html#cfn-quicksight-analysis-categoryfilterconfiguration-customfilterconfiguration
         */
        readonly customFilterConfiguration?: CfnAnalysis.CustomFilterConfigurationProperty | cdk.IResolvable;
        /**
         * A list of custom filter values.
         *
         * In the Amazon QuickSight console, this filter type is called a custom filter list.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilterconfiguration.html#cfn-quicksight-analysis-categoryfilterconfiguration-customfilterlistconfiguration
         */
        readonly customFilterListConfiguration?: CfnAnalysis.CustomFilterListConfigurationProperty | cdk.IResolvable;
        /**
         * A list of filter configurations.
         *
         * In the Amazon QuickSight console, this filter type is called a filter list.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilterconfiguration.html#cfn-quicksight-analysis-categoryfilterconfiguration-filterlistconfiguration
         */
        readonly filterListConfiguration?: CfnAnalysis.FilterListConfigurationProperty | cdk.IResolvable;
    }
    /**
     * A list of custom filter values.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customfilterlistconfiguration.html
     */
    interface CustomFilterListConfigurationProperty {
        /**
         * The list of category values for the filter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customfilterlistconfiguration.html#cfn-quicksight-analysis-customfilterlistconfiguration-categoryvalues
         */
        readonly categoryValues?: Array<string>;
        /**
         * The match operator that is used to determine if a filter should be applied.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customfilterlistconfiguration.html#cfn-quicksight-analysis-customfilterlistconfiguration-matchoperator
         */
        readonly matchOperator: string;
        /**
         * This option determines how null values should be treated when filtering data.
         *
         * - `ALL_VALUES` : Include null values in filtered results.
         * - `NULLS_ONLY` : Only include null values in filtered results.
         * - `NON_NULLS_ONLY` : Exclude null values from filtered results.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customfilterlistconfiguration.html#cfn-quicksight-analysis-customfilterlistconfiguration-nulloption
         */
        readonly nullOption: string;
        /**
         * Select all of the values. Null is not the assigned value of select all.
         *
         * - `FILTER_ALL_VALUES`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customfilterlistconfiguration.html#cfn-quicksight-analysis-customfilterlistconfiguration-selectalloptions
         */
        readonly selectAllOptions?: string;
    }
    /**
     * A custom filter that filters based on a single value.
     *
     * This filter can be partially matched.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customfilterconfiguration.html
     */
    interface CustomFilterConfigurationProperty {
        /**
         * The category value for the filter.
         *
         * This field is mutually exclusive to `ParameterName` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customfilterconfiguration.html#cfn-quicksight-analysis-customfilterconfiguration-categoryvalue
         */
        readonly categoryValue?: string;
        /**
         * The match operator that is used to determine if a filter should be applied.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customfilterconfiguration.html#cfn-quicksight-analysis-customfilterconfiguration-matchoperator
         */
        readonly matchOperator: string;
        /**
         * This option determines how null values should be treated when filtering data.
         *
         * - `ALL_VALUES` : Include null values in filtered results.
         * - `NULLS_ONLY` : Only include null values in filtered results.
         * - `NON_NULLS_ONLY` : Exclude null values from filtered results.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customfilterconfiguration.html#cfn-quicksight-analysis-customfilterconfiguration-nulloption
         */
        readonly nullOption: string;
        /**
         * The parameter whose value should be used for the filter value.
         *
         * This field is mutually exclusive to `CategoryValue` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customfilterconfiguration.html#cfn-quicksight-analysis-customfilterconfiguration-parametername
         */
        readonly parameterName?: string;
        /**
         * Select all of the values. Null is not the assigned value of select all.
         *
         * - `FILTER_ALL_VALUES`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customfilterconfiguration.html#cfn-quicksight-analysis-customfilterconfiguration-selectalloptions
         */
        readonly selectAllOptions?: string;
    }
    /**
     * A list of filter configurations.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterlistconfiguration.html
     */
    interface FilterListConfigurationProperty {
        /**
         * The list of category values for the filter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterlistconfiguration.html#cfn-quicksight-analysis-filterlistconfiguration-categoryvalues
         */
        readonly categoryValues?: Array<string>;
        /**
         * The match operator that is used to determine if a filter should be applied.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterlistconfiguration.html#cfn-quicksight-analysis-filterlistconfiguration-matchoperator
         */
        readonly matchOperator: string;
        /**
         * This option determines how null values should be treated when filtering data.
         *
         * - `ALL_VALUES` : Include null values in filtered results.
         * - `NULLS_ONLY` : Only include null values in filtered results.
         * - `NON_NULLS_ONLY` : Exclude null values from filtered results.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterlistconfiguration.html#cfn-quicksight-analysis-filterlistconfiguration-nulloption
         */
        readonly nullOption?: string;
        /**
         * Select all of the values. Null is not the assigned value of select all.
         *
         * - `FILTER_ALL_VALUES`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterlistconfiguration.html#cfn-quicksight-analysis-filterlistconfiguration-selectalloptions
         */
        readonly selectAllOptions?: string;
    }
    /**
     * A `NestedFilter` filters data with a subset of data that is defined by the nested inner filter.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-nestedfilter.html
     */
    interface NestedFilterProperty {
        /**
         * The column that the filter is applied to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-nestedfilter.html#cfn-quicksight-analysis-nestedfilter-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-nestedfilter.html#cfn-quicksight-analysis-nestedfilter-filterid
         */
        readonly filterId: string;
        /**
         * A boolean condition to include or exclude the subset that is defined by the values of the nested inner filter.
         *
         * @default - false
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-nestedfilter.html#cfn-quicksight-analysis-nestedfilter-includeinnerset
         */
        readonly includeInnerSet: boolean | cdk.IResolvable;
        /**
         * The `InnerFilter` defines the subset of data to be used with the `NestedFilter` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-nestedfilter.html#cfn-quicksight-analysis-nestedfilter-innerfilter
         */
        readonly innerFilter: CfnAnalysis.InnerFilterProperty | cdk.IResolvable;
    }
    /**
     * The `InnerFilter` defines the subset of data to be used with the `NestedFilter` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-innerfilter.html
     */
    interface InnerFilterProperty {
        /**
         * A `CategoryInnerFilter` filters text values for the `NestedFilter` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-innerfilter.html#cfn-quicksight-analysis-innerfilter-categoryinnerfilter
         */
        readonly categoryInnerFilter?: CfnAnalysis.CategoryInnerFilterProperty | cdk.IResolvable;
    }
    /**
     * A `CategoryInnerFilter` filters text values for the `NestedFilter` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryinnerfilter.html
     */
    interface CategoryInnerFilterProperty {
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryinnerfilter.html#cfn-quicksight-analysis-categoryinnerfilter-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryinnerfilter.html#cfn-quicksight-analysis-categoryinnerfilter-configuration
         */
        readonly configuration: CfnAnalysis.CategoryFilterConfigurationProperty | cdk.IResolvable;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryinnerfilter.html#cfn-quicksight-analysis-categoryinnerfilter-defaultfiltercontrolconfiguration
         */
        readonly defaultFilterControlConfiguration?: CfnAnalysis.DefaultFilterControlConfigurationProperty | cdk.IResolvable;
    }
    /**
     * The scope configuration for a `FilterGroup` .
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterscopeconfiguration.html
     */
    interface FilterScopeConfigurationProperty {
        /**
         * The configuration that applies a filter to all sheets.
         *
         * When you choose `AllSheets` as the value for a `FilterScopeConfiguration` , this filter is applied to all visuals of all sheets in an Analysis, Dashboard, or Template. The `AllSheetsFilterScopeConfiguration` is chosen.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterscopeconfiguration.html#cfn-quicksight-analysis-filterscopeconfiguration-allsheets
         */
        readonly allSheets?: any | cdk.IResolvable;
        /**
         * The configuration for applying a filter to specific sheets.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterscopeconfiguration.html#cfn-quicksight-analysis-filterscopeconfiguration-selectedsheets
         */
        readonly selectedSheets?: cdk.IResolvable | CfnAnalysis.SelectedSheetsFilterScopeConfigurationProperty;
    }
    /**
     * The configuration for applying a filter to specific sheets or visuals.
     *
     * You can apply this filter to multiple visuals that are on one sheet or to all visuals on a sheet.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-selectedsheetsfilterscopeconfiguration.html
     */
    interface SelectedSheetsFilterScopeConfigurationProperty {
        /**
         * The sheet ID and visual IDs of the sheet and visuals that the filter is applied to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-selectedsheetsfilterscopeconfiguration.html#cfn-quicksight-analysis-selectedsheetsfilterscopeconfiguration-sheetvisualscopingconfigurations
         */
        readonly sheetVisualScopingConfigurations?: Array<cdk.IResolvable | CfnAnalysis.SheetVisualScopingConfigurationProperty> | cdk.IResolvable;
    }
    /**
     * The filter that is applied to the options.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetvisualscopingconfiguration.html
     */
    interface SheetVisualScopingConfigurationProperty {
        /**
         * The scope of the applied entities. Choose one of the following options:.
         *
         * - `ALL_VISUALS`
         * - `SELECTED_VISUALS`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetvisualscopingconfiguration.html#cfn-quicksight-analysis-sheetvisualscopingconfiguration-scope
         */
        readonly scope: string;
        /**
         * The selected sheet that the filter is applied to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetvisualscopingconfiguration.html#cfn-quicksight-analysis-sheetvisualscopingconfiguration-sheetid
         */
        readonly sheetId: string;
        /**
         * The selected visuals that the filter is applied to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetvisualscopingconfiguration.html#cfn-quicksight-analysis-sheetvisualscopingconfiguration-visualids
         */
        readonly visualIds?: Array<string>;
    }
    /**
     * The calculated field of an analysis.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedfield.html
     */
    interface CalculatedFieldProperty {
        /**
         * The data set that is used in this calculated field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedfield.html#cfn-quicksight-analysis-calculatedfield-datasetidentifier
         */
        readonly dataSetIdentifier: string;
        /**
         * The expression of the calculated field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedfield.html#cfn-quicksight-analysis-calculatedfield-expression
         */
        readonly expression: string;
        /**
         * The name of the calculated field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedfield.html#cfn-quicksight-analysis-calculatedfield-name
         */
        readonly name: string;
    }
    /**
     * A data set.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datasetidentifierdeclaration.html
     */
    interface DataSetIdentifierDeclarationProperty {
        /**
         * The Amazon Resource Name (ARN) of the data set.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datasetidentifierdeclaration.html#cfn-quicksight-analysis-datasetidentifierdeclaration-datasetarn
         */
        readonly dataSetArn: string;
        /**
         * The identifier of the data set, typically the data set's name.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datasetidentifierdeclaration.html#cfn-quicksight-analysis-datasetidentifierdeclaration-identifier
         */
        readonly identifier: string;
    }
    /**
     * The general configuration of a column.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnconfiguration.html
     */
    interface ColumnConfigurationProperty {
        /**
         * The color configurations of the column.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnconfiguration.html#cfn-quicksight-analysis-columnconfiguration-colorsconfiguration
         */
        readonly colorsConfiguration?: CfnAnalysis.ColorsConfigurationProperty | cdk.IResolvable;
        /**
         * The column.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnconfiguration.html#cfn-quicksight-analysis-columnconfiguration-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The format configuration of a column.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnconfiguration.html#cfn-quicksight-analysis-columnconfiguration-formatconfiguration
         */
        readonly formatConfiguration?: CfnAnalysis.FormatConfigurationProperty | cdk.IResolvable;
        /**
         * The role of the column.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnconfiguration.html#cfn-quicksight-analysis-columnconfiguration-role
         */
        readonly role?: string;
    }
    /**
     * The formatting configuration for all types of field.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-formatconfiguration.html
     */
    interface FormatConfigurationProperty {
        /**
         * Formatting configuration for `DateTime` fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-formatconfiguration.html#cfn-quicksight-analysis-formatconfiguration-datetimeformatconfiguration
         */
        readonly dateTimeFormatConfiguration?: CfnAnalysis.DateTimeFormatConfigurationProperty | cdk.IResolvable;
        /**
         * Formatting configuration for number fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-formatconfiguration.html#cfn-quicksight-analysis-formatconfiguration-numberformatconfiguration
         */
        readonly numberFormatConfiguration?: cdk.IResolvable | CfnAnalysis.NumberFormatConfigurationProperty;
        /**
         * Formatting configuration for string fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-formatconfiguration.html#cfn-quicksight-analysis-formatconfiguration-stringformatconfiguration
         */
        readonly stringFormatConfiguration?: cdk.IResolvable | CfnAnalysis.StringFormatConfigurationProperty;
    }
    /**
     * Formatting configuration for number fields.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numberformatconfiguration.html
     */
    interface NumberFormatConfigurationProperty {
        /**
         * The options that determine the numeric format configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numberformatconfiguration.html#cfn-quicksight-analysis-numberformatconfiguration-formatconfiguration
         */
        readonly formatConfiguration?: cdk.IResolvable | CfnAnalysis.NumericFormatConfigurationProperty;
    }
    /**
     * The options that determine the numeric format configuration.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericformatconfiguration.html
     */
    interface NumericFormatConfigurationProperty {
        /**
         * The options that determine the currency display format configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericformatconfiguration.html#cfn-quicksight-analysis-numericformatconfiguration-currencydisplayformatconfiguration
         */
        readonly currencyDisplayFormatConfiguration?: CfnAnalysis.CurrencyDisplayFormatConfigurationProperty | cdk.IResolvable;
        /**
         * The options that determine the number display format configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericformatconfiguration.html#cfn-quicksight-analysis-numericformatconfiguration-numberdisplayformatconfiguration
         */
        readonly numberDisplayFormatConfiguration?: cdk.IResolvable | CfnAnalysis.NumberDisplayFormatConfigurationProperty;
        /**
         * The options that determine the percentage display format configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericformatconfiguration.html#cfn-quicksight-analysis-numericformatconfiguration-percentagedisplayformatconfiguration
         */
        readonly percentageDisplayFormatConfiguration?: cdk.IResolvable | CfnAnalysis.PercentageDisplayFormatConfigurationProperty;
    }
    /**
     * The options that determine the number display format configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numberdisplayformatconfiguration.html
     */
    interface NumberDisplayFormatConfigurationProperty {
        /**
         * The option that determines the decimal places configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numberdisplayformatconfiguration.html#cfn-quicksight-analysis-numberdisplayformatconfiguration-decimalplacesconfiguration
         */
        readonly decimalPlacesConfiguration?: CfnAnalysis.DecimalPlacesConfigurationProperty | cdk.IResolvable;
        /**
         * The options that determine the negative value configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numberdisplayformatconfiguration.html#cfn-quicksight-analysis-numberdisplayformatconfiguration-negativevalueconfiguration
         */
        readonly negativeValueConfiguration?: cdk.IResolvable | CfnAnalysis.NegativeValueConfigurationProperty;
        /**
         * The options that determine the null value format configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numberdisplayformatconfiguration.html#cfn-quicksight-analysis-numberdisplayformatconfiguration-nullvalueformatconfiguration
         */
        readonly nullValueFormatConfiguration?: cdk.IResolvable | CfnAnalysis.NullValueFormatConfigurationProperty;
        /**
         * Determines the number scale value of the number format.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numberdisplayformatconfiguration.html#cfn-quicksight-analysis-numberdisplayformatconfiguration-numberscale
         */
        readonly numberScale?: string;
        /**
         * Determines the prefix value of the number format.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numberdisplayformatconfiguration.html#cfn-quicksight-analysis-numberdisplayformatconfiguration-prefix
         */
        readonly prefix?: string;
        /**
         * The options that determine the numeric separator configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numberdisplayformatconfiguration.html#cfn-quicksight-analysis-numberdisplayformatconfiguration-separatorconfiguration
         */
        readonly separatorConfiguration?: cdk.IResolvable | CfnAnalysis.NumericSeparatorConfigurationProperty;
        /**
         * Determines the suffix value of the number format.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numberdisplayformatconfiguration.html#cfn-quicksight-analysis-numberdisplayformatconfiguration-suffix
         */
        readonly suffix?: string;
    }
    /**
     * The options that determine the negative value configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-negativevalueconfiguration.html
     */
    interface NegativeValueConfigurationProperty {
        /**
         * Determines the display mode of the negative value configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-negativevalueconfiguration.html#cfn-quicksight-analysis-negativevalueconfiguration-displaymode
         */
        readonly displayMode: string;
    }
    /**
     * The option that determines the decimal places configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalplacesconfiguration.html
     */
    interface DecimalPlacesConfigurationProperty {
        /**
         * The values of the decimal places.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalplacesconfiguration.html#cfn-quicksight-analysis-decimalplacesconfiguration-decimalplaces
         */
        readonly decimalPlaces: number;
    }
    /**
     * The options that determine the null value format configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-nullvalueformatconfiguration.html
     */
    interface NullValueFormatConfigurationProperty {
        /**
         * Determines the null string of null values.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-nullvalueformatconfiguration.html#cfn-quicksight-analysis-nullvalueformatconfiguration-nullstring
         */
        readonly nullString: string;
    }
    /**
     * The options that determine the numeric separator configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericseparatorconfiguration.html
     */
    interface NumericSeparatorConfigurationProperty {
        /**
         * Determines the decimal separator.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericseparatorconfiguration.html#cfn-quicksight-analysis-numericseparatorconfiguration-decimalseparator
         */
        readonly decimalSeparator?: string;
        /**
         * The options that determine the thousands separator configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericseparatorconfiguration.html#cfn-quicksight-analysis-numericseparatorconfiguration-thousandsseparator
         */
        readonly thousandsSeparator?: cdk.IResolvable | CfnAnalysis.ThousandSeparatorOptionsProperty;
    }
    /**
     * The options that determine the thousands separator configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-thousandseparatoroptions.html
     */
    interface ThousandSeparatorOptionsProperty {
        /**
         * Determines the way numbers are styled to accommodate different readability standards.
         *
         * The `DEFAULT` value uses the standard international grouping system and groups numbers by the thousands. The `LAKHS` value uses the Indian numbering system and groups numbers by lakhs and crores.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-thousandseparatoroptions.html#cfn-quicksight-analysis-thousandseparatoroptions-groupingstyle
         */
        readonly groupingStyle?: string;
        /**
         * Determines the thousands separator symbol.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-thousandseparatoroptions.html#cfn-quicksight-analysis-thousandseparatoroptions-symbol
         */
        readonly symbol?: string;
        /**
         * Determines the visibility of the thousands separator.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-thousandseparatoroptions.html#cfn-quicksight-analysis-thousandseparatoroptions-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The options that determine the currency display format configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-currencydisplayformatconfiguration.html
     */
    interface CurrencyDisplayFormatConfigurationProperty {
        /**
         * The option that determines the decimal places configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-currencydisplayformatconfiguration.html#cfn-quicksight-analysis-currencydisplayformatconfiguration-decimalplacesconfiguration
         */
        readonly decimalPlacesConfiguration?: CfnAnalysis.DecimalPlacesConfigurationProperty | cdk.IResolvable;
        /**
         * The options that determine the negative value configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-currencydisplayformatconfiguration.html#cfn-quicksight-analysis-currencydisplayformatconfiguration-negativevalueconfiguration
         */
        readonly negativeValueConfiguration?: cdk.IResolvable | CfnAnalysis.NegativeValueConfigurationProperty;
        /**
         * The options that determine the null value format configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-currencydisplayformatconfiguration.html#cfn-quicksight-analysis-currencydisplayformatconfiguration-nullvalueformatconfiguration
         */
        readonly nullValueFormatConfiguration?: cdk.IResolvable | CfnAnalysis.NullValueFormatConfigurationProperty;
        /**
         * Determines the number scale value for the currency format.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-currencydisplayformatconfiguration.html#cfn-quicksight-analysis-currencydisplayformatconfiguration-numberscale
         */
        readonly numberScale?: string;
        /**
         * Determines the prefix value of the currency format.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-currencydisplayformatconfiguration.html#cfn-quicksight-analysis-currencydisplayformatconfiguration-prefix
         */
        readonly prefix?: string;
        /**
         * The options that determine the numeric separator configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-currencydisplayformatconfiguration.html#cfn-quicksight-analysis-currencydisplayformatconfiguration-separatorconfiguration
         */
        readonly separatorConfiguration?: cdk.IResolvable | CfnAnalysis.NumericSeparatorConfigurationProperty;
        /**
         * Determines the suffix value of the currency format.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-currencydisplayformatconfiguration.html#cfn-quicksight-analysis-currencydisplayformatconfiguration-suffix
         */
        readonly suffix?: string;
        /**
         * Determines the symbol for the currency format.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-currencydisplayformatconfiguration.html#cfn-quicksight-analysis-currencydisplayformatconfiguration-symbol
         */
        readonly symbol?: string;
    }
    /**
     * The options that determine the percentage display format configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-percentagedisplayformatconfiguration.html
     */
    interface PercentageDisplayFormatConfigurationProperty {
        /**
         * The option that determines the decimal places configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-percentagedisplayformatconfiguration.html#cfn-quicksight-analysis-percentagedisplayformatconfiguration-decimalplacesconfiguration
         */
        readonly decimalPlacesConfiguration?: CfnAnalysis.DecimalPlacesConfigurationProperty | cdk.IResolvable;
        /**
         * The options that determine the negative value configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-percentagedisplayformatconfiguration.html#cfn-quicksight-analysis-percentagedisplayformatconfiguration-negativevalueconfiguration
         */
        readonly negativeValueConfiguration?: cdk.IResolvable | CfnAnalysis.NegativeValueConfigurationProperty;
        /**
         * The options that determine the null value format configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-percentagedisplayformatconfiguration.html#cfn-quicksight-analysis-percentagedisplayformatconfiguration-nullvalueformatconfiguration
         */
        readonly nullValueFormatConfiguration?: cdk.IResolvable | CfnAnalysis.NullValueFormatConfigurationProperty;
        /**
         * Determines the prefix value of the percentage format.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-percentagedisplayformatconfiguration.html#cfn-quicksight-analysis-percentagedisplayformatconfiguration-prefix
         */
        readonly prefix?: string;
        /**
         * The options that determine the numeric separator configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-percentagedisplayformatconfiguration.html#cfn-quicksight-analysis-percentagedisplayformatconfiguration-separatorconfiguration
         */
        readonly separatorConfiguration?: cdk.IResolvable | CfnAnalysis.NumericSeparatorConfigurationProperty;
        /**
         * Determines the suffix value of the percentage format.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-percentagedisplayformatconfiguration.html#cfn-quicksight-analysis-percentagedisplayformatconfiguration-suffix
         */
        readonly suffix?: string;
    }
    /**
     * Formatting configuration for `DateTime` fields.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeformatconfiguration.html
     */
    interface DateTimeFormatConfigurationProperty {
        /**
         * Determines the `DateTime` format.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeformatconfiguration.html#cfn-quicksight-analysis-datetimeformatconfiguration-datetimeformat
         */
        readonly dateTimeFormat?: string;
        /**
         * The options that determine the null value format configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeformatconfiguration.html#cfn-quicksight-analysis-datetimeformatconfiguration-nullvalueformatconfiguration
         */
        readonly nullValueFormatConfiguration?: cdk.IResolvable | CfnAnalysis.NullValueFormatConfigurationProperty;
        /**
         * The formatting configuration for numeric `DateTime` fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeformatconfiguration.html#cfn-quicksight-analysis-datetimeformatconfiguration-numericformatconfiguration
         */
        readonly numericFormatConfiguration?: cdk.IResolvable | CfnAnalysis.NumericFormatConfigurationProperty;
    }
    /**
     * Formatting configuration for string fields.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringformatconfiguration.html
     */
    interface StringFormatConfigurationProperty {
        /**
         * The options that determine the null value format configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringformatconfiguration.html#cfn-quicksight-analysis-stringformatconfiguration-nullvalueformatconfiguration
         */
        readonly nullValueFormatConfiguration?: cdk.IResolvable | CfnAnalysis.NullValueFormatConfigurationProperty;
        /**
         * The formatting configuration for numeric strings.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringformatconfiguration.html#cfn-quicksight-analysis-stringformatconfiguration-numericformatconfiguration
         */
        readonly numericFormatConfiguration?: cdk.IResolvable | CfnAnalysis.NumericFormatConfigurationProperty;
    }
    /**
     * The color configurations for a column.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorsconfiguration.html
     */
    interface ColorsConfigurationProperty {
        /**
         * A list of up to 50 custom colors.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorsconfiguration.html#cfn-quicksight-analysis-colorsconfiguration-customcolors
         */
        readonly customColors?: Array<CfnAnalysis.CustomColorProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * Determines the color that's applied to a particular data value in a column.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcolor.html
     */
    interface CustomColorProperty {
        /**
         * The color that is applied to the data value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcolor.html#cfn-quicksight-analysis-customcolor-color
         */
        readonly color: string;
        /**
         * The data value that the color is applied to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcolor.html#cfn-quicksight-analysis-customcolor-fieldvalue
         */
        readonly fieldValue?: string;
        /**
         * The value of a special data value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcolor.html#cfn-quicksight-analysis-customcolor-specialvalue
         */
        readonly specialValue?: string;
    }
    /**
     * The configuration for default analysis settings.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefaults.html
     */
    interface AnalysisDefaultsProperty {
        /**
         * The configuration for default new sheet settings.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefaults.html#cfn-quicksight-analysis-analysisdefaults-defaultnewsheetconfiguration
         */
        readonly defaultNewSheetConfiguration: CfnAnalysis.DefaultNewSheetConfigurationProperty | cdk.IResolvable;
    }
    /**
     * The configuration for default new sheet settings.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultnewsheetconfiguration.html
     */
    interface DefaultNewSheetConfigurationProperty {
        /**
         * The options that determine the default settings for interactive layout configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultnewsheetconfiguration.html#cfn-quicksight-analysis-defaultnewsheetconfiguration-interactivelayoutconfiguration
         */
        readonly interactiveLayoutConfiguration?: CfnAnalysis.DefaultInteractiveLayoutConfigurationProperty | cdk.IResolvable;
        /**
         * The options that determine the default settings for a paginated layout configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultnewsheetconfiguration.html#cfn-quicksight-analysis-defaultnewsheetconfiguration-paginatedlayoutconfiguration
         */
        readonly paginatedLayoutConfiguration?: CfnAnalysis.DefaultPaginatedLayoutConfigurationProperty | cdk.IResolvable;
        /**
         * The option that determines the sheet content type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultnewsheetconfiguration.html#cfn-quicksight-analysis-defaultnewsheetconfiguration-sheetcontenttype
         */
        readonly sheetContentType?: string;
    }
    /**
     * The options that determine the default settings for interactive layout configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultinteractivelayoutconfiguration.html
     */
    interface DefaultInteractiveLayoutConfigurationProperty {
        /**
         * The options that determine the default settings of a free-form layout configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultinteractivelayoutconfiguration.html#cfn-quicksight-analysis-defaultinteractivelayoutconfiguration-freeform
         */
        readonly freeForm?: CfnAnalysis.DefaultFreeFormLayoutConfigurationProperty | cdk.IResolvable;
        /**
         * The options that determine the default settings for a grid layout configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultinteractivelayoutconfiguration.html#cfn-quicksight-analysis-defaultinteractivelayoutconfiguration-grid
         */
        readonly grid?: CfnAnalysis.DefaultGridLayoutConfigurationProperty | cdk.IResolvable;
    }
    /**
     * The options that determine the default settings of a free-form layout configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfreeformlayoutconfiguration.html
     */
    interface DefaultFreeFormLayoutConfigurationProperty {
        /**
         * Determines the screen canvas size options for a free-form layout.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfreeformlayoutconfiguration.html#cfn-quicksight-analysis-defaultfreeformlayoutconfiguration-canvassizeoptions
         */
        readonly canvasSizeOptions: CfnAnalysis.FreeFormLayoutCanvasSizeOptionsProperty | cdk.IResolvable;
    }
    /**
     * Configuration options for the canvas of a free-form layout.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutcanvassizeoptions.html
     */
    interface FreeFormLayoutCanvasSizeOptionsProperty {
        /**
         * The options that determine the sizing of the canvas used in a free-form layout.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutcanvassizeoptions.html#cfn-quicksight-analysis-freeformlayoutcanvassizeoptions-screencanvassizeoptions
         */
        readonly screenCanvasSizeOptions?: CfnAnalysis.FreeFormLayoutScreenCanvasSizeOptionsProperty | cdk.IResolvable;
    }
    /**
     * The options that determine the sizing of the canvas used in a free-form layout.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutscreencanvassizeoptions.html
     */
    interface FreeFormLayoutScreenCanvasSizeOptionsProperty {
        /**
         * The width that the view port will be optimized for when the layout renders.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutscreencanvassizeoptions.html#cfn-quicksight-analysis-freeformlayoutscreencanvassizeoptions-optimizedviewportwidth
         */
        readonly optimizedViewPortWidth: string;
    }
    /**
     * The options that determine the default settings for a grid layout configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultgridlayoutconfiguration.html
     */
    interface DefaultGridLayoutConfigurationProperty {
        /**
         * Determines the screen canvas size options for a grid layout.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultgridlayoutconfiguration.html#cfn-quicksight-analysis-defaultgridlayoutconfiguration-canvassizeoptions
         */
        readonly canvasSizeOptions: CfnAnalysis.GridLayoutCanvasSizeOptionsProperty | cdk.IResolvable;
    }
    /**
     * Configuration options for the canvas of a grid layout.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gridlayoutcanvassizeoptions.html
     */
    interface GridLayoutCanvasSizeOptionsProperty {
        /**
         * The options that determine the sizing of the canvas used in a grid layout.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gridlayoutcanvassizeoptions.html#cfn-quicksight-analysis-gridlayoutcanvassizeoptions-screencanvassizeoptions
         */
        readonly screenCanvasSizeOptions?: CfnAnalysis.GridLayoutScreenCanvasSizeOptionsProperty | cdk.IResolvable;
    }
    /**
     * The options that determine the sizing of the canvas used in a grid layout.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gridlayoutscreencanvassizeoptions.html
     */
    interface GridLayoutScreenCanvasSizeOptionsProperty {
        /**
         * The width that the view port will be optimized for when the layout renders.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gridlayoutscreencanvassizeoptions.html#cfn-quicksight-analysis-gridlayoutscreencanvassizeoptions-optimizedviewportwidth
         */
        readonly optimizedViewPortWidth?: string;
        /**
         * This value determines the layout behavior when the viewport is resized.
         *
         * - `FIXED` : A fixed width will be used when optimizing the layout. In the Amazon QuickSight console, this option is called `Classic` .
         * - `RESPONSIVE` : The width of the canvas will be responsive and optimized to the view port. In the Amazon QuickSight console, this option is called `Tiled` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gridlayoutscreencanvassizeoptions.html#cfn-quicksight-analysis-gridlayoutscreencanvassizeoptions-resizeoption
         */
        readonly resizeOption: string;
    }
    /**
     * The options that determine the default settings for a paginated layout configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultpaginatedlayoutconfiguration.html
     */
    interface DefaultPaginatedLayoutConfigurationProperty {
        /**
         * The options that determine the default settings for a section-based layout configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultpaginatedlayoutconfiguration.html#cfn-quicksight-analysis-defaultpaginatedlayoutconfiguration-sectionbased
         */
        readonly sectionBased?: CfnAnalysis.DefaultSectionBasedLayoutConfigurationProperty | cdk.IResolvable;
    }
    /**
     * The options that determine the default settings for a section-based layout configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultsectionbasedlayoutconfiguration.html
     */
    interface DefaultSectionBasedLayoutConfigurationProperty {
        /**
         * Determines the screen canvas size options for a section-based layout.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultsectionbasedlayoutconfiguration.html#cfn-quicksight-analysis-defaultsectionbasedlayoutconfiguration-canvassizeoptions
         */
        readonly canvasSizeOptions: cdk.IResolvable | CfnAnalysis.SectionBasedLayoutCanvasSizeOptionsProperty;
    }
    /**
     * The options for the canvas of a section-based layout.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionbasedlayoutcanvassizeoptions.html
     */
    interface SectionBasedLayoutCanvasSizeOptionsProperty {
        /**
         * The options for a paper canvas of a section-based layout.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionbasedlayoutcanvassizeoptions.html#cfn-quicksight-analysis-sectionbasedlayoutcanvassizeoptions-papercanvassizeoptions
         */
        readonly paperCanvasSizeOptions?: cdk.IResolvable | CfnAnalysis.SectionBasedLayoutPaperCanvasSizeOptionsProperty;
    }
    /**
     * The options for a paper canvas of a section-based layout.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionbasedlayoutpapercanvassizeoptions.html
     */
    interface SectionBasedLayoutPaperCanvasSizeOptionsProperty {
        /**
         * Defines the spacing between the canvas content and the top, bottom, left, and right edges.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionbasedlayoutpapercanvassizeoptions.html#cfn-quicksight-analysis-sectionbasedlayoutpapercanvassizeoptions-papermargin
         */
        readonly paperMargin?: cdk.IResolvable | CfnAnalysis.SpacingProperty;
        /**
         * The paper orientation that is used to define canvas dimensions. Choose one of the following options:.
         *
         * - PORTRAIT
         * - LANDSCAPE
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionbasedlayoutpapercanvassizeoptions.html#cfn-quicksight-analysis-sectionbasedlayoutpapercanvassizeoptions-paperorientation
         */
        readonly paperOrientation?: string;
        /**
         * The paper size that is used to define canvas dimensions.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionbasedlayoutpapercanvassizeoptions.html#cfn-quicksight-analysis-sectionbasedlayoutpapercanvassizeoptions-papersize
         */
        readonly paperSize?: string;
    }
    /**
     * The configuration of spacing (often a margin or padding).
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-spacing.html
     */
    interface SpacingProperty {
        /**
         * Define the bottom spacing.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-spacing.html#cfn-quicksight-analysis-spacing-bottom
         */
        readonly bottom?: string;
        /**
         * Define the left spacing.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-spacing.html#cfn-quicksight-analysis-spacing-left
         */
        readonly left?: string;
        /**
         * Define the right spacing.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-spacing.html#cfn-quicksight-analysis-spacing-right
         */
        readonly right?: string;
        /**
         * Define the top spacing.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-spacing.html#cfn-quicksight-analysis-spacing-top
         */
        readonly top?: string;
    }
    /**
     * A sheet is an object that contains a set of visuals that are viewed together on one page in a paginated report.
     *
     * Every analysis and dashboard must contain at least one sheet.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetdefinition.html
     */
    interface SheetDefinitionProperty {
        /**
         * The layout content type of the sheet. Choose one of the following options:.
         *
         * - `PAGINATED` : Creates a sheet for a paginated report.
         * - `INTERACTIVE` : Creates a sheet for an interactive dashboard.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetdefinition.html#cfn-quicksight-analysis-sheetdefinition-contenttype
         */
        readonly contentType?: string;
        /**
         * A description of the sheet.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetdefinition.html#cfn-quicksight-analysis-sheetdefinition-description
         */
        readonly description?: string;
        /**
         * The list of filter controls that are on a sheet.
         *
         * For more information, see [Adding filter controls to analysis sheets](https://docs.aws.amazon.com/quicksight/latest/user/filter-controls.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetdefinition.html#cfn-quicksight-analysis-sheetdefinition-filtercontrols
         */
        readonly filterControls?: Array<CfnAnalysis.FilterControlProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * A list of images on a sheet.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetdefinition.html#cfn-quicksight-analysis-sheetdefinition-images
         */
        readonly images?: Array<cdk.IResolvable | CfnAnalysis.SheetImageProperty> | cdk.IResolvable;
        /**
         * Layouts define how the components of a sheet are arranged.
         *
         * For more information, see [Types of layout](https://docs.aws.amazon.com/quicksight/latest/user/types-of-layout.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetdefinition.html#cfn-quicksight-analysis-sheetdefinition-layouts
         */
        readonly layouts?: Array<cdk.IResolvable | CfnAnalysis.LayoutProperty> | cdk.IResolvable;
        /**
         * The name of the sheet.
         *
         * This name is displayed on the sheet's tab in the Amazon QuickSight console.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetdefinition.html#cfn-quicksight-analysis-sheetdefinition-name
         */
        readonly name?: string;
        /**
         * The list of parameter controls that are on a sheet.
         *
         * For more information, see [Using a Control with a Parameter in Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/parameters-controls.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetdefinition.html#cfn-quicksight-analysis-sheetdefinition-parametercontrols
         */
        readonly parameterControls?: Array<cdk.IResolvable | CfnAnalysis.ParameterControlProperty> | cdk.IResolvable;
        /**
         * The control layouts of the sheet.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetdefinition.html#cfn-quicksight-analysis-sheetdefinition-sheetcontrollayouts
         */
        readonly sheetControlLayouts?: Array<cdk.IResolvable | CfnAnalysis.SheetControlLayoutProperty> | cdk.IResolvable;
        /**
         * The unique identifier of a sheet.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetdefinition.html#cfn-quicksight-analysis-sheetdefinition-sheetid
         */
        readonly sheetId: string;
        /**
         * The text boxes that are on a sheet.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetdefinition.html#cfn-quicksight-analysis-sheetdefinition-textboxes
         */
        readonly textBoxes?: Array<cdk.IResolvable | CfnAnalysis.SheetTextBoxProperty> | cdk.IResolvable;
        /**
         * The title of the sheet.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetdefinition.html#cfn-quicksight-analysis-sheetdefinition-title
         */
        readonly title?: string;
        /**
         * A list of the visuals that are on a sheet.
         *
         * Visual placement is determined by the layout of the sheet.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetdefinition.html#cfn-quicksight-analysis-sheetdefinition-visuals
         */
        readonly visuals?: Array<cdk.IResolvable | CfnAnalysis.VisualProperty> | cdk.IResolvable;
    }
    /**
     * The control of a parameter that users can interact with in a dashboard or an analysis.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parametercontrol.html
     */
    interface ParameterControlProperty {
        /**
         * A control from a date parameter that specifies date and time.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parametercontrol.html#cfn-quicksight-analysis-parametercontrol-datetimepicker
         */
        readonly dateTimePicker?: cdk.IResolvable | CfnAnalysis.ParameterDateTimePickerControlProperty;
        /**
         * A control to display a dropdown list with buttons that are used to select a single value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parametercontrol.html#cfn-quicksight-analysis-parametercontrol-dropdown
         */
        readonly dropdown?: cdk.IResolvable | CfnAnalysis.ParameterDropDownControlProperty;
        /**
         * A control to display a list with buttons or boxes that are used to select either a single value or multiple values.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parametercontrol.html#cfn-quicksight-analysis-parametercontrol-list
         */
        readonly list?: cdk.IResolvable | CfnAnalysis.ParameterListControlProperty;
        /**
         * A control to display a horizontal toggle bar.
         *
         * This is used to change a value by sliding the toggle.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parametercontrol.html#cfn-quicksight-analysis-parametercontrol-slider
         */
        readonly slider?: cdk.IResolvable | CfnAnalysis.ParameterSliderControlProperty;
        /**
         * A control to display a text box that is used to enter multiple entries.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parametercontrol.html#cfn-quicksight-analysis-parametercontrol-textarea
         */
        readonly textArea?: cdk.IResolvable | CfnAnalysis.ParameterTextAreaControlProperty;
        /**
         * A control to display a text box that is used to enter a single entry.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parametercontrol.html#cfn-quicksight-analysis-parametercontrol-textfield
         */
        readonly textField?: cdk.IResolvable | CfnAnalysis.ParameterTextFieldControlProperty;
    }
    /**
     * A control to display a horizontal toggle bar.
     *
     * This is used to change a value by sliding the toggle.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterslidercontrol.html
     */
    interface ParameterSliderControlProperty {
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterslidercontrol.html#cfn-quicksight-analysis-parameterslidercontrol-displayoptions
         */
        readonly displayOptions?: cdk.IResolvable | CfnAnalysis.SliderControlDisplayOptionsProperty;
        /**
         * The larger value that is displayed at the right of the slider.
         *
         * @default - 0
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterslidercontrol.html#cfn-quicksight-analysis-parameterslidercontrol-maximumvalue
         */
        readonly maximumValue: number;
        /**
         * The smaller value that is displayed at the left of the slider.
         *
         * @default - 0
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterslidercontrol.html#cfn-quicksight-analysis-parameterslidercontrol-minimumvalue
         */
        readonly minimumValue: number;
        /**
         * The ID of the `ParameterSliderControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterslidercontrol.html#cfn-quicksight-analysis-parameterslidercontrol-parametercontrolid
         */
        readonly parameterControlId: string;
        /**
         * The source parameter name of the `ParameterSliderControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterslidercontrol.html#cfn-quicksight-analysis-parameterslidercontrol-sourceparametername
         */
        readonly sourceParameterName: string;
        /**
         * The number of increments that the slider bar is divided into.
         *
         * @default - 0
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterslidercontrol.html#cfn-quicksight-analysis-parameterslidercontrol-stepsize
         */
        readonly stepSize: number;
        /**
         * The title of the `ParameterSliderControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterslidercontrol.html#cfn-quicksight-analysis-parameterslidercontrol-title
         */
        readonly title: string;
    }
    /**
     * A control to display a text box that is used to enter multiple entries.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parametertextareacontrol.html
     */
    interface ParameterTextAreaControlProperty {
        /**
         * The delimiter that is used to separate the lines in text.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parametertextareacontrol.html#cfn-quicksight-analysis-parametertextareacontrol-delimiter
         */
        readonly delimiter?: string;
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parametertextareacontrol.html#cfn-quicksight-analysis-parametertextareacontrol-displayoptions
         */
        readonly displayOptions?: cdk.IResolvable | CfnAnalysis.TextAreaControlDisplayOptionsProperty;
        /**
         * The ID of the `ParameterTextAreaControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parametertextareacontrol.html#cfn-quicksight-analysis-parametertextareacontrol-parametercontrolid
         */
        readonly parameterControlId: string;
        /**
         * The source parameter name of the `ParameterTextAreaControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parametertextareacontrol.html#cfn-quicksight-analysis-parametertextareacontrol-sourceparametername
         */
        readonly sourceParameterName: string;
        /**
         * The title of the `ParameterTextAreaControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parametertextareacontrol.html#cfn-quicksight-analysis-parametertextareacontrol-title
         */
        readonly title: string;
    }
    /**
     * A control to display a dropdown list with buttons that are used to select a single value.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterdropdowncontrol.html
     */
    interface ParameterDropDownControlProperty {
        /**
         * The values that are displayed in a control can be configured to only show values that are valid based on what's selected in other controls.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterdropdowncontrol.html#cfn-quicksight-analysis-parameterdropdowncontrol-cascadingcontrolconfiguration
         */
        readonly cascadingControlConfiguration?: CfnAnalysis.CascadingControlConfigurationProperty | cdk.IResolvable;
        /**
         * The visibility configuration of the Apply button on a `ParameterDropDownControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterdropdowncontrol.html#cfn-quicksight-analysis-parameterdropdowncontrol-commitmode
         */
        readonly commitMode?: string;
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterdropdowncontrol.html#cfn-quicksight-analysis-parameterdropdowncontrol-displayoptions
         */
        readonly displayOptions?: CfnAnalysis.DropDownControlDisplayOptionsProperty | cdk.IResolvable;
        /**
         * The ID of the `ParameterDropDownControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterdropdowncontrol.html#cfn-quicksight-analysis-parameterdropdowncontrol-parametercontrolid
         */
        readonly parameterControlId: string;
        /**
         * A list of selectable values that are used in a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterdropdowncontrol.html#cfn-quicksight-analysis-parameterdropdowncontrol-selectablevalues
         */
        readonly selectableValues?: cdk.IResolvable | CfnAnalysis.ParameterSelectableValuesProperty;
        /**
         * The source parameter name of the `ParameterDropDownControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterdropdowncontrol.html#cfn-quicksight-analysis-parameterdropdowncontrol-sourceparametername
         */
        readonly sourceParameterName: string;
        /**
         * The title of the `ParameterDropDownControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterdropdowncontrol.html#cfn-quicksight-analysis-parameterdropdowncontrol-title
         */
        readonly title: string;
        /**
         * The type parameter name of the `ParameterDropDownControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterdropdowncontrol.html#cfn-quicksight-analysis-parameterdropdowncontrol-type
         */
        readonly type?: string;
    }
    /**
     * The values that are displayed in a control can be configured to only show values that are valid based on what's selected in other controls.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-cascadingcontrolconfiguration.html
     */
    interface CascadingControlConfigurationProperty {
        /**
         * A list of source controls that determine the values that are used in the current control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-cascadingcontrolconfiguration.html#cfn-quicksight-analysis-cascadingcontrolconfiguration-sourcecontrols
         */
        readonly sourceControls?: Array<CfnAnalysis.CascadingControlSourceProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The source controls that are used in a `CascadingControlConfiguration` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-cascadingcontrolsource.html
     */
    interface CascadingControlSourceProperty {
        /**
         * The column identifier that determines which column to look up for the source sheet control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-cascadingcontrolsource.html#cfn-quicksight-analysis-cascadingcontrolsource-columntomatch
         */
        readonly columnToMatch?: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The source sheet control ID of a `CascadingControlSource` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-cascadingcontrolsource.html#cfn-quicksight-analysis-cascadingcontrolsource-sourcesheetcontrolid
         */
        readonly sourceSheetControlId?: string;
    }
    /**
     * A list of selectable values that are used in a control.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterselectablevalues.html
     */
    interface ParameterSelectableValuesProperty {
        /**
         * The column identifier that fetches values from the data set.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterselectablevalues.html#cfn-quicksight-analysis-parameterselectablevalues-linktodatasetcolumn
         */
        readonly linkToDataSetColumn?: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The values that are used in `ParameterSelectableValues` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterselectablevalues.html#cfn-quicksight-analysis-parameterselectablevalues-values
         */
        readonly values?: Array<string>;
    }
    /**
     * A control to display a text box that is used to enter a single entry.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parametertextfieldcontrol.html
     */
    interface ParameterTextFieldControlProperty {
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parametertextfieldcontrol.html#cfn-quicksight-analysis-parametertextfieldcontrol-displayoptions
         */
        readonly displayOptions?: cdk.IResolvable | CfnAnalysis.TextFieldControlDisplayOptionsProperty;
        /**
         * The ID of the `ParameterTextFieldControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parametertextfieldcontrol.html#cfn-quicksight-analysis-parametertextfieldcontrol-parametercontrolid
         */
        readonly parameterControlId: string;
        /**
         * The source parameter name of the `ParameterTextFieldControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parametertextfieldcontrol.html#cfn-quicksight-analysis-parametertextfieldcontrol-sourceparametername
         */
        readonly sourceParameterName: string;
        /**
         * The title of the `ParameterTextFieldControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parametertextfieldcontrol.html#cfn-quicksight-analysis-parametertextfieldcontrol-title
         */
        readonly title: string;
    }
    /**
     * A control to display a list with buttons or boxes that are used to select either a single value or multiple values.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterlistcontrol.html
     */
    interface ParameterListControlProperty {
        /**
         * The values that are displayed in a control can be configured to only show values that are valid based on what's selected in other controls.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterlistcontrol.html#cfn-quicksight-analysis-parameterlistcontrol-cascadingcontrolconfiguration
         */
        readonly cascadingControlConfiguration?: CfnAnalysis.CascadingControlConfigurationProperty | cdk.IResolvable;
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterlistcontrol.html#cfn-quicksight-analysis-parameterlistcontrol-displayoptions
         */
        readonly displayOptions?: cdk.IResolvable | CfnAnalysis.ListControlDisplayOptionsProperty;
        /**
         * The ID of the `ParameterListControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterlistcontrol.html#cfn-quicksight-analysis-parameterlistcontrol-parametercontrolid
         */
        readonly parameterControlId: string;
        /**
         * A list of selectable values that are used in a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterlistcontrol.html#cfn-quicksight-analysis-parameterlistcontrol-selectablevalues
         */
        readonly selectableValues?: cdk.IResolvable | CfnAnalysis.ParameterSelectableValuesProperty;
        /**
         * The source parameter name of the `ParameterListControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterlistcontrol.html#cfn-quicksight-analysis-parameterlistcontrol-sourceparametername
         */
        readonly sourceParameterName: string;
        /**
         * The title of the `ParameterListControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterlistcontrol.html#cfn-quicksight-analysis-parameterlistcontrol-title
         */
        readonly title: string;
        /**
         * The type of `ParameterListControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterlistcontrol.html#cfn-quicksight-analysis-parameterlistcontrol-type
         */
        readonly type?: string;
    }
    /**
     * A control from a date parameter that specifies date and time.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterdatetimepickercontrol.html
     */
    interface ParameterDateTimePickerControlProperty {
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterdatetimepickercontrol.html#cfn-quicksight-analysis-parameterdatetimepickercontrol-displayoptions
         */
        readonly displayOptions?: CfnAnalysis.DateTimePickerControlDisplayOptionsProperty | cdk.IResolvable;
        /**
         * The ID of the `ParameterDateTimePickerControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterdatetimepickercontrol.html#cfn-quicksight-analysis-parameterdatetimepickercontrol-parametercontrolid
         */
        readonly parameterControlId: string;
        /**
         * The name of the `ParameterDateTimePickerControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterdatetimepickercontrol.html#cfn-quicksight-analysis-parameterdatetimepickercontrol-sourceparametername
         */
        readonly sourceParameterName: string;
        /**
         * The title of the `ParameterDateTimePickerControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterdatetimepickercontrol.html#cfn-quicksight-analysis-parameterdatetimepickercontrol-title
         */
        readonly title: string;
    }
    /**
     * A text box.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheettextbox.html
     */
    interface SheetTextBoxProperty {
        /**
         * The content that is displayed in the text box.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheettextbox.html#cfn-quicksight-analysis-sheettextbox-content
         */
        readonly content?: string;
        /**
         * The unique identifier for a text box.
         *
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have text boxes that share identifiers.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheettextbox.html#cfn-quicksight-analysis-sheettextbox-sheettextboxid
         */
        readonly sheetTextBoxId: string;
    }
    /**
     * A `Layout` defines the placement of elements within a sheet.
     *
     * For more information, see [Types of layout](https://docs.aws.amazon.com/quicksight/latest/user/types-of-layout.html) in the *Amazon QuickSight User Guide* .
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layout.html
     */
    interface LayoutProperty {
        /**
         * The configuration that determines what the type of layout for a sheet.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layout.html#cfn-quicksight-analysis-layout-configuration
         */
        readonly configuration: cdk.IResolvable | CfnAnalysis.LayoutConfigurationProperty;
    }
    /**
     * The configuration that determines what the type of layout will be used on a sheet.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layoutconfiguration.html
     */
    interface LayoutConfigurationProperty {
        /**
         * A free-form is optimized for a fixed width and has more control over the exact placement of layout elements.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layoutconfiguration.html#cfn-quicksight-analysis-layoutconfiguration-freeformlayout
         */
        readonly freeFormLayout?: CfnAnalysis.FreeFormLayoutConfigurationProperty | cdk.IResolvable;
        /**
         * A type of layout that can be used on a sheet.
         *
         * In a grid layout, visuals snap to a grid with standard spacing and alignment. Dashboards are displayed as designed, with options to fit to screen or view at actual size. A grid layout can be configured to behave in one of two ways when the viewport is resized: `FIXED` or `RESPONSIVE` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layoutconfiguration.html#cfn-quicksight-analysis-layoutconfiguration-gridlayout
         */
        readonly gridLayout?: CfnAnalysis.GridLayoutConfigurationProperty | cdk.IResolvable;
        /**
         * A section based layout organizes visuals into multiple sections and has customized header, footer and page break.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layoutconfiguration.html#cfn-quicksight-analysis-layoutconfiguration-sectionbasedlayout
         */
        readonly sectionBasedLayout?: cdk.IResolvable | CfnAnalysis.SectionBasedLayoutConfigurationProperty;
    }
    /**
     * The configuration for a grid layout. Also called a tiled layout.
     *
     * Visuals snap to a grid with standard spacing and alignment. Dashboards are displayed as designed, with options to fit to screen or view at actual size.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gridlayoutconfiguration.html
     */
    interface GridLayoutConfigurationProperty {
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gridlayoutconfiguration.html#cfn-quicksight-analysis-gridlayoutconfiguration-canvassizeoptions
         */
        readonly canvasSizeOptions?: CfnAnalysis.GridLayoutCanvasSizeOptionsProperty | cdk.IResolvable;
        /**
         * The elements that are included in a grid layout.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gridlayoutconfiguration.html#cfn-quicksight-analysis-gridlayoutconfiguration-elements
         */
        readonly elements: Array<CfnAnalysis.GridLayoutElementProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * An element within a grid layout.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gridlayoutelement.html
     */
    interface GridLayoutElementProperty {
        /**
         * The column index for the upper left corner of an element.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gridlayoutelement.html#cfn-quicksight-analysis-gridlayoutelement-columnindex
         */
        readonly columnIndex?: number;
        /**
         * The width of a grid element expressed as a number of grid columns.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gridlayoutelement.html#cfn-quicksight-analysis-gridlayoutelement-columnspan
         */
        readonly columnSpan: number;
        /**
         * A unique identifier for an element within a grid layout.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gridlayoutelement.html#cfn-quicksight-analysis-gridlayoutelement-elementid
         */
        readonly elementId: string;
        /**
         * The type of element.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gridlayoutelement.html#cfn-quicksight-analysis-gridlayoutelement-elementtype
         */
        readonly elementType: string;
        /**
         * The row index for the upper left corner of an element.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gridlayoutelement.html#cfn-quicksight-analysis-gridlayoutelement-rowindex
         */
        readonly rowIndex?: number;
        /**
         * The height of a grid element expressed as a number of grid rows.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gridlayoutelement.html#cfn-quicksight-analysis-gridlayoutelement-rowspan
         */
        readonly rowSpan: number;
    }
    /**
     * The configuration of a free-form layout.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutconfiguration.html
     */
    interface FreeFormLayoutConfigurationProperty {
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutconfiguration.html#cfn-quicksight-analysis-freeformlayoutconfiguration-canvassizeoptions
         */
        readonly canvasSizeOptions?: CfnAnalysis.FreeFormLayoutCanvasSizeOptionsProperty | cdk.IResolvable;
        /**
         * The elements that are included in a free-form layout.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutconfiguration.html#cfn-quicksight-analysis-freeformlayoutconfiguration-elements
         */
        readonly elements: Array<CfnAnalysis.FreeFormLayoutElementProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * An element within a free-form layout.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutelement.html
     */
    interface FreeFormLayoutElementProperty {
        /**
         * The background style configuration of a free-form layout element.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutelement.html#cfn-quicksight-analysis-freeformlayoutelement-backgroundstyle
         */
        readonly backgroundStyle?: CfnAnalysis.FreeFormLayoutElementBackgroundStyleProperty | cdk.IResolvable;
        /**
         * The border style configuration of a free-form layout element.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutelement.html#cfn-quicksight-analysis-freeformlayoutelement-borderstyle
         */
        readonly borderStyle?: CfnAnalysis.FreeFormLayoutElementBorderStyleProperty | cdk.IResolvable;
        /**
         * A unique identifier for an element within a free-form layout.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutelement.html#cfn-quicksight-analysis-freeformlayoutelement-elementid
         */
        readonly elementId: string;
        /**
         * The type of element.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutelement.html#cfn-quicksight-analysis-freeformlayoutelement-elementtype
         */
        readonly elementType: string;
        /**
         * The height of an element within a free-form layout.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutelement.html#cfn-quicksight-analysis-freeformlayoutelement-height
         */
        readonly height: string;
        /**
         * The loading animation configuration of a free-form layout element.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutelement.html#cfn-quicksight-analysis-freeformlayoutelement-loadinganimation
         */
        readonly loadingAnimation?: cdk.IResolvable | CfnAnalysis.LoadingAnimationProperty;
        /**
         * The rendering rules that determine when an element should be displayed within a free-form layout.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutelement.html#cfn-quicksight-analysis-freeformlayoutelement-renderingrules
         */
        readonly renderingRules?: Array<cdk.IResolvable | CfnAnalysis.SheetElementRenderingRuleProperty> | cdk.IResolvable;
        /**
         * The border style configuration of a free-form layout element.
         *
         * This border style is used when the element is selected.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutelement.html#cfn-quicksight-analysis-freeformlayoutelement-selectedborderstyle
         */
        readonly selectedBorderStyle?: CfnAnalysis.FreeFormLayoutElementBorderStyleProperty | cdk.IResolvable;
        /**
         * The visibility of an element within a free-form layout.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutelement.html#cfn-quicksight-analysis-freeformlayoutelement-visibility
         */
        readonly visibility?: string;
        /**
         * The width of an element within a free-form layout.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutelement.html#cfn-quicksight-analysis-freeformlayoutelement-width
         */
        readonly width: string;
        /**
         * The x-axis coordinate of the element.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutelement.html#cfn-quicksight-analysis-freeformlayoutelement-xaxislocation
         */
        readonly xAxisLocation: string;
        /**
         * The y-axis coordinate of the element.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutelement.html#cfn-quicksight-analysis-freeformlayoutelement-yaxislocation
         */
        readonly yAxisLocation: string;
    }
    /**
     * The background style configuration of a free-form layout element.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutelementborderstyle.html
     */
    interface FreeFormLayoutElementBorderStyleProperty {
        /**
         * The border color of a free-form layout element.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutelementborderstyle.html#cfn-quicksight-analysis-freeformlayoutelementborderstyle-color
         */
        readonly color?: string;
        /**
         * The border visibility of a free-form layout element.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutelementborderstyle.html#cfn-quicksight-analysis-freeformlayoutelementborderstyle-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The rendering rules of a sheet that uses a free-form layout.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetelementrenderingrule.html
     */
    interface SheetElementRenderingRuleProperty {
        /**
         * The override configuration of the rendering rules of a sheet.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetelementrenderingrule.html#cfn-quicksight-analysis-sheetelementrenderingrule-configurationoverrides
         */
        readonly configurationOverrides: cdk.IResolvable | CfnAnalysis.SheetElementConfigurationOverridesProperty;
        /**
         * The expression of the rendering rules of a sheet.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetelementrenderingrule.html#cfn-quicksight-analysis-sheetelementrenderingrule-expression
         */
        readonly expression: string;
    }
    /**
     * The override configuration of the rendering rules of a sheet.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetelementconfigurationoverrides.html
     */
    interface SheetElementConfigurationOverridesProperty {
        /**
         * Determines whether or not the overrides are visible. Choose one of the following options:.
         *
         * - `VISIBLE`
         * - `HIDDEN`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetelementconfigurationoverrides.html#cfn-quicksight-analysis-sheetelementconfigurationoverrides-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The configuration of loading animation in free-form layout.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-loadinganimation.html
     */
    interface LoadingAnimationProperty {
        /**
         * The visibility configuration of `LoadingAnimation` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-loadinganimation.html#cfn-quicksight-analysis-loadinganimation-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The background style configuration of a free-form layout element.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutelementbackgroundstyle.html
     */
    interface FreeFormLayoutElementBackgroundStyleProperty {
        /**
         * The background color of a free-form layout element.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutelementbackgroundstyle.html#cfn-quicksight-analysis-freeformlayoutelementbackgroundstyle-color
         */
        readonly color?: string;
        /**
         * The background visibility of a free-form layout element.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutelementbackgroundstyle.html#cfn-quicksight-analysis-freeformlayoutelementbackgroundstyle-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The configuration for a section-based layout.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionbasedlayoutconfiguration.html
     */
    interface SectionBasedLayoutConfigurationProperty {
        /**
         * A list of body section configurations.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionbasedlayoutconfiguration.html#cfn-quicksight-analysis-sectionbasedlayoutconfiguration-bodysections
         */
        readonly bodySections: Array<CfnAnalysis.BodySectionConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The options for the canvas of a section-based layout.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionbasedlayoutconfiguration.html#cfn-quicksight-analysis-sectionbasedlayoutconfiguration-canvassizeoptions
         */
        readonly canvasSizeOptions: cdk.IResolvable | CfnAnalysis.SectionBasedLayoutCanvasSizeOptionsProperty;
        /**
         * A list of footer section configurations.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionbasedlayoutconfiguration.html#cfn-quicksight-analysis-sectionbasedlayoutconfiguration-footersections
         */
        readonly footerSections: Array<CfnAnalysis.HeaderFooterSectionConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * A list of header section configurations.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionbasedlayoutconfiguration.html#cfn-quicksight-analysis-sectionbasedlayoutconfiguration-headersections
         */
        readonly headerSections: Array<CfnAnalysis.HeaderFooterSectionConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The configuration of a header or footer section.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-headerfootersectionconfiguration.html
     */
    interface HeaderFooterSectionConfigurationProperty {
        /**
         * The layout configuration of the header or footer section.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-headerfootersectionconfiguration.html#cfn-quicksight-analysis-headerfootersectionconfiguration-layout
         */
        readonly layout: cdk.IResolvable | CfnAnalysis.SectionLayoutConfigurationProperty;
        /**
         * The unique identifier of the header or footer section.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-headerfootersectionconfiguration.html#cfn-quicksight-analysis-headerfootersectionconfiguration-sectionid
         */
        readonly sectionId: string;
        /**
         * The style options of a header or footer section.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-headerfootersectionconfiguration.html#cfn-quicksight-analysis-headerfootersectionconfiguration-style
         */
        readonly style?: cdk.IResolvable | CfnAnalysis.SectionStyleProperty;
    }
    /**
     * The layout configuration of a section.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionlayoutconfiguration.html
     */
    interface SectionLayoutConfigurationProperty {
        /**
         * The free-form layout configuration of a section.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionlayoutconfiguration.html#cfn-quicksight-analysis-sectionlayoutconfiguration-freeformlayout
         */
        readonly freeFormLayout: CfnAnalysis.FreeFormSectionLayoutConfigurationProperty | cdk.IResolvable;
    }
    /**
     * The free-form layout configuration of a section.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformsectionlayoutconfiguration.html
     */
    interface FreeFormSectionLayoutConfigurationProperty {
        /**
         * The elements that are included in the free-form layout.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformsectionlayoutconfiguration.html#cfn-quicksight-analysis-freeformsectionlayoutconfiguration-elements
         */
        readonly elements: Array<CfnAnalysis.FreeFormLayoutElementProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The options that style a section.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionstyle.html
     */
    interface SectionStyleProperty {
        /**
         * The height of a section.
         *
         * Heights can only be defined for header and footer sections. The default height margin is 0.5 inches.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionstyle.html#cfn-quicksight-analysis-sectionstyle-height
         */
        readonly height?: string;
        /**
         * The spacing between section content and its top, bottom, left, and right edges.
         *
         * There is no padding by default.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionstyle.html#cfn-quicksight-analysis-sectionstyle-padding
         */
        readonly padding?: cdk.IResolvable | CfnAnalysis.SpacingProperty;
    }
    /**
     * The configuration of a body section.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionconfiguration.html
     */
    interface BodySectionConfigurationProperty {
        /**
         * The configuration of content in a body section.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionconfiguration.html#cfn-quicksight-analysis-bodysectionconfiguration-content
         */
        readonly content: CfnAnalysis.BodySectionContentProperty | cdk.IResolvable;
        /**
         * The configuration of a page break for a section.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionconfiguration.html#cfn-quicksight-analysis-bodysectionconfiguration-pagebreakconfiguration
         */
        readonly pageBreakConfiguration?: cdk.IResolvable | CfnAnalysis.SectionPageBreakConfigurationProperty;
        /**
         * Describes the configurations that are required to declare a section as repeating.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionconfiguration.html#cfn-quicksight-analysis-bodysectionconfiguration-repeatconfiguration
         */
        readonly repeatConfiguration?: CfnAnalysis.BodySectionRepeatConfigurationProperty | cdk.IResolvable;
        /**
         * The unique identifier of a body section.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionconfiguration.html#cfn-quicksight-analysis-bodysectionconfiguration-sectionid
         */
        readonly sectionId: string;
        /**
         * The style options of a body section.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionconfiguration.html#cfn-quicksight-analysis-bodysectionconfiguration-style
         */
        readonly style?: cdk.IResolvable | CfnAnalysis.SectionStyleProperty;
    }
    /**
     * The configuration of content in a body section.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectioncontent.html
     */
    interface BodySectionContentProperty {
        /**
         * The layout configuration of a body section.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectioncontent.html#cfn-quicksight-analysis-bodysectioncontent-layout
         */
        readonly layout?: cdk.IResolvable | CfnAnalysis.SectionLayoutConfigurationProperty;
    }
    /**
     * The configuration of a page break for a section.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionpagebreakconfiguration.html
     */
    interface SectionPageBreakConfigurationProperty {
        /**
         * The configuration of a page break after a section.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionpagebreakconfiguration.html#cfn-quicksight-analysis-sectionpagebreakconfiguration-after
         */
        readonly after?: cdk.IResolvable | CfnAnalysis.SectionAfterPageBreakProperty;
    }
    /**
     * The configuration of a page break after a section.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionafterpagebreak.html
     */
    interface SectionAfterPageBreakProperty {
        /**
         * The option that enables or disables a page break at the end of a section.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionafterpagebreak.html#cfn-quicksight-analysis-sectionafterpagebreak-status
         */
        readonly status?: string;
    }
    /**
     * Describes the configurations that are required to declare a section as repeating.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionrepeatconfiguration.html
     */
    interface BodySectionRepeatConfigurationProperty {
        /**
         * List of `BodySectionRepeatDimensionConfiguration` values that describe the dataset column and constraints for the column used to repeat the contents of a section.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionrepeatconfiguration.html#cfn-quicksight-analysis-bodysectionrepeatconfiguration-dimensionconfigurations
         */
        readonly dimensionConfigurations?: Array<CfnAnalysis.BodySectionRepeatDimensionConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * List of visuals to exclude from repetition in repeating sections.
         *
         * The visuals will render identically, and ignore the repeating configurations in all repeating instances.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionrepeatconfiguration.html#cfn-quicksight-analysis-bodysectionrepeatconfiguration-nonrepeatingvisuals
         */
        readonly nonRepeatingVisuals?: Array<string>;
        /**
         * Page break configuration to apply for each repeating instance.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionrepeatconfiguration.html#cfn-quicksight-analysis-bodysectionrepeatconfiguration-pagebreakconfiguration
         */
        readonly pageBreakConfiguration?: CfnAnalysis.BodySectionRepeatPageBreakConfigurationProperty | cdk.IResolvable;
    }
    /**
     * Describes the dataset column and constraints for the dynamic values used to repeat the contents of a section.
     *
     * The dataset column is either *Category* or *Numeric* column configuration
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionrepeatdimensionconfiguration.html
     */
    interface BodySectionRepeatDimensionConfigurationProperty {
        /**
         * Describes the *Category* dataset column and constraints around the dynamic values that will be used in repeating the section contents.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionrepeatdimensionconfiguration.html#cfn-quicksight-analysis-bodysectionrepeatdimensionconfiguration-dynamiccategorydimensionconfiguration
         */
        readonly dynamicCategoryDimensionConfiguration?: CfnAnalysis.BodySectionDynamicCategoryDimensionConfigurationProperty | cdk.IResolvable;
        /**
         * Describes the *Numeric* dataset column and constraints around the dynamic values used to repeat the contents of a section.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionrepeatdimensionconfiguration.html#cfn-quicksight-analysis-bodysectionrepeatdimensionconfiguration-dynamicnumericdimensionconfiguration
         */
        readonly dynamicNumericDimensionConfiguration?: CfnAnalysis.BodySectionDynamicNumericDimensionConfigurationProperty | cdk.IResolvable;
    }
    /**
     * Describes the *Numeric* dataset column and constraints for the dynamic values used to repeat the contents of a section.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectiondynamicnumericdimensionconfiguration.html
     */
    interface BodySectionDynamicNumericDimensionConfigurationProperty {
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectiondynamicnumericdimensionconfiguration.html#cfn-quicksight-analysis-bodysectiondynamicnumericdimensionconfiguration-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * Number of values to use from the column for repetition.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectiondynamicnumericdimensionconfiguration.html#cfn-quicksight-analysis-bodysectiondynamicnumericdimensionconfiguration-limit
         */
        readonly limit?: number;
        /**
         * Sort criteria on the column values that you use for repetition.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectiondynamicnumericdimensionconfiguration.html#cfn-quicksight-analysis-bodysectiondynamicnumericdimensionconfiguration-sortbymetrics
         */
        readonly sortByMetrics?: Array<CfnAnalysis.ColumnSortProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The sort configuration for a column that is not used in a field well.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnsort.html
     */
    interface ColumnSortProperty {
        /**
         * The aggregation function that is defined in the column sort.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnsort.html#cfn-quicksight-analysis-columnsort-aggregationfunction
         */
        readonly aggregationFunction?: CfnAnalysis.AggregationFunctionProperty | cdk.IResolvable;
        /**
         * The sort direction.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnsort.html#cfn-quicksight-analysis-columnsort-direction
         */
        readonly direction: string;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnsort.html#cfn-quicksight-analysis-columnsort-sortby
         */
        readonly sortBy: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
    }
    /**
     * Describes the *Category* dataset column and constraints for the dynamic values used to repeat the contents of a section.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectiondynamiccategorydimensionconfiguration.html
     */
    interface BodySectionDynamicCategoryDimensionConfigurationProperty {
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectiondynamiccategorydimensionconfiguration.html#cfn-quicksight-analysis-bodysectiondynamiccategorydimensionconfiguration-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * Number of values to use from the column for repetition.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectiondynamiccategorydimensionconfiguration.html#cfn-quicksight-analysis-bodysectiondynamiccategorydimensionconfiguration-limit
         */
        readonly limit?: number;
        /**
         * Sort criteria on the column values that you use for repetition.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectiondynamiccategorydimensionconfiguration.html#cfn-quicksight-analysis-bodysectiondynamiccategorydimensionconfiguration-sortbymetrics
         */
        readonly sortByMetrics?: Array<CfnAnalysis.ColumnSortProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The page break configuration to apply for each repeating instance.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionrepeatpagebreakconfiguration.html
     */
    interface BodySectionRepeatPageBreakConfigurationProperty {
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionrepeatpagebreakconfiguration.html#cfn-quicksight-analysis-bodysectionrepeatpagebreakconfiguration-after
         */
        readonly after?: cdk.IResolvable | CfnAnalysis.SectionAfterPageBreakProperty;
    }
    /**
     * The control of a filter that is used to interact with a dashboard or an analysis.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtercontrol.html
     */
    interface FilterControlProperty {
        /**
         * A control from a filter that is scoped across more than one sheet.
         *
         * This represents your filter control on a sheet
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtercontrol.html#cfn-quicksight-analysis-filtercontrol-crosssheet
         */
        readonly crossSheet?: CfnAnalysis.FilterCrossSheetControlProperty | cdk.IResolvable;
        /**
         * A control from a date filter that is used to specify date and time.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtercontrol.html#cfn-quicksight-analysis-filtercontrol-datetimepicker
         */
        readonly dateTimePicker?: CfnAnalysis.FilterDateTimePickerControlProperty | cdk.IResolvable;
        /**
         * A control to display a dropdown list with buttons that are used to select a single value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtercontrol.html#cfn-quicksight-analysis-filtercontrol-dropdown
         */
        readonly dropdown?: CfnAnalysis.FilterDropDownControlProperty | cdk.IResolvable;
        /**
         * A control to display a list of buttons or boxes.
         *
         * This is used to select either a single value or multiple values.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtercontrol.html#cfn-quicksight-analysis-filtercontrol-list
         */
        readonly list?: CfnAnalysis.FilterListControlProperty | cdk.IResolvable;
        /**
         * A control from a date filter that is used to specify the relative date.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtercontrol.html#cfn-quicksight-analysis-filtercontrol-relativedatetime
         */
        readonly relativeDateTime?: CfnAnalysis.FilterRelativeDateTimeControlProperty | cdk.IResolvable;
        /**
         * A control to display a horizontal toggle bar.
         *
         * This is used to change a value by sliding the toggle.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtercontrol.html#cfn-quicksight-analysis-filtercontrol-slider
         */
        readonly slider?: CfnAnalysis.FilterSliderControlProperty | cdk.IResolvable;
        /**
         * A control to display a text box that is used to enter multiple entries.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtercontrol.html#cfn-quicksight-analysis-filtercontrol-textarea
         */
        readonly textArea?: CfnAnalysis.FilterTextAreaControlProperty | cdk.IResolvable;
        /**
         * A control to display a text box that is used to enter a single entry.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtercontrol.html#cfn-quicksight-analysis-filtercontrol-textfield
         */
        readonly textField?: CfnAnalysis.FilterTextFieldControlProperty | cdk.IResolvable;
    }
    /**
     * A control to display a horizontal toggle bar.
     *
     * This is used to change a value by sliding the toggle.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterslidercontrol.html
     */
    interface FilterSliderControlProperty {
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterslidercontrol.html#cfn-quicksight-analysis-filterslidercontrol-displayoptions
         */
        readonly displayOptions?: cdk.IResolvable | CfnAnalysis.SliderControlDisplayOptionsProperty;
        /**
         * The ID of the `FilterSliderControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterslidercontrol.html#cfn-quicksight-analysis-filterslidercontrol-filtercontrolid
         */
        readonly filterControlId: string;
        /**
         * The larger value that is displayed at the right of the slider.
         *
         * @default - 0
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterslidercontrol.html#cfn-quicksight-analysis-filterslidercontrol-maximumvalue
         */
        readonly maximumValue: number;
        /**
         * The smaller value that is displayed at the left of the slider.
         *
         * @default - 0
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterslidercontrol.html#cfn-quicksight-analysis-filterslidercontrol-minimumvalue
         */
        readonly minimumValue: number;
        /**
         * The source filter ID of the `FilterSliderControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterslidercontrol.html#cfn-quicksight-analysis-filterslidercontrol-sourcefilterid
         */
        readonly sourceFilterId: string;
        /**
         * The number of increments that the slider bar is divided into.
         *
         * @default - 0
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterslidercontrol.html#cfn-quicksight-analysis-filterslidercontrol-stepsize
         */
        readonly stepSize: number;
        /**
         * The title of the `FilterSliderControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterslidercontrol.html#cfn-quicksight-analysis-filterslidercontrol-title
         */
        readonly title: string;
        /**
         * The type of the `FilterSliderControl` . Choose one of the following options:.
         *
         * - `SINGLE_POINT` : Filter against(equals) a single data point.
         * - `RANGE` : Filter data that is in a specified range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterslidercontrol.html#cfn-quicksight-analysis-filterslidercontrol-type
         */
        readonly type?: string;
    }
    /**
     * A control to display a text box that is used to enter multiple entries.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtertextareacontrol.html
     */
    interface FilterTextAreaControlProperty {
        /**
         * The delimiter that is used to separate the lines in text.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtertextareacontrol.html#cfn-quicksight-analysis-filtertextareacontrol-delimiter
         */
        readonly delimiter?: string;
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtertextareacontrol.html#cfn-quicksight-analysis-filtertextareacontrol-displayoptions
         */
        readonly displayOptions?: cdk.IResolvable | CfnAnalysis.TextAreaControlDisplayOptionsProperty;
        /**
         * The ID of the `FilterTextAreaControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtertextareacontrol.html#cfn-quicksight-analysis-filtertextareacontrol-filtercontrolid
         */
        readonly filterControlId: string;
        /**
         * The source filter ID of the `FilterTextAreaControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtertextareacontrol.html#cfn-quicksight-analysis-filtertextareacontrol-sourcefilterid
         */
        readonly sourceFilterId: string;
        /**
         * The title of the `FilterTextAreaControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtertextareacontrol.html#cfn-quicksight-analysis-filtertextareacontrol-title
         */
        readonly title: string;
    }
    /**
     * A control to display a dropdown list with buttons that are used to select a single value.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterdropdowncontrol.html
     */
    interface FilterDropDownControlProperty {
        /**
         * The values that are displayed in a control can be configured to only show values that are valid based on what's selected in other controls.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterdropdowncontrol.html#cfn-quicksight-analysis-filterdropdowncontrol-cascadingcontrolconfiguration
         */
        readonly cascadingControlConfiguration?: CfnAnalysis.CascadingControlConfigurationProperty | cdk.IResolvable;
        /**
         * The visibility configuration of the Apply button on a `FilterDropDownControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterdropdowncontrol.html#cfn-quicksight-analysis-filterdropdowncontrol-commitmode
         */
        readonly commitMode?: string;
        /**
         * The display options of the `FilterDropDownControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterdropdowncontrol.html#cfn-quicksight-analysis-filterdropdowncontrol-displayoptions
         */
        readonly displayOptions?: CfnAnalysis.DropDownControlDisplayOptionsProperty | cdk.IResolvable;
        /**
         * The ID of the `FilterDropDownControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterdropdowncontrol.html#cfn-quicksight-analysis-filterdropdowncontrol-filtercontrolid
         */
        readonly filterControlId: string;
        /**
         * A list of selectable values that are used in a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterdropdowncontrol.html#cfn-quicksight-analysis-filterdropdowncontrol-selectablevalues
         */
        readonly selectableValues?: CfnAnalysis.FilterSelectableValuesProperty | cdk.IResolvable;
        /**
         * The source filter ID of the `FilterDropDownControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterdropdowncontrol.html#cfn-quicksight-analysis-filterdropdowncontrol-sourcefilterid
         */
        readonly sourceFilterId: string;
        /**
         * The title of the `FilterDropDownControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterdropdowncontrol.html#cfn-quicksight-analysis-filterdropdowncontrol-title
         */
        readonly title: string;
        /**
         * The type of the `FilterDropDownControl` . Choose one of the following options:.
         *
         * - `MULTI_SELECT` : The user can select multiple entries from a dropdown menu.
         * - `SINGLE_SELECT` : The user can select a single entry from a dropdown menu.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterdropdowncontrol.html#cfn-quicksight-analysis-filterdropdowncontrol-type
         */
        readonly type?: string;
    }
    /**
     * A control to display a text box that is used to enter a single entry.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtertextfieldcontrol.html
     */
    interface FilterTextFieldControlProperty {
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtertextfieldcontrol.html#cfn-quicksight-analysis-filtertextfieldcontrol-displayoptions
         */
        readonly displayOptions?: cdk.IResolvable | CfnAnalysis.TextFieldControlDisplayOptionsProperty;
        /**
         * The ID of the `FilterTextFieldControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtertextfieldcontrol.html#cfn-quicksight-analysis-filtertextfieldcontrol-filtercontrolid
         */
        readonly filterControlId: string;
        /**
         * The source filter ID of the `FilterTextFieldControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtertextfieldcontrol.html#cfn-quicksight-analysis-filtertextfieldcontrol-sourcefilterid
         */
        readonly sourceFilterId: string;
        /**
         * The title of the `FilterTextFieldControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtertextfieldcontrol.html#cfn-quicksight-analysis-filtertextfieldcontrol-title
         */
        readonly title: string;
    }
    /**
     * A control to display a list of buttons or boxes.
     *
     * This is used to select either a single value or multiple values.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterlistcontrol.html
     */
    interface FilterListControlProperty {
        /**
         * The values that are displayed in a control can be configured to only show values that are valid based on what's selected in other controls.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterlistcontrol.html#cfn-quicksight-analysis-filterlistcontrol-cascadingcontrolconfiguration
         */
        readonly cascadingControlConfiguration?: CfnAnalysis.CascadingControlConfigurationProperty | cdk.IResolvable;
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterlistcontrol.html#cfn-quicksight-analysis-filterlistcontrol-displayoptions
         */
        readonly displayOptions?: cdk.IResolvable | CfnAnalysis.ListControlDisplayOptionsProperty;
        /**
         * The ID of the `FilterListControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterlistcontrol.html#cfn-quicksight-analysis-filterlistcontrol-filtercontrolid
         */
        readonly filterControlId: string;
        /**
         * A list of selectable values that are used in a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterlistcontrol.html#cfn-quicksight-analysis-filterlistcontrol-selectablevalues
         */
        readonly selectableValues?: CfnAnalysis.FilterSelectableValuesProperty | cdk.IResolvable;
        /**
         * The source filter ID of the `FilterListControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterlistcontrol.html#cfn-quicksight-analysis-filterlistcontrol-sourcefilterid
         */
        readonly sourceFilterId: string;
        /**
         * The title of the `FilterListControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterlistcontrol.html#cfn-quicksight-analysis-filterlistcontrol-title
         */
        readonly title: string;
        /**
         * The type of the `FilterListControl` . Choose one of the following options:.
         *
         * - `MULTI_SELECT` : The user can select multiple entries from the list.
         * - `SINGLE_SELECT` : The user can select a single entry from the list.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterlistcontrol.html#cfn-quicksight-analysis-filterlistcontrol-type
         */
        readonly type?: string;
    }
    /**
     * A control from a date filter that is used to specify date and time.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterdatetimepickercontrol.html
     */
    interface FilterDateTimePickerControlProperty {
        /**
         * The visibility configurationof the Apply button on a `DateTimePickerControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterdatetimepickercontrol.html#cfn-quicksight-analysis-filterdatetimepickercontrol-commitmode
         */
        readonly commitMode?: string;
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterdatetimepickercontrol.html#cfn-quicksight-analysis-filterdatetimepickercontrol-displayoptions
         */
        readonly displayOptions?: CfnAnalysis.DateTimePickerControlDisplayOptionsProperty | cdk.IResolvable;
        /**
         * The ID of the `FilterDateTimePickerControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterdatetimepickercontrol.html#cfn-quicksight-analysis-filterdatetimepickercontrol-filtercontrolid
         */
        readonly filterControlId: string;
        /**
         * The source filter ID of the `FilterDateTimePickerControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterdatetimepickercontrol.html#cfn-quicksight-analysis-filterdatetimepickercontrol-sourcefilterid
         */
        readonly sourceFilterId: string;
        /**
         * The title of the `FilterDateTimePickerControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterdatetimepickercontrol.html#cfn-quicksight-analysis-filterdatetimepickercontrol-title
         */
        readonly title: string;
        /**
         * The type of the `FilterDropDownControl` . Choose one of the following options:.
         *
         * - `MULTI_SELECT` : The user can select multiple entries from a dropdown menu.
         * - `SINGLE_SELECT` : The user can select a single entry from a dropdown menu.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterdatetimepickercontrol.html#cfn-quicksight-analysis-filterdatetimepickercontrol-type
         */
        readonly type?: string;
    }
    /**
     * A control from a date filter that is used to specify the relative date.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterrelativedatetimecontrol.html
     */
    interface FilterRelativeDateTimeControlProperty {
        /**
         * The visibility configuration of the Apply button on a `FilterRelativeDateTimeControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterrelativedatetimecontrol.html#cfn-quicksight-analysis-filterrelativedatetimecontrol-commitmode
         */
        readonly commitMode?: string;
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterrelativedatetimecontrol.html#cfn-quicksight-analysis-filterrelativedatetimecontrol-displayoptions
         */
        readonly displayOptions?: cdk.IResolvable | CfnAnalysis.RelativeDateTimeControlDisplayOptionsProperty;
        /**
         * The ID of the `FilterTextAreaControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterrelativedatetimecontrol.html#cfn-quicksight-analysis-filterrelativedatetimecontrol-filtercontrolid
         */
        readonly filterControlId: string;
        /**
         * The source filter ID of the `FilterTextAreaControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterrelativedatetimecontrol.html#cfn-quicksight-analysis-filterrelativedatetimecontrol-sourcefilterid
         */
        readonly sourceFilterId: string;
        /**
         * The title of the `FilterTextAreaControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterrelativedatetimecontrol.html#cfn-quicksight-analysis-filterrelativedatetimecontrol-title
         */
        readonly title: string;
    }
    /**
     * A control from a filter that is scoped across more than one sheet.
     *
     * This represents your filter control on a sheet
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtercrosssheetcontrol.html
     */
    interface FilterCrossSheetControlProperty {
        /**
         * The values that are displayed in a control can be configured to only show values that are valid based on what's selected in other controls.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtercrosssheetcontrol.html#cfn-quicksight-analysis-filtercrosssheetcontrol-cascadingcontrolconfiguration
         */
        readonly cascadingControlConfiguration?: CfnAnalysis.CascadingControlConfigurationProperty | cdk.IResolvable;
        /**
         * The ID of the `FilterCrossSheetControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtercrosssheetcontrol.html#cfn-quicksight-analysis-filtercrosssheetcontrol-filtercontrolid
         */
        readonly filterControlId: string;
        /**
         * The source filter ID of the `FilterCrossSheetControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtercrosssheetcontrol.html#cfn-quicksight-analysis-filtercrosssheetcontrol-sourcefilterid
         */
        readonly sourceFilterId: string;
    }
    /**
     * A grid layout to define the placement of sheet control.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetcontrollayout.html
     */
    interface SheetControlLayoutProperty {
        /**
         * The configuration that determines the elements and canvas size options of sheet control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetcontrollayout.html#cfn-quicksight-analysis-sheetcontrollayout-configuration
         */
        readonly configuration: cdk.IResolvable | CfnAnalysis.SheetControlLayoutConfigurationProperty;
    }
    /**
     * The configuration that determines the elements and canvas size options of sheet control.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetcontrollayoutconfiguration.html
     */
    interface SheetControlLayoutConfigurationProperty {
        /**
         * The configuration that determines the elements and canvas size options of sheet control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetcontrollayoutconfiguration.html#cfn-quicksight-analysis-sheetcontrollayoutconfiguration-gridlayout
         */
        readonly gridLayout?: CfnAnalysis.GridLayoutConfigurationProperty | cdk.IResolvable;
    }
    /**
     * A visual displayed on a sheet in an analysis, dashboard, or template.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html
     */
    interface VisualProperty {
        /**
         * A bar chart.
         *
         * For more information, see [Using bar charts](https://docs.aws.amazon.com/quicksight/latest/user/bar-charts.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-barchartvisual
         */
        readonly barChartVisual?: CfnAnalysis.BarChartVisualProperty | cdk.IResolvable;
        /**
         * A box plot.
         *
         * For more information, see [Using box plots](https://docs.aws.amazon.com/quicksight/latest/user/box-plots.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-boxplotvisual
         */
        readonly boxPlotVisual?: CfnAnalysis.BoxPlotVisualProperty | cdk.IResolvable;
        /**
         * A combo chart.
         *
         * For more information, see [Using combo charts](https://docs.aws.amazon.com/quicksight/latest/user/combo-charts.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-combochartvisual
         */
        readonly comboChartVisual?: CfnAnalysis.ComboChartVisualProperty | cdk.IResolvable;
        /**
         * A visual that contains custom content.
         *
         * For more information, see [Using custom visual content](https://docs.aws.amazon.com/quicksight/latest/user/custom-visual-content.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-customcontentvisual
         */
        readonly customContentVisual?: CfnAnalysis.CustomContentVisualProperty | cdk.IResolvable;
        /**
         * An empty visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-emptyvisual
         */
        readonly emptyVisual?: CfnAnalysis.EmptyVisualProperty | cdk.IResolvable;
        /**
         * A filled map.
         *
         * For more information, see [Creating filled maps](https://docs.aws.amazon.com/quicksight/latest/user/filled-maps.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-filledmapvisual
         */
        readonly filledMapVisual?: CfnAnalysis.FilledMapVisualProperty | cdk.IResolvable;
        /**
         * A funnel chart.
         *
         * For more information, see [Using funnel charts](https://docs.aws.amazon.com/quicksight/latest/user/funnel-visual-content.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-funnelchartvisual
         */
        readonly funnelChartVisual?: CfnAnalysis.FunnelChartVisualProperty | cdk.IResolvable;
        /**
         * A gauge chart.
         *
         * For more information, see [Using gauge charts](https://docs.aws.amazon.com/quicksight/latest/user/gauge-chart.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-gaugechartvisual
         */
        readonly gaugeChartVisual?: CfnAnalysis.GaugeChartVisualProperty | cdk.IResolvable;
        /**
         * A geospatial map or a points on map visual.
         *
         * For more information, see [Creating point maps](https://docs.aws.amazon.com/quicksight/latest/user/point-maps.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-geospatialmapvisual
         */
        readonly geospatialMapVisual?: CfnAnalysis.GeospatialMapVisualProperty | cdk.IResolvable;
        /**
         * A heat map.
         *
         * For more information, see [Using heat maps](https://docs.aws.amazon.com/quicksight/latest/user/heat-map.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-heatmapvisual
         */
        readonly heatMapVisual?: CfnAnalysis.HeatMapVisualProperty | cdk.IResolvable;
        /**
         * A histogram.
         *
         * For more information, see [Using histograms](https://docs.aws.amazon.com/quicksight/latest/user/histogram-charts.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-histogramvisual
         */
        readonly histogramVisual?: CfnAnalysis.HistogramVisualProperty | cdk.IResolvable;
        /**
         * An insight visual.
         *
         * For more information, see [Working with insights](https://docs.aws.amazon.com/quicksight/latest/user/computational-insights.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-insightvisual
         */
        readonly insightVisual?: CfnAnalysis.InsightVisualProperty | cdk.IResolvable;
        /**
         * A key performance indicator (KPI).
         *
         * For more information, see [Using KPIs](https://docs.aws.amazon.com/quicksight/latest/user/kpi.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-kpivisual
         */
        readonly kpiVisual?: cdk.IResolvable | CfnAnalysis.KPIVisualProperty;
        /**
         * The properties for a layer map visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-layermapvisual
         */
        readonly layerMapVisual?: cdk.IResolvable | CfnAnalysis.LayerMapVisualProperty;
        /**
         * A line chart.
         *
         * For more information, see [Using line charts](https://docs.aws.amazon.com/quicksight/latest/user/line-charts.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-linechartvisual
         */
        readonly lineChartVisual?: cdk.IResolvable | CfnAnalysis.LineChartVisualProperty;
        /**
         * A pie or donut chart.
         *
         * For more information, see [Using pie charts](https://docs.aws.amazon.com/quicksight/latest/user/pie-chart.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-piechartvisual
         */
        readonly pieChartVisual?: cdk.IResolvable | CfnAnalysis.PieChartVisualProperty;
        /**
         * A pivot table.
         *
         * For more information, see [Using pivot tables](https://docs.aws.amazon.com/quicksight/latest/user/pivot-table.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-pivottablevisual
         */
        readonly pivotTableVisual?: cdk.IResolvable | CfnAnalysis.PivotTableVisualProperty;
        /**
         * The custom plugin visual type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-pluginvisual
         */
        readonly pluginVisual?: cdk.IResolvable | CfnAnalysis.PluginVisualProperty;
        /**
         * A radar chart visual.
         *
         * For more information, see [Using radar charts](https://docs.aws.amazon.com/quicksight/latest/user/radar-chart.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-radarchartvisual
         */
        readonly radarChartVisual?: cdk.IResolvable | CfnAnalysis.RadarChartVisualProperty;
        /**
         * A sankey diagram.
         *
         * For more information, see [Using Sankey diagrams](https://docs.aws.amazon.com/quicksight/latest/user/sankey-diagram.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-sankeydiagramvisual
         */
        readonly sankeyDiagramVisual?: cdk.IResolvable | CfnAnalysis.SankeyDiagramVisualProperty;
        /**
         * A scatter plot.
         *
         * For more information, see [Using scatter plots](https://docs.aws.amazon.com/quicksight/latest/user/scatter-plot.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-scatterplotvisual
         */
        readonly scatterPlotVisual?: cdk.IResolvable | CfnAnalysis.ScatterPlotVisualProperty;
        /**
         * A table visual.
         *
         * For more information, see [Using tables as visuals](https://docs.aws.amazon.com/quicksight/latest/user/tabular.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-tablevisual
         */
        readonly tableVisual?: cdk.IResolvable | CfnAnalysis.TableVisualProperty;
        /**
         * A tree map.
         *
         * For more information, see [Using tree maps](https://docs.aws.amazon.com/quicksight/latest/user/tree-map.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-treemapvisual
         */
        readonly treeMapVisual?: cdk.IResolvable | CfnAnalysis.TreeMapVisualProperty;
        /**
         * A waterfall chart.
         *
         * For more information, see [Using waterfall charts](https://docs.aws.amazon.com/quicksight/latest/user/waterfall-chart.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-waterfallvisual
         */
        readonly waterfallVisual?: cdk.IResolvable | CfnAnalysis.WaterfallVisualProperty;
        /**
         * A word cloud.
         *
         * For more information, see [Using word clouds](https://docs.aws.amazon.com/quicksight/latest/user/word-cloud.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visual.html#cfn-quicksight-analysis-visual-wordcloudvisual
         */
        readonly wordCloudVisual?: cdk.IResolvable | CfnAnalysis.WordCloudVisualProperty;
    }
    /**
     * A funnel chart.
     *
     * For more information, see [Using funnel charts](https://docs.aws.amazon.com/quicksight/latest/user/funnel-visual-content.html) in the *Amazon QuickSight User Guide* .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartvisual.html
     */
    interface FunnelChartVisualProperty {
        /**
         * The list of custom actions that are configured for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartvisual.html#cfn-quicksight-analysis-funnelchartvisual-actions
         */
        readonly actions?: Array<cdk.IResolvable | CfnAnalysis.VisualCustomActionProperty> | cdk.IResolvable;
        /**
         * The configuration of a `FunnelChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartvisual.html#cfn-quicksight-analysis-funnelchartvisual-chartconfiguration
         */
        readonly chartConfiguration?: CfnAnalysis.FunnelChartConfigurationProperty | cdk.IResolvable;
        /**
         * The column hierarchy that is used during drill-downs and drill-ups.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartvisual.html#cfn-quicksight-analysis-funnelchartvisual-columnhierarchies
         */
        readonly columnHierarchies?: Array<CfnAnalysis.ColumnHierarchyProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The subtitle that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartvisual.html#cfn-quicksight-analysis-funnelchartvisual-subtitle
         */
        readonly subtitle?: cdk.IResolvable | CfnAnalysis.VisualSubtitleLabelOptionsProperty;
        /**
         * The title that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartvisual.html#cfn-quicksight-analysis-funnelchartvisual-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.VisualTitleLabelOptionsProperty;
        /**
         * The alt text for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartvisual.html#cfn-quicksight-analysis-funnelchartvisual-visualcontentalttext
         */
        readonly visualContentAltText?: string;
        /**
         * The unique identifier of a visual.
         *
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers..
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartvisual.html#cfn-quicksight-analysis-funnelchartvisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * The subtitle label options for a visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualsubtitlelabeloptions.html
     */
    interface VisualSubtitleLabelOptionsProperty {
        /**
         * The long text format of the subtitle label, such as plain text or rich text.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualsubtitlelabeloptions.html#cfn-quicksight-analysis-visualsubtitlelabeloptions-formattext
         */
        readonly formatText?: cdk.IResolvable | CfnAnalysis.LongFormatTextProperty;
        /**
         * The visibility of the subtitle label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualsubtitlelabeloptions.html#cfn-quicksight-analysis-visualsubtitlelabeloptions-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The text format for a subtitle.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-longformattext.html
     */
    interface LongFormatTextProperty {
        /**
         * Plain text format.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-longformattext.html#cfn-quicksight-analysis-longformattext-plaintext
         */
        readonly plainText?: string;
        /**
         * Rich text.
         *
         * Examples of rich text include bold, underline, and italics.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-longformattext.html#cfn-quicksight-analysis-longformattext-richtext
         */
        readonly richText?: string;
    }
    /**
     * The configuration of a `FunnelChartVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartconfiguration.html
     */
    interface FunnelChartConfigurationProperty {
        /**
         * The label options of the categories that are displayed in a `FunnelChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartconfiguration.html#cfn-quicksight-analysis-funnelchartconfiguration-categorylabeloptions
         */
        readonly categoryLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The options that determine the presentation of the data labels.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartconfiguration.html#cfn-quicksight-analysis-funnelchartconfiguration-datalabeloptions
         */
        readonly dataLabelOptions?: CfnAnalysis.FunnelChartDataLabelOptionsProperty | cdk.IResolvable;
        /**
         * The field well configuration of a `FunnelChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartconfiguration.html#cfn-quicksight-analysis-funnelchartconfiguration-fieldwells
         */
        readonly fieldWells?: CfnAnalysis.FunnelChartFieldWellsProperty | cdk.IResolvable;
        /**
         * The general visual interactions setup for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartconfiguration.html#cfn-quicksight-analysis-funnelchartconfiguration-interactions
         */
        readonly interactions?: cdk.IResolvable | CfnAnalysis.VisualInteractionOptionsProperty;
        /**
         * The sort configuration of a `FunnelChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartconfiguration.html#cfn-quicksight-analysis-funnelchartconfiguration-sortconfiguration
         */
        readonly sortConfiguration?: CfnAnalysis.FunnelChartSortConfigurationProperty | cdk.IResolvable;
        /**
         * The tooltip configuration of a `FunnelChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartconfiguration.html#cfn-quicksight-analysis-funnelchartconfiguration-tooltip
         */
        readonly tooltip?: cdk.IResolvable | CfnAnalysis.TooltipOptionsProperty;
        /**
         * The label options for the values that are displayed in a `FunnelChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartconfiguration.html#cfn-quicksight-analysis-funnelchartconfiguration-valuelabeloptions
         */
        readonly valueLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The visual palette configuration of a `FunnelChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartconfiguration.html#cfn-quicksight-analysis-funnelchartconfiguration-visualpalette
         */
        readonly visualPalette?: cdk.IResolvable | CfnAnalysis.VisualPaletteProperty;
    }
    /**
     * The sort configuration of a `FunnelChartVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartsortconfiguration.html
     */
    interface FunnelChartSortConfigurationProperty {
        /**
         * The limit on the number of categories displayed.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartsortconfiguration.html#cfn-quicksight-analysis-funnelchartsortconfiguration-categoryitemslimit
         */
        readonly categoryItemsLimit?: cdk.IResolvable | CfnAnalysis.ItemsLimitConfigurationProperty;
        /**
         * The sort configuration of the category fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartsortconfiguration.html#cfn-quicksight-analysis-funnelchartsortconfiguration-categorysort
         */
        readonly categorySort?: Array<CfnAnalysis.FieldSortOptionsProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The limit configuration of the visual display for an axis.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-itemslimitconfiguration.html
     */
    interface ItemsLimitConfigurationProperty {
        /**
         * The limit on how many items of a field are showed in the chart.
         *
         * For example, the number of slices that are displayed in a pie chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-itemslimitconfiguration.html#cfn-quicksight-analysis-itemslimitconfiguration-itemslimit
         */
        readonly itemsLimit?: number;
        /**
         * The `Show other` of an axis in the chart. Choose one of the following options:.
         *
         * - `INCLUDE`
         * - `EXCLUDE`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-itemslimitconfiguration.html#cfn-quicksight-analysis-itemslimitconfiguration-othercategories
         */
        readonly otherCategories?: string;
    }
    /**
     * The field sort options in a chart configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldsortoptions.html
     */
    interface FieldSortOptionsProperty {
        /**
         * The sort configuration for a column that is not used in a field well.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldsortoptions.html#cfn-quicksight-analysis-fieldsortoptions-columnsort
         */
        readonly columnSort?: CfnAnalysis.ColumnSortProperty | cdk.IResolvable;
        /**
         * The sort configuration for a field in a field well.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldsortoptions.html#cfn-quicksight-analysis-fieldsortoptions-fieldsort
         */
        readonly fieldSort?: CfnAnalysis.FieldSortProperty | cdk.IResolvable;
    }
    /**
     * The sort configuration for a field in a field well.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldsort.html
     */
    interface FieldSortProperty {
        /**
         * The sort direction. Choose one of the following options:.
         *
         * - `ASC` : Ascending
         * - `DESC` : Descending
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldsort.html#cfn-quicksight-analysis-fieldsort-direction
         */
        readonly direction: string;
        /**
         * The sort configuration target field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldsort.html#cfn-quicksight-analysis-fieldsort-fieldid
         */
        readonly fieldId: string;
    }
    /**
     * The options that determine the presentation of the data labels.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartdatalabeloptions.html
     */
    interface FunnelChartDataLabelOptionsProperty {
        /**
         * The visibility of the category labels within the data labels.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartdatalabeloptions.html#cfn-quicksight-analysis-funnelchartdatalabeloptions-categorylabelvisibility
         */
        readonly categoryLabelVisibility?: string;
        /**
         * The color of the data label text.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartdatalabeloptions.html#cfn-quicksight-analysis-funnelchartdatalabeloptions-labelcolor
         */
        readonly labelColor?: string;
        /**
         * The font configuration for the data labels.
         *
         * Only the `FontSize` attribute of the font configuration is used for data labels.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartdatalabeloptions.html#cfn-quicksight-analysis-funnelchartdatalabeloptions-labelfontconfiguration
         */
        readonly labelFontConfiguration?: CfnAnalysis.FontConfigurationProperty | cdk.IResolvable;
        /**
         * Determines the style of the metric labels.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartdatalabeloptions.html#cfn-quicksight-analysis-funnelchartdatalabeloptions-measuredatalabelstyle
         */
        readonly measureDataLabelStyle?: string;
        /**
         * The visibility of the measure labels within the data labels.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartdatalabeloptions.html#cfn-quicksight-analysis-funnelchartdatalabeloptions-measurelabelvisibility
         */
        readonly measureLabelVisibility?: string;
        /**
         * Determines the positioning of the data label relative to a section of the funnel.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartdatalabeloptions.html#cfn-quicksight-analysis-funnelchartdatalabeloptions-position
         */
        readonly position?: string;
        /**
         * The visibility option that determines if data labels are displayed.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartdatalabeloptions.html#cfn-quicksight-analysis-funnelchartdatalabeloptions-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The label options for an axis on a chart.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-chartaxislabeloptions.html
     */
    interface ChartAxisLabelOptionsProperty {
        /**
         * The label options for a chart axis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-chartaxislabeloptions.html#cfn-quicksight-analysis-chartaxislabeloptions-axislabeloptions
         */
        readonly axisLabelOptions?: Array<CfnAnalysis.AxisLabelOptionsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The visibility configuration of the sort icon on a chart's axis label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-chartaxislabeloptions.html#cfn-quicksight-analysis-chartaxislabeloptions-sorticonvisibility
         */
        readonly sortIconVisibility?: string;
        /**
         * The visibility of an axis label on a chart. Choose one of the following options:.
         *
         * - `VISIBLE` : Shows the axis.
         * - `HIDDEN` : Hides the axis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-chartaxislabeloptions.html#cfn-quicksight-analysis-chartaxislabeloptions-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The label options for a chart axis.
     *
     * You must specify the field that the label is targeted to.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabeloptions.html
     */
    interface AxisLabelOptionsProperty {
        /**
         * The options that indicate which field the label belongs to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabeloptions.html#cfn-quicksight-analysis-axislabeloptions-applyto
         */
        readonly applyTo?: CfnAnalysis.AxisLabelReferenceOptionsProperty | cdk.IResolvable;
        /**
         * The text for the axis label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabeloptions.html#cfn-quicksight-analysis-axislabeloptions-customlabel
         */
        readonly customLabel?: string;
        /**
         * The font configuration of the axis label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabeloptions.html#cfn-quicksight-analysis-axislabeloptions-fontconfiguration
         */
        readonly fontConfiguration?: CfnAnalysis.FontConfigurationProperty | cdk.IResolvable;
    }
    /**
     * The reference that specifies where the axis label is applied to.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabelreferenceoptions.html
     */
    interface AxisLabelReferenceOptionsProperty {
        /**
         * The column that the axis label is targeted to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabelreferenceoptions.html#cfn-quicksight-analysis-axislabelreferenceoptions-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The field that the axis label is targeted to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabelreferenceoptions.html#cfn-quicksight-analysis-axislabelreferenceoptions-fieldid
         */
        readonly fieldId: string;
    }
    /**
     * The field well configuration of a `FunnelChartVisual` .
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartfieldwells.html
     */
    interface FunnelChartFieldWellsProperty {
        /**
         * The field well configuration of a `FunnelChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartfieldwells.html#cfn-quicksight-analysis-funnelchartfieldwells-funnelchartaggregatedfieldwells
         */
        readonly funnelChartAggregatedFieldWells?: CfnAnalysis.FunnelChartAggregatedFieldWellsProperty | cdk.IResolvable;
    }
    /**
     * The field well configuration of a `FunnelChartVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartaggregatedfieldwells.html
     */
    interface FunnelChartAggregatedFieldWellsProperty {
        /**
         * The category field wells of a funnel chart.
         *
         * Values are grouped by category fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartaggregatedfieldwells.html#cfn-quicksight-analysis-funnelchartaggregatedfieldwells-category
         */
        readonly category?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The value field wells of a funnel chart.
         *
         * Values are aggregated based on categories.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartaggregatedfieldwells.html#cfn-quicksight-analysis-funnelchartaggregatedfieldwells-values
         */
        readonly values?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
    }
    /**
     * The dimension type field.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-dimensionfield.html
     */
    interface DimensionFieldProperty {
        /**
         * The dimension type field with categorical type columns.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-dimensionfield.html#cfn-quicksight-analysis-dimensionfield-categoricaldimensionfield
         */
        readonly categoricalDimensionField?: CfnAnalysis.CategoricalDimensionFieldProperty | cdk.IResolvable;
        /**
         * The dimension type field with date type columns.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-dimensionfield.html#cfn-quicksight-analysis-dimensionfield-datedimensionfield
         */
        readonly dateDimensionField?: CfnAnalysis.DateDimensionFieldProperty | cdk.IResolvable;
        /**
         * The dimension type field with numerical type columns.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-dimensionfield.html#cfn-quicksight-analysis-dimensionfield-numericaldimensionfield
         */
        readonly numericalDimensionField?: cdk.IResolvable | CfnAnalysis.NumericalDimensionFieldProperty;
    }
    /**
     * The dimension type field with date type columns.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datedimensionfield.html
     */
    interface DateDimensionFieldProperty {
        /**
         * The column that is used in the `DateDimensionField` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datedimensionfield.html#cfn-quicksight-analysis-datedimensionfield-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The date granularity of the `DateDimensionField` . Choose one of the following options:.
         *
         * - `YEAR`
         * - `QUARTER`
         * - `MONTH`
         * - `WEEK`
         * - `DAY`
         * - `HOUR`
         * - `MINUTE`
         * - `SECOND`
         * - `MILLISECOND`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datedimensionfield.html#cfn-quicksight-analysis-datedimensionfield-dategranularity
         */
        readonly dateGranularity?: string;
        /**
         * The custom field ID.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datedimensionfield.html#cfn-quicksight-analysis-datedimensionfield-fieldid
         */
        readonly fieldId: string;
        /**
         * The format configuration of the field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datedimensionfield.html#cfn-quicksight-analysis-datedimensionfield-formatconfiguration
         */
        readonly formatConfiguration?: CfnAnalysis.DateTimeFormatConfigurationProperty | cdk.IResolvable;
        /**
         * The custom hierarchy ID.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datedimensionfield.html#cfn-quicksight-analysis-datedimensionfield-hierarchyid
         */
        readonly hierarchyId?: string;
    }
    /**
     * The dimension type field with numerical type columns.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericaldimensionfield.html
     */
    interface NumericalDimensionFieldProperty {
        /**
         * The column that is used in the `NumericalDimensionField` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericaldimensionfield.html#cfn-quicksight-analysis-numericaldimensionfield-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The custom field ID.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericaldimensionfield.html#cfn-quicksight-analysis-numericaldimensionfield-fieldid
         */
        readonly fieldId: string;
        /**
         * The format configuration of the field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericaldimensionfield.html#cfn-quicksight-analysis-numericaldimensionfield-formatconfiguration
         */
        readonly formatConfiguration?: cdk.IResolvable | CfnAnalysis.NumberFormatConfigurationProperty;
        /**
         * The custom hierarchy ID.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericaldimensionfield.html#cfn-quicksight-analysis-numericaldimensionfield-hierarchyid
         */
        readonly hierarchyId?: string;
    }
    /**
     * The dimension type field with categorical type columns..
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricaldimensionfield.html
     */
    interface CategoricalDimensionFieldProperty {
        /**
         * The column that is used in the `CategoricalDimensionField` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricaldimensionfield.html#cfn-quicksight-analysis-categoricaldimensionfield-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The custom field ID.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricaldimensionfield.html#cfn-quicksight-analysis-categoricaldimensionfield-fieldid
         */
        readonly fieldId: string;
        /**
         * The format configuration of the field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricaldimensionfield.html#cfn-quicksight-analysis-categoricaldimensionfield-formatconfiguration
         */
        readonly formatConfiguration?: cdk.IResolvable | CfnAnalysis.StringFormatConfigurationProperty;
        /**
         * The custom hierarchy ID.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricaldimensionfield.html#cfn-quicksight-analysis-categoricaldimensionfield-hierarchyid
         */
        readonly hierarchyId?: string;
    }
    /**
     * The measure (metric) type field.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-measurefield.html
     */
    interface MeasureFieldProperty {
        /**
         * The calculated measure field only used in pivot tables.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-measurefield.html#cfn-quicksight-analysis-measurefield-calculatedmeasurefield
         */
        readonly calculatedMeasureField?: CfnAnalysis.CalculatedMeasureFieldProperty | cdk.IResolvable;
        /**
         * The measure type field with categorical type columns.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-measurefield.html#cfn-quicksight-analysis-measurefield-categoricalmeasurefield
         */
        readonly categoricalMeasureField?: CfnAnalysis.CategoricalMeasureFieldProperty | cdk.IResolvable;
        /**
         * The measure type field with date type columns.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-measurefield.html#cfn-quicksight-analysis-measurefield-datemeasurefield
         */
        readonly dateMeasureField?: CfnAnalysis.DateMeasureFieldProperty | cdk.IResolvable;
        /**
         * The measure type field with numerical type columns.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-measurefield.html#cfn-quicksight-analysis-measurefield-numericalmeasurefield
         */
        readonly numericalMeasureField?: cdk.IResolvable | CfnAnalysis.NumericalMeasureFieldProperty;
    }
    /**
     * The measure type field with date type columns.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datemeasurefield.html
     */
    interface DateMeasureFieldProperty {
        /**
         * The aggregation function of the measure field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datemeasurefield.html#cfn-quicksight-analysis-datemeasurefield-aggregationfunction
         */
        readonly aggregationFunction?: string;
        /**
         * The column that is used in the `DateMeasureField` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datemeasurefield.html#cfn-quicksight-analysis-datemeasurefield-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The custom field ID.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datemeasurefield.html#cfn-quicksight-analysis-datemeasurefield-fieldid
         */
        readonly fieldId: string;
        /**
         * The format configuration of the field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datemeasurefield.html#cfn-quicksight-analysis-datemeasurefield-formatconfiguration
         */
        readonly formatConfiguration?: CfnAnalysis.DateTimeFormatConfigurationProperty | cdk.IResolvable;
    }
    /**
     * The measure type field with numerical type columns.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericalmeasurefield.html
     */
    interface NumericalMeasureFieldProperty {
        /**
         * The aggregation function of the measure field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericalmeasurefield.html#cfn-quicksight-analysis-numericalmeasurefield-aggregationfunction
         */
        readonly aggregationFunction?: cdk.IResolvable | CfnAnalysis.NumericalAggregationFunctionProperty;
        /**
         * The column that is used in the `NumericalMeasureField` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericalmeasurefield.html#cfn-quicksight-analysis-numericalmeasurefield-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The custom field ID.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericalmeasurefield.html#cfn-quicksight-analysis-numericalmeasurefield-fieldid
         */
        readonly fieldId: string;
        /**
         * The format configuration of the field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericalmeasurefield.html#cfn-quicksight-analysis-numericalmeasurefield-formatconfiguration
         */
        readonly formatConfiguration?: cdk.IResolvable | CfnAnalysis.NumberFormatConfigurationProperty;
    }
    /**
     * The measure type field with categorical type columns.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricalmeasurefield.html
     */
    interface CategoricalMeasureFieldProperty {
        /**
         * The aggregation function of the measure field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricalmeasurefield.html#cfn-quicksight-analysis-categoricalmeasurefield-aggregationfunction
         */
        readonly aggregationFunction?: string;
        /**
         * The column that is used in the `CategoricalMeasureField` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricalmeasurefield.html#cfn-quicksight-analysis-categoricalmeasurefield-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The custom field ID.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricalmeasurefield.html#cfn-quicksight-analysis-categoricalmeasurefield-fieldid
         */
        readonly fieldId: string;
        /**
         * The format configuration of the field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricalmeasurefield.html#cfn-quicksight-analysis-categoricalmeasurefield-formatconfiguration
         */
        readonly formatConfiguration?: cdk.IResolvable | CfnAnalysis.StringFormatConfigurationProperty;
    }
    /**
     * The table calculation measure field for pivot tables.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedmeasurefield.html
     */
    interface CalculatedMeasureFieldProperty {
        /**
         * The expression in the table calculation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedmeasurefield.html#cfn-quicksight-analysis-calculatedmeasurefield-expression
         */
        readonly expression: string;
        /**
         * The custom field ID.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedmeasurefield.html#cfn-quicksight-analysis-calculatedmeasurefield-fieldid
         */
        readonly fieldId: string;
    }
    /**
     * The display options for the visual tooltip.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tooltipoptions.html
     */
    interface TooltipOptionsProperty {
        /**
         * The setup for the detailed tooltip.
         *
         * The tooltip setup is always saved. The display type is decided based on the tooltip type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tooltipoptions.html#cfn-quicksight-analysis-tooltipoptions-fieldbasedtooltip
         */
        readonly fieldBasedTooltip?: CfnAnalysis.FieldBasedTooltipProperty | cdk.IResolvable;
        /**
         * The selected type for the tooltip. Choose one of the following options:.
         *
         * - `BASIC` : A basic tooltip.
         * - `DETAILED` : A detailed tooltip.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tooltipoptions.html#cfn-quicksight-analysis-tooltipoptions-selectedtooltiptype
         */
        readonly selectedTooltipType?: string;
        /**
         * Determines whether or not the tooltip is visible.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tooltipoptions.html#cfn-quicksight-analysis-tooltipoptions-tooltipvisibility
         */
        readonly tooltipVisibility?: string;
    }
    /**
     * The setup for the detailed tooltip.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldbasedtooltip.html
     */
    interface FieldBasedTooltipProperty {
        /**
         * The visibility of `Show aggregations` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldbasedtooltip.html#cfn-quicksight-analysis-fieldbasedtooltip-aggregationvisibility
         */
        readonly aggregationVisibility?: string;
        /**
         * The fields configuration in the tooltip.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldbasedtooltip.html#cfn-quicksight-analysis-fieldbasedtooltip-tooltipfields
         */
        readonly tooltipFields?: Array<cdk.IResolvable | CfnAnalysis.TooltipItemProperty> | cdk.IResolvable;
        /**
         * The type for the >tooltip title. Choose one of the following options:.
         *
         * - `NONE` : Doesn't use the primary value as the title.
         * - `PRIMARY_VALUE` : Uses primary value as the title.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldbasedtooltip.html#cfn-quicksight-analysis-fieldbasedtooltip-tooltiptitletype
         */
        readonly tooltipTitleType?: string;
    }
    /**
     * The tooltip.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tooltipitem.html
     */
    interface TooltipItemProperty {
        /**
         * The tooltip item for the columns that are not part of a field well.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tooltipitem.html#cfn-quicksight-analysis-tooltipitem-columntooltipitem
         */
        readonly columnTooltipItem?: CfnAnalysis.ColumnTooltipItemProperty | cdk.IResolvable;
        /**
         * The tooltip item for the fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tooltipitem.html#cfn-quicksight-analysis-tooltipitem-fieldtooltipitem
         */
        readonly fieldTooltipItem?: CfnAnalysis.FieldTooltipItemProperty | cdk.IResolvable;
    }
    /**
     * The tooltip item for the fields.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldtooltipitem.html
     */
    interface FieldTooltipItemProperty {
        /**
         * The unique ID of the field that is targeted by the tooltip.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldtooltipitem.html#cfn-quicksight-analysis-fieldtooltipitem-fieldid
         */
        readonly fieldId: string;
        /**
         * The label of the tooltip item.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldtooltipitem.html#cfn-quicksight-analysis-fieldtooltipitem-label
         */
        readonly label?: string;
        /**
         * Determines the target of the field tooltip item in a combo chart visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldtooltipitem.html#cfn-quicksight-analysis-fieldtooltipitem-tooltiptarget
         */
        readonly tooltipTarget?: string;
        /**
         * The visibility of the tooltip item.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldtooltipitem.html#cfn-quicksight-analysis-fieldtooltipitem-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The tooltip item for the columns that are not part of a field well.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columntooltipitem.html
     */
    interface ColumnTooltipItemProperty {
        /**
         * The aggregation function of the column tooltip item.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columntooltipitem.html#cfn-quicksight-analysis-columntooltipitem-aggregation
         */
        readonly aggregation?: CfnAnalysis.AggregationFunctionProperty | cdk.IResolvable;
        /**
         * The target column of the tooltip item.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columntooltipitem.html#cfn-quicksight-analysis-columntooltipitem-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The label of the tooltip item.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columntooltipitem.html#cfn-quicksight-analysis-columntooltipitem-label
         */
        readonly label?: string;
        /**
         * Determines the target of the column tooltip item in a combo chart visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columntooltipitem.html#cfn-quicksight-analysis-columntooltipitem-tooltiptarget
         */
        readonly tooltipTarget?: string;
        /**
         * The visibility of the tooltip item.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columntooltipitem.html#cfn-quicksight-analysis-columntooltipitem-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The visual display options for the visual palette.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualpalette.html
     */
    interface VisualPaletteProperty {
        /**
         * The chart color options for the visual palette.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualpalette.html#cfn-quicksight-analysis-visualpalette-chartcolor
         */
        readonly chartColor?: string;
        /**
         * The color map options for the visual palette.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualpalette.html#cfn-quicksight-analysis-visualpalette-colormap
         */
        readonly colorMap?: Array<CfnAnalysis.DataPathColorProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The color map that determines the color options for a particular element.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathcolor.html
     */
    interface DataPathColorProperty {
        /**
         * The color that needs to be applied to the element.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathcolor.html#cfn-quicksight-analysis-datapathcolor-color
         */
        readonly color: string;
        /**
         * The element that the color needs to be applied to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathcolor.html#cfn-quicksight-analysis-datapathcolor-element
         */
        readonly element: CfnAnalysis.DataPathValueProperty | cdk.IResolvable;
        /**
         * The time granularity of the field that the color needs to be applied to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathcolor.html#cfn-quicksight-analysis-datapathcolor-timegranularity
         */
        readonly timeGranularity?: string;
    }
    /**
     * The data path that needs to be sorted.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathvalue.html
     */
    interface DataPathValueProperty {
        /**
         * The type configuration of the field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathvalue.html#cfn-quicksight-analysis-datapathvalue-datapathtype
         */
        readonly dataPathType?: CfnAnalysis.DataPathTypeProperty | cdk.IResolvable;
        /**
         * The field ID of the field that needs to be sorted.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathvalue.html#cfn-quicksight-analysis-datapathvalue-fieldid
         */
        readonly fieldId?: string;
        /**
         * The actual value of the field that needs to be sorted.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathvalue.html#cfn-quicksight-analysis-datapathvalue-fieldvalue
         */
        readonly fieldValue?: string;
    }
    /**
     * The type of the data path value.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathtype.html
     */
    interface DataPathTypeProperty {
        /**
         * The type of data path value utilized in a pivot table. Choose one of the following options:.
         *
         * - `HIERARCHY_ROWS_LAYOUT_COLUMN` - The type of data path for the rows layout column, when `RowsLayout` is set to `HIERARCHY` .
         * - `MULTIPLE_ROW_METRICS_COLUMN` - The type of data path for the metric column when the row is set to Metric Placement.
         * - `EMPTY_COLUMN_HEADER` - The type of data path for the column with empty column header, when there is no field in `ColumnsFieldWell` and the row is set to Metric Placement.
         * - `COUNT_METRIC_COLUMN` - The type of data path for the column with `COUNT` as the metric, when there is no field in the `ValuesFieldWell` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathtype.html#cfn-quicksight-analysis-datapathtype-pivottabledatapathtype
         */
        readonly pivotTableDataPathType?: string;
    }
    /**
     * The general visual interactions setup for visual publish options.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualinteractionoptions.html
     */
    interface VisualInteractionOptionsProperty {
        /**
         * The context menu options for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualinteractionoptions.html#cfn-quicksight-analysis-visualinteractionoptions-contextmenuoption
         */
        readonly contextMenuOption?: CfnAnalysis.ContextMenuOptionProperty | cdk.IResolvable;
        /**
         * The on-visual menu options for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualinteractionoptions.html#cfn-quicksight-analysis-visualinteractionoptions-visualmenuoption
         */
        readonly visualMenuOption?: cdk.IResolvable | CfnAnalysis.VisualMenuOptionProperty;
    }
    /**
     * The context menu options for a visual's interactions.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-contextmenuoption.html
     */
    interface ContextMenuOptionProperty {
        /**
         * The availability status of the context menu options.
         *
         * If the value of this property is set to `ENABLED` , dashboard readers can interact with the context menu.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-contextmenuoption.html#cfn-quicksight-analysis-contextmenuoption-availabilitystatus
         */
        readonly availabilityStatus?: string;
    }
    /**
     * The menu options for a visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualmenuoption.html
     */
    interface VisualMenuOptionProperty {
        /**
         * The availaiblity status of a visual's menu options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualmenuoption.html#cfn-quicksight-analysis-visualmenuoption-availabilitystatus
         */
        readonly availabilityStatus?: string;
    }
    /**
     * A custom action defined on a visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualcustomaction.html
     */
    interface VisualCustomActionProperty {
        /**
         * A list of `VisualCustomActionOperations` .
         *
         * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualcustomaction.html#cfn-quicksight-analysis-visualcustomaction-actionoperations
         */
        readonly actionOperations: Array<cdk.IResolvable | CfnAnalysis.VisualCustomActionOperationProperty> | cdk.IResolvable;
        /**
         * The ID of the `VisualCustomAction` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualcustomaction.html#cfn-quicksight-analysis-visualcustomaction-customactionid
         */
        readonly customActionId: string;
        /**
         * The name of the `VisualCustomAction` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualcustomaction.html#cfn-quicksight-analysis-visualcustomaction-name
         */
        readonly name: string;
        /**
         * The status of the `VisualCustomAction` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualcustomaction.html#cfn-quicksight-analysis-visualcustomaction-status
         */
        readonly status?: string;
        /**
         * The trigger of the `VisualCustomAction` .
         *
         * Valid values are defined as follows:
         *
         * - `DATA_POINT_CLICK` : Initiates a custom action by a left pointer click on a data point.
         * - `DATA_POINT_MENU` : Initiates a custom action by right pointer click from the menu.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualcustomaction.html#cfn-quicksight-analysis-visualcustomaction-trigger
         */
        readonly trigger: string;
    }
    /**
     * The operation that is defined by the custom action.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualcustomactionoperation.html
     */
    interface VisualCustomActionOperationProperty {
        /**
         * The filter operation that filters data included in a visual or in an entire sheet.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualcustomactionoperation.html#cfn-quicksight-analysis-visualcustomactionoperation-filteroperation
         */
        readonly filterOperation?: CfnAnalysis.CustomActionFilterOperationProperty | cdk.IResolvable;
        /**
         * The navigation operation that navigates between different sheets in the same analysis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualcustomactionoperation.html#cfn-quicksight-analysis-visualcustomactionoperation-navigationoperation
         */
        readonly navigationOperation?: CfnAnalysis.CustomActionNavigationOperationProperty | cdk.IResolvable;
        /**
         * The set parameter operation that sets parameters in custom action.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualcustomactionoperation.html#cfn-quicksight-analysis-visualcustomactionoperation-setparametersoperation
         */
        readonly setParametersOperation?: CfnAnalysis.CustomActionSetParametersOperationProperty | cdk.IResolvable;
        /**
         * The URL operation that opens a link to another webpage.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualcustomactionoperation.html#cfn-quicksight-analysis-visualcustomactionoperation-urloperation
         */
        readonly urlOperation?: CfnAnalysis.CustomActionURLOperationProperty | cdk.IResolvable;
    }
    /**
     * The navigation operation that navigates between different sheets in the same analysis.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customactionnavigationoperation.html
     */
    interface CustomActionNavigationOperationProperty {
        /**
         * The configuration that chooses the navigation target.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customactionnavigationoperation.html#cfn-quicksight-analysis-customactionnavigationoperation-localnavigationconfiguration
         */
        readonly localNavigationConfiguration?: cdk.IResolvable | CfnAnalysis.LocalNavigationConfigurationProperty;
    }
    /**
     * The navigation configuration for `CustomActionNavigationOperation` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-localnavigationconfiguration.html
     */
    interface LocalNavigationConfigurationProperty {
        /**
         * The sheet that is targeted for navigation in the same analysis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-localnavigationconfiguration.html#cfn-quicksight-analysis-localnavigationconfiguration-targetsheetid
         */
        readonly targetSheetId: string;
    }
    /**
     * The set parameter operation that sets parameters in custom action.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customactionsetparametersoperation.html
     */
    interface CustomActionSetParametersOperationProperty {
        /**
         * The parameter that determines the value configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customactionsetparametersoperation.html#cfn-quicksight-analysis-customactionsetparametersoperation-parametervalueconfigurations
         */
        readonly parameterValueConfigurations: Array<cdk.IResolvable | CfnAnalysis.SetParameterValueConfigurationProperty> | cdk.IResolvable;
    }
    /**
     * The configuration of adding parameters in action.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-setparametervalueconfiguration.html
     */
    interface SetParameterValueConfigurationProperty {
        /**
         * The destination parameter name of the `SetParameterValueConfiguration` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-setparametervalueconfiguration.html#cfn-quicksight-analysis-setparametervalueconfiguration-destinationparametername
         */
        readonly destinationParameterName: string;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-setparametervalueconfiguration.html#cfn-quicksight-analysis-setparametervalueconfiguration-value
         */
        readonly value: CfnAnalysis.DestinationParameterValueConfigurationProperty | cdk.IResolvable;
    }
    /**
     * The configuration of destination parameter values.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-destinationparametervalueconfiguration.html
     */
    interface DestinationParameterValueConfigurationProperty {
        /**
         * The configuration of custom values for destination parameter in `DestinationParameterValueConfiguration` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-destinationparametervalueconfiguration.html#cfn-quicksight-analysis-destinationparametervalueconfiguration-customvaluesconfiguration
         */
        readonly customValuesConfiguration?: CfnAnalysis.CustomValuesConfigurationProperty | cdk.IResolvable;
        /**
         * The configuration that selects all options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-destinationparametervalueconfiguration.html#cfn-quicksight-analysis-destinationparametervalueconfiguration-selectallvalueoptions
         */
        readonly selectAllValueOptions?: string;
        /**
         * A column of a data set.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-destinationparametervalueconfiguration.html#cfn-quicksight-analysis-destinationparametervalueconfiguration-sourcecolumn
         */
        readonly sourceColumn?: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The source field ID of the destination parameter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-destinationparametervalueconfiguration.html#cfn-quicksight-analysis-destinationparametervalueconfiguration-sourcefield
         */
        readonly sourceField?: string;
        /**
         * The source parameter name of the destination parameter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-destinationparametervalueconfiguration.html#cfn-quicksight-analysis-destinationparametervalueconfiguration-sourceparametername
         */
        readonly sourceParameterName?: string;
    }
    /**
     * The configuration of custom values for the destination parameter in `DestinationParameterValueConfiguration` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customvaluesconfiguration.html
     */
    interface CustomValuesConfigurationProperty {
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customvaluesconfiguration.html#cfn-quicksight-analysis-customvaluesconfiguration-customvalues
         */
        readonly customValues: CfnAnalysis.CustomParameterValuesProperty | cdk.IResolvable;
        /**
         * Includes the null value in custom action parameter values.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customvaluesconfiguration.html#cfn-quicksight-analysis-customvaluesconfiguration-includenullvalue
         */
        readonly includeNullValue?: boolean | cdk.IResolvable;
    }
    /**
     * The customized parameter values.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customparametervalues.html
     */
    interface CustomParameterValuesProperty {
        /**
         * A list of datetime-type parameter values.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customparametervalues.html#cfn-quicksight-analysis-customparametervalues-datetimevalues
         */
        readonly dateTimeValues?: Array<string>;
        /**
         * A list of decimal-type parameter values.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customparametervalues.html#cfn-quicksight-analysis-customparametervalues-decimalvalues
         */
        readonly decimalValues?: Array<number> | cdk.IResolvable;
        /**
         * A list of integer-type parameter values.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customparametervalues.html#cfn-quicksight-analysis-customparametervalues-integervalues
         */
        readonly integerValues?: Array<number> | cdk.IResolvable;
        /**
         * A list of string-type parameter values.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customparametervalues.html#cfn-quicksight-analysis-customparametervalues-stringvalues
         */
        readonly stringValues?: Array<string>;
    }
    /**
     * The filter operation that filters data included in a visual or in an entire sheet.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customactionfilteroperation.html
     */
    interface CustomActionFilterOperationProperty {
        /**
         * The configuration that chooses the fields to be filtered.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customactionfilteroperation.html#cfn-quicksight-analysis-customactionfilteroperation-selectedfieldsconfiguration
         */
        readonly selectedFieldsConfiguration: CfnAnalysis.FilterOperationSelectedFieldsConfigurationProperty | cdk.IResolvable;
        /**
         * The configuration that chooses the target visuals to be filtered.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customactionfilteroperation.html#cfn-quicksight-analysis-customactionfilteroperation-targetvisualsconfiguration
         */
        readonly targetVisualsConfiguration: CfnAnalysis.FilterOperationTargetVisualsConfigurationProperty | cdk.IResolvable;
    }
    /**
     * The configuration of selected fields in the `CustomActionFilterOperation` .
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filteroperationselectedfieldsconfiguration.html
     */
    interface FilterOperationSelectedFieldsConfigurationProperty {
        /**
         * The selected columns of a dataset.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filteroperationselectedfieldsconfiguration.html#cfn-quicksight-analysis-filteroperationselectedfieldsconfiguration-selectedcolumns
         */
        readonly selectedColumns?: Array<CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * A structure that contains the options that choose which fields are filtered in the `CustomActionFilterOperation` .
         *
         * Valid values are defined as follows:
         *
         * - `ALL_FIELDS` : Applies the filter operation to all fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filteroperationselectedfieldsconfiguration.html#cfn-quicksight-analysis-filteroperationselectedfieldsconfiguration-selectedfieldoptions
         */
        readonly selectedFieldOptions?: string;
        /**
         * Chooses the fields that are filtered in `CustomActionFilterOperation` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filteroperationselectedfieldsconfiguration.html#cfn-quicksight-analysis-filteroperationselectedfieldsconfiguration-selectedfields
         */
        readonly selectedFields?: Array<string>;
    }
    /**
     * The configuration of target visuals that you want to be filtered.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filteroperationtargetvisualsconfiguration.html
     */
    interface FilterOperationTargetVisualsConfigurationProperty {
        /**
         * The configuration of the same-sheet target visuals that you want to be filtered.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filteroperationtargetvisualsconfiguration.html#cfn-quicksight-analysis-filteroperationtargetvisualsconfiguration-samesheettargetvisualconfiguration
         */
        readonly sameSheetTargetVisualConfiguration?: cdk.IResolvable | CfnAnalysis.SameSheetTargetVisualConfigurationProperty;
    }
    /**
     * The configuration of the same-sheet target visuals that you want to be filtered.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-samesheettargetvisualconfiguration.html
     */
    interface SameSheetTargetVisualConfigurationProperty {
        /**
         * The options that choose the target visual in the same sheet.
         *
         * Valid values are defined as follows:
         *
         * - `ALL_VISUALS` : Applies the filter operation to all visuals in the same sheet.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-samesheettargetvisualconfiguration.html#cfn-quicksight-analysis-samesheettargetvisualconfiguration-targetvisualoptions
         */
        readonly targetVisualOptions?: string;
        /**
         * A list of the target visual IDs that are located in the same sheet of the analysis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-samesheettargetvisualconfiguration.html#cfn-quicksight-analysis-samesheettargetvisualconfiguration-targetvisuals
         */
        readonly targetVisuals?: Array<string>;
    }
    /**
     * The URL operation that opens a link to another webpage.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customactionurloperation.html
     */
    interface CustomActionURLOperationProperty {
        /**
         * The target of the `CustomActionURLOperation` .
         *
         * Valid values are defined as follows:
         *
         * - `NEW_TAB` : Opens the target URL in a new browser tab.
         * - `NEW_WINDOW` : Opens the target URL in a new browser window.
         * - `SAME_TAB` : Opens the target URL in the same browser tab.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customactionurloperation.html#cfn-quicksight-analysis-customactionurloperation-urltarget
         */
        readonly urlTarget: string;
        /**
         * THe URL link of the `CustomActionURLOperation` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customactionurloperation.html#cfn-quicksight-analysis-customactionurloperation-urltemplate
         */
        readonly urlTemplate: string;
    }
    /**
     * The title label options for a visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualtitlelabeloptions.html
     */
    interface VisualTitleLabelOptionsProperty {
        /**
         * The short text format of the title label, such as plain text or rich text.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualtitlelabeloptions.html#cfn-quicksight-analysis-visualtitlelabeloptions-formattext
         */
        readonly formatText?: cdk.IResolvable | CfnAnalysis.ShortFormatTextProperty;
        /**
         * The visibility of the title label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visualtitlelabeloptions.html#cfn-quicksight-analysis-visualtitlelabeloptions-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The text format for the title.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-shortformattext.html
     */
    interface ShortFormatTextProperty {
        /**
         * Plain text format.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-shortformattext.html#cfn-quicksight-analysis-shortformattext-plaintext
         */
        readonly plainText?: string;
        /**
         * Rich text.
         *
         * Examples of rich text include bold, underline, and italics.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-shortformattext.html#cfn-quicksight-analysis-shortformattext-richtext
         */
        readonly richText?: string;
    }
    /**
     * The option that determines the hierarchy of the fields for a visual element.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnhierarchy.html
     */
    interface ColumnHierarchyProperty {
        /**
         * The option that determines the hierarchy of any `DateTime` fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnhierarchy.html#cfn-quicksight-analysis-columnhierarchy-datetimehierarchy
         */
        readonly dateTimeHierarchy?: CfnAnalysis.DateTimeHierarchyProperty | cdk.IResolvable;
        /**
         * The option that determines the hierarchy of the fields that are built within a visual's field wells.
         *
         * These fields can't be duplicated to other visuals.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnhierarchy.html#cfn-quicksight-analysis-columnhierarchy-explicithierarchy
         */
        readonly explicitHierarchy?: CfnAnalysis.ExplicitHierarchyProperty | cdk.IResolvable;
        /**
         * The option that determines the hierarchy of the fields that are defined during data preparation.
         *
         * These fields are available to use in any analysis that uses the data source.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnhierarchy.html#cfn-quicksight-analysis-columnhierarchy-predefinedhierarchy
         */
        readonly predefinedHierarchy?: cdk.IResolvable | CfnAnalysis.PredefinedHierarchyProperty;
    }
    /**
     * The option that determines the hierarchy of any `DateTime` fields.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimehierarchy.html
     */
    interface DateTimeHierarchyProperty {
        /**
         * The option that determines the drill down filters for the `DateTime` hierarchy.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimehierarchy.html#cfn-quicksight-analysis-datetimehierarchy-drilldownfilters
         */
        readonly drillDownFilters?: Array<CfnAnalysis.DrillDownFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The hierarchy ID of the `DateTime` hierarchy.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimehierarchy.html#cfn-quicksight-analysis-datetimehierarchy-hierarchyid
         */
        readonly hierarchyId: string;
    }
    /**
     * The drill down filter for the column hierarchies.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-drilldownfilter.html
     */
    interface DrillDownFilterProperty {
        /**
         * The category type drill down filter.
         *
         * This filter is used for string type columns.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-drilldownfilter.html#cfn-quicksight-analysis-drilldownfilter-categoryfilter
         */
        readonly categoryFilter?: CfnAnalysis.CategoryDrillDownFilterProperty | cdk.IResolvable;
        /**
         * The numeric equality type drill down filter.
         *
         * This filter is used for number type columns.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-drilldownfilter.html#cfn-quicksight-analysis-drilldownfilter-numericequalityfilter
         */
        readonly numericEqualityFilter?: cdk.IResolvable | CfnAnalysis.NumericEqualityDrillDownFilterProperty;
        /**
         * The time range drill down filter.
         *
         * This filter is used for date time columns.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-drilldownfilter.html#cfn-quicksight-analysis-drilldownfilter-timerangefilter
         */
        readonly timeRangeFilter?: cdk.IResolvable | CfnAnalysis.TimeRangeDrillDownFilterProperty;
    }
    /**
     * The numeric equality type drill down filter.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericequalitydrilldownfilter.html
     */
    interface NumericEqualityDrillDownFilterProperty {
        /**
         * The column that the filter is applied to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericequalitydrilldownfilter.html#cfn-quicksight-analysis-numericequalitydrilldownfilter-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The value of the double input numeric drill down filter.
         *
         * @default - 0
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericequalitydrilldownfilter.html#cfn-quicksight-analysis-numericequalitydrilldownfilter-value
         */
        readonly value: number;
    }
    /**
     * The time range drill down filter.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timerangedrilldownfilter.html
     */
    interface TimeRangeDrillDownFilterProperty {
        /**
         * The column that the filter is applied to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timerangedrilldownfilter.html#cfn-quicksight-analysis-timerangedrilldownfilter-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The maximum value for the filter value range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timerangedrilldownfilter.html#cfn-quicksight-analysis-timerangedrilldownfilter-rangemaximum
         */
        readonly rangeMaximum: string;
        /**
         * The minimum value for the filter value range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timerangedrilldownfilter.html#cfn-quicksight-analysis-timerangedrilldownfilter-rangeminimum
         */
        readonly rangeMinimum: string;
        /**
         * The level of time precision that is used to aggregate `DateTime` values.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timerangedrilldownfilter.html#cfn-quicksight-analysis-timerangedrilldownfilter-timegranularity
         */
        readonly timeGranularity: string;
    }
    /**
     * The category drill down filter.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categorydrilldownfilter.html
     */
    interface CategoryDrillDownFilterProperty {
        /**
         * A list of the string inputs that are the values of the category drill down filter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categorydrilldownfilter.html#cfn-quicksight-analysis-categorydrilldownfilter-categoryvalues
         */
        readonly categoryValues: Array<string>;
        /**
         * The column that the filter is applied to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categorydrilldownfilter.html#cfn-quicksight-analysis-categorydrilldownfilter-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
    }
    /**
     * The option that determines the hierarchy of the fields that are built within a visual's field wells.
     *
     * These fields can't be duplicated to other visuals.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-explicithierarchy.html
     */
    interface ExplicitHierarchyProperty {
        /**
         * The list of columns that define the explicit hierarchy.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-explicithierarchy.html#cfn-quicksight-analysis-explicithierarchy-columns
         */
        readonly columns: Array<CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The option that determines the drill down filters for the explicit hierarchy.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-explicithierarchy.html#cfn-quicksight-analysis-explicithierarchy-drilldownfilters
         */
        readonly drillDownFilters?: Array<CfnAnalysis.DrillDownFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The hierarchy ID of the explicit hierarchy.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-explicithierarchy.html#cfn-quicksight-analysis-explicithierarchy-hierarchyid
         */
        readonly hierarchyId: string;
    }
    /**
     * The option that determines the hierarchy of the fields that are defined during data preparation.
     *
     * These fields are available to use in any analysis that uses the data source.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-predefinedhierarchy.html
     */
    interface PredefinedHierarchyProperty {
        /**
         * The list of columns that define the predefined hierarchy.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-predefinedhierarchy.html#cfn-quicksight-analysis-predefinedhierarchy-columns
         */
        readonly columns: Array<CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The option that determines the drill down filters for the predefined hierarchy.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-predefinedhierarchy.html#cfn-quicksight-analysis-predefinedhierarchy-drilldownfilters
         */
        readonly drillDownFilters?: Array<CfnAnalysis.DrillDownFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The hierarchy ID of the predefined hierarchy.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-predefinedhierarchy.html#cfn-quicksight-analysis-predefinedhierarchy-hierarchyid
         */
        readonly hierarchyId: string;
    }
    /**
     * A filled map.
     *
     * For more information, see [Creating filled maps](https://docs.aws.amazon.com/quicksight/latest/user/filled-maps.html) in the *Amazon QuickSight User Guide* .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapvisual.html
     */
    interface FilledMapVisualProperty {
        /**
         * The list of custom actions that are configured for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapvisual.html#cfn-quicksight-analysis-filledmapvisual-actions
         */
        readonly actions?: Array<cdk.IResolvable | CfnAnalysis.VisualCustomActionProperty> | cdk.IResolvable;
        /**
         * The configuration settings of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapvisual.html#cfn-quicksight-analysis-filledmapvisual-chartconfiguration
         */
        readonly chartConfiguration?: CfnAnalysis.FilledMapConfigurationProperty | cdk.IResolvable;
        /**
         * The column hierarchy that is used during drill-downs and drill-ups.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapvisual.html#cfn-quicksight-analysis-filledmapvisual-columnhierarchies
         */
        readonly columnHierarchies?: Array<CfnAnalysis.ColumnHierarchyProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The conditional formatting of a `FilledMapVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapvisual.html#cfn-quicksight-analysis-filledmapvisual-conditionalformatting
         */
        readonly conditionalFormatting?: CfnAnalysis.FilledMapConditionalFormattingProperty | cdk.IResolvable;
        /**
         * The subtitle that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapvisual.html#cfn-quicksight-analysis-filledmapvisual-subtitle
         */
        readonly subtitle?: cdk.IResolvable | CfnAnalysis.VisualSubtitleLabelOptionsProperty;
        /**
         * The title that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapvisual.html#cfn-quicksight-analysis-filledmapvisual-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.VisualTitleLabelOptionsProperty;
        /**
         * The alt text for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapvisual.html#cfn-quicksight-analysis-filledmapvisual-visualcontentalttext
         */
        readonly visualContentAltText?: string;
        /**
         * The unique identifier of a visual.
         *
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers..
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapvisual.html#cfn-quicksight-analysis-filledmapvisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * The conditional formatting of a `FilledMapVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapconditionalformatting.html
     */
    interface FilledMapConditionalFormattingProperty {
        /**
         * Conditional formatting options of a `FilledMapVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapconditionalformatting.html#cfn-quicksight-analysis-filledmapconditionalformatting-conditionalformattingoptions
         */
        readonly conditionalFormattingOptions: Array<CfnAnalysis.FilledMapConditionalFormattingOptionProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * Conditional formatting options of a `FilledMapVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapconditionalformattingoption.html
     */
    interface FilledMapConditionalFormattingOptionProperty {
        /**
         * The conditional formatting that determines the shape of the filled map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapconditionalformattingoption.html#cfn-quicksight-analysis-filledmapconditionalformattingoption-shape
         */
        readonly shape: CfnAnalysis.FilledMapShapeConditionalFormattingProperty | cdk.IResolvable;
    }
    /**
     * The conditional formatting that determines the shape of the filled map.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapshapeconditionalformatting.html
     */
    interface FilledMapShapeConditionalFormattingProperty {
        /**
         * The field ID of the filled map shape.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapshapeconditionalformatting.html#cfn-quicksight-analysis-filledmapshapeconditionalformatting-fieldid
         */
        readonly fieldId: string;
        /**
         * The conditional formatting that determines the background color of a filled map's shape.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapshapeconditionalformatting.html#cfn-quicksight-analysis-filledmapshapeconditionalformatting-format
         */
        readonly format?: cdk.IResolvable | CfnAnalysis.ShapeConditionalFormatProperty;
    }
    /**
     * The shape conditional formatting of a filled map visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-shapeconditionalformat.html
     */
    interface ShapeConditionalFormatProperty {
        /**
         * The conditional formatting for the shape background color of a filled map visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-shapeconditionalformat.html#cfn-quicksight-analysis-shapeconditionalformat-backgroundcolor
         */
        readonly backgroundColor: CfnAnalysis.ConditionalFormattingColorProperty | cdk.IResolvable;
    }
    /**
     * The formatting configuration for the color.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcolor.html
     */
    interface ConditionalFormattingColorProperty {
        /**
         * Formatting configuration for gradient color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcolor.html#cfn-quicksight-analysis-conditionalformattingcolor-gradient
         */
        readonly gradient?: CfnAnalysis.ConditionalFormattingGradientColorProperty | cdk.IResolvable;
        /**
         * Formatting configuration for solid color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcolor.html#cfn-quicksight-analysis-conditionalformattingcolor-solid
         */
        readonly solid?: CfnAnalysis.ConditionalFormattingSolidColorProperty | cdk.IResolvable;
    }
    /**
     * Formatting configuration for gradient color.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattinggradientcolor.html
     */
    interface ConditionalFormattingGradientColorProperty {
        /**
         * Determines the color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattinggradientcolor.html#cfn-quicksight-analysis-conditionalformattinggradientcolor-color
         */
        readonly color: CfnAnalysis.GradientColorProperty | cdk.IResolvable;
        /**
         * The expression that determines the formatting configuration for gradient color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattinggradientcolor.html#cfn-quicksight-analysis-conditionalformattinggradientcolor-expression
         */
        readonly expression: string;
    }
    /**
     * Determines the gradient color settings.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gradientcolor.html
     */
    interface GradientColorProperty {
        /**
         * The list of gradient color stops.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gradientcolor.html#cfn-quicksight-analysis-gradientcolor-stops
         */
        readonly stops?: Array<CfnAnalysis.GradientStopProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * Determines the gradient stop configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gradientstop.html
     */
    interface GradientStopProperty {
        /**
         * Determines the color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gradientstop.html#cfn-quicksight-analysis-gradientstop-color
         */
        readonly color?: string;
        /**
         * Determines the data value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gradientstop.html#cfn-quicksight-analysis-gradientstop-datavalue
         */
        readonly dataValue?: number;
        /**
         * Determines gradient offset value.
         *
         * @default - 0
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gradientstop.html#cfn-quicksight-analysis-gradientstop-gradientoffset
         */
        readonly gradientOffset: number;
    }
    /**
     * Formatting configuration for solid color.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingsolidcolor.html
     */
    interface ConditionalFormattingSolidColorProperty {
        /**
         * Determines the color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingsolidcolor.html#cfn-quicksight-analysis-conditionalformattingsolidcolor-color
         */
        readonly color?: string;
        /**
         * The expression that determines the formatting configuration for solid color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingsolidcolor.html#cfn-quicksight-analysis-conditionalformattingsolidcolor-expression
         */
        readonly expression: string;
    }
    /**
     * The configuration for a `FilledMapVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapconfiguration.html
     */
    interface FilledMapConfigurationProperty {
        /**
         * The field wells of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapconfiguration.html#cfn-quicksight-analysis-filledmapconfiguration-fieldwells
         */
        readonly fieldWells?: CfnAnalysis.FilledMapFieldWellsProperty | cdk.IResolvable;
        /**
         * The general visual interactions setup for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapconfiguration.html#cfn-quicksight-analysis-filledmapconfiguration-interactions
         */
        readonly interactions?: cdk.IResolvable | CfnAnalysis.VisualInteractionOptionsProperty;
        /**
         * The legend display setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapconfiguration.html#cfn-quicksight-analysis-filledmapconfiguration-legend
         */
        readonly legend?: cdk.IResolvable | CfnAnalysis.LegendOptionsProperty;
        /**
         * The map style options of the filled map visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapconfiguration.html#cfn-quicksight-analysis-filledmapconfiguration-mapstyleoptions
         */
        readonly mapStyleOptions?: CfnAnalysis.GeospatialMapStyleOptionsProperty | cdk.IResolvable;
        /**
         * The sort configuration of a `FilledMapVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapconfiguration.html#cfn-quicksight-analysis-filledmapconfiguration-sortconfiguration
         */
        readonly sortConfiguration?: CfnAnalysis.FilledMapSortConfigurationProperty | cdk.IResolvable;
        /**
         * The tooltip display setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapconfiguration.html#cfn-quicksight-analysis-filledmapconfiguration-tooltip
         */
        readonly tooltip?: cdk.IResolvable | CfnAnalysis.TooltipOptionsProperty;
        /**
         * The window options of the filled map visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapconfiguration.html#cfn-quicksight-analysis-filledmapconfiguration-windowoptions
         */
        readonly windowOptions?: CfnAnalysis.GeospatialWindowOptionsProperty | cdk.IResolvable;
    }
    /**
     * The sort configuration of a `FilledMapVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapsortconfiguration.html
     */
    interface FilledMapSortConfigurationProperty {
        /**
         * The sort configuration of the location fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapsortconfiguration.html#cfn-quicksight-analysis-filledmapsortconfiguration-categorysort
         */
        readonly categorySort?: Array<CfnAnalysis.FieldSortOptionsProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The options for the legend setup of a visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-legendoptions.html
     */
    interface LegendOptionsProperty {
        /**
         * The height of the legend.
         *
         * If this value is omitted, a default height is used when rendering.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-legendoptions.html#cfn-quicksight-analysis-legendoptions-height
         */
        readonly height?: string;
        /**
         * The positions for the legend. Choose one of the following options:.
         *
         * - `AUTO`
         * - `RIGHT`
         * - `BOTTOM`
         * - `LEFT`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-legendoptions.html#cfn-quicksight-analysis-legendoptions-position
         */
        readonly position?: string;
        /**
         * The custom title for the legend.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-legendoptions.html#cfn-quicksight-analysis-legendoptions-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.LabelOptionsProperty;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-legendoptions.html#cfn-quicksight-analysis-legendoptions-valuefontconfiguration
         */
        readonly valueFontConfiguration?: CfnAnalysis.FontConfigurationProperty | cdk.IResolvable;
        /**
         * Determines whether or not the legend is visible.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-legendoptions.html#cfn-quicksight-analysis-legendoptions-visibility
         */
        readonly visibility?: string;
        /**
         * The width of the legend.
         *
         * If this value is omitted, a default width is used when rendering.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-legendoptions.html#cfn-quicksight-analysis-legendoptions-width
         */
        readonly width?: string;
    }
    /**
     * The map style options of the geospatial map.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapstyleoptions.html
     */
    interface GeospatialMapStyleOptionsProperty {
        /**
         * The base map style of the geospatial map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapstyleoptions.html#cfn-quicksight-analysis-geospatialmapstyleoptions-basemapstyle
         */
        readonly baseMapStyle?: string;
    }
    /**
     * The field wells of a `FilledMapVisual` .
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapfieldwells.html
     */
    interface FilledMapFieldWellsProperty {
        /**
         * The aggregated field well of the filled map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapfieldwells.html#cfn-quicksight-analysis-filledmapfieldwells-filledmapaggregatedfieldwells
         */
        readonly filledMapAggregatedFieldWells?: CfnAnalysis.FilledMapAggregatedFieldWellsProperty | cdk.IResolvable;
    }
    /**
     * The aggregated field well of the filled map.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapaggregatedfieldwells.html
     */
    interface FilledMapAggregatedFieldWellsProperty {
        /**
         * The aggregated location field well of the filled map.
         *
         * Values are grouped by location fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapaggregatedfieldwells.html#cfn-quicksight-analysis-filledmapaggregatedfieldwells-geospatial
         */
        readonly geospatial?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The aggregated color field well of a filled map.
         *
         * Values are aggregated based on location fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapaggregatedfieldwells.html#cfn-quicksight-analysis-filledmapaggregatedfieldwells-values
         */
        readonly values?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
    }
    /**
     * The window options of the geospatial map visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialwindowoptions.html
     */
    interface GeospatialWindowOptionsProperty {
        /**
         * The bounds options (north, south, west, east) of the geospatial window options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialwindowoptions.html#cfn-quicksight-analysis-geospatialwindowoptions-bounds
         */
        readonly bounds?: CfnAnalysis.GeospatialCoordinateBoundsProperty | cdk.IResolvable;
        /**
         * The map zoom modes (manual, auto) of the geospatial window options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialwindowoptions.html#cfn-quicksight-analysis-geospatialwindowoptions-mapzoommode
         */
        readonly mapZoomMode?: string;
    }
    /**
     * The bound options (north, south, west, east) of the geospatial window options.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcoordinatebounds.html
     */
    interface GeospatialCoordinateBoundsProperty {
        /**
         * The longitude of the east bound of the geospatial coordinate bounds.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcoordinatebounds.html#cfn-quicksight-analysis-geospatialcoordinatebounds-east
         */
        readonly east: number;
        /**
         * The latitude of the north bound of the geospatial coordinate bounds.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcoordinatebounds.html#cfn-quicksight-analysis-geospatialcoordinatebounds-north
         */
        readonly north: number;
        /**
         * The latitude of the south bound of the geospatial coordinate bounds.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcoordinatebounds.html#cfn-quicksight-analysis-geospatialcoordinatebounds-south
         */
        readonly south: number;
        /**
         * The longitude of the west bound of the geospatial coordinate bounds.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcoordinatebounds.html#cfn-quicksight-analysis-geospatialcoordinatebounds-west
         */
        readonly west: number;
    }
    /**
     * A box plot.
     *
     * For more information, see [Using box plots](https://docs.aws.amazon.com/quicksight/latest/user/box-plots.html) in the *Amazon QuickSight User Guide* .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html
     */
    interface BoxPlotVisualProperty {
        /**
         * The list of custom actions that are configured for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-actions
         */
        readonly actions?: Array<cdk.IResolvable | CfnAnalysis.VisualCustomActionProperty> | cdk.IResolvable;
        /**
         * The configuration settings of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-chartconfiguration
         */
        readonly chartConfiguration?: CfnAnalysis.BoxPlotChartConfigurationProperty | cdk.IResolvable;
        /**
         * The column hierarchy that is used during drill-downs and drill-ups.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-columnhierarchies
         */
        readonly columnHierarchies?: Array<CfnAnalysis.ColumnHierarchyProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The subtitle that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-subtitle
         */
        readonly subtitle?: cdk.IResolvable | CfnAnalysis.VisualSubtitleLabelOptionsProperty;
        /**
         * The title that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.VisualTitleLabelOptionsProperty;
        /**
         * The alt text for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-visualcontentalttext
         */
        readonly visualContentAltText?: string;
        /**
         * The unique identifier of a visual.
         *
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers..
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html#cfn-quicksight-analysis-boxplotvisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * The configuration of a `BoxPlotVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html
     */
    interface BoxPlotChartConfigurationProperty {
        /**
         * The box plot chart options for a box plot visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-boxplotoptions
         */
        readonly boxPlotOptions?: CfnAnalysis.BoxPlotOptionsProperty | cdk.IResolvable;
        /**
         * The label display options (grid line, range, scale, axis step) of a box plot category.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-categoryaxis
         */
        readonly categoryAxis?: CfnAnalysis.AxisDisplayOptionsProperty | cdk.IResolvable;
        /**
         * The label options (label text, label visibility and sort Icon visibility) of a box plot category.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-categorylabeloptions
         */
        readonly categoryLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The field wells of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-fieldwells
         */
        readonly fieldWells?: CfnAnalysis.BoxPlotFieldWellsProperty | cdk.IResolvable;
        /**
         * The general visual interactions setup for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-interactions
         */
        readonly interactions?: cdk.IResolvable | CfnAnalysis.VisualInteractionOptionsProperty;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-legend
         */
        readonly legend?: cdk.IResolvable | CfnAnalysis.LegendOptionsProperty;
        /**
         * The label display options (grid line, range, scale, axis step) of a box plot category.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-primaryyaxisdisplayoptions
         */
        readonly primaryYAxisDisplayOptions?: CfnAnalysis.AxisDisplayOptionsProperty | cdk.IResolvable;
        /**
         * The label options (label text, label visibility and sort icon visibility) of a box plot value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-primaryyaxislabeloptions
         */
        readonly primaryYAxisLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The reference line setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-referencelines
         */
        readonly referenceLines?: Array<cdk.IResolvable | CfnAnalysis.ReferenceLineProperty> | cdk.IResolvable;
        /**
         * The sort configuration of a `BoxPlotVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-sortconfiguration
         */
        readonly sortConfiguration?: CfnAnalysis.BoxPlotSortConfigurationProperty | cdk.IResolvable;
        /**
         * The tooltip display setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-tooltip
         */
        readonly tooltip?: cdk.IResolvable | CfnAnalysis.TooltipOptionsProperty;
        /**
         * The palette (chart color) display setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html#cfn-quicksight-analysis-boxplotchartconfiguration-visualpalette
         */
        readonly visualPalette?: cdk.IResolvable | CfnAnalysis.VisualPaletteProperty;
    }
    /**
     * The sort configuration of a `BoxPlotVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotsortconfiguration.html
     */
    interface BoxPlotSortConfigurationProperty {
        /**
         * The sort configuration of a group by fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotsortconfiguration.html#cfn-quicksight-analysis-boxplotsortconfiguration-categorysort
         */
        readonly categorySort?: Array<CfnAnalysis.FieldSortOptionsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The pagination configuration of a table visual or box plot.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotsortconfiguration.html#cfn-quicksight-analysis-boxplotsortconfiguration-paginationconfiguration
         */
        readonly paginationConfiguration?: cdk.IResolvable | CfnAnalysis.PaginationConfigurationProperty;
    }
    /**
     * The pagination configuration for a table visual or boxplot.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-paginationconfiguration.html
     */
    interface PaginationConfigurationProperty {
        /**
         * Indicates the page number.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-paginationconfiguration.html#cfn-quicksight-analysis-paginationconfiguration-pagenumber
         */
        readonly pageNumber: number;
        /**
         * Indicates how many items render in one page.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-paginationconfiguration.html#cfn-quicksight-analysis-paginationconfiguration-pagesize
         */
        readonly pageSize: number;
    }
    /**
     * The reference line visual display options.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referenceline.html
     */
    interface ReferenceLineProperty {
        /**
         * The data configuration of the reference line.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referenceline.html#cfn-quicksight-analysis-referenceline-dataconfiguration
         */
        readonly dataConfiguration: cdk.IResolvable | CfnAnalysis.ReferenceLineDataConfigurationProperty;
        /**
         * The label configuration of the reference line.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referenceline.html#cfn-quicksight-analysis-referenceline-labelconfiguration
         */
        readonly labelConfiguration?: cdk.IResolvable | CfnAnalysis.ReferenceLineLabelConfigurationProperty;
        /**
         * The status of the reference line. Choose one of the following options:.
         *
         * - `ENABLE`
         * - `DISABLE`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referenceline.html#cfn-quicksight-analysis-referenceline-status
         */
        readonly status?: string;
        /**
         * The style configuration of the reference line.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referenceline.html#cfn-quicksight-analysis-referenceline-styleconfiguration
         */
        readonly styleConfiguration?: cdk.IResolvable | CfnAnalysis.ReferenceLineStyleConfigurationProperty;
    }
    /**
     * The data configuration of the reference line.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinedataconfiguration.html
     */
    interface ReferenceLineDataConfigurationProperty {
        /**
         * The axis binding type of the reference line. Choose one of the following options:.
         *
         * - `PrimaryY`
         * - `SecondaryY`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinedataconfiguration.html#cfn-quicksight-analysis-referencelinedataconfiguration-axisbinding
         */
        readonly axisBinding?: string;
        /**
         * The dynamic configuration of the reference line data configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinedataconfiguration.html#cfn-quicksight-analysis-referencelinedataconfiguration-dynamicconfiguration
         */
        readonly dynamicConfiguration?: cdk.IResolvable | CfnAnalysis.ReferenceLineDynamicDataConfigurationProperty;
        /**
         * The series type of the reference line data configuration. Choose one of the following options:.
         *
         * - `BAR`
         * - `LINE`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinedataconfiguration.html#cfn-quicksight-analysis-referencelinedataconfiguration-seriestype
         */
        readonly seriesType?: string;
        /**
         * The static data configuration of the reference line data configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinedataconfiguration.html#cfn-quicksight-analysis-referencelinedataconfiguration-staticconfiguration
         */
        readonly staticConfiguration?: cdk.IResolvable | CfnAnalysis.ReferenceLineStaticDataConfigurationProperty;
    }
    /**
     * The dynamic configuration of the reference line data configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinedynamicdataconfiguration.html
     */
    interface ReferenceLineDynamicDataConfigurationProperty {
        /**
         * The calculation that is used in the dynamic data.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinedynamicdataconfiguration.html#cfn-quicksight-analysis-referencelinedynamicdataconfiguration-calculation
         */
        readonly calculation: cdk.IResolvable | CfnAnalysis.NumericalAggregationFunctionProperty;
        /**
         * The column that the dynamic data targets.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinedynamicdataconfiguration.html#cfn-quicksight-analysis-referencelinedynamicdataconfiguration-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The aggregation function that is used in the dynamic data.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinedynamicdataconfiguration.html#cfn-quicksight-analysis-referencelinedynamicdataconfiguration-measureaggregationfunction
         */
        readonly measureAggregationFunction?: CfnAnalysis.AggregationFunctionProperty | cdk.IResolvable;
    }
    /**
     * The static data configuration of the reference line data configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinestaticdataconfiguration.html
     */
    interface ReferenceLineStaticDataConfigurationProperty {
        /**
         * The double input of the static data.
         *
         * @default - 0
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinestaticdataconfiguration.html#cfn-quicksight-analysis-referencelinestaticdataconfiguration-value
         */
        readonly value: number;
    }
    /**
     * The label configuration of a reference line.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinelabelconfiguration.html
     */
    interface ReferenceLineLabelConfigurationProperty {
        /**
         * The custom label configuration of the label in a reference line.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinelabelconfiguration.html#cfn-quicksight-analysis-referencelinelabelconfiguration-customlabelconfiguration
         */
        readonly customLabelConfiguration?: cdk.IResolvable | CfnAnalysis.ReferenceLineCustomLabelConfigurationProperty;
        /**
         * The font color configuration of the label in a reference line.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinelabelconfiguration.html#cfn-quicksight-analysis-referencelinelabelconfiguration-fontcolor
         */
        readonly fontColor?: string;
        /**
         * The font configuration of the label in a reference line.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinelabelconfiguration.html#cfn-quicksight-analysis-referencelinelabelconfiguration-fontconfiguration
         */
        readonly fontConfiguration?: CfnAnalysis.FontConfigurationProperty | cdk.IResolvable;
        /**
         * The horizontal position configuration of the label in a reference line. Choose one of the following options:.
         *
         * - `LEFT`
         * - `CENTER`
         * - `RIGHT`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinelabelconfiguration.html#cfn-quicksight-analysis-referencelinelabelconfiguration-horizontalposition
         */
        readonly horizontalPosition?: string;
        /**
         * The value label configuration of the label in a reference line.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinelabelconfiguration.html#cfn-quicksight-analysis-referencelinelabelconfiguration-valuelabelconfiguration
         */
        readonly valueLabelConfiguration?: cdk.IResolvable | CfnAnalysis.ReferenceLineValueLabelConfigurationProperty;
        /**
         * The vertical position configuration of the label in a reference line. Choose one of the following options:.
         *
         * - `ABOVE`
         * - `BELOW`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinelabelconfiguration.html#cfn-quicksight-analysis-referencelinelabelconfiguration-verticalposition
         */
        readonly verticalPosition?: string;
    }
    /**
     * The value label configuration of the label in a reference line.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinevaluelabelconfiguration.html
     */
    interface ReferenceLineValueLabelConfigurationProperty {
        /**
         * The format configuration of the value label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinevaluelabelconfiguration.html#cfn-quicksight-analysis-referencelinevaluelabelconfiguration-formatconfiguration
         */
        readonly formatConfiguration?: cdk.IResolvable | CfnAnalysis.NumericFormatConfigurationProperty;
        /**
         * The relative position of the value label. Choose one of the following options:.
         *
         * - `BEFORE_CUSTOM_LABEL`
         * - `AFTER_CUSTOM_LABEL`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinevaluelabelconfiguration.html#cfn-quicksight-analysis-referencelinevaluelabelconfiguration-relativeposition
         */
        readonly relativePosition?: string;
    }
    /**
     * The configuration for a custom label on a `ReferenceLine` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinecustomlabelconfiguration.html
     */
    interface ReferenceLineCustomLabelConfigurationProperty {
        /**
         * The string text of the custom label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinecustomlabelconfiguration.html#cfn-quicksight-analysis-referencelinecustomlabelconfiguration-customlabel
         */
        readonly customLabel: string;
    }
    /**
     * The style configuration of the reference line.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinestyleconfiguration.html
     */
    interface ReferenceLineStyleConfigurationProperty {
        /**
         * The hex color of the reference line.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinestyleconfiguration.html#cfn-quicksight-analysis-referencelinestyleconfiguration-color
         */
        readonly color?: string;
        /**
         * The pattern type of the line style. Choose one of the following options:.
         *
         * - `SOLID`
         * - `DASHED`
         * - `DOTTED`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinestyleconfiguration.html#cfn-quicksight-analysis-referencelinestyleconfiguration-pattern
         */
        readonly pattern?: string;
    }
    /**
     * The display options for the axis label.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html
     */
    interface AxisDisplayOptionsProperty {
        /**
         * Determines whether or not the axis line is visible.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html#cfn-quicksight-analysis-axisdisplayoptions-axislinevisibility
         */
        readonly axisLineVisibility?: string;
        /**
         * The offset value that determines the starting placement of the axis within a visual's bounds.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html#cfn-quicksight-analysis-axisdisplayoptions-axisoffset
         */
        readonly axisOffset?: string;
        /**
         * The data options for an axis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html#cfn-quicksight-analysis-axisdisplayoptions-dataoptions
         */
        readonly dataOptions?: CfnAnalysis.AxisDataOptionsProperty | cdk.IResolvable;
        /**
         * Determines whether or not the grid line is visible.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html#cfn-quicksight-analysis-axisdisplayoptions-gridlinevisibility
         */
        readonly gridLineVisibility?: string;
        /**
         * The scroll bar options for an axis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html#cfn-quicksight-analysis-axisdisplayoptions-scrollbaroptions
         */
        readonly scrollbarOptions?: cdk.IResolvable | CfnAnalysis.ScrollBarOptionsProperty;
        /**
         * The tick label options of an axis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html#cfn-quicksight-analysis-axisdisplayoptions-ticklabeloptions
         */
        readonly tickLabelOptions?: CfnAnalysis.AxisTickLabelOptionsProperty | cdk.IResolvable;
    }
    /**
     * The data options for an axis.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdataoptions.html
     */
    interface AxisDataOptionsProperty {
        /**
         * The options for an axis with a date field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdataoptions.html#cfn-quicksight-analysis-axisdataoptions-dateaxisoptions
         */
        readonly dateAxisOptions?: CfnAnalysis.DateAxisOptionsProperty | cdk.IResolvable;
        /**
         * The options for an axis with a numeric field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdataoptions.html#cfn-quicksight-analysis-axisdataoptions-numericaxisoptions
         */
        readonly numericAxisOptions?: cdk.IResolvable | CfnAnalysis.NumericAxisOptionsProperty;
    }
    /**
     * The options that determine how a date axis is displayed.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-dateaxisoptions.html
     */
    interface DateAxisOptionsProperty {
        /**
         * Determines whether or not missing dates are displayed.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-dateaxisoptions.html#cfn-quicksight-analysis-dateaxisoptions-missingdatevisibility
         */
        readonly missingDateVisibility?: string;
    }
    /**
     * The options for an axis with a numeric field.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericaxisoptions.html
     */
    interface NumericAxisOptionsProperty {
        /**
         * The range setup of a numeric axis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericaxisoptions.html#cfn-quicksight-analysis-numericaxisoptions-range
         */
        readonly range?: CfnAnalysis.AxisDisplayRangeProperty | cdk.IResolvable;
        /**
         * The scale setup of a numeric axis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericaxisoptions.html#cfn-quicksight-analysis-numericaxisoptions-scale
         */
        readonly scale?: CfnAnalysis.AxisScaleProperty | cdk.IResolvable;
    }
    /**
     * The scale setup options for a numeric axis display.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisscale.html
     */
    interface AxisScaleProperty {
        /**
         * The linear axis scale setup.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisscale.html#cfn-quicksight-analysis-axisscale-linear
         */
        readonly linear?: CfnAnalysis.AxisLinearScaleProperty | cdk.IResolvable;
        /**
         * The logarithmic axis scale setup.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisscale.html#cfn-quicksight-analysis-axisscale-logarithmic
         */
        readonly logarithmic?: CfnAnalysis.AxisLogarithmicScaleProperty | cdk.IResolvable;
    }
    /**
     * The logarithmic axis scale setup.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislogarithmicscale.html
     */
    interface AxisLogarithmicScaleProperty {
        /**
         * The base setup of a logarithmic axis scale.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislogarithmicscale.html#cfn-quicksight-analysis-axislogarithmicscale-base
         */
        readonly base?: number;
    }
    /**
     * The liner axis scale setup.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislinearscale.html
     */
    interface AxisLinearScaleProperty {
        /**
         * The step count setup of a linear axis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislinearscale.html#cfn-quicksight-analysis-axislinearscale-stepcount
         */
        readonly stepCount?: number;
        /**
         * The step size setup of a linear axis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislinearscale.html#cfn-quicksight-analysis-axislinearscale-stepsize
         */
        readonly stepSize?: number;
    }
    /**
     * The range setup of a numeric axis display range.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayrange.html
     */
    interface AxisDisplayRangeProperty {
        /**
         * The data-driven setup of an axis display range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayrange.html#cfn-quicksight-analysis-axisdisplayrange-datadriven
         */
        readonly dataDriven?: any | cdk.IResolvable;
        /**
         * The minimum and maximum setup of an axis display range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayrange.html#cfn-quicksight-analysis-axisdisplayrange-minmax
         */
        readonly minMax?: CfnAnalysis.AxisDisplayMinMaxRangeProperty | cdk.IResolvable;
    }
    /**
     * The minimum and maximum setup for an axis display range.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayminmaxrange.html
     */
    interface AxisDisplayMinMaxRangeProperty {
        /**
         * The maximum setup for an axis display range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayminmaxrange.html#cfn-quicksight-analysis-axisdisplayminmaxrange-maximum
         */
        readonly maximum?: number;
        /**
         * The minimum setup for an axis display range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayminmaxrange.html#cfn-quicksight-analysis-axisdisplayminmaxrange-minimum
         */
        readonly minimum?: number;
    }
    /**
     * The tick label options of an axis.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisticklabeloptions.html
     */
    interface AxisTickLabelOptionsProperty {
        /**
         * Determines whether or not the axis ticks are visible.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisticklabeloptions.html#cfn-quicksight-analysis-axisticklabeloptions-labeloptions
         */
        readonly labelOptions?: cdk.IResolvable | CfnAnalysis.LabelOptionsProperty;
        /**
         * The rotation angle of the axis tick labels.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisticklabeloptions.html#cfn-quicksight-analysis-axisticklabeloptions-rotationangle
         */
        readonly rotationAngle?: number;
    }
    /**
     * The visual display options for a data zoom scroll bar.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scrollbaroptions.html
     */
    interface ScrollBarOptionsProperty {
        /**
         * The visibility of the data zoom scroll bar.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scrollbaroptions.html#cfn-quicksight-analysis-scrollbaroptions-visibility
         */
        readonly visibility?: string;
        /**
         * The visibility range for the data zoom scroll bar.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scrollbaroptions.html#cfn-quicksight-analysis-scrollbaroptions-visiblerange
         */
        readonly visibleRange?: cdk.IResolvable | CfnAnalysis.VisibleRangeOptionsProperty;
    }
    /**
     * The range options for the data zoom scroll bar.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visiblerangeoptions.html
     */
    interface VisibleRangeOptionsProperty {
        /**
         * The percent range in the visible range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-visiblerangeoptions.html#cfn-quicksight-analysis-visiblerangeoptions-percentrange
         */
        readonly percentRange?: cdk.IResolvable | CfnAnalysis.PercentVisibleRangeProperty;
    }
    /**
     * The percent range in the visible range.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-percentvisiblerange.html
     */
    interface PercentVisibleRangeProperty {
        /**
         * The lower bound of the range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-percentvisiblerange.html#cfn-quicksight-analysis-percentvisiblerange-from
         */
        readonly from?: number;
        /**
         * The top bound of the range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-percentvisiblerange.html#cfn-quicksight-analysis-percentvisiblerange-to
         */
        readonly to?: number;
    }
    /**
     * The field wells of a `BoxPlotVisual` .
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotfieldwells.html
     */
    interface BoxPlotFieldWellsProperty {
        /**
         * The aggregated field wells of a box plot.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotfieldwells.html#cfn-quicksight-analysis-boxplotfieldwells-boxplotaggregatedfieldwells
         */
        readonly boxPlotAggregatedFieldWells?: CfnAnalysis.BoxPlotAggregatedFieldWellsProperty | cdk.IResolvable;
    }
    /**
     * The aggregated field well for a box plot.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotaggregatedfieldwells.html
     */
    interface BoxPlotAggregatedFieldWellsProperty {
        /**
         * The group by field well of a box plot chart.
         *
         * Values are grouped based on group by fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotaggregatedfieldwells.html#cfn-quicksight-analysis-boxplotaggregatedfieldwells-groupby
         */
        readonly groupBy?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The value field well of a box plot chart.
         *
         * Values are aggregated based on group by fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotaggregatedfieldwells.html#cfn-quicksight-analysis-boxplotaggregatedfieldwells-values
         */
        readonly values?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
    }
    /**
     * The options of a box plot visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotoptions.html
     */
    interface BoxPlotOptionsProperty {
        /**
         * Determines the visibility of all data points of the box plot.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotoptions.html#cfn-quicksight-analysis-boxplotoptions-alldatapointsvisibility
         */
        readonly allDataPointsVisibility?: string;
        /**
         * Determines the visibility of the outlier in a box plot.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotoptions.html#cfn-quicksight-analysis-boxplotoptions-outliervisibility
         */
        readonly outlierVisibility?: string;
        /**
         * The style options of the box plot.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotoptions.html#cfn-quicksight-analysis-boxplotoptions-styleoptions
         */
        readonly styleOptions?: CfnAnalysis.BoxPlotStyleOptionsProperty | cdk.IResolvable;
    }
    /**
     * The style options of the box plot.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotstyleoptions.html
     */
    interface BoxPlotStyleOptionsProperty {
        /**
         * The fill styles (solid, transparent) of the box plot.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotstyleoptions.html#cfn-quicksight-analysis-boxplotstyleoptions-fillstyle
         */
        readonly fillStyle?: string;
    }
    /**
     * A waterfall chart.
     *
     * For more information, see [Using waterfall charts](https://docs.aws.amazon.com/quicksight/latest/user/waterfall-chart.html) in the *Amazon QuickSight User Guide* .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallvisual.html
     */
    interface WaterfallVisualProperty {
        /**
         * The list of custom actions that are configured for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallvisual.html#cfn-quicksight-analysis-waterfallvisual-actions
         */
        readonly actions?: Array<cdk.IResolvable | CfnAnalysis.VisualCustomActionProperty> | cdk.IResolvable;
        /**
         * The configuration for a waterfall visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallvisual.html#cfn-quicksight-analysis-waterfallvisual-chartconfiguration
         */
        readonly chartConfiguration?: cdk.IResolvable | CfnAnalysis.WaterfallChartConfigurationProperty;
        /**
         * The column hierarchy that is used during drill-downs and drill-ups.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallvisual.html#cfn-quicksight-analysis-waterfallvisual-columnhierarchies
         */
        readonly columnHierarchies?: Array<CfnAnalysis.ColumnHierarchyProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The subtitle that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallvisual.html#cfn-quicksight-analysis-waterfallvisual-subtitle
         */
        readonly subtitle?: cdk.IResolvable | CfnAnalysis.VisualSubtitleLabelOptionsProperty;
        /**
         * The title that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallvisual.html#cfn-quicksight-analysis-waterfallvisual-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.VisualTitleLabelOptionsProperty;
        /**
         * The alt text for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallvisual.html#cfn-quicksight-analysis-waterfallvisual-visualcontentalttext
         */
        readonly visualContentAltText?: string;
        /**
         * The unique identifier of a visual.
         *
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallvisual.html#cfn-quicksight-analysis-waterfallvisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * The configuration for a waterfall visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartconfiguration.html
     */
    interface WaterfallChartConfigurationProperty {
        /**
         * The options that determine the presentation of the category axis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartconfiguration.html#cfn-quicksight-analysis-waterfallchartconfiguration-categoryaxisdisplayoptions
         */
        readonly categoryAxisDisplayOptions?: CfnAnalysis.AxisDisplayOptionsProperty | cdk.IResolvable;
        /**
         * The options that determine the presentation of the category axis label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartconfiguration.html#cfn-quicksight-analysis-waterfallchartconfiguration-categoryaxislabeloptions
         */
        readonly categoryAxisLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The color configuration of a waterfall visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartconfiguration.html#cfn-quicksight-analysis-waterfallchartconfiguration-colorconfiguration
         */
        readonly colorConfiguration?: cdk.IResolvable | CfnAnalysis.WaterfallChartColorConfigurationProperty;
        /**
         * The data label configuration of a waterfall visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartconfiguration.html#cfn-quicksight-analysis-waterfallchartconfiguration-datalabels
         */
        readonly dataLabels?: CfnAnalysis.DataLabelOptionsProperty | cdk.IResolvable;
        /**
         * The field well configuration of a waterfall visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartconfiguration.html#cfn-quicksight-analysis-waterfallchartconfiguration-fieldwells
         */
        readonly fieldWells?: cdk.IResolvable | CfnAnalysis.WaterfallChartFieldWellsProperty;
        /**
         * The general visual interactions setup for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartconfiguration.html#cfn-quicksight-analysis-waterfallchartconfiguration-interactions
         */
        readonly interactions?: cdk.IResolvable | CfnAnalysis.VisualInteractionOptionsProperty;
        /**
         * The legend configuration of a waterfall visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartconfiguration.html#cfn-quicksight-analysis-waterfallchartconfiguration-legend
         */
        readonly legend?: cdk.IResolvable | CfnAnalysis.LegendOptionsProperty;
        /**
         * The options that determine the presentation of the y-axis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartconfiguration.html#cfn-quicksight-analysis-waterfallchartconfiguration-primaryyaxisdisplayoptions
         */
        readonly primaryYAxisDisplayOptions?: CfnAnalysis.AxisDisplayOptionsProperty | cdk.IResolvable;
        /**
         * The options that determine the presentation of the y-axis label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartconfiguration.html#cfn-quicksight-analysis-waterfallchartconfiguration-primaryyaxislabeloptions
         */
        readonly primaryYAxisLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The sort configuration of a waterfall visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartconfiguration.html#cfn-quicksight-analysis-waterfallchartconfiguration-sortconfiguration
         */
        readonly sortConfiguration?: cdk.IResolvable | CfnAnalysis.WaterfallChartSortConfigurationProperty;
        /**
         * The visual palette configuration of a waterfall visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartconfiguration.html#cfn-quicksight-analysis-waterfallchartconfiguration-visualpalette
         */
        readonly visualPalette?: cdk.IResolvable | CfnAnalysis.VisualPaletteProperty;
        /**
         * The options that determine the presentation of a waterfall visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartconfiguration.html#cfn-quicksight-analysis-waterfallchartconfiguration-waterfallchartoptions
         */
        readonly waterfallChartOptions?: cdk.IResolvable | CfnAnalysis.WaterfallChartOptionsProperty;
    }
    /**
     * The sort configuration of a waterfall visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartsortconfiguration.html
     */
    interface WaterfallChartSortConfigurationProperty {
        /**
         * The limit on the number of bar groups that are displayed.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartsortconfiguration.html#cfn-quicksight-analysis-waterfallchartsortconfiguration-breakdownitemslimit
         */
        readonly breakdownItemsLimit?: cdk.IResolvable | CfnAnalysis.ItemsLimitConfigurationProperty;
        /**
         * The sort configuration of the category fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartsortconfiguration.html#cfn-quicksight-analysis-waterfallchartsortconfiguration-categorysort
         */
        readonly categorySort?: Array<CfnAnalysis.FieldSortOptionsProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The options that determine the presentation of the data labels.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeloptions.html
     */
    interface DataLabelOptionsProperty {
        /**
         * Determines the visibility of the category field labels.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeloptions.html#cfn-quicksight-analysis-datalabeloptions-categorylabelvisibility
         */
        readonly categoryLabelVisibility?: string;
        /**
         * The option that determines the data label type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeloptions.html#cfn-quicksight-analysis-datalabeloptions-datalabeltypes
         */
        readonly dataLabelTypes?: Array<CfnAnalysis.DataLabelTypeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * Determines the color of the data labels.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeloptions.html#cfn-quicksight-analysis-datalabeloptions-labelcolor
         */
        readonly labelColor?: string;
        /**
         * Determines the content of the data labels.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeloptions.html#cfn-quicksight-analysis-datalabeloptions-labelcontent
         */
        readonly labelContent?: string;
        /**
         * Determines the font configuration of the data labels.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeloptions.html#cfn-quicksight-analysis-datalabeloptions-labelfontconfiguration
         */
        readonly labelFontConfiguration?: CfnAnalysis.FontConfigurationProperty | cdk.IResolvable;
        /**
         * Determines the visibility of the measure field labels.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeloptions.html#cfn-quicksight-analysis-datalabeloptions-measurelabelvisibility
         */
        readonly measureLabelVisibility?: string;
        /**
         * Determines whether overlap is enabled or disabled for the data labels.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeloptions.html#cfn-quicksight-analysis-datalabeloptions-overlap
         */
        readonly overlap?: string;
        /**
         * Determines the position of the data labels.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeloptions.html#cfn-quicksight-analysis-datalabeloptions-position
         */
        readonly position?: string;
        /**
         * Determines the visibility of the total.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeloptions.html#cfn-quicksight-analysis-datalabeloptions-totalsvisibility
         */
        readonly totalsVisibility?: string;
        /**
         * Determines the visibility of the data labels.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeloptions.html#cfn-quicksight-analysis-datalabeloptions-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The option that determines the data label type.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeltype.html
     */
    interface DataLabelTypeProperty {
        /**
         * The option that specifies individual data values for labels.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeltype.html#cfn-quicksight-analysis-datalabeltype-datapathlabeltype
         */
        readonly dataPathLabelType?: CfnAnalysis.DataPathLabelTypeProperty | cdk.IResolvable;
        /**
         * Determines the label configuration for the entire field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeltype.html#cfn-quicksight-analysis-datalabeltype-fieldlabeltype
         */
        readonly fieldLabelType?: CfnAnalysis.FieldLabelTypeProperty | cdk.IResolvable;
        /**
         * Determines the label configuration for the maximum value in a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeltype.html#cfn-quicksight-analysis-datalabeltype-maximumlabeltype
         */
        readonly maximumLabelType?: cdk.IResolvable | CfnAnalysis.MaximumLabelTypeProperty;
        /**
         * Determines the label configuration for the minimum value in a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeltype.html#cfn-quicksight-analysis-datalabeltype-minimumlabeltype
         */
        readonly minimumLabelType?: cdk.IResolvable | CfnAnalysis.MinimumLabelTypeProperty;
        /**
         * Determines the label configuration for range end value in a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeltype.html#cfn-quicksight-analysis-datalabeltype-rangeendslabeltype
         */
        readonly rangeEndsLabelType?: cdk.IResolvable | CfnAnalysis.RangeEndsLabelTypeProperty;
    }
    /**
     * The maximum label of a data path label.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-maximumlabeltype.html
     */
    interface MaximumLabelTypeProperty {
        /**
         * The visibility of the maximum label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-maximumlabeltype.html#cfn-quicksight-analysis-maximumlabeltype-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The option that specifies individual data values for labels.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathlabeltype.html
     */
    interface DataPathLabelTypeProperty {
        /**
         * The field ID of the field that the data label needs to be applied to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathlabeltype.html#cfn-quicksight-analysis-datapathlabeltype-fieldid
         */
        readonly fieldId?: string;
        /**
         * The actual value of the field that is labeled.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathlabeltype.html#cfn-quicksight-analysis-datapathlabeltype-fieldvalue
         */
        readonly fieldValue?: string;
        /**
         * The visibility of the data label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathlabeltype.html#cfn-quicksight-analysis-datapathlabeltype-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The range ends label type of a data path label.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-rangeendslabeltype.html
     */
    interface RangeEndsLabelTypeProperty {
        /**
         * The visibility of the range ends label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-rangeendslabeltype.html#cfn-quicksight-analysis-rangeendslabeltype-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The field label type.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldlabeltype.html
     */
    interface FieldLabelTypeProperty {
        /**
         * Indicates the field that is targeted by the field label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldlabeltype.html#cfn-quicksight-analysis-fieldlabeltype-fieldid
         */
        readonly fieldId?: string;
        /**
         * The visibility of the field label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldlabeltype.html#cfn-quicksight-analysis-fieldlabeltype-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The minimum label of a data path label.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-minimumlabeltype.html
     */
    interface MinimumLabelTypeProperty {
        /**
         * The visibility of the minimum label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-minimumlabeltype.html#cfn-quicksight-analysis-minimumlabeltype-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The field well configuration of a waterfall visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartfieldwells.html
     */
    interface WaterfallChartFieldWellsProperty {
        /**
         * The field well configuration of a waterfall visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartfieldwells.html#cfn-quicksight-analysis-waterfallchartfieldwells-waterfallchartaggregatedfieldwells
         */
        readonly waterfallChartAggregatedFieldWells?: cdk.IResolvable | CfnAnalysis.WaterfallChartAggregatedFieldWellsProperty;
    }
    /**
     * The field well configuration of a waterfall visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartaggregatedfieldwells.html
     */
    interface WaterfallChartAggregatedFieldWellsProperty {
        /**
         * The breakdown field wells of a waterfall visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartaggregatedfieldwells.html#cfn-quicksight-analysis-waterfallchartaggregatedfieldwells-breakdowns
         */
        readonly breakdowns?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The category field wells of a waterfall visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartaggregatedfieldwells.html#cfn-quicksight-analysis-waterfallchartaggregatedfieldwells-categories
         */
        readonly categories?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The value field wells of a waterfall visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartaggregatedfieldwells.html#cfn-quicksight-analysis-waterfallchartaggregatedfieldwells-values
         */
        readonly values?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
    }
    /**
     * The options that determine the presentation of a waterfall visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartoptions.html
     */
    interface WaterfallChartOptionsProperty {
        /**
         * This option determines the total bar label of a waterfall visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartoptions.html#cfn-quicksight-analysis-waterfallchartoptions-totalbarlabel
         */
        readonly totalBarLabel?: string;
    }
    /**
     * The color configuration of a waterfall visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartcolorconfiguration.html
     */
    interface WaterfallChartColorConfigurationProperty {
        /**
         * The color configuration for individual groups within a waterfall visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartcolorconfiguration.html#cfn-quicksight-analysis-waterfallchartcolorconfiguration-groupcolorconfiguration
         */
        readonly groupColorConfiguration?: cdk.IResolvable | CfnAnalysis.WaterfallChartGroupColorConfigurationProperty;
    }
    /**
     * The color configuration for individual groups within a waterfall visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartgroupcolorconfiguration.html
     */
    interface WaterfallChartGroupColorConfigurationProperty {
        /**
         * Defines the color for the negative bars of a waterfall chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartgroupcolorconfiguration.html#cfn-quicksight-analysis-waterfallchartgroupcolorconfiguration-negativebarcolor
         */
        readonly negativeBarColor?: string;
        /**
         * Defines the color for the positive bars of a waterfall chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartgroupcolorconfiguration.html#cfn-quicksight-analysis-waterfallchartgroupcolorconfiguration-positivebarcolor
         */
        readonly positiveBarColor?: string;
        /**
         * Defines the color for the total bars of a waterfall chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-waterfallchartgroupcolorconfiguration.html#cfn-quicksight-analysis-waterfallchartgroupcolorconfiguration-totalbarcolor
         */
        readonly totalBarColor?: string;
    }
    /**
     * A visual that contains custom content.
     *
     * For more information, see [Using custom visual content](https://docs.aws.amazon.com/quicksight/latest/user/custom-visual-content.html) in the *Amazon QuickSight User Guide* .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentvisual.html
     */
    interface CustomContentVisualProperty {
        /**
         * The list of custom actions that are configured for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentvisual.html#cfn-quicksight-analysis-customcontentvisual-actions
         */
        readonly actions?: Array<cdk.IResolvable | CfnAnalysis.VisualCustomActionProperty> | cdk.IResolvable;
        /**
         * The configuration of a `CustomContentVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentvisual.html#cfn-quicksight-analysis-customcontentvisual-chartconfiguration
         */
        readonly chartConfiguration?: CfnAnalysis.CustomContentConfigurationProperty | cdk.IResolvable;
        /**
         * The dataset that is used to create the custom content visual.
         *
         * You can't create a visual without a dataset.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentvisual.html#cfn-quicksight-analysis-customcontentvisual-datasetidentifier
         */
        readonly dataSetIdentifier: string;
        /**
         * The subtitle that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentvisual.html#cfn-quicksight-analysis-customcontentvisual-subtitle
         */
        readonly subtitle?: cdk.IResolvable | CfnAnalysis.VisualSubtitleLabelOptionsProperty;
        /**
         * The title that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentvisual.html#cfn-quicksight-analysis-customcontentvisual-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.VisualTitleLabelOptionsProperty;
        /**
         * The alt text for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentvisual.html#cfn-quicksight-analysis-customcontentvisual-visualcontentalttext
         */
        readonly visualContentAltText?: string;
        /**
         * The unique identifier of a visual.
         *
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentvisual.html#cfn-quicksight-analysis-customcontentvisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * The configuration of a `CustomContentVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentconfiguration.html
     */
    interface CustomContentConfigurationProperty {
        /**
         * The content type of the custom content visual.
         *
         * You can use this to have the visual render as an image.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentconfiguration.html#cfn-quicksight-analysis-customcontentconfiguration-contenttype
         */
        readonly contentType?: string;
        /**
         * The input URL that links to the custom content that you want in the custom visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentconfiguration.html#cfn-quicksight-analysis-customcontentconfiguration-contenturl
         */
        readonly contentUrl?: string;
        /**
         * The sizing options for the size of the custom content visual.
         *
         * This structure is required when the `ContentType` of the visual is `'IMAGE'` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentconfiguration.html#cfn-quicksight-analysis-customcontentconfiguration-imagescaling
         */
        readonly imageScaling?: string;
        /**
         * The general visual interactions setup for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentconfiguration.html#cfn-quicksight-analysis-customcontentconfiguration-interactions
         */
        readonly interactions?: cdk.IResolvable | CfnAnalysis.VisualInteractionOptionsProperty;
    }
    /**
     * A pie or donut chart.
     *
     * The `PieChartVisual` structure describes a visual that is a member of the pie chart family.
     *
     * The following charts can be described by using this structure:
     *
     * - Pie charts
     * - Donut charts
     *
     * For more information, see [Using pie charts](https://docs.aws.amazon.com/quicksight/latest/user/pie-chart.html) in the *Amazon QuickSight User Guide* .
     *
     * For more information, see [Using donut charts](https://docs.aws.amazon.com/quicksight/latest/user/donut-chart.html) in the *Amazon QuickSight User Guide* .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartvisual.html
     */
    interface PieChartVisualProperty {
        /**
         * The list of custom actions that are configured for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartvisual.html#cfn-quicksight-analysis-piechartvisual-actions
         */
        readonly actions?: Array<cdk.IResolvable | CfnAnalysis.VisualCustomActionProperty> | cdk.IResolvable;
        /**
         * The configuration of a pie chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartvisual.html#cfn-quicksight-analysis-piechartvisual-chartconfiguration
         */
        readonly chartConfiguration?: cdk.IResolvable | CfnAnalysis.PieChartConfigurationProperty;
        /**
         * The column hierarchy that is used during drill-downs and drill-ups.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartvisual.html#cfn-quicksight-analysis-piechartvisual-columnhierarchies
         */
        readonly columnHierarchies?: Array<CfnAnalysis.ColumnHierarchyProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The subtitle that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartvisual.html#cfn-quicksight-analysis-piechartvisual-subtitle
         */
        readonly subtitle?: cdk.IResolvable | CfnAnalysis.VisualSubtitleLabelOptionsProperty;
        /**
         * The title that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartvisual.html#cfn-quicksight-analysis-piechartvisual-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.VisualTitleLabelOptionsProperty;
        /**
         * The alt text for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartvisual.html#cfn-quicksight-analysis-piechartvisual-visualcontentalttext
         */
        readonly visualContentAltText?: string;
        /**
         * The unique identifier of a visual.
         *
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartvisual.html#cfn-quicksight-analysis-piechartvisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * The configuration of a pie chart.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartconfiguration.html
     */
    interface PieChartConfigurationProperty {
        /**
         * The label options of the group/color that is displayed in a pie chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartconfiguration.html#cfn-quicksight-analysis-piechartconfiguration-categorylabeloptions
         */
        readonly categoryLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The contribution analysis (anomaly configuration) setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartconfiguration.html#cfn-quicksight-analysis-piechartconfiguration-contributionanalysisdefaults
         */
        readonly contributionAnalysisDefaults?: Array<CfnAnalysis.ContributionAnalysisDefaultProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The options that determine if visual data labels are displayed.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartconfiguration.html#cfn-quicksight-analysis-piechartconfiguration-datalabels
         */
        readonly dataLabels?: CfnAnalysis.DataLabelOptionsProperty | cdk.IResolvable;
        /**
         * The options that determine the shape of the chart.
         *
         * This option determines whether the chart is a pie chart or a donut chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartconfiguration.html#cfn-quicksight-analysis-piechartconfiguration-donutoptions
         */
        readonly donutOptions?: CfnAnalysis.DonutOptionsProperty | cdk.IResolvable;
        /**
         * The field wells of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartconfiguration.html#cfn-quicksight-analysis-piechartconfiguration-fieldwells
         */
        readonly fieldWells?: cdk.IResolvable | CfnAnalysis.PieChartFieldWellsProperty;
        /**
         * The general visual interactions setup for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartconfiguration.html#cfn-quicksight-analysis-piechartconfiguration-interactions
         */
        readonly interactions?: cdk.IResolvable | CfnAnalysis.VisualInteractionOptionsProperty;
        /**
         * The legend display setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartconfiguration.html#cfn-quicksight-analysis-piechartconfiguration-legend
         */
        readonly legend?: cdk.IResolvable | CfnAnalysis.LegendOptionsProperty;
        /**
         * The small multiples setup for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartconfiguration.html#cfn-quicksight-analysis-piechartconfiguration-smallmultiplesoptions
         */
        readonly smallMultiplesOptions?: cdk.IResolvable | CfnAnalysis.SmallMultiplesOptionsProperty;
        /**
         * The sort configuration of a pie chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartconfiguration.html#cfn-quicksight-analysis-piechartconfiguration-sortconfiguration
         */
        readonly sortConfiguration?: cdk.IResolvable | CfnAnalysis.PieChartSortConfigurationProperty;
        /**
         * The tooltip display setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartconfiguration.html#cfn-quicksight-analysis-piechartconfiguration-tooltip
         */
        readonly tooltip?: cdk.IResolvable | CfnAnalysis.TooltipOptionsProperty;
        /**
         * The label options for the value that is displayed in a pie chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartconfiguration.html#cfn-quicksight-analysis-piechartconfiguration-valuelabeloptions
         */
        readonly valueLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The palette (chart color) display setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartconfiguration.html#cfn-quicksight-analysis-piechartconfiguration-visualpalette
         */
        readonly visualPalette?: cdk.IResolvable | CfnAnalysis.VisualPaletteProperty;
    }
    /**
     * The sort configuration of a pie chart.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartsortconfiguration.html
     */
    interface PieChartSortConfigurationProperty {
        /**
         * The limit on the number of categories that are displayed in a pie chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartsortconfiguration.html#cfn-quicksight-analysis-piechartsortconfiguration-categoryitemslimit
         */
        readonly categoryItemsLimit?: cdk.IResolvable | CfnAnalysis.ItemsLimitConfigurationProperty;
        /**
         * The sort configuration of the category fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartsortconfiguration.html#cfn-quicksight-analysis-piechartsortconfiguration-categorysort
         */
        readonly categorySort?: Array<CfnAnalysis.FieldSortOptionsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The limit on the number of small multiples panels that are displayed.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartsortconfiguration.html#cfn-quicksight-analysis-piechartsortconfiguration-smallmultipleslimitconfiguration
         */
        readonly smallMultiplesLimitConfiguration?: cdk.IResolvable | CfnAnalysis.ItemsLimitConfigurationProperty;
        /**
         * The sort configuration of the small multiples field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartsortconfiguration.html#cfn-quicksight-analysis-piechartsortconfiguration-smallmultiplessort
         */
        readonly smallMultiplesSort?: Array<CfnAnalysis.FieldSortOptionsProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The contribution analysis visual display for a line, pie, or bar chart.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-contributionanalysisdefault.html
     */
    interface ContributionAnalysisDefaultProperty {
        /**
         * The dimensions columns that are used in the contribution analysis, usually a list of `ColumnIdentifiers` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-contributionanalysisdefault.html#cfn-quicksight-analysis-contributionanalysisdefault-contributordimensions
         */
        readonly contributorDimensions: Array<CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The measure field that is used in the contribution analysis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-contributionanalysisdefault.html#cfn-quicksight-analysis-contributionanalysisdefault-measurefieldid
         */
        readonly measureFieldId: string;
    }
    /**
     * The field well configuration of a pie chart.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartfieldwells.html
     */
    interface PieChartFieldWellsProperty {
        /**
         * The field well configuration of a pie chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartfieldwells.html#cfn-quicksight-analysis-piechartfieldwells-piechartaggregatedfieldwells
         */
        readonly pieChartAggregatedFieldWells?: cdk.IResolvable | CfnAnalysis.PieChartAggregatedFieldWellsProperty;
    }
    /**
     * The field well configuration of a pie chart.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartaggregatedfieldwells.html
     */
    interface PieChartAggregatedFieldWellsProperty {
        /**
         * The category (group/color) field wells of a pie chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartaggregatedfieldwells.html#cfn-quicksight-analysis-piechartaggregatedfieldwells-category
         */
        readonly category?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The small multiples field well of a pie chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartaggregatedfieldwells.html#cfn-quicksight-analysis-piechartaggregatedfieldwells-smallmultiples
         */
        readonly smallMultiples?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The value field wells of a pie chart.
         *
         * Values are aggregated based on categories.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartaggregatedfieldwells.html#cfn-quicksight-analysis-piechartaggregatedfieldwells-values
         */
        readonly values?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
    }
    /**
     * The options for configuring a donut chart or pie chart.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-donutoptions.html
     */
    interface DonutOptionsProperty {
        /**
         * The option for define the arc of the chart shape. Valid values are as follows:.
         *
         * - `WHOLE` - A pie chart
         * - `SMALL` - A small-sized donut chart
         * - `MEDIUM` - A medium-sized donut chart
         * - `LARGE` - A large-sized donut chart
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-donutoptions.html#cfn-quicksight-analysis-donutoptions-arcoptions
         */
        readonly arcOptions?: CfnAnalysis.ArcOptionsProperty | cdk.IResolvable;
        /**
         * The label options of the label that is displayed in the center of a donut chart.
         *
         * This option isn't available for pie charts.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-donutoptions.html#cfn-quicksight-analysis-donutoptions-donutcenteroptions
         */
        readonly donutCenterOptions?: CfnAnalysis.DonutCenterOptionsProperty | cdk.IResolvable;
    }
    /**
     * The label options of the label that is displayed in the center of a donut chart.
     *
     * This option isn't available for pie charts.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-donutcenteroptions.html
     */
    interface DonutCenterOptionsProperty {
        /**
         * Determines the visibility of the label in a donut chart.
         *
         * In the Amazon QuickSight console, this option is called `'Show total'` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-donutcenteroptions.html#cfn-quicksight-analysis-donutcenteroptions-labelvisibility
         */
        readonly labelVisibility?: string;
    }
    /**
     * The options that determine the arc thickness of a `GaugeChartVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcoptions.html
     */
    interface ArcOptionsProperty {
        /**
         * The arc thickness of a `GaugeChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcoptions.html#cfn-quicksight-analysis-arcoptions-arcthickness
         */
        readonly arcThickness?: string;
    }
    /**
     * Options that determine the layout and display options of a chart's small multiples.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-smallmultiplesoptions.html
     */
    interface SmallMultiplesOptionsProperty {
        /**
         * Sets the maximum number of visible columns to display in the grid of small multiples panels.
         *
         * The default is `Auto` , which automatically adjusts the columns in the grid to fit the overall layout and size of the given chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-smallmultiplesoptions.html#cfn-quicksight-analysis-smallmultiplesoptions-maxvisiblecolumns
         */
        readonly maxVisibleColumns?: number;
        /**
         * Sets the maximum number of visible rows to display in the grid of small multiples panels.
         *
         * The default value is `Auto` , which automatically adjusts the rows in the grid to fit the overall layout and size of the given chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-smallmultiplesoptions.html#cfn-quicksight-analysis-smallmultiplesoptions-maxvisiblerows
         */
        readonly maxVisibleRows?: number;
        /**
         * Configures the display options for each small multiples panel.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-smallmultiplesoptions.html#cfn-quicksight-analysis-smallmultiplesoptions-panelconfiguration
         */
        readonly panelConfiguration?: cdk.IResolvable | CfnAnalysis.PanelConfigurationProperty;
        /**
         * The properties of a small multiples X axis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-smallmultiplesoptions.html#cfn-quicksight-analysis-smallmultiplesoptions-xaxis
         */
        readonly xAxis?: cdk.IResolvable | CfnAnalysis.SmallMultiplesAxisPropertiesProperty;
        /**
         * The properties of a small multiples Y axis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-smallmultiplesoptions.html#cfn-quicksight-analysis-smallmultiplesoptions-yaxis
         */
        readonly yAxis?: cdk.IResolvable | CfnAnalysis.SmallMultiplesAxisPropertiesProperty;
    }
    /**
     * A collection of options that configure how each panel displays in a small multiples chart.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-panelconfiguration.html
     */
    interface PanelConfigurationProperty {
        /**
         * Sets the background color for each panel.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-panelconfiguration.html#cfn-quicksight-analysis-panelconfiguration-backgroundcolor
         */
        readonly backgroundColor?: string;
        /**
         * Determines whether or not a background for each small multiples panel is rendered.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-panelconfiguration.html#cfn-quicksight-analysis-panelconfiguration-backgroundvisibility
         */
        readonly backgroundVisibility?: string;
        /**
         * Sets the line color of panel borders.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-panelconfiguration.html#cfn-quicksight-analysis-panelconfiguration-bordercolor
         */
        readonly borderColor?: string;
        /**
         * Sets the line style of panel borders.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-panelconfiguration.html#cfn-quicksight-analysis-panelconfiguration-borderstyle
         */
        readonly borderStyle?: string;
        /**
         * Sets the line thickness of panel borders.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-panelconfiguration.html#cfn-quicksight-analysis-panelconfiguration-borderthickness
         */
        readonly borderThickness?: string;
        /**
         * Determines whether or not each panel displays a border.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-panelconfiguration.html#cfn-quicksight-analysis-panelconfiguration-bordervisibility
         */
        readonly borderVisibility?: string;
        /**
         * Sets the total amount of negative space to display between sibling panels.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-panelconfiguration.html#cfn-quicksight-analysis-panelconfiguration-gutterspacing
         */
        readonly gutterSpacing?: string;
        /**
         * Determines whether or not negative space between sibling panels is rendered.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-panelconfiguration.html#cfn-quicksight-analysis-panelconfiguration-guttervisibility
         */
        readonly gutterVisibility?: string;
        /**
         * Configures the title display within each small multiples panel.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-panelconfiguration.html#cfn-quicksight-analysis-panelconfiguration-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.PanelTitleOptionsProperty;
    }
    /**
     * The options that determine the title styles for each small multiples panel.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-paneltitleoptions.html
     */
    interface PanelTitleOptionsProperty {
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-paneltitleoptions.html#cfn-quicksight-analysis-paneltitleoptions-fontconfiguration
         */
        readonly fontConfiguration?: CfnAnalysis.FontConfigurationProperty | cdk.IResolvable;
        /**
         * Sets the horizontal text alignment of the title within each panel.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-paneltitleoptions.html#cfn-quicksight-analysis-paneltitleoptions-horizontaltextalignment
         */
        readonly horizontalTextAlignment?: string;
        /**
         * Determines whether or not panel titles are displayed.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-paneltitleoptions.html#cfn-quicksight-analysis-paneltitleoptions-visibility
         */
        readonly visibility?: string;
    }
    /**
     * Configures the properties of a chart's axes that are used by small multiples panels.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-smallmultiplesaxisproperties.html
     */
    interface SmallMultiplesAxisPropertiesProperty {
        /**
         * Defines the placement of the axis.
         *
         * By default, axes are rendered `OUTSIDE` of the panels. Axes with `INDEPENDENT` scale are rendered `INSIDE` the panels.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-smallmultiplesaxisproperties.html#cfn-quicksight-analysis-smallmultiplesaxisproperties-placement
         */
        readonly placement?: string;
        /**
         * Determines whether scale of the axes are shared or independent.
         *
         * The default value is `SHARED` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-smallmultiplesaxisproperties.html#cfn-quicksight-analysis-smallmultiplesaxisproperties-scale
         */
        readonly scale?: string;
    }
    /**
     * A key performance indicator (KPI).
     *
     * For more information, see [Using KPIs](https://docs.aws.amazon.com/quicksight/latest/user/kpi.html) in the *Amazon QuickSight User Guide* .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpivisual.html
     */
    interface KPIVisualProperty {
        /**
         * The list of custom actions that are configured for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpivisual.html#cfn-quicksight-analysis-kpivisual-actions
         */
        readonly actions?: Array<cdk.IResolvable | CfnAnalysis.VisualCustomActionProperty> | cdk.IResolvable;
        /**
         * The configuration of a KPI visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpivisual.html#cfn-quicksight-analysis-kpivisual-chartconfiguration
         */
        readonly chartConfiguration?: cdk.IResolvable | CfnAnalysis.KPIConfigurationProperty;
        /**
         * The column hierarchy that is used during drill-downs and drill-ups.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpivisual.html#cfn-quicksight-analysis-kpivisual-columnhierarchies
         */
        readonly columnHierarchies?: Array<CfnAnalysis.ColumnHierarchyProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The conditional formatting of a KPI visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpivisual.html#cfn-quicksight-analysis-kpivisual-conditionalformatting
         */
        readonly conditionalFormatting?: cdk.IResolvable | CfnAnalysis.KPIConditionalFormattingProperty;
        /**
         * The subtitle that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpivisual.html#cfn-quicksight-analysis-kpivisual-subtitle
         */
        readonly subtitle?: cdk.IResolvable | CfnAnalysis.VisualSubtitleLabelOptionsProperty;
        /**
         * The title that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpivisual.html#cfn-quicksight-analysis-kpivisual-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.VisualTitleLabelOptionsProperty;
        /**
         * The alt text for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpivisual.html#cfn-quicksight-analysis-kpivisual-visualcontentalttext
         */
        readonly visualContentAltText?: string;
        /**
         * The unique identifier of a visual.
         *
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpivisual.html#cfn-quicksight-analysis-kpivisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * The conditional formatting of a KPI visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiconditionalformatting.html
     */
    interface KPIConditionalFormattingProperty {
        /**
         * The conditional formatting options of a KPI visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiconditionalformatting.html#cfn-quicksight-analysis-kpiconditionalformatting-conditionalformattingoptions
         */
        readonly conditionalFormattingOptions?: Array<cdk.IResolvable | CfnAnalysis.KPIConditionalFormattingOptionProperty> | cdk.IResolvable;
    }
    /**
     * The conditional formatting options of a KPI visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiconditionalformattingoption.html
     */
    interface KPIConditionalFormattingOptionProperty {
        /**
         * The conditional formatting for the actual value of a KPI visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiconditionalformattingoption.html#cfn-quicksight-analysis-kpiconditionalformattingoption-actualvalue
         */
        readonly actualValue?: cdk.IResolvable | CfnAnalysis.KPIActualValueConditionalFormattingProperty;
        /**
         * The conditional formatting for the comparison value of a KPI visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiconditionalformattingoption.html#cfn-quicksight-analysis-kpiconditionalformattingoption-comparisonvalue
         */
        readonly comparisonValue?: cdk.IResolvable | CfnAnalysis.KPIComparisonValueConditionalFormattingProperty;
        /**
         * The conditional formatting for the primary value of a KPI visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiconditionalformattingoption.html#cfn-quicksight-analysis-kpiconditionalformattingoption-primaryvalue
         */
        readonly primaryValue?: cdk.IResolvable | CfnAnalysis.KPIPrimaryValueConditionalFormattingProperty;
        /**
         * The conditional formatting for the progress bar of a KPI visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiconditionalformattingoption.html#cfn-quicksight-analysis-kpiconditionalformattingoption-progressbar
         */
        readonly progressBar?: cdk.IResolvable | CfnAnalysis.KPIProgressBarConditionalFormattingProperty;
    }
    /**
     * The conditional formatting for the primary value of a KPI visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiprimaryvalueconditionalformatting.html
     */
    interface KPIPrimaryValueConditionalFormattingProperty {
        /**
         * The conditional formatting of the primary value's icon.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiprimaryvalueconditionalformatting.html#cfn-quicksight-analysis-kpiprimaryvalueconditionalformatting-icon
         */
        readonly icon?: CfnAnalysis.ConditionalFormattingIconProperty | cdk.IResolvable;
        /**
         * The conditional formatting of the primary value's text color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiprimaryvalueconditionalformatting.html#cfn-quicksight-analysis-kpiprimaryvalueconditionalformatting-textcolor
         */
        readonly textColor?: CfnAnalysis.ConditionalFormattingColorProperty | cdk.IResolvable;
    }
    /**
     * The formatting configuration for the icon.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingicon.html
     */
    interface ConditionalFormattingIconProperty {
        /**
         * Determines the custom condition for an icon set.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingicon.html#cfn-quicksight-analysis-conditionalformattingicon-customcondition
         */
        readonly customCondition?: CfnAnalysis.ConditionalFormattingCustomIconConditionProperty | cdk.IResolvable;
        /**
         * Formatting configuration for icon set.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingicon.html#cfn-quicksight-analysis-conditionalformattingicon-iconset
         */
        readonly iconSet?: CfnAnalysis.ConditionalFormattingIconSetProperty | cdk.IResolvable;
    }
    /**
     * Determines the custom condition for an icon set.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcustomiconcondition.html
     */
    interface ConditionalFormattingCustomIconConditionProperty {
        /**
         * Determines the color of the icon.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcustomiconcondition.html#cfn-quicksight-analysis-conditionalformattingcustomiconcondition-color
         */
        readonly color?: string;
        /**
         * Determines the icon display configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcustomiconcondition.html#cfn-quicksight-analysis-conditionalformattingcustomiconcondition-displayconfiguration
         */
        readonly displayConfiguration?: CfnAnalysis.ConditionalFormattingIconDisplayConfigurationProperty | cdk.IResolvable;
        /**
         * The expression that determines the condition of the icon set.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcustomiconcondition.html#cfn-quicksight-analysis-conditionalformattingcustomiconcondition-expression
         */
        readonly expression: string;
        /**
         * Custom icon options for an icon set.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcustomiconcondition.html#cfn-quicksight-analysis-conditionalformattingcustomiconcondition-iconoptions
         */
        readonly iconOptions: CfnAnalysis.ConditionalFormattingCustomIconOptionsProperty | cdk.IResolvable;
    }
    /**
     * Determines the icon display configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingicondisplayconfiguration.html
     */
    interface ConditionalFormattingIconDisplayConfigurationProperty {
        /**
         * Determines the icon display configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingicondisplayconfiguration.html#cfn-quicksight-analysis-conditionalformattingicondisplayconfiguration-icondisplayoption
         */
        readonly iconDisplayOption?: string;
    }
    /**
     * Custom icon options for an icon set.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcustomiconoptions.html
     */
    interface ConditionalFormattingCustomIconOptionsProperty {
        /**
         * Determines the type of icon.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcustomiconoptions.html#cfn-quicksight-analysis-conditionalformattingcustomiconoptions-icon
         */
        readonly icon?: string;
        /**
         * Determines the Unicode icon type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcustomiconoptions.html#cfn-quicksight-analysis-conditionalformattingcustomiconoptions-unicodeicon
         */
        readonly unicodeIcon?: string;
    }
    /**
     * Formatting configuration for icon set.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingiconset.html
     */
    interface ConditionalFormattingIconSetProperty {
        /**
         * The expression that determines the formatting configuration for the icon set.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingiconset.html#cfn-quicksight-analysis-conditionalformattingiconset-expression
         */
        readonly expression: string;
        /**
         * Determines the icon set type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingiconset.html#cfn-quicksight-analysis-conditionalformattingiconset-iconsettype
         */
        readonly iconSetType?: string;
    }
    /**
     * The conditional formatting for the actual value of a KPI visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiactualvalueconditionalformatting.html
     */
    interface KPIActualValueConditionalFormattingProperty {
        /**
         * The conditional formatting of the actual value's icon.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiactualvalueconditionalformatting.html#cfn-quicksight-analysis-kpiactualvalueconditionalformatting-icon
         */
        readonly icon?: CfnAnalysis.ConditionalFormattingIconProperty | cdk.IResolvable;
        /**
         * The conditional formatting of the actual value's text color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiactualvalueconditionalformatting.html#cfn-quicksight-analysis-kpiactualvalueconditionalformatting-textcolor
         */
        readonly textColor?: CfnAnalysis.ConditionalFormattingColorProperty | cdk.IResolvable;
    }
    /**
     * The conditional formatting for the comparison value of a KPI visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpicomparisonvalueconditionalformatting.html
     */
    interface KPIComparisonValueConditionalFormattingProperty {
        /**
         * The conditional formatting of the comparison value's icon.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpicomparisonvalueconditionalformatting.html#cfn-quicksight-analysis-kpicomparisonvalueconditionalformatting-icon
         */
        readonly icon?: CfnAnalysis.ConditionalFormattingIconProperty | cdk.IResolvable;
        /**
         * The conditional formatting of the comparison value's text color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpicomparisonvalueconditionalformatting.html#cfn-quicksight-analysis-kpicomparisonvalueconditionalformatting-textcolor
         */
        readonly textColor?: CfnAnalysis.ConditionalFormattingColorProperty | cdk.IResolvable;
    }
    /**
     * The conditional formatting for the progress bar of a KPI visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiprogressbarconditionalformatting.html
     */
    interface KPIProgressBarConditionalFormattingProperty {
        /**
         * The conditional formatting of the progress bar's foreground color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiprogressbarconditionalformatting.html#cfn-quicksight-analysis-kpiprogressbarconditionalformatting-foregroundcolor
         */
        readonly foregroundColor?: CfnAnalysis.ConditionalFormattingColorProperty | cdk.IResolvable;
    }
    /**
     * The configuration of a KPI visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiconfiguration.html
     */
    interface KPIConfigurationProperty {
        /**
         * The field well configuration of a KPI visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiconfiguration.html#cfn-quicksight-analysis-kpiconfiguration-fieldwells
         */
        readonly fieldWells?: cdk.IResolvable | CfnAnalysis.KPIFieldWellsProperty;
        /**
         * The general visual interactions setup for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiconfiguration.html#cfn-quicksight-analysis-kpiconfiguration-interactions
         */
        readonly interactions?: cdk.IResolvable | CfnAnalysis.VisualInteractionOptionsProperty;
        /**
         * The options that determine the presentation of a KPI visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiconfiguration.html#cfn-quicksight-analysis-kpiconfiguration-kpioptions
         */
        readonly kpiOptions?: cdk.IResolvable | CfnAnalysis.KPIOptionsProperty;
        /**
         * The sort configuration of a KPI visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiconfiguration.html#cfn-quicksight-analysis-kpiconfiguration-sortconfiguration
         */
        readonly sortConfiguration?: cdk.IResolvable | CfnAnalysis.KPISortConfigurationProperty;
    }
    /**
     * The sort configuration of a KPI visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpisortconfiguration.html
     */
    interface KPISortConfigurationProperty {
        /**
         * The sort configuration of the trend group fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpisortconfiguration.html#cfn-quicksight-analysis-kpisortconfiguration-trendgroupsort
         */
        readonly trendGroupSort?: Array<CfnAnalysis.FieldSortOptionsProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The options that determine the presentation of a KPI visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpioptions.html
     */
    interface KPIOptionsProperty {
        /**
         * The comparison configuration of a KPI visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpioptions.html#cfn-quicksight-analysis-kpioptions-comparison
         */
        readonly comparison?: CfnAnalysis.ComparisonConfigurationProperty | cdk.IResolvable;
        /**
         * The options that determine the primary value display type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpioptions.html#cfn-quicksight-analysis-kpioptions-primaryvaluedisplaytype
         */
        readonly primaryValueDisplayType?: string;
        /**
         * The options that determine the primary value font configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpioptions.html#cfn-quicksight-analysis-kpioptions-primaryvaluefontconfiguration
         */
        readonly primaryValueFontConfiguration?: CfnAnalysis.FontConfigurationProperty | cdk.IResolvable;
        /**
         * The options that determine the presentation of the progress bar of a KPI visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpioptions.html#cfn-quicksight-analysis-kpioptions-progressbar
         */
        readonly progressBar?: cdk.IResolvable | CfnAnalysis.ProgressBarOptionsProperty;
        /**
         * The options that determine the presentation of the secondary value of a KPI visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpioptions.html#cfn-quicksight-analysis-kpioptions-secondaryvalue
         */
        readonly secondaryValue?: cdk.IResolvable | CfnAnalysis.SecondaryValueOptionsProperty;
        /**
         * The options that determine the secondary value font configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpioptions.html#cfn-quicksight-analysis-kpioptions-secondaryvaluefontconfiguration
         */
        readonly secondaryValueFontConfiguration?: CfnAnalysis.FontConfigurationProperty | cdk.IResolvable;
        /**
         * The options that determine the visibility, color, type, and tooltip visibility of the sparkline of a KPI visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpioptions.html#cfn-quicksight-analysis-kpioptions-sparkline
         */
        readonly sparkline?: cdk.IResolvable | CfnAnalysis.KPISparklineOptionsProperty;
        /**
         * The options that determine the presentation of trend arrows in a KPI visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpioptions.html#cfn-quicksight-analysis-kpioptions-trendarrows
         */
        readonly trendArrows?: cdk.IResolvable | CfnAnalysis.TrendArrowOptionsProperty;
        /**
         * The options that determine the layout a KPI visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpioptions.html#cfn-quicksight-analysis-kpioptions-visuallayoutoptions
         */
        readonly visualLayoutOptions?: cdk.IResolvable | CfnAnalysis.KPIVisualLayoutOptionsProperty;
    }
    /**
     * The options that determine the layout a KPI visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpivisuallayoutoptions.html
     */
    interface KPIVisualLayoutOptionsProperty {
        /**
         * The standard layout of the KPI visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpivisuallayoutoptions.html#cfn-quicksight-analysis-kpivisuallayoutoptions-standardlayout
         */
        readonly standardLayout?: cdk.IResolvable | CfnAnalysis.KPIVisualStandardLayoutProperty;
    }
    /**
     * The standard layout of the KPI visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpivisualstandardlayout.html
     */
    interface KPIVisualStandardLayoutProperty {
        /**
         * The standard layout type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpivisualstandardlayout.html#cfn-quicksight-analysis-kpivisualstandardlayout-type
         */
        readonly type: string;
    }
    /**
     * The options that determine the presentation of trend arrows in a KPI visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-trendarrowoptions.html
     */
    interface TrendArrowOptionsProperty {
        /**
         * The visibility of the trend arrows.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-trendarrowoptions.html#cfn-quicksight-analysis-trendarrowoptions-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The options that determine the presentation of the secondary value of a KPI visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-secondaryvalueoptions.html
     */
    interface SecondaryValueOptionsProperty {
        /**
         * Determines the visibility of the secondary value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-secondaryvalueoptions.html#cfn-quicksight-analysis-secondaryvalueoptions-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The comparison display configuration of a KPI or gauge chart.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-comparisonconfiguration.html
     */
    interface ComparisonConfigurationProperty {
        /**
         * The format of the comparison.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-comparisonconfiguration.html#cfn-quicksight-analysis-comparisonconfiguration-comparisonformat
         */
        readonly comparisonFormat?: CfnAnalysis.ComparisonFormatConfigurationProperty | cdk.IResolvable;
        /**
         * The method of the comparison. Choose from the following options:.
         *
         * - `DIFFERENCE`
         * - `PERCENT_DIFFERENCE`
         * - `PERCENT`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-comparisonconfiguration.html#cfn-quicksight-analysis-comparisonconfiguration-comparisonmethod
         */
        readonly comparisonMethod?: string;
    }
    /**
     * The format of the comparison.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-comparisonformatconfiguration.html
     */
    interface ComparisonFormatConfigurationProperty {
        /**
         * The number display format.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-comparisonformatconfiguration.html#cfn-quicksight-analysis-comparisonformatconfiguration-numberdisplayformatconfiguration
         */
        readonly numberDisplayFormatConfiguration?: cdk.IResolvable | CfnAnalysis.NumberDisplayFormatConfigurationProperty;
        /**
         * The percentage display format.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-comparisonformatconfiguration.html#cfn-quicksight-analysis-comparisonformatconfiguration-percentagedisplayformatconfiguration
         */
        readonly percentageDisplayFormatConfiguration?: cdk.IResolvable | CfnAnalysis.PercentageDisplayFormatConfigurationProperty;
    }
    /**
     * The options that determine the presentation of the progress bar of a KPI visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-progressbaroptions.html
     */
    interface ProgressBarOptionsProperty {
        /**
         * The visibility of the progress bar.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-progressbaroptions.html#cfn-quicksight-analysis-progressbaroptions-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The options that determine the visibility, color, type, and tooltip visibility of the sparkline of a KPI visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpisparklineoptions.html
     */
    interface KPISparklineOptionsProperty {
        /**
         * The color of the sparkline.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpisparklineoptions.html#cfn-quicksight-analysis-kpisparklineoptions-color
         */
        readonly color?: string;
        /**
         * The tooltip visibility of the sparkline.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpisparklineoptions.html#cfn-quicksight-analysis-kpisparklineoptions-tooltipvisibility
         */
        readonly tooltipVisibility?: string;
        /**
         * The type of the sparkline.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpisparklineoptions.html#cfn-quicksight-analysis-kpisparklineoptions-type
         */
        readonly type: string;
        /**
         * The visibility of the sparkline.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpisparklineoptions.html#cfn-quicksight-analysis-kpisparklineoptions-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The field well configuration of a KPI visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpifieldwells.html
     */
    interface KPIFieldWellsProperty {
        /**
         * The target value field wells of a KPI visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpifieldwells.html#cfn-quicksight-analysis-kpifieldwells-targetvalues
         */
        readonly targetValues?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
        /**
         * The trend group field wells of a KPI visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpifieldwells.html#cfn-quicksight-analysis-kpifieldwells-trendgroups
         */
        readonly trendGroups?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The value field wells of a KPI visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpifieldwells.html#cfn-quicksight-analysis-kpifieldwells-values
         */
        readonly values?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
    }
    /**
     * A histogram.
     *
     * For more information, see [Using histograms](https://docs.aws.amazon.com/quicksight/latest/user/histogram-charts.html) in the *Amazon QuickSight User Guide* .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramvisual.html
     */
    interface HistogramVisualProperty {
        /**
         * The list of custom actions that are configured for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramvisual.html#cfn-quicksight-analysis-histogramvisual-actions
         */
        readonly actions?: Array<cdk.IResolvable | CfnAnalysis.VisualCustomActionProperty> | cdk.IResolvable;
        /**
         * The configuration for a `HistogramVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramvisual.html#cfn-quicksight-analysis-histogramvisual-chartconfiguration
         */
        readonly chartConfiguration?: CfnAnalysis.HistogramConfigurationProperty | cdk.IResolvable;
        /**
         * The subtitle that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramvisual.html#cfn-quicksight-analysis-histogramvisual-subtitle
         */
        readonly subtitle?: cdk.IResolvable | CfnAnalysis.VisualSubtitleLabelOptionsProperty;
        /**
         * The title that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramvisual.html#cfn-quicksight-analysis-histogramvisual-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.VisualTitleLabelOptionsProperty;
        /**
         * The alt text for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramvisual.html#cfn-quicksight-analysis-histogramvisual-visualcontentalttext
         */
        readonly visualContentAltText?: string;
        /**
         * The unique identifier of a visual.
         *
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramvisual.html#cfn-quicksight-analysis-histogramvisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * The configuration for a `HistogramVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramconfiguration.html
     */
    interface HistogramConfigurationProperty {
        /**
         * The options that determine the presentation of histogram bins.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramconfiguration.html#cfn-quicksight-analysis-histogramconfiguration-binoptions
         */
        readonly binOptions?: CfnAnalysis.HistogramBinOptionsProperty | cdk.IResolvable;
        /**
         * The data label configuration of a histogram.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramconfiguration.html#cfn-quicksight-analysis-histogramconfiguration-datalabels
         */
        readonly dataLabels?: CfnAnalysis.DataLabelOptionsProperty | cdk.IResolvable;
        /**
         * The field well configuration of a histogram.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramconfiguration.html#cfn-quicksight-analysis-histogramconfiguration-fieldwells
         */
        readonly fieldWells?: CfnAnalysis.HistogramFieldWellsProperty | cdk.IResolvable;
        /**
         * The general visual interactions setup for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramconfiguration.html#cfn-quicksight-analysis-histogramconfiguration-interactions
         */
        readonly interactions?: cdk.IResolvable | CfnAnalysis.VisualInteractionOptionsProperty;
        /**
         * The tooltip configuration of a histogram.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramconfiguration.html#cfn-quicksight-analysis-histogramconfiguration-tooltip
         */
        readonly tooltip?: cdk.IResolvable | CfnAnalysis.TooltipOptionsProperty;
        /**
         * The visual palette configuration of a histogram.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramconfiguration.html#cfn-quicksight-analysis-histogramconfiguration-visualpalette
         */
        readonly visualPalette?: cdk.IResolvable | CfnAnalysis.VisualPaletteProperty;
        /**
         * The options that determine the presentation of the x-axis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramconfiguration.html#cfn-quicksight-analysis-histogramconfiguration-xaxisdisplayoptions
         */
        readonly xAxisDisplayOptions?: CfnAnalysis.AxisDisplayOptionsProperty | cdk.IResolvable;
        /**
         * The options that determine the presentation of the x-axis label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramconfiguration.html#cfn-quicksight-analysis-histogramconfiguration-xaxislabeloptions
         */
        readonly xAxisLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The options that determine the presentation of the y-axis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramconfiguration.html#cfn-quicksight-analysis-histogramconfiguration-yaxisdisplayoptions
         */
        readonly yAxisDisplayOptions?: CfnAnalysis.AxisDisplayOptionsProperty | cdk.IResolvable;
    }
    /**
     * The options that determine the presentation of histogram bins.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogrambinoptions.html
     */
    interface HistogramBinOptionsProperty {
        /**
         * The options that determine the bin count of a histogram.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogrambinoptions.html#cfn-quicksight-analysis-histogrambinoptions-bincount
         */
        readonly binCount?: CfnAnalysis.BinCountOptionsProperty | cdk.IResolvable;
        /**
         * The options that determine the bin width of a histogram.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogrambinoptions.html#cfn-quicksight-analysis-histogrambinoptions-binwidth
         */
        readonly binWidth?: CfnAnalysis.BinWidthOptionsProperty | cdk.IResolvable;
        /**
         * The options that determine the selected bin type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogrambinoptions.html#cfn-quicksight-analysis-histogrambinoptions-selectedbintype
         */
        readonly selectedBinType?: string;
        /**
         * The options that determine the bin start value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogrambinoptions.html#cfn-quicksight-analysis-histogrambinoptions-startvalue
         */
        readonly startValue?: number;
    }
    /**
     * The options that determine the bin width of a histogram.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-binwidthoptions.html
     */
    interface BinWidthOptionsProperty {
        /**
         * The options that determine the bin count limit.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-binwidthoptions.html#cfn-quicksight-analysis-binwidthoptions-bincountlimit
         */
        readonly binCountLimit?: number;
        /**
         * The options that determine the bin width value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-binwidthoptions.html#cfn-quicksight-analysis-binwidthoptions-value
         */
        readonly value?: number;
    }
    /**
     * The options that determine the bin count of a histogram.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bincountoptions.html
     */
    interface BinCountOptionsProperty {
        /**
         * The options that determine the bin count value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bincountoptions.html#cfn-quicksight-analysis-bincountoptions-value
         */
        readonly value?: number;
    }
    /**
     * The field well configuration of a histogram.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramfieldwells.html
     */
    interface HistogramFieldWellsProperty {
        /**
         * The field well configuration of a histogram.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramfieldwells.html#cfn-quicksight-analysis-histogramfieldwells-histogramaggregatedfieldwells
         */
        readonly histogramAggregatedFieldWells?: CfnAnalysis.HistogramAggregatedFieldWellsProperty | cdk.IResolvable;
    }
    /**
     * The field well configuration of a histogram.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramaggregatedfieldwells.html
     */
    interface HistogramAggregatedFieldWellsProperty {
        /**
         * The value field wells of a histogram.
         *
         * Values are aggregated by `COUNT` or `DISTINCT_COUNT` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramaggregatedfieldwells.html#cfn-quicksight-analysis-histogramaggregatedfieldwells-values
         */
        readonly values?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
    }
    /**
     * A table visual.
     *
     * For more information, see [Using tables as visuals](https://docs.aws.amazon.com/quicksight/latest/user/tabular.html) in the *Amazon QuickSight User Guide* .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablevisual.html
     */
    interface TableVisualProperty {
        /**
         * The list of custom actions that are configured for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablevisual.html#cfn-quicksight-analysis-tablevisual-actions
         */
        readonly actions?: Array<cdk.IResolvable | CfnAnalysis.VisualCustomActionProperty> | cdk.IResolvable;
        /**
         * The configuration settings of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablevisual.html#cfn-quicksight-analysis-tablevisual-chartconfiguration
         */
        readonly chartConfiguration?: cdk.IResolvable | CfnAnalysis.TableConfigurationProperty;
        /**
         * The conditional formatting for a `PivotTableVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablevisual.html#cfn-quicksight-analysis-tablevisual-conditionalformatting
         */
        readonly conditionalFormatting?: cdk.IResolvable | CfnAnalysis.TableConditionalFormattingProperty;
        /**
         * The subtitle that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablevisual.html#cfn-quicksight-analysis-tablevisual-subtitle
         */
        readonly subtitle?: cdk.IResolvable | CfnAnalysis.VisualSubtitleLabelOptionsProperty;
        /**
         * The title that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablevisual.html#cfn-quicksight-analysis-tablevisual-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.VisualTitleLabelOptionsProperty;
        /**
         * The alt text for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablevisual.html#cfn-quicksight-analysis-tablevisual-visualcontentalttext
         */
        readonly visualContentAltText?: string;
        /**
         * The unique identifier of a visual.
         *
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers..
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablevisual.html#cfn-quicksight-analysis-tablevisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * The conditional formatting for a `PivotTableVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableconditionalformatting.html
     */
    interface TableConditionalFormattingProperty {
        /**
         * Conditional formatting options for a `PivotTableVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableconditionalformatting.html#cfn-quicksight-analysis-tableconditionalformatting-conditionalformattingoptions
         */
        readonly conditionalFormattingOptions?: Array<cdk.IResolvable | CfnAnalysis.TableConditionalFormattingOptionProperty> | cdk.IResolvable;
    }
    /**
     * Conditional formatting options for a `PivotTableVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableconditionalformattingoption.html
     */
    interface TableConditionalFormattingOptionProperty {
        /**
         * The cell conditional formatting option for a table.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableconditionalformattingoption.html#cfn-quicksight-analysis-tableconditionalformattingoption-cell
         */
        readonly cell?: cdk.IResolvable | CfnAnalysis.TableCellConditionalFormattingProperty;
        /**
         * The row conditional formatting option for a table.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableconditionalformattingoption.html#cfn-quicksight-analysis-tableconditionalformattingoption-row
         */
        readonly row?: cdk.IResolvable | CfnAnalysis.TableRowConditionalFormattingProperty;
    }
    /**
     * The conditional formatting of a table row.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablerowconditionalformatting.html
     */
    interface TableRowConditionalFormattingProperty {
        /**
         * The conditional formatting color (solid, gradient) of the background for a table row.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablerowconditionalformatting.html#cfn-quicksight-analysis-tablerowconditionalformatting-backgroundcolor
         */
        readonly backgroundColor?: CfnAnalysis.ConditionalFormattingColorProperty | cdk.IResolvable;
        /**
         * The conditional formatting color (solid, gradient) of the text for a table row.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablerowconditionalformatting.html#cfn-quicksight-analysis-tablerowconditionalformatting-textcolor
         */
        readonly textColor?: CfnAnalysis.ConditionalFormattingColorProperty | cdk.IResolvable;
    }
    /**
     * The cell conditional formatting option for a table.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablecellconditionalformatting.html
     */
    interface TableCellConditionalFormattingProperty {
        /**
         * The field ID of the cell for conditional formatting.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablecellconditionalformatting.html#cfn-quicksight-analysis-tablecellconditionalformatting-fieldid
         */
        readonly fieldId: string;
        /**
         * The text format of the cell for conditional formatting.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablecellconditionalformatting.html#cfn-quicksight-analysis-tablecellconditionalformatting-textformat
         */
        readonly textFormat?: cdk.IResolvable | CfnAnalysis.TextConditionalFormatProperty;
    }
    /**
     * The conditional formatting for the text.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-textconditionalformat.html
     */
    interface TextConditionalFormatProperty {
        /**
         * The conditional formatting for the text background color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-textconditionalformat.html#cfn-quicksight-analysis-textconditionalformat-backgroundcolor
         */
        readonly backgroundColor?: CfnAnalysis.ConditionalFormattingColorProperty | cdk.IResolvable;
        /**
         * The conditional formatting for the icon.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-textconditionalformat.html#cfn-quicksight-analysis-textconditionalformat-icon
         */
        readonly icon?: CfnAnalysis.ConditionalFormattingIconProperty | cdk.IResolvable;
        /**
         * The conditional formatting for the text color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-textconditionalformat.html#cfn-quicksight-analysis-textconditionalformat-textcolor
         */
        readonly textColor?: CfnAnalysis.ConditionalFormattingColorProperty | cdk.IResolvable;
    }
    /**
     * The configuration for a `TableVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableconfiguration.html
     */
    interface TableConfigurationProperty {
        /**
         * The field options for a table visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableconfiguration.html#cfn-quicksight-analysis-tableconfiguration-fieldoptions
         */
        readonly fieldOptions?: cdk.IResolvable | CfnAnalysis.TableFieldOptionsProperty;
        /**
         * The field wells of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableconfiguration.html#cfn-quicksight-analysis-tableconfiguration-fieldwells
         */
        readonly fieldWells?: cdk.IResolvable | CfnAnalysis.TableFieldWellsProperty;
        /**
         * The general visual interactions setup for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableconfiguration.html#cfn-quicksight-analysis-tableconfiguration-interactions
         */
        readonly interactions?: cdk.IResolvable | CfnAnalysis.VisualInteractionOptionsProperty;
        /**
         * The paginated report options for a table visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableconfiguration.html#cfn-quicksight-analysis-tableconfiguration-paginatedreportoptions
         */
        readonly paginatedReportOptions?: cdk.IResolvable | CfnAnalysis.TablePaginatedReportOptionsProperty;
        /**
         * The sort configuration for a `TableVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableconfiguration.html#cfn-quicksight-analysis-tableconfiguration-sortconfiguration
         */
        readonly sortConfiguration?: cdk.IResolvable | CfnAnalysis.TableSortConfigurationProperty;
        /**
         * A collection of inline visualizations to display within a chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableconfiguration.html#cfn-quicksight-analysis-tableconfiguration-tableinlinevisualizations
         */
        readonly tableInlineVisualizations?: Array<cdk.IResolvable | CfnAnalysis.TableInlineVisualizationProperty> | cdk.IResolvable;
        /**
         * The table options for a table visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableconfiguration.html#cfn-quicksight-analysis-tableconfiguration-tableoptions
         */
        readonly tableOptions?: cdk.IResolvable | CfnAnalysis.TableOptionsProperty;
        /**
         * The total options for a table visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableconfiguration.html#cfn-quicksight-analysis-tableconfiguration-totaloptions
         */
        readonly totalOptions?: cdk.IResolvable | CfnAnalysis.TotalOptionsProperty;
    }
    /**
     * The sort configuration for a `TableVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablesortconfiguration.html
     */
    interface TableSortConfigurationProperty {
        /**
         * The pagination configuration (page size, page number) for the table.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablesortconfiguration.html#cfn-quicksight-analysis-tablesortconfiguration-paginationconfiguration
         */
        readonly paginationConfiguration?: cdk.IResolvable | CfnAnalysis.PaginationConfigurationProperty;
        /**
         * The field sort options for rows in the table.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablesortconfiguration.html#cfn-quicksight-analysis-tablesortconfiguration-rowsort
         */
        readonly rowSort?: Array<CfnAnalysis.FieldSortOptionsProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The paginated report options for a table visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablepaginatedreportoptions.html
     */
    interface TablePaginatedReportOptionsProperty {
        /**
         * The visibility of repeating header rows on each page.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablepaginatedreportoptions.html#cfn-quicksight-analysis-tablepaginatedreportoptions-overflowcolumnheadervisibility
         */
        readonly overflowColumnHeaderVisibility?: string;
        /**
         * The visibility of printing table overflow across pages.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablepaginatedreportoptions.html#cfn-quicksight-analysis-tablepaginatedreportoptions-verticaloverflowvisibility
         */
        readonly verticalOverflowVisibility?: string;
    }
    /**
     * The table options for a table visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableoptions.html
     */
    interface TableOptionsProperty {
        /**
         * The table cell style of table cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableoptions.html#cfn-quicksight-analysis-tableoptions-cellstyle
         */
        readonly cellStyle?: cdk.IResolvable | CfnAnalysis.TableCellStyleProperty;
        /**
         * The table cell style of a table header.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableoptions.html#cfn-quicksight-analysis-tableoptions-headerstyle
         */
        readonly headerStyle?: cdk.IResolvable | CfnAnalysis.TableCellStyleProperty;
        /**
         * The orientation (vertical, horizontal) for a table.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableoptions.html#cfn-quicksight-analysis-tableoptions-orientation
         */
        readonly orientation?: string;
        /**
         * The row alternate color options (widget status, row alternate colors) for a table.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableoptions.html#cfn-quicksight-analysis-tableoptions-rowalternatecoloroptions
         */
        readonly rowAlternateColorOptions?: cdk.IResolvable | CfnAnalysis.RowAlternateColorOptionsProperty;
    }
    /**
     * The table cell style for a cell in pivot table or table visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablecellstyle.html
     */
    interface TableCellStyleProperty {
        /**
         * The background color for the table cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablecellstyle.html#cfn-quicksight-analysis-tablecellstyle-backgroundcolor
         */
        readonly backgroundColor?: string;
        /**
         * The borders for the table cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablecellstyle.html#cfn-quicksight-analysis-tablecellstyle-border
         */
        readonly border?: CfnAnalysis.GlobalTableBorderOptionsProperty | cdk.IResolvable;
        /**
         * The font configuration of the table cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablecellstyle.html#cfn-quicksight-analysis-tablecellstyle-fontconfiguration
         */
        readonly fontConfiguration?: CfnAnalysis.FontConfigurationProperty | cdk.IResolvable;
        /**
         * The height color for the table cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablecellstyle.html#cfn-quicksight-analysis-tablecellstyle-height
         */
        readonly height?: number;
        /**
         * The horizontal text alignment (left, center, right, auto) for the table cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablecellstyle.html#cfn-quicksight-analysis-tablecellstyle-horizontaltextalignment
         */
        readonly horizontalTextAlignment?: string;
        /**
         * The text wrap (none, wrap) for the table cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablecellstyle.html#cfn-quicksight-analysis-tablecellstyle-textwrap
         */
        readonly textWrap?: string;
        /**
         * The vertical text alignment (top, middle, bottom) for the table cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablecellstyle.html#cfn-quicksight-analysis-tablecellstyle-verticaltextalignment
         */
        readonly verticalTextAlignment?: string;
        /**
         * The visibility of the table cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablecellstyle.html#cfn-quicksight-analysis-tablecellstyle-visibility
         */
        readonly visibility?: string;
    }
    /**
     * Determines the border options for a table visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-globaltableborderoptions.html
     */
    interface GlobalTableBorderOptionsProperty {
        /**
         * Determines the options for side specific border.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-globaltableborderoptions.html#cfn-quicksight-analysis-globaltableborderoptions-sidespecificborder
         */
        readonly sideSpecificBorder?: cdk.IResolvable | CfnAnalysis.TableSideBorderOptionsProperty;
        /**
         * Determines the options for uniform border.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-globaltableborderoptions.html#cfn-quicksight-analysis-globaltableborderoptions-uniformborder
         */
        readonly uniformBorder?: cdk.IResolvable | CfnAnalysis.TableBorderOptionsProperty;
    }
    /**
     * The border options for a table border.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableborderoptions.html
     */
    interface TableBorderOptionsProperty {
        /**
         * The color of a table border.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableborderoptions.html#cfn-quicksight-analysis-tableborderoptions-color
         */
        readonly color?: string;
        /**
         * The style (none, solid) of a table border.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableborderoptions.html#cfn-quicksight-analysis-tableborderoptions-style
         */
        readonly style?: string;
        /**
         * The thickness of a table border.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableborderoptions.html#cfn-quicksight-analysis-tableborderoptions-thickness
         */
        readonly thickness?: number;
    }
    /**
     * The side border options for a table.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablesideborderoptions.html
     */
    interface TableSideBorderOptionsProperty {
        /**
         * The table border options of the bottom border.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablesideborderoptions.html#cfn-quicksight-analysis-tablesideborderoptions-bottom
         */
        readonly bottom?: cdk.IResolvable | CfnAnalysis.TableBorderOptionsProperty;
        /**
         * The table border options of the inner horizontal border.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablesideborderoptions.html#cfn-quicksight-analysis-tablesideborderoptions-innerhorizontal
         */
        readonly innerHorizontal?: cdk.IResolvable | CfnAnalysis.TableBorderOptionsProperty;
        /**
         * The table border options of the inner vertical border.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablesideborderoptions.html#cfn-quicksight-analysis-tablesideborderoptions-innervertical
         */
        readonly innerVertical?: cdk.IResolvable | CfnAnalysis.TableBorderOptionsProperty;
        /**
         * The table border options of the left border.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablesideborderoptions.html#cfn-quicksight-analysis-tablesideborderoptions-left
         */
        readonly left?: cdk.IResolvable | CfnAnalysis.TableBorderOptionsProperty;
        /**
         * The table border options of the right border.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablesideborderoptions.html#cfn-quicksight-analysis-tablesideborderoptions-right
         */
        readonly right?: cdk.IResolvable | CfnAnalysis.TableBorderOptionsProperty;
        /**
         * The table border options of the top border.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablesideborderoptions.html#cfn-quicksight-analysis-tablesideborderoptions-top
         */
        readonly top?: cdk.IResolvable | CfnAnalysis.TableBorderOptionsProperty;
    }
    /**
     * Determines the row alternate color options.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-rowalternatecoloroptions.html
     */
    interface RowAlternateColorOptionsProperty {
        /**
         * Determines the list of row alternate colors.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-rowalternatecoloroptions.html#cfn-quicksight-analysis-rowalternatecoloroptions-rowalternatecolors
         */
        readonly rowAlternateColors?: Array<string>;
        /**
         * Determines the widget status.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-rowalternatecoloroptions.html#cfn-quicksight-analysis-rowalternatecoloroptions-status
         */
        readonly status?: string;
        /**
         * The primary background color options for alternate rows.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-rowalternatecoloroptions.html#cfn-quicksight-analysis-rowalternatecoloroptions-useprimarybackgroundcolor
         */
        readonly usePrimaryBackgroundColor?: string;
    }
    /**
     * The inline visualization of a specific type to display within a chart.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableinlinevisualization.html
     */
    interface TableInlineVisualizationProperty {
        /**
         * The configuration of the inline visualization of the data bars within a chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableinlinevisualization.html#cfn-quicksight-analysis-tableinlinevisualization-databars
         */
        readonly dataBars?: CfnAnalysis.DataBarsOptionsProperty | cdk.IResolvable;
    }
    /**
     * The options for data bars.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-databarsoptions.html
     */
    interface DataBarsOptionsProperty {
        /**
         * The field ID for the data bars options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-databarsoptions.html#cfn-quicksight-analysis-databarsoptions-fieldid
         */
        readonly fieldId: string;
        /**
         * The color of the negative data bar.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-databarsoptions.html#cfn-quicksight-analysis-databarsoptions-negativecolor
         */
        readonly negativeColor?: string;
        /**
         * The color of the positive data bar.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-databarsoptions.html#cfn-quicksight-analysis-databarsoptions-positivecolor
         */
        readonly positiveColor?: string;
    }
    /**
     * The field wells for a table visual.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldwells.html
     */
    interface TableFieldWellsProperty {
        /**
         * The aggregated field well for the table.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldwells.html#cfn-quicksight-analysis-tablefieldwells-tableaggregatedfieldwells
         */
        readonly tableAggregatedFieldWells?: cdk.IResolvable | CfnAnalysis.TableAggregatedFieldWellsProperty;
        /**
         * The unaggregated field well for the table.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldwells.html#cfn-quicksight-analysis-tablefieldwells-tableunaggregatedfieldwells
         */
        readonly tableUnaggregatedFieldWells?: cdk.IResolvable | CfnAnalysis.TableUnaggregatedFieldWellsProperty;
    }
    /**
     * The unaggregated field well for the table.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableunaggregatedfieldwells.html
     */
    interface TableUnaggregatedFieldWellsProperty {
        /**
         * The values field well for a pivot table.
         *
         * Values are unaggregated for an unaggregated table.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableunaggregatedfieldwells.html#cfn-quicksight-analysis-tableunaggregatedfieldwells-values
         */
        readonly values?: Array<cdk.IResolvable | CfnAnalysis.UnaggregatedFieldProperty> | cdk.IResolvable;
    }
    /**
     * The unaggregated field for a table.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-unaggregatedfield.html
     */
    interface UnaggregatedFieldProperty {
        /**
         * The column that is used in the `UnaggregatedField` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-unaggregatedfield.html#cfn-quicksight-analysis-unaggregatedfield-column
         */
        readonly column: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The custom field ID.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-unaggregatedfield.html#cfn-quicksight-analysis-unaggregatedfield-fieldid
         */
        readonly fieldId: string;
        /**
         * The format configuration of the field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-unaggregatedfield.html#cfn-quicksight-analysis-unaggregatedfield-formatconfiguration
         */
        readonly formatConfiguration?: CfnAnalysis.FormatConfigurationProperty | cdk.IResolvable;
    }
    /**
     * The aggregated field well for the table.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableaggregatedfieldwells.html
     */
    interface TableAggregatedFieldWellsProperty {
        /**
         * The group by field well for a pivot table.
         *
         * Values are grouped by group by fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableaggregatedfieldwells.html#cfn-quicksight-analysis-tableaggregatedfieldwells-groupby
         */
        readonly groupBy?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The values field well for a pivot table.
         *
         * Values are aggregated based on group by fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableaggregatedfieldwells.html#cfn-quicksight-analysis-tableaggregatedfieldwells-values
         */
        readonly values?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
    }
    /**
     * The field options of a table visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldoptions.html
     */
    interface TableFieldOptionsProperty {
        /**
         * The order of the field IDs that are configured as field options for a table visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldoptions.html#cfn-quicksight-analysis-tablefieldoptions-order
         */
        readonly order?: Array<string>;
        /**
         * The settings for the pinned columns of a table visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldoptions.html#cfn-quicksight-analysis-tablefieldoptions-pinnedfieldoptions
         */
        readonly pinnedFieldOptions?: cdk.IResolvable | CfnAnalysis.TablePinnedFieldOptionsProperty;
        /**
         * The field options to be configured to a table.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldoptions.html#cfn-quicksight-analysis-tablefieldoptions-selectedfieldoptions
         */
        readonly selectedFieldOptions?: Array<cdk.IResolvable | CfnAnalysis.TableFieldOptionProperty> | cdk.IResolvable;
    }
    /**
     * The settings for the pinned columns of a table visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablepinnedfieldoptions.html
     */
    interface TablePinnedFieldOptionsProperty {
        /**
         * A list of columns to be pinned to the left of a table visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablepinnedfieldoptions.html#cfn-quicksight-analysis-tablepinnedfieldoptions-pinnedleftfields
         */
        readonly pinnedLeftFields?: Array<string>;
    }
    /**
     * The options for a table field.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldoption.html
     */
    interface TableFieldOptionProperty {
        /**
         * The custom label for a table field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldoption.html#cfn-quicksight-analysis-tablefieldoption-customlabel
         */
        readonly customLabel?: string;
        /**
         * The field ID for a table field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldoption.html#cfn-quicksight-analysis-tablefieldoption-fieldid
         */
        readonly fieldId: string;
        /**
         * The URL configuration for a table field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldoption.html#cfn-quicksight-analysis-tablefieldoption-urlstyling
         */
        readonly urlStyling?: cdk.IResolvable | CfnAnalysis.TableFieldURLConfigurationProperty;
        /**
         * The visibility of a table field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldoption.html#cfn-quicksight-analysis-tablefieldoption-visibility
         */
        readonly visibility?: string;
        /**
         * The width for a table field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldoption.html#cfn-quicksight-analysis-tablefieldoption-width
         */
        readonly width?: string;
    }
    /**
     * The URL configuration for a table field.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldurlconfiguration.html
     */
    interface TableFieldURLConfigurationProperty {
        /**
         * The image configuration of a table field URL.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldurlconfiguration.html#cfn-quicksight-analysis-tablefieldurlconfiguration-imageconfiguration
         */
        readonly imageConfiguration?: cdk.IResolvable | CfnAnalysis.TableFieldImageConfigurationProperty;
        /**
         * The link configuration of a table field URL.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldurlconfiguration.html#cfn-quicksight-analysis-tablefieldurlconfiguration-linkconfiguration
         */
        readonly linkConfiguration?: cdk.IResolvable | CfnAnalysis.TableFieldLinkConfigurationProperty;
    }
    /**
     * The link configuration of a table field URL.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldlinkconfiguration.html
     */
    interface TableFieldLinkConfigurationProperty {
        /**
         * The URL content (text, icon) for the table link configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldlinkconfiguration.html#cfn-quicksight-analysis-tablefieldlinkconfiguration-content
         */
        readonly content: cdk.IResolvable | CfnAnalysis.TableFieldLinkContentConfigurationProperty;
        /**
         * The URL target (new tab, new window, same tab) for the table link configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldlinkconfiguration.html#cfn-quicksight-analysis-tablefieldlinkconfiguration-target
         */
        readonly target: string;
    }
    /**
     * The URL content (text, icon) for the table link configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldlinkcontentconfiguration.html
     */
    interface TableFieldLinkContentConfigurationProperty {
        /**
         * The custom icon content for the table link content configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldlinkcontentconfiguration.html#cfn-quicksight-analysis-tablefieldlinkcontentconfiguration-customiconcontent
         */
        readonly customIconContent?: cdk.IResolvable | CfnAnalysis.TableFieldCustomIconContentProperty;
        /**
         * The custom text content (value, font configuration) for the table link content configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldlinkcontentconfiguration.html#cfn-quicksight-analysis-tablefieldlinkcontentconfiguration-customtextcontent
         */
        readonly customTextContent?: cdk.IResolvable | CfnAnalysis.TableFieldCustomTextContentProperty;
    }
    /**
     * The custom icon content for the table link content configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldcustomiconcontent.html
     */
    interface TableFieldCustomIconContentProperty {
        /**
         * The icon set type (link) of the custom icon content for table URL link content.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldcustomiconcontent.html#cfn-quicksight-analysis-tablefieldcustomiconcontent-icon
         */
        readonly icon?: string;
    }
    /**
     * The custom text content (value, font configuration) for the table link content configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldcustomtextcontent.html
     */
    interface TableFieldCustomTextContentProperty {
        /**
         * The font configuration of the custom text content for the table URL link content.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldcustomtextcontent.html#cfn-quicksight-analysis-tablefieldcustomtextcontent-fontconfiguration
         */
        readonly fontConfiguration: CfnAnalysis.FontConfigurationProperty | cdk.IResolvable;
        /**
         * The string value of the custom text content for the table URL link content.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldcustomtextcontent.html#cfn-quicksight-analysis-tablefieldcustomtextcontent-value
         */
        readonly value?: string;
    }
    /**
     * The image configuration of a table field URL.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldimageconfiguration.html
     */
    interface TableFieldImageConfigurationProperty {
        /**
         * The sizing options for the table image configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldimageconfiguration.html#cfn-quicksight-analysis-tablefieldimageconfiguration-sizingoptions
         */
        readonly sizingOptions?: cdk.IResolvable | CfnAnalysis.TableCellImageSizingConfigurationProperty;
    }
    /**
     * The sizing options for the table image configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablecellimagesizingconfiguration.html
     */
    interface TableCellImageSizingConfigurationProperty {
        /**
         * The cell scaling configuration of the sizing options for the table image configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablecellimagesizingconfiguration.html#cfn-quicksight-analysis-tablecellimagesizingconfiguration-tablecellimagescalingconfiguration
         */
        readonly tableCellImageScalingConfiguration?: string;
    }
    /**
     * The total options for a table visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-totaloptions.html
     */
    interface TotalOptionsProperty {
        /**
         * The custom label string for the total cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-totaloptions.html#cfn-quicksight-analysis-totaloptions-customlabel
         */
        readonly customLabel?: string;
        /**
         * The placement (start, end) for the total cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-totaloptions.html#cfn-quicksight-analysis-totaloptions-placement
         */
        readonly placement?: string;
        /**
         * The scroll status (pinned, scrolled) for the total cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-totaloptions.html#cfn-quicksight-analysis-totaloptions-scrollstatus
         */
        readonly scrollStatus?: string;
        /**
         * The total aggregation settings for each value field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-totaloptions.html#cfn-quicksight-analysis-totaloptions-totalaggregationoptions
         */
        readonly totalAggregationOptions?: Array<cdk.IResolvable | CfnAnalysis.TotalAggregationOptionProperty> | cdk.IResolvable;
        /**
         * Cell styling options for the total cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-totaloptions.html#cfn-quicksight-analysis-totaloptions-totalcellstyle
         */
        readonly totalCellStyle?: cdk.IResolvable | CfnAnalysis.TableCellStyleProperty;
        /**
         * The visibility configuration for the total cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-totaloptions.html#cfn-quicksight-analysis-totaloptions-totalsvisibility
         */
        readonly totalsVisibility?: string;
    }
    /**
     * The total aggregation settings map of a field id.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-totalaggregationoption.html
     */
    interface TotalAggregationOptionProperty {
        /**
         * The field id that's associated with the total aggregation option.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-totalaggregationoption.html#cfn-quicksight-analysis-totalaggregationoption-fieldid
         */
        readonly fieldId: string;
        /**
         * The total aggregation function that you want to set for a specified field id.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-totalaggregationoption.html#cfn-quicksight-analysis-totalaggregationoption-totalaggregationfunction
         */
        readonly totalAggregationFunction: cdk.IResolvable | CfnAnalysis.TotalAggregationFunctionProperty;
    }
    /**
     * An aggregation function that aggregates the total values of a measure.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-totalaggregationfunction.html
     */
    interface TotalAggregationFunctionProperty {
        /**
         * A built in aggregation function for total values.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-totalaggregationfunction.html#cfn-quicksight-analysis-totalaggregationfunction-simpletotalaggregationfunction
         */
        readonly simpleTotalAggregationFunction?: string;
    }
    /**
     * A pivot table.
     *
     * For more information, see [Using pivot tables](https://docs.aws.amazon.com/quicksight/latest/user/pivot-table.html) in the *Amazon QuickSight User Guide* .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablevisual.html
     */
    interface PivotTableVisualProperty {
        /**
         * The list of custom actions that are configured for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablevisual.html#cfn-quicksight-analysis-pivottablevisual-actions
         */
        readonly actions?: Array<cdk.IResolvable | CfnAnalysis.VisualCustomActionProperty> | cdk.IResolvable;
        /**
         * The configuration settings of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablevisual.html#cfn-quicksight-analysis-pivottablevisual-chartconfiguration
         */
        readonly chartConfiguration?: cdk.IResolvable | CfnAnalysis.PivotTableConfigurationProperty;
        /**
         * The conditional formatting for a `PivotTableVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablevisual.html#cfn-quicksight-analysis-pivottablevisual-conditionalformatting
         */
        readonly conditionalFormatting?: cdk.IResolvable | CfnAnalysis.PivotTableConditionalFormattingProperty;
        /**
         * The subtitle that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablevisual.html#cfn-quicksight-analysis-pivottablevisual-subtitle
         */
        readonly subtitle?: cdk.IResolvable | CfnAnalysis.VisualSubtitleLabelOptionsProperty;
        /**
         * The title that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablevisual.html#cfn-quicksight-analysis-pivottablevisual-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.VisualTitleLabelOptionsProperty;
        /**
         * The alt text for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablevisual.html#cfn-quicksight-analysis-pivottablevisual-visualcontentalttext
         */
        readonly visualContentAltText?: string;
        /**
         * The unique identifier of a visual.
         *
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers..
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablevisual.html#cfn-quicksight-analysis-pivottablevisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * The conditional formatting for a `PivotTableVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableconditionalformatting.html
     */
    interface PivotTableConditionalFormattingProperty {
        /**
         * Conditional formatting options for a `PivotTableVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableconditionalformatting.html#cfn-quicksight-analysis-pivottableconditionalformatting-conditionalformattingoptions
         */
        readonly conditionalFormattingOptions?: Array<cdk.IResolvable | CfnAnalysis.PivotTableConditionalFormattingOptionProperty> | cdk.IResolvable;
    }
    /**
     * Conditional formatting options for a `PivotTableVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableconditionalformattingoption.html
     */
    interface PivotTableConditionalFormattingOptionProperty {
        /**
         * The cell conditional formatting option for a pivot table.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableconditionalformattingoption.html#cfn-quicksight-analysis-pivottableconditionalformattingoption-cell
         */
        readonly cell?: cdk.IResolvable | CfnAnalysis.PivotTableCellConditionalFormattingProperty;
    }
    /**
     * The cell conditional formatting option for a pivot table.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablecellconditionalformatting.html
     */
    interface PivotTableCellConditionalFormattingProperty {
        /**
         * The field ID of the cell for conditional formatting.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablecellconditionalformatting.html#cfn-quicksight-analysis-pivottablecellconditionalformatting-fieldid
         */
        readonly fieldId: string;
        /**
         * The scope of the cell for conditional formatting.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablecellconditionalformatting.html#cfn-quicksight-analysis-pivottablecellconditionalformatting-scope
         */
        readonly scope?: cdk.IResolvable | CfnAnalysis.PivotTableConditionalFormattingScopeProperty;
        /**
         * A list of cell scopes for conditional formatting.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablecellconditionalformatting.html#cfn-quicksight-analysis-pivottablecellconditionalformatting-scopes
         */
        readonly scopes?: Array<cdk.IResolvable | CfnAnalysis.PivotTableConditionalFormattingScopeProperty> | cdk.IResolvable;
        /**
         * The text format of the cell for conditional formatting.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablecellconditionalformatting.html#cfn-quicksight-analysis-pivottablecellconditionalformatting-textformat
         */
        readonly textFormat?: cdk.IResolvable | CfnAnalysis.TextConditionalFormatProperty;
    }
    /**
     * The scope of the cell for conditional formatting.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableconditionalformattingscope.html
     */
    interface PivotTableConditionalFormattingScopeProperty {
        /**
         * The role (field, field total, grand total) of the cell for conditional formatting.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableconditionalformattingscope.html#cfn-quicksight-analysis-pivottableconditionalformattingscope-role
         */
        readonly role?: string;
    }
    /**
     * The configuration for a `PivotTableVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableconfiguration.html
     */
    interface PivotTableConfigurationProperty {
        /**
         * The field options for a pivot table visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableconfiguration.html#cfn-quicksight-analysis-pivottableconfiguration-fieldoptions
         */
        readonly fieldOptions?: cdk.IResolvable | CfnAnalysis.PivotTableFieldOptionsProperty;
        /**
         * The field wells of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableconfiguration.html#cfn-quicksight-analysis-pivottableconfiguration-fieldwells
         */
        readonly fieldWells?: cdk.IResolvable | CfnAnalysis.PivotTableFieldWellsProperty;
        /**
         * The general visual interactions setup for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableconfiguration.html#cfn-quicksight-analysis-pivottableconfiguration-interactions
         */
        readonly interactions?: cdk.IResolvable | CfnAnalysis.VisualInteractionOptionsProperty;
        /**
         * The paginated report options for a pivot table visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableconfiguration.html#cfn-quicksight-analysis-pivottableconfiguration-paginatedreportoptions
         */
        readonly paginatedReportOptions?: cdk.IResolvable | CfnAnalysis.PivotTablePaginatedReportOptionsProperty;
        /**
         * The sort configuration for a `PivotTableVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableconfiguration.html#cfn-quicksight-analysis-pivottableconfiguration-sortconfiguration
         */
        readonly sortConfiguration?: cdk.IResolvable | CfnAnalysis.PivotTableSortConfigurationProperty;
        /**
         * The table options for a pivot table visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableconfiguration.html#cfn-quicksight-analysis-pivottableconfiguration-tableoptions
         */
        readonly tableOptions?: cdk.IResolvable | CfnAnalysis.PivotTableOptionsProperty;
        /**
         * The total options for a pivot table visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableconfiguration.html#cfn-quicksight-analysis-pivottableconfiguration-totaloptions
         */
        readonly totalOptions?: cdk.IResolvable | CfnAnalysis.PivotTableTotalOptionsProperty;
    }
    /**
     * The sort configuration for a `PivotTableVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablesortconfiguration.html
     */
    interface PivotTableSortConfigurationProperty {
        /**
         * The field sort options for a pivot table sort configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablesortconfiguration.html#cfn-quicksight-analysis-pivottablesortconfiguration-fieldsortoptions
         */
        readonly fieldSortOptions?: Array<cdk.IResolvable | CfnAnalysis.PivotFieldSortOptionsProperty> | cdk.IResolvable;
    }
    /**
     * The field sort options for a pivot table sort configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivotfieldsortoptions.html
     */
    interface PivotFieldSortOptionsProperty {
        /**
         * The field ID for the field sort options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivotfieldsortoptions.html#cfn-quicksight-analysis-pivotfieldsortoptions-fieldid
         */
        readonly fieldId: string;
        /**
         * The sort by field for the field sort options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivotfieldsortoptions.html#cfn-quicksight-analysis-pivotfieldsortoptions-sortby
         */
        readonly sortBy: cdk.IResolvable | CfnAnalysis.PivotTableSortByProperty;
    }
    /**
     * The sort by field for the field sort options.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablesortby.html
     */
    interface PivotTableSortByProperty {
        /**
         * The column sort (field id, direction) for the pivot table sort by options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablesortby.html#cfn-quicksight-analysis-pivottablesortby-column
         */
        readonly column?: CfnAnalysis.ColumnSortProperty | cdk.IResolvable;
        /**
         * The data path sort (data path value, direction) for the pivot table sort by options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablesortby.html#cfn-quicksight-analysis-pivottablesortby-datapath
         */
        readonly dataPath?: CfnAnalysis.DataPathSortProperty | cdk.IResolvable;
        /**
         * The field sort (field id, direction) for the pivot table sort by options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablesortby.html#cfn-quicksight-analysis-pivottablesortby-field
         */
        readonly field?: CfnAnalysis.FieldSortProperty | cdk.IResolvable;
    }
    /**
     * Allows data paths to be sorted by a specific data value.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathsort.html
     */
    interface DataPathSortProperty {
        /**
         * Determines the sort direction.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathsort.html#cfn-quicksight-analysis-datapathsort-direction
         */
        readonly direction: string;
        /**
         * The list of data paths that need to be sorted.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathsort.html#cfn-quicksight-analysis-datapathsort-sortpaths
         */
        readonly sortPaths: Array<CfnAnalysis.DataPathValueProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The paginated report options for a pivot table visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablepaginatedreportoptions.html
     */
    interface PivotTablePaginatedReportOptionsProperty {
        /**
         * The visibility of the repeating header rows on each page.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablepaginatedreportoptions.html#cfn-quicksight-analysis-pivottablepaginatedreportoptions-overflowcolumnheadervisibility
         */
        readonly overflowColumnHeaderVisibility?: string;
        /**
         * The visibility of the printing table overflow across pages.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablepaginatedreportoptions.html#cfn-quicksight-analysis-pivottablepaginatedreportoptions-verticaloverflowvisibility
         */
        readonly verticalOverflowVisibility?: string;
    }
    /**
     * The table options for a pivot table visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableoptions.html
     */
    interface PivotTableOptionsProperty {
        /**
         * The table cell style of cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableoptions.html#cfn-quicksight-analysis-pivottableoptions-cellstyle
         */
        readonly cellStyle?: cdk.IResolvable | CfnAnalysis.TableCellStyleProperty;
        /**
         * The visibility setting of a pivot table's collapsed row dimension fields.
         *
         * If the value of this structure is `HIDDEN` , all collapsed columns in a pivot table are automatically hidden. The default value is `VISIBLE` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableoptions.html#cfn-quicksight-analysis-pivottableoptions-collapsedrowdimensionsvisibility
         */
        readonly collapsedRowDimensionsVisibility?: string;
        /**
         * The table cell style of the column header.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableoptions.html#cfn-quicksight-analysis-pivottableoptions-columnheaderstyle
         */
        readonly columnHeaderStyle?: cdk.IResolvable | CfnAnalysis.TableCellStyleProperty;
        /**
         * The visibility of the column names.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableoptions.html#cfn-quicksight-analysis-pivottableoptions-columnnamesvisibility
         */
        readonly columnNamesVisibility?: string;
        /**
         * The default cell width of the pivot table.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableoptions.html#cfn-quicksight-analysis-pivottableoptions-defaultcellwidth
         */
        readonly defaultCellWidth?: string;
        /**
         * The metric placement (row, column) options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableoptions.html#cfn-quicksight-analysis-pivottableoptions-metricplacement
         */
        readonly metricPlacement?: string;
        /**
         * The row alternate color options (widget status, row alternate colors).
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableoptions.html#cfn-quicksight-analysis-pivottableoptions-rowalternatecoloroptions
         */
        readonly rowAlternateColorOptions?: cdk.IResolvable | CfnAnalysis.RowAlternateColorOptionsProperty;
        /**
         * The table cell style of row field names.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableoptions.html#cfn-quicksight-analysis-pivottableoptions-rowfieldnamesstyle
         */
        readonly rowFieldNamesStyle?: cdk.IResolvable | CfnAnalysis.TableCellStyleProperty;
        /**
         * The table cell style of the row headers.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableoptions.html#cfn-quicksight-analysis-pivottableoptions-rowheaderstyle
         */
        readonly rowHeaderStyle?: cdk.IResolvable | CfnAnalysis.TableCellStyleProperty;
        /**
         * The options for the label that is located above the row headers.
         *
         * This option is only applicable when `RowsLayout` is set to `HIERARCHY` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableoptions.html#cfn-quicksight-analysis-pivottableoptions-rowslabeloptions
         */
        readonly rowsLabelOptions?: cdk.IResolvable | CfnAnalysis.PivotTableRowsLabelOptionsProperty;
        /**
         * The layout for the row dimension headers of a pivot table. Choose one of the following options.
         *
         * - `TABULAR` : (Default) Each row field is displayed in a separate column.
         * - `HIERARCHY` : All row fields are displayed in a single column. Indentation is used to differentiate row headers of different fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableoptions.html#cfn-quicksight-analysis-pivottableoptions-rowslayout
         */
        readonly rowsLayout?: string;
        /**
         * The visibility of the single metric options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableoptions.html#cfn-quicksight-analysis-pivottableoptions-singlemetricvisibility
         */
        readonly singleMetricVisibility?: string;
        /**
         * Determines the visibility of the pivot table.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableoptions.html#cfn-quicksight-analysis-pivottableoptions-togglebuttonsvisibility
         */
        readonly toggleButtonsVisibility?: string;
    }
    /**
     * The options for the label thta is located above the row headers.
     *
     * This option is only applicable when `RowsLayout` is set to `HIERARCHY` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablerowslabeloptions.html
     */
    interface PivotTableRowsLabelOptionsProperty {
        /**
         * The custom label string for the rows label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablerowslabeloptions.html#cfn-quicksight-analysis-pivottablerowslabeloptions-customlabel
         */
        readonly customLabel?: string;
        /**
         * The visibility of the rows label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablerowslabeloptions.html#cfn-quicksight-analysis-pivottablerowslabeloptions-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The field wells for a pivot table visual.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablefieldwells.html
     */
    interface PivotTableFieldWellsProperty {
        /**
         * The aggregated field well for the pivot table.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablefieldwells.html#cfn-quicksight-analysis-pivottablefieldwells-pivottableaggregatedfieldwells
         */
        readonly pivotTableAggregatedFieldWells?: cdk.IResolvable | CfnAnalysis.PivotTableAggregatedFieldWellsProperty;
    }
    /**
     * The aggregated field well for the pivot table.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableaggregatedfieldwells.html
     */
    interface PivotTableAggregatedFieldWellsProperty {
        /**
         * The columns field well for a pivot table.
         *
         * Values are grouped by columns fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableaggregatedfieldwells.html#cfn-quicksight-analysis-pivottableaggregatedfieldwells-columns
         */
        readonly columns?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The rows field well for a pivot table.
         *
         * Values are grouped by rows fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableaggregatedfieldwells.html#cfn-quicksight-analysis-pivottableaggregatedfieldwells-rows
         */
        readonly rows?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The values field well for a pivot table.
         *
         * Values are aggregated based on rows and columns fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableaggregatedfieldwells.html#cfn-quicksight-analysis-pivottableaggregatedfieldwells-values
         */
        readonly values?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
    }
    /**
     * The field options for a pivot table visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablefieldoptions.html
     */
    interface PivotTableFieldOptionsProperty {
        /**
         * The collapse state options for the pivot table field options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablefieldoptions.html#cfn-quicksight-analysis-pivottablefieldoptions-collapsestateoptions
         */
        readonly collapseStateOptions?: Array<cdk.IResolvable | CfnAnalysis.PivotTableFieldCollapseStateOptionProperty> | cdk.IResolvable;
        /**
         * The data path options for the pivot table field options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablefieldoptions.html#cfn-quicksight-analysis-pivottablefieldoptions-datapathoptions
         */
        readonly dataPathOptions?: Array<cdk.IResolvable | CfnAnalysis.PivotTableDataPathOptionProperty> | cdk.IResolvable;
        /**
         * The selected field options for the pivot table field options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablefieldoptions.html#cfn-quicksight-analysis-pivottablefieldoptions-selectedfieldoptions
         */
        readonly selectedFieldOptions?: Array<cdk.IResolvable | CfnAnalysis.PivotTableFieldOptionProperty> | cdk.IResolvable;
    }
    /**
     * The collapse state options for the pivot table field options.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablefieldcollapsestateoption.html
     */
    interface PivotTableFieldCollapseStateOptionProperty {
        /**
         * The state of the field target of a pivot table. Choose one of the following options:.
         *
         * - `COLLAPSED`
         * - `EXPANDED`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablefieldcollapsestateoption.html#cfn-quicksight-analysis-pivottablefieldcollapsestateoption-state
         */
        readonly state?: string;
        /**
         * A tagged-union object that sets the collapse state.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablefieldcollapsestateoption.html#cfn-quicksight-analysis-pivottablefieldcollapsestateoption-target
         */
        readonly target: cdk.IResolvable | CfnAnalysis.PivotTableFieldCollapseStateTargetProperty;
    }
    /**
     * The target of a pivot table field collapse state.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablefieldcollapsestatetarget.html
     */
    interface PivotTableFieldCollapseStateTargetProperty {
        /**
         * The data path of the pivot table's header.
         *
         * Used to set the collapse state.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablefieldcollapsestatetarget.html#cfn-quicksight-analysis-pivottablefieldcollapsestatetarget-fielddatapathvalues
         */
        readonly fieldDataPathValues?: Array<CfnAnalysis.DataPathValueProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The field ID of the pivot table that the collapse state needs to be set to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablefieldcollapsestatetarget.html#cfn-quicksight-analysis-pivottablefieldcollapsestatetarget-fieldid
         */
        readonly fieldId?: string;
    }
    /**
     * The data path options for the pivot table field options.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottabledatapathoption.html
     */
    interface PivotTableDataPathOptionProperty {
        /**
         * The list of data path values for the data path options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottabledatapathoption.html#cfn-quicksight-analysis-pivottabledatapathoption-datapathlist
         */
        readonly dataPathList: Array<CfnAnalysis.DataPathValueProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The width of the data path option.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottabledatapathoption.html#cfn-quicksight-analysis-pivottabledatapathoption-width
         */
        readonly width?: string;
    }
    /**
     * The selected field options for the pivot table field options.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablefieldoption.html
     */
    interface PivotTableFieldOptionProperty {
        /**
         * The custom label of the pivot table field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablefieldoption.html#cfn-quicksight-analysis-pivottablefieldoption-customlabel
         */
        readonly customLabel?: string;
        /**
         * The field ID of the pivot table field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablefieldoption.html#cfn-quicksight-analysis-pivottablefieldoption-fieldid
         */
        readonly fieldId: string;
        /**
         * The visibility of the pivot table field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablefieldoption.html#cfn-quicksight-analysis-pivottablefieldoption-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The total options for a pivot table visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottabletotaloptions.html
     */
    interface PivotTableTotalOptionsProperty {
        /**
         * The column subtotal options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottabletotaloptions.html#cfn-quicksight-analysis-pivottabletotaloptions-columnsubtotaloptions
         */
        readonly columnSubtotalOptions?: cdk.IResolvable | CfnAnalysis.SubtotalOptionsProperty;
        /**
         * The column total options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottabletotaloptions.html#cfn-quicksight-analysis-pivottabletotaloptions-columntotaloptions
         */
        readonly columnTotalOptions?: cdk.IResolvable | CfnAnalysis.PivotTotalOptionsProperty;
        /**
         * The row subtotal options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottabletotaloptions.html#cfn-quicksight-analysis-pivottabletotaloptions-rowsubtotaloptions
         */
        readonly rowSubtotalOptions?: cdk.IResolvable | CfnAnalysis.SubtotalOptionsProperty;
        /**
         * The row total options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottabletotaloptions.html#cfn-quicksight-analysis-pivottabletotaloptions-rowtotaloptions
         */
        readonly rowTotalOptions?: cdk.IResolvable | CfnAnalysis.PivotTotalOptionsProperty;
    }
    /**
     * The subtotal options.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-subtotaloptions.html
     */
    interface SubtotalOptionsProperty {
        /**
         * The custom label string for the subtotal cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-subtotaloptions.html#cfn-quicksight-analysis-subtotaloptions-customlabel
         */
        readonly customLabel?: string;
        /**
         * The field level (all, custom, last) for the subtotal cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-subtotaloptions.html#cfn-quicksight-analysis-subtotaloptions-fieldlevel
         */
        readonly fieldLevel?: string;
        /**
         * The optional configuration of subtotal cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-subtotaloptions.html#cfn-quicksight-analysis-subtotaloptions-fieldleveloptions
         */
        readonly fieldLevelOptions?: Array<cdk.IResolvable | CfnAnalysis.PivotTableFieldSubtotalOptionsProperty> | cdk.IResolvable;
        /**
         * The cell styling options for the subtotals of header cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-subtotaloptions.html#cfn-quicksight-analysis-subtotaloptions-metricheadercellstyle
         */
        readonly metricHeaderCellStyle?: cdk.IResolvable | CfnAnalysis.TableCellStyleProperty;
        /**
         * The style targets options for subtotals.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-subtotaloptions.html#cfn-quicksight-analysis-subtotaloptions-styletargets
         */
        readonly styleTargets?: Array<cdk.IResolvable | CfnAnalysis.TableStyleTargetProperty> | cdk.IResolvable;
        /**
         * The cell styling options for the subtotal cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-subtotaloptions.html#cfn-quicksight-analysis-subtotaloptions-totalcellstyle
         */
        readonly totalCellStyle?: cdk.IResolvable | CfnAnalysis.TableCellStyleProperty;
        /**
         * The visibility configuration for the subtotal cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-subtotaloptions.html#cfn-quicksight-analysis-subtotaloptions-totalsvisibility
         */
        readonly totalsVisibility?: string;
        /**
         * The cell styling options for the subtotals of value cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-subtotaloptions.html#cfn-quicksight-analysis-subtotaloptions-valuecellstyle
         */
        readonly valueCellStyle?: cdk.IResolvable | CfnAnalysis.TableCellStyleProperty;
    }
    /**
     * The optional configuration of subtotals cells.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablefieldsubtotaloptions.html
     */
    interface PivotTableFieldSubtotalOptionsProperty {
        /**
         * The field ID of the subtotal options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablefieldsubtotaloptions.html#cfn-quicksight-analysis-pivottablefieldsubtotaloptions-fieldid
         */
        readonly fieldId?: string;
    }
    /**
     * The table style target.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablestyletarget.html
     */
    interface TableStyleTargetProperty {
        /**
         * The cell type of the table style target.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablestyletarget.html#cfn-quicksight-analysis-tablestyletarget-celltype
         */
        readonly cellType: string;
    }
    /**
     * The optional configuration of totals cells in a `PivotTableVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottotaloptions.html
     */
    interface PivotTotalOptionsProperty {
        /**
         * The custom label string for the total cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottotaloptions.html#cfn-quicksight-analysis-pivottotaloptions-customlabel
         */
        readonly customLabel?: string;
        /**
         * The cell styling options for the total of header cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottotaloptions.html#cfn-quicksight-analysis-pivottotaloptions-metricheadercellstyle
         */
        readonly metricHeaderCellStyle?: cdk.IResolvable | CfnAnalysis.TableCellStyleProperty;
        /**
         * The placement (start, end) for the total cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottotaloptions.html#cfn-quicksight-analysis-pivottotaloptions-placement
         */
        readonly placement?: string;
        /**
         * The scroll status (pinned, scrolled) for the total cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottotaloptions.html#cfn-quicksight-analysis-pivottotaloptions-scrollstatus
         */
        readonly scrollStatus?: string;
        /**
         * The total aggregation options for each value field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottotaloptions.html#cfn-quicksight-analysis-pivottotaloptions-totalaggregationoptions
         */
        readonly totalAggregationOptions?: Array<cdk.IResolvable | CfnAnalysis.TotalAggregationOptionProperty> | cdk.IResolvable;
        /**
         * The cell styling options for the total cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottotaloptions.html#cfn-quicksight-analysis-pivottotaloptions-totalcellstyle
         */
        readonly totalCellStyle?: cdk.IResolvable | CfnAnalysis.TableCellStyleProperty;
        /**
         * The visibility configuration for the total cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottotaloptions.html#cfn-quicksight-analysis-pivottotaloptions-totalsvisibility
         */
        readonly totalsVisibility?: string;
        /**
         * The cell styling options for the totals of value cells.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottotaloptions.html#cfn-quicksight-analysis-pivottotaloptions-valuecellstyle
         */
        readonly valueCellStyle?: cdk.IResolvable | CfnAnalysis.TableCellStyleProperty;
    }
    /**
     * A geospatial map or a points on map visual.
     *
     * For more information, see [Creating point maps](https://docs.aws.amazon.com/quicksight/latest/user/point-maps.html) in the *Amazon QuickSight User Guide* .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapvisual.html
     */
    interface GeospatialMapVisualProperty {
        /**
         * The list of custom actions that are configured for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapvisual.html#cfn-quicksight-analysis-geospatialmapvisual-actions
         */
        readonly actions?: Array<cdk.IResolvable | CfnAnalysis.VisualCustomActionProperty> | cdk.IResolvable;
        /**
         * The configuration settings of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapvisual.html#cfn-quicksight-analysis-geospatialmapvisual-chartconfiguration
         */
        readonly chartConfiguration?: CfnAnalysis.GeospatialMapConfigurationProperty | cdk.IResolvable;
        /**
         * The column hierarchy that is used during drill-downs and drill-ups.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapvisual.html#cfn-quicksight-analysis-geospatialmapvisual-columnhierarchies
         */
        readonly columnHierarchies?: Array<CfnAnalysis.ColumnHierarchyProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The subtitle that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapvisual.html#cfn-quicksight-analysis-geospatialmapvisual-subtitle
         */
        readonly subtitle?: cdk.IResolvable | CfnAnalysis.VisualSubtitleLabelOptionsProperty;
        /**
         * The title that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapvisual.html#cfn-quicksight-analysis-geospatialmapvisual-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.VisualTitleLabelOptionsProperty;
        /**
         * The alt text for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapvisual.html#cfn-quicksight-analysis-geospatialmapvisual-visualcontentalttext
         */
        readonly visualContentAltText?: string;
        /**
         * The unique identifier of a visual.
         *
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers..
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapvisual.html#cfn-quicksight-analysis-geospatialmapvisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * The configuration of a `GeospatialMapVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapconfiguration.html
     */
    interface GeospatialMapConfigurationProperty {
        /**
         * The field wells of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapconfiguration.html#cfn-quicksight-analysis-geospatialmapconfiguration-fieldwells
         */
        readonly fieldWells?: CfnAnalysis.GeospatialMapFieldWellsProperty | cdk.IResolvable;
        /**
         * The general visual interactions setup for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapconfiguration.html#cfn-quicksight-analysis-geospatialmapconfiguration-interactions
         */
        readonly interactions?: cdk.IResolvable | CfnAnalysis.VisualInteractionOptionsProperty;
        /**
         * The legend display setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapconfiguration.html#cfn-quicksight-analysis-geospatialmapconfiguration-legend
         */
        readonly legend?: cdk.IResolvable | CfnAnalysis.LegendOptionsProperty;
        /**
         * The map style options of the geospatial map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapconfiguration.html#cfn-quicksight-analysis-geospatialmapconfiguration-mapstyleoptions
         */
        readonly mapStyleOptions?: CfnAnalysis.GeospatialMapStyleOptionsProperty | cdk.IResolvable;
        /**
         * The point style options of the geospatial map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapconfiguration.html#cfn-quicksight-analysis-geospatialmapconfiguration-pointstyleoptions
         */
        readonly pointStyleOptions?: CfnAnalysis.GeospatialPointStyleOptionsProperty | cdk.IResolvable;
        /**
         * The tooltip display setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapconfiguration.html#cfn-quicksight-analysis-geospatialmapconfiguration-tooltip
         */
        readonly tooltip?: cdk.IResolvable | CfnAnalysis.TooltipOptionsProperty;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapconfiguration.html#cfn-quicksight-analysis-geospatialmapconfiguration-visualpalette
         */
        readonly visualPalette?: cdk.IResolvable | CfnAnalysis.VisualPaletteProperty;
        /**
         * The window options of the geospatial map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapconfiguration.html#cfn-quicksight-analysis-geospatialmapconfiguration-windowoptions
         */
        readonly windowOptions?: CfnAnalysis.GeospatialWindowOptionsProperty | cdk.IResolvable;
    }
    /**
     * The field wells of a `GeospatialMapVisual` .
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapfieldwells.html
     */
    interface GeospatialMapFieldWellsProperty {
        /**
         * The aggregated field well for a geospatial map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapfieldwells.html#cfn-quicksight-analysis-geospatialmapfieldwells-geospatialmapaggregatedfieldwells
         */
        readonly geospatialMapAggregatedFieldWells?: CfnAnalysis.GeospatialMapAggregatedFieldWellsProperty | cdk.IResolvable;
    }
    /**
     * The aggregated field wells for a geospatial map.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapaggregatedfieldwells.html
     */
    interface GeospatialMapAggregatedFieldWellsProperty {
        /**
         * The color field wells of a geospatial map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapaggregatedfieldwells.html#cfn-quicksight-analysis-geospatialmapaggregatedfieldwells-colors
         */
        readonly colors?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The geospatial field wells of a geospatial map.
         *
         * Values are grouped by geospatial fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapaggregatedfieldwells.html#cfn-quicksight-analysis-geospatialmapaggregatedfieldwells-geospatial
         */
        readonly geospatial?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The size field wells of a geospatial map.
         *
         * Values are aggregated based on geospatial fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapaggregatedfieldwells.html#cfn-quicksight-analysis-geospatialmapaggregatedfieldwells-values
         */
        readonly values?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
    }
    /**
     * The point style of the geospatial map.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialpointstyleoptions.html
     */
    interface GeospatialPointStyleOptionsProperty {
        /**
         * The cluster marker configuration of the geospatial point style.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialpointstyleoptions.html#cfn-quicksight-analysis-geospatialpointstyleoptions-clustermarkerconfiguration
         */
        readonly clusterMarkerConfiguration?: CfnAnalysis.ClusterMarkerConfigurationProperty | cdk.IResolvable;
        /**
         * The heatmap configuration of the geospatial point style.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialpointstyleoptions.html#cfn-quicksight-analysis-geospatialpointstyleoptions-heatmapconfiguration
         */
        readonly heatmapConfiguration?: CfnAnalysis.GeospatialHeatmapConfigurationProperty | cdk.IResolvable;
        /**
         * The selected point styles (point, cluster) of the geospatial map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialpointstyleoptions.html#cfn-quicksight-analysis-geospatialpointstyleoptions-selectedpointstyle
         */
        readonly selectedPointStyle?: string;
    }
    /**
     * The cluster marker configuration of the geospatial map selected point style.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-clustermarkerconfiguration.html
     */
    interface ClusterMarkerConfigurationProperty {
        /**
         * The cluster marker that is a part of the cluster marker configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-clustermarkerconfiguration.html#cfn-quicksight-analysis-clustermarkerconfiguration-clustermarker
         */
        readonly clusterMarker?: CfnAnalysis.ClusterMarkerProperty | cdk.IResolvable;
    }
    /**
     * The cluster marker that is a part of the cluster marker configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-clustermarker.html
     */
    interface ClusterMarkerProperty {
        /**
         * The simple cluster marker of the cluster marker.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-clustermarker.html#cfn-quicksight-analysis-clustermarker-simpleclustermarker
         */
        readonly simpleClusterMarker?: cdk.IResolvable | CfnAnalysis.SimpleClusterMarkerProperty;
    }
    /**
     * The simple cluster marker of the cluster marker.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-simpleclustermarker.html
     */
    interface SimpleClusterMarkerProperty {
        /**
         * The color of the simple cluster marker.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-simpleclustermarker.html#cfn-quicksight-analysis-simpleclustermarker-color
         */
        readonly color?: string;
    }
    /**
     * The heatmap configuration of the geospatial point style.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialheatmapconfiguration.html
     */
    interface GeospatialHeatmapConfigurationProperty {
        /**
         * The color scale specification for the heatmap point style.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialheatmapconfiguration.html#cfn-quicksight-analysis-geospatialheatmapconfiguration-heatmapcolor
         */
        readonly heatmapColor?: CfnAnalysis.GeospatialHeatmapColorScaleProperty | cdk.IResolvable;
    }
    /**
     * The color scale specification for the heatmap point style.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialheatmapcolorscale.html
     */
    interface GeospatialHeatmapColorScaleProperty {
        /**
         * The list of colors to be used in heatmap point style.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialheatmapcolorscale.html#cfn-quicksight-analysis-geospatialheatmapcolorscale-colors
         */
        readonly colors?: Array<CfnAnalysis.GeospatialHeatmapDataColorProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The color to be used in the heatmap point style.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialheatmapdatacolor.html
     */
    interface GeospatialHeatmapDataColorProperty {
        /**
         * The hex color to be used in the heatmap point style.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialheatmapdatacolor.html#cfn-quicksight-analysis-geospatialheatmapdatacolor-color
         */
        readonly color: string;
    }
    /**
     * A bar chart.
     *
     * The `BarChartVisual` structure describes a visual that is a member of the bar chart family. The following charts can be described using this structure:
     *
     * - Horizontal bar chart
     * - Vertical bar chart
     * - Horizontal stacked bar chart
     * - Vertical stacked bar chart
     * - Horizontal stacked 100% bar chart
     * - Vertical stacked 100% bar chart
     *
     * For more information, see [Using bar charts](https://docs.aws.amazon.com/quicksight/latest/user/bar-charts.html) in the *Amazon QuickSight User Guide* .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html
     */
    interface BarChartVisualProperty {
        /**
         * The list of custom actions that are configured for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-actions
         */
        readonly actions?: Array<cdk.IResolvable | CfnAnalysis.VisualCustomActionProperty> | cdk.IResolvable;
        /**
         * The configuration settings of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-chartconfiguration
         */
        readonly chartConfiguration?: CfnAnalysis.BarChartConfigurationProperty | cdk.IResolvable;
        /**
         * The column hierarchy that is used during drill-downs and drill-ups.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-columnhierarchies
         */
        readonly columnHierarchies?: Array<CfnAnalysis.ColumnHierarchyProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The subtitle that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-subtitle
         */
        readonly subtitle?: cdk.IResolvable | CfnAnalysis.VisualSubtitleLabelOptionsProperty;
        /**
         * The title that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.VisualTitleLabelOptionsProperty;
        /**
         * The alt text for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-visualcontentalttext
         */
        readonly visualContentAltText?: string;
        /**
         * The unique identifier of a visual.
         *
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html#cfn-quicksight-analysis-barchartvisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * The configuration of a `BarChartVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html
     */
    interface BarChartConfigurationProperty {
        /**
         * Determines the arrangement of the bars.
         *
         * The orientation and arrangement of bars determine the type of bar that is used in the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-barsarrangement
         */
        readonly barsArrangement?: string;
        /**
         * The label display options (grid line, range, scale, axis step) for bar chart category.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-categoryaxis
         */
        readonly categoryAxis?: CfnAnalysis.AxisDisplayOptionsProperty | cdk.IResolvable;
        /**
         * The label options (label text, label visibility and sort icon visibility) for a bar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-categorylabeloptions
         */
        readonly categoryLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The label options (label text, label visibility and sort icon visibility) for a color that is used in a bar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-colorlabeloptions
         */
        readonly colorLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The contribution analysis (anomaly configuration) setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-contributionanalysisdefaults
         */
        readonly contributionAnalysisDefaults?: Array<CfnAnalysis.ContributionAnalysisDefaultProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The options that determine if visual data labels are displayed.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-datalabels
         */
        readonly dataLabels?: CfnAnalysis.DataLabelOptionsProperty | cdk.IResolvable;
        /**
         * The field wells of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-fieldwells
         */
        readonly fieldWells?: CfnAnalysis.BarChartFieldWellsProperty | cdk.IResolvable;
        /**
         * The general visual interactions setup for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-interactions
         */
        readonly interactions?: cdk.IResolvable | CfnAnalysis.VisualInteractionOptionsProperty;
        /**
         * The legend display setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-legend
         */
        readonly legend?: cdk.IResolvable | CfnAnalysis.LegendOptionsProperty;
        /**
         * The orientation of the bars in a bar chart visual. There are two valid values in this structure:.
         *
         * - `HORIZONTAL` : Used for charts that have horizontal bars. Visuals that use this value are horizontal bar charts, horizontal stacked bar charts, and horizontal stacked 100% bar charts.
         * - `VERTICAL` : Used for charts that have vertical bars. Visuals that use this value are vertical bar charts, vertical stacked bar charts, and vertical stacked 100% bar charts.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-orientation
         */
        readonly orientation?: string;
        /**
         * The reference line setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-referencelines
         */
        readonly referenceLines?: Array<cdk.IResolvable | CfnAnalysis.ReferenceLineProperty> | cdk.IResolvable;
        /**
         * The small multiples setup for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-smallmultiplesoptions
         */
        readonly smallMultiplesOptions?: cdk.IResolvable | CfnAnalysis.SmallMultiplesOptionsProperty;
        /**
         * The sort configuration of a `BarChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-sortconfiguration
         */
        readonly sortConfiguration?: CfnAnalysis.BarChartSortConfigurationProperty | cdk.IResolvable;
        /**
         * The tooltip display setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-tooltip
         */
        readonly tooltip?: cdk.IResolvable | CfnAnalysis.TooltipOptionsProperty;
        /**
         * The label display options (grid line, range, scale, axis step) for a bar chart value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-valueaxis
         */
        readonly valueAxis?: CfnAnalysis.AxisDisplayOptionsProperty | cdk.IResolvable;
        /**
         * The label options (label text, label visibility and sort icon visibility) for a bar chart value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-valuelabeloptions
         */
        readonly valueLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The palette (chart color) display setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html#cfn-quicksight-analysis-barchartconfiguration-visualpalette
         */
        readonly visualPalette?: cdk.IResolvable | CfnAnalysis.VisualPaletteProperty;
    }
    /**
     * sort-configuration-description.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html
     */
    interface BarChartSortConfigurationProperty {
        /**
         * The limit on the number of categories displayed in a bar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html#cfn-quicksight-analysis-barchartsortconfiguration-categoryitemslimit
         */
        readonly categoryItemsLimit?: cdk.IResolvable | CfnAnalysis.ItemsLimitConfigurationProperty;
        /**
         * The sort configuration of category fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html#cfn-quicksight-analysis-barchartsortconfiguration-categorysort
         */
        readonly categorySort?: Array<CfnAnalysis.FieldSortOptionsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The limit on the number of values displayed in a bar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html#cfn-quicksight-analysis-barchartsortconfiguration-coloritemslimit
         */
        readonly colorItemsLimit?: cdk.IResolvable | CfnAnalysis.ItemsLimitConfigurationProperty;
        /**
         * The sort configuration of color fields in a bar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html#cfn-quicksight-analysis-barchartsortconfiguration-colorsort
         */
        readonly colorSort?: Array<CfnAnalysis.FieldSortOptionsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The limit on the number of small multiples panels that are displayed.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html#cfn-quicksight-analysis-barchartsortconfiguration-smallmultipleslimitconfiguration
         */
        readonly smallMultiplesLimitConfiguration?: cdk.IResolvable | CfnAnalysis.ItemsLimitConfigurationProperty;
        /**
         * The sort configuration of the small multiples field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html#cfn-quicksight-analysis-barchartsortconfiguration-smallmultiplessort
         */
        readonly smallMultiplesSort?: Array<CfnAnalysis.FieldSortOptionsProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The field wells of a `BarChartVisual` .
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartfieldwells.html
     */
    interface BarChartFieldWellsProperty {
        /**
         * The aggregated field wells of a bar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartfieldwells.html#cfn-quicksight-analysis-barchartfieldwells-barchartaggregatedfieldwells
         */
        readonly barChartAggregatedFieldWells?: CfnAnalysis.BarChartAggregatedFieldWellsProperty | cdk.IResolvable;
    }
    /**
     * The aggregated field wells of a bar chart.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartaggregatedfieldwells.html
     */
    interface BarChartAggregatedFieldWellsProperty {
        /**
         * The category (y-axis) field well of a bar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartaggregatedfieldwells.html#cfn-quicksight-analysis-barchartaggregatedfieldwells-category
         */
        readonly category?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The color (group/color) field well of a bar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartaggregatedfieldwells.html#cfn-quicksight-analysis-barchartaggregatedfieldwells-colors
         */
        readonly colors?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The small multiples field well of a bar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartaggregatedfieldwells.html#cfn-quicksight-analysis-barchartaggregatedfieldwells-smallmultiples
         */
        readonly smallMultiples?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The value field wells of a bar chart.
         *
         * Values are aggregated by category.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartaggregatedfieldwells.html#cfn-quicksight-analysis-barchartaggregatedfieldwells-values
         */
        readonly values?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
    }
    /**
     * A scatter plot.
     *
     * For more information, see [Using scatter plots](https://docs.aws.amazon.com/quicksight/latest/user/scatter-plot.html) in the *Amazon QuickSight User Guide* .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotvisual.html
     */
    interface ScatterPlotVisualProperty {
        /**
         * The list of custom actions that are configured for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotvisual.html#cfn-quicksight-analysis-scatterplotvisual-actions
         */
        readonly actions?: Array<cdk.IResolvable | CfnAnalysis.VisualCustomActionProperty> | cdk.IResolvable;
        /**
         * The configuration settings of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotvisual.html#cfn-quicksight-analysis-scatterplotvisual-chartconfiguration
         */
        readonly chartConfiguration?: cdk.IResolvable | CfnAnalysis.ScatterPlotConfigurationProperty;
        /**
         * The column hierarchy that is used during drill-downs and drill-ups.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotvisual.html#cfn-quicksight-analysis-scatterplotvisual-columnhierarchies
         */
        readonly columnHierarchies?: Array<CfnAnalysis.ColumnHierarchyProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The subtitle that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotvisual.html#cfn-quicksight-analysis-scatterplotvisual-subtitle
         */
        readonly subtitle?: cdk.IResolvable | CfnAnalysis.VisualSubtitleLabelOptionsProperty;
        /**
         * The title that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotvisual.html#cfn-quicksight-analysis-scatterplotvisual-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.VisualTitleLabelOptionsProperty;
        /**
         * The alt text for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotvisual.html#cfn-quicksight-analysis-scatterplotvisual-visualcontentalttext
         */
        readonly visualContentAltText?: string;
        /**
         * The unique identifier of a visual.
         *
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotvisual.html#cfn-quicksight-analysis-scatterplotvisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * The configuration of a scatter plot.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotconfiguration.html
     */
    interface ScatterPlotConfigurationProperty {
        /**
         * The options that determine if visual data labels are displayed.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotconfiguration.html#cfn-quicksight-analysis-scatterplotconfiguration-datalabels
         */
        readonly dataLabels?: CfnAnalysis.DataLabelOptionsProperty | cdk.IResolvable;
        /**
         * The field wells of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotconfiguration.html#cfn-quicksight-analysis-scatterplotconfiguration-fieldwells
         */
        readonly fieldWells?: cdk.IResolvable | CfnAnalysis.ScatterPlotFieldWellsProperty;
        /**
         * The general visual interactions setup for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotconfiguration.html#cfn-quicksight-analysis-scatterplotconfiguration-interactions
         */
        readonly interactions?: cdk.IResolvable | CfnAnalysis.VisualInteractionOptionsProperty;
        /**
         * The legend display setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotconfiguration.html#cfn-quicksight-analysis-scatterplotconfiguration-legend
         */
        readonly legend?: cdk.IResolvable | CfnAnalysis.LegendOptionsProperty;
        /**
         * The sort configuration of a scatter plot.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotconfiguration.html#cfn-quicksight-analysis-scatterplotconfiguration-sortconfiguration
         */
        readonly sortConfiguration?: cdk.IResolvable | CfnAnalysis.ScatterPlotSortConfigurationProperty;
        /**
         * The legend display setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotconfiguration.html#cfn-quicksight-analysis-scatterplotconfiguration-tooltip
         */
        readonly tooltip?: cdk.IResolvable | CfnAnalysis.TooltipOptionsProperty;
        /**
         * The palette (chart color) display setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotconfiguration.html#cfn-quicksight-analysis-scatterplotconfiguration-visualpalette
         */
        readonly visualPalette?: cdk.IResolvable | CfnAnalysis.VisualPaletteProperty;
        /**
         * The label display options (grid line, range, scale, and axis step) of the scatter plot's x-axis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotconfiguration.html#cfn-quicksight-analysis-scatterplotconfiguration-xaxisdisplayoptions
         */
        readonly xAxisDisplayOptions?: CfnAnalysis.AxisDisplayOptionsProperty | cdk.IResolvable;
        /**
         * The label options (label text, label visibility, and sort icon visibility) of the scatter plot's x-axis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotconfiguration.html#cfn-quicksight-analysis-scatterplotconfiguration-xaxislabeloptions
         */
        readonly xAxisLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The label display options (grid line, range, scale, and axis step) of the scatter plot's y-axis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotconfiguration.html#cfn-quicksight-analysis-scatterplotconfiguration-yaxisdisplayoptions
         */
        readonly yAxisDisplayOptions?: CfnAnalysis.AxisDisplayOptionsProperty | cdk.IResolvable;
        /**
         * The label options (label text, label visibility, and sort icon visibility) of the scatter plot's y-axis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotconfiguration.html#cfn-quicksight-analysis-scatterplotconfiguration-yaxislabeloptions
         */
        readonly yAxisLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
    }
    /**
     * The field well configuration of a scatter plot.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotfieldwells.html
     */
    interface ScatterPlotFieldWellsProperty {
        /**
         * The aggregated field wells of a scatter plot.
         *
         * The x and y-axes of scatter plots with aggregated field wells are aggregated by category, label, or both.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotfieldwells.html#cfn-quicksight-analysis-scatterplotfieldwells-scatterplotcategoricallyaggregatedfieldwells
         */
        readonly scatterPlotCategoricallyAggregatedFieldWells?: cdk.IResolvable | CfnAnalysis.ScatterPlotCategoricallyAggregatedFieldWellsProperty;
        /**
         * The unaggregated field wells of a scatter plot.
         *
         * The x and y-axes of these scatter plots are unaggregated.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotfieldwells.html#cfn-quicksight-analysis-scatterplotfieldwells-scatterplotunaggregatedfieldwells
         */
        readonly scatterPlotUnaggregatedFieldWells?: cdk.IResolvable | CfnAnalysis.ScatterPlotUnaggregatedFieldWellsProperty;
    }
    /**
     * The unaggregated field wells of a scatter plot.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotunaggregatedfieldwells.html
     */
    interface ScatterPlotUnaggregatedFieldWellsProperty {
        /**
         * The category field well of a scatter plot.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotunaggregatedfieldwells.html#cfn-quicksight-analysis-scatterplotunaggregatedfieldwells-category
         */
        readonly category?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The label field well of a scatter plot.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotunaggregatedfieldwells.html#cfn-quicksight-analysis-scatterplotunaggregatedfieldwells-label
         */
        readonly label?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The size field well of a scatter plot.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotunaggregatedfieldwells.html#cfn-quicksight-analysis-scatterplotunaggregatedfieldwells-size
         */
        readonly size?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
        /**
         * The x-axis field well of a scatter plot.
         *
         * The x-axis is a dimension field and cannot be aggregated.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotunaggregatedfieldwells.html#cfn-quicksight-analysis-scatterplotunaggregatedfieldwells-xaxis
         */
        readonly xAxis?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The y-axis field well of a scatter plot.
         *
         * The y-axis is a dimension field and cannot be aggregated.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotunaggregatedfieldwells.html#cfn-quicksight-analysis-scatterplotunaggregatedfieldwells-yaxis
         */
        readonly yAxis?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The aggregated field well of a scatter plot.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotcategoricallyaggregatedfieldwells.html
     */
    interface ScatterPlotCategoricallyAggregatedFieldWellsProperty {
        /**
         * The category field well of a scatter plot.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotcategoricallyaggregatedfieldwells.html#cfn-quicksight-analysis-scatterplotcategoricallyaggregatedfieldwells-category
         */
        readonly category?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The label field well of a scatter plot.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotcategoricallyaggregatedfieldwells.html#cfn-quicksight-analysis-scatterplotcategoricallyaggregatedfieldwells-label
         */
        readonly label?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The size field well of a scatter plot.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotcategoricallyaggregatedfieldwells.html#cfn-quicksight-analysis-scatterplotcategoricallyaggregatedfieldwells-size
         */
        readonly size?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
        /**
         * The x-axis field well of a scatter plot.
         *
         * The x-axis is aggregated by category.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotcategoricallyaggregatedfieldwells.html#cfn-quicksight-analysis-scatterplotcategoricallyaggregatedfieldwells-xaxis
         */
        readonly xAxis?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
        /**
         * The y-axis field well of a scatter plot.
         *
         * The y-axis is aggregated by category.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotcategoricallyaggregatedfieldwells.html#cfn-quicksight-analysis-scatterplotcategoricallyaggregatedfieldwells-yaxis
         */
        readonly yAxis?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
    }
    /**
     * The sort configuration of a scatter plot.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotsortconfiguration.html
     */
    interface ScatterPlotSortConfigurationProperty {
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotsortconfiguration.html#cfn-quicksight-analysis-scatterplotsortconfiguration-scatterplotlimitconfiguration
         */
        readonly scatterPlotLimitConfiguration?: cdk.IResolvable | CfnAnalysis.ItemsLimitConfigurationProperty;
    }
    /**
     * A radar chart visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartvisual.html
     */
    interface RadarChartVisualProperty {
        /**
         * The list of custom actions that are configured for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartvisual.html#cfn-quicksight-analysis-radarchartvisual-actions
         */
        readonly actions?: Array<cdk.IResolvable | CfnAnalysis.VisualCustomActionProperty> | cdk.IResolvable;
        /**
         * The configuration settings of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartvisual.html#cfn-quicksight-analysis-radarchartvisual-chartconfiguration
         */
        readonly chartConfiguration?: cdk.IResolvable | CfnAnalysis.RadarChartConfigurationProperty;
        /**
         * The column hierarchy that is used during drill-downs and drill-ups.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartvisual.html#cfn-quicksight-analysis-radarchartvisual-columnhierarchies
         */
        readonly columnHierarchies?: Array<CfnAnalysis.ColumnHierarchyProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The subtitle that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartvisual.html#cfn-quicksight-analysis-radarchartvisual-subtitle
         */
        readonly subtitle?: cdk.IResolvable | CfnAnalysis.VisualSubtitleLabelOptionsProperty;
        /**
         * The title that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartvisual.html#cfn-quicksight-analysis-radarchartvisual-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.VisualTitleLabelOptionsProperty;
        /**
         * The alt text for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartvisual.html#cfn-quicksight-analysis-radarchartvisual-visualcontentalttext
         */
        readonly visualContentAltText?: string;
        /**
         * The unique identifier of a visual.
         *
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartvisual.html#cfn-quicksight-analysis-radarchartvisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * The configuration of a `RadarChartVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartconfiguration.html
     */
    interface RadarChartConfigurationProperty {
        /**
         * Determines the visibility of the colors of alternatign bands in a radar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartconfiguration.html#cfn-quicksight-analysis-radarchartconfiguration-alternatebandcolorsvisibility
         */
        readonly alternateBandColorsVisibility?: string;
        /**
         * The color of the even-numbered alternate bands of a radar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartconfiguration.html#cfn-quicksight-analysis-radarchartconfiguration-alternatebandevencolor
         */
        readonly alternateBandEvenColor?: string;
        /**
         * The color of the odd-numbered alternate bands of a radar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartconfiguration.html#cfn-quicksight-analysis-radarchartconfiguration-alternatebandoddcolor
         */
        readonly alternateBandOddColor?: string;
        /**
         * The axis behavior options of a radar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartconfiguration.html#cfn-quicksight-analysis-radarchartconfiguration-axesrangescale
         */
        readonly axesRangeScale?: string;
        /**
         * The base sreies settings of a radar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartconfiguration.html#cfn-quicksight-analysis-radarchartconfiguration-baseseriessettings
         */
        readonly baseSeriesSettings?: cdk.IResolvable | CfnAnalysis.RadarChartSeriesSettingsProperty;
        /**
         * The category axis of a radar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartconfiguration.html#cfn-quicksight-analysis-radarchartconfiguration-categoryaxis
         */
        readonly categoryAxis?: CfnAnalysis.AxisDisplayOptionsProperty | cdk.IResolvable;
        /**
         * The category label options of a radar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartconfiguration.html#cfn-quicksight-analysis-radarchartconfiguration-categorylabeloptions
         */
        readonly categoryLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The color axis of a radar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartconfiguration.html#cfn-quicksight-analysis-radarchartconfiguration-coloraxis
         */
        readonly colorAxis?: CfnAnalysis.AxisDisplayOptionsProperty | cdk.IResolvable;
        /**
         * The color label options of a radar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartconfiguration.html#cfn-quicksight-analysis-radarchartconfiguration-colorlabeloptions
         */
        readonly colorLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The field well configuration of a `RadarChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartconfiguration.html#cfn-quicksight-analysis-radarchartconfiguration-fieldwells
         */
        readonly fieldWells?: cdk.IResolvable | CfnAnalysis.RadarChartFieldWellsProperty;
        /**
         * The general visual interactions setup for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartconfiguration.html#cfn-quicksight-analysis-radarchartconfiguration-interactions
         */
        readonly interactions?: cdk.IResolvable | CfnAnalysis.VisualInteractionOptionsProperty;
        /**
         * The legend display setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartconfiguration.html#cfn-quicksight-analysis-radarchartconfiguration-legend
         */
        readonly legend?: cdk.IResolvable | CfnAnalysis.LegendOptionsProperty;
        /**
         * The shape of the radar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartconfiguration.html#cfn-quicksight-analysis-radarchartconfiguration-shape
         */
        readonly shape?: string;
        /**
         * The sort configuration of a `RadarChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartconfiguration.html#cfn-quicksight-analysis-radarchartconfiguration-sortconfiguration
         */
        readonly sortConfiguration?: cdk.IResolvable | CfnAnalysis.RadarChartSortConfigurationProperty;
        /**
         * The start angle of a radar chart's axis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartconfiguration.html#cfn-quicksight-analysis-radarchartconfiguration-startangle
         */
        readonly startAngle?: number;
        /**
         * The palette (chart color) display setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartconfiguration.html#cfn-quicksight-analysis-radarchartconfiguration-visualpalette
         */
        readonly visualPalette?: cdk.IResolvable | CfnAnalysis.VisualPaletteProperty;
    }
    /**
     * The sort configuration of a `RadarChartVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartsortconfiguration.html
     */
    interface RadarChartSortConfigurationProperty {
        /**
         * The category items limit for a radar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartsortconfiguration.html#cfn-quicksight-analysis-radarchartsortconfiguration-categoryitemslimit
         */
        readonly categoryItemsLimit?: cdk.IResolvable | CfnAnalysis.ItemsLimitConfigurationProperty;
        /**
         * The category sort options of a radar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartsortconfiguration.html#cfn-quicksight-analysis-radarchartsortconfiguration-categorysort
         */
        readonly categorySort?: Array<CfnAnalysis.FieldSortOptionsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The color items limit of a radar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartsortconfiguration.html#cfn-quicksight-analysis-radarchartsortconfiguration-coloritemslimit
         */
        readonly colorItemsLimit?: cdk.IResolvable | CfnAnalysis.ItemsLimitConfigurationProperty;
        /**
         * The color sort configuration of a radar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartsortconfiguration.html#cfn-quicksight-analysis-radarchartsortconfiguration-colorsort
         */
        readonly colorSort?: Array<CfnAnalysis.FieldSortOptionsProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The series settings of a radar chart.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartseriessettings.html
     */
    interface RadarChartSeriesSettingsProperty {
        /**
         * The area style settings of a radar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartseriessettings.html#cfn-quicksight-analysis-radarchartseriessettings-areastylesettings
         */
        readonly areaStyleSettings?: cdk.IResolvable | CfnAnalysis.RadarChartAreaStyleSettingsProperty;
    }
    /**
     * The configured style settings of a radar chart.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartareastylesettings.html
     */
    interface RadarChartAreaStyleSettingsProperty {
        /**
         * The visibility settings of a radar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartareastylesettings.html#cfn-quicksight-analysis-radarchartareastylesettings-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The field wells of a radar chart visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartfieldwells.html
     */
    interface RadarChartFieldWellsProperty {
        /**
         * The aggregated field wells of a radar chart visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartfieldwells.html#cfn-quicksight-analysis-radarchartfieldwells-radarchartaggregatedfieldwells
         */
        readonly radarChartAggregatedFieldWells?: cdk.IResolvable | CfnAnalysis.RadarChartAggregatedFieldWellsProperty;
    }
    /**
     * The aggregated field well configuration of a `RadarChartVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartaggregatedfieldwells.html
     */
    interface RadarChartAggregatedFieldWellsProperty {
        /**
         * The aggregated field well categories of a radar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartaggregatedfieldwells.html#cfn-quicksight-analysis-radarchartaggregatedfieldwells-category
         */
        readonly category?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The color that are assigned to the aggregated field wells of a radar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartaggregatedfieldwells.html#cfn-quicksight-analysis-radarchartaggregatedfieldwells-color
         */
        readonly color?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The values that are assigned to the aggregated field wells of a radar chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartaggregatedfieldwells.html#cfn-quicksight-analysis-radarchartaggregatedfieldwells-values
         */
        readonly values?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
    }
    /**
     * A heat map.
     *
     * For more information, see [Using heat maps](https://docs.aws.amazon.com/quicksight/latest/user/heat-map.html) in the *Amazon QuickSight User Guide* .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapvisual.html
     */
    interface HeatMapVisualProperty {
        /**
         * The list of custom actions that are configured for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapvisual.html#cfn-quicksight-analysis-heatmapvisual-actions
         */
        readonly actions?: Array<cdk.IResolvable | CfnAnalysis.VisualCustomActionProperty> | cdk.IResolvable;
        /**
         * The configuration of a heat map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapvisual.html#cfn-quicksight-analysis-heatmapvisual-chartconfiguration
         */
        readonly chartConfiguration?: CfnAnalysis.HeatMapConfigurationProperty | cdk.IResolvable;
        /**
         * The column hierarchy that is used during drill-downs and drill-ups.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapvisual.html#cfn-quicksight-analysis-heatmapvisual-columnhierarchies
         */
        readonly columnHierarchies?: Array<CfnAnalysis.ColumnHierarchyProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The subtitle that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapvisual.html#cfn-quicksight-analysis-heatmapvisual-subtitle
         */
        readonly subtitle?: cdk.IResolvable | CfnAnalysis.VisualSubtitleLabelOptionsProperty;
        /**
         * The title that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapvisual.html#cfn-quicksight-analysis-heatmapvisual-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.VisualTitleLabelOptionsProperty;
        /**
         * The alt text for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapvisual.html#cfn-quicksight-analysis-heatmapvisual-visualcontentalttext
         */
        readonly visualContentAltText?: string;
        /**
         * The unique identifier of a visual.
         *
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapvisual.html#cfn-quicksight-analysis-heatmapvisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * The configuration of a heat map.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapconfiguration.html
     */
    interface HeatMapConfigurationProperty {
        /**
         * The color options (gradient color, point of divergence) in a heat map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapconfiguration.html#cfn-quicksight-analysis-heatmapconfiguration-colorscale
         */
        readonly colorScale?: CfnAnalysis.ColorScaleProperty | cdk.IResolvable;
        /**
         * The label options of the column that is displayed in a heat map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapconfiguration.html#cfn-quicksight-analysis-heatmapconfiguration-columnlabeloptions
         */
        readonly columnLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The options that determine if visual data labels are displayed.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapconfiguration.html#cfn-quicksight-analysis-heatmapconfiguration-datalabels
         */
        readonly dataLabels?: CfnAnalysis.DataLabelOptionsProperty | cdk.IResolvable;
        /**
         * The field wells of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapconfiguration.html#cfn-quicksight-analysis-heatmapconfiguration-fieldwells
         */
        readonly fieldWells?: CfnAnalysis.HeatMapFieldWellsProperty | cdk.IResolvable;
        /**
         * The general visual interactions setup for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapconfiguration.html#cfn-quicksight-analysis-heatmapconfiguration-interactions
         */
        readonly interactions?: cdk.IResolvable | CfnAnalysis.VisualInteractionOptionsProperty;
        /**
         * The legend display setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapconfiguration.html#cfn-quicksight-analysis-heatmapconfiguration-legend
         */
        readonly legend?: cdk.IResolvable | CfnAnalysis.LegendOptionsProperty;
        /**
         * The label options of the row that is displayed in a `heat map` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapconfiguration.html#cfn-quicksight-analysis-heatmapconfiguration-rowlabeloptions
         */
        readonly rowLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The sort configuration of a heat map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapconfiguration.html#cfn-quicksight-analysis-heatmapconfiguration-sortconfiguration
         */
        readonly sortConfiguration?: CfnAnalysis.HeatMapSortConfigurationProperty | cdk.IResolvable;
        /**
         * The tooltip display setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapconfiguration.html#cfn-quicksight-analysis-heatmapconfiguration-tooltip
         */
        readonly tooltip?: cdk.IResolvable | CfnAnalysis.TooltipOptionsProperty;
    }
    /**
     * The sort configuration of a heat map.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapsortconfiguration.html
     */
    interface HeatMapSortConfigurationProperty {
        /**
         * The limit on the number of columns that are displayed in a heat map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapsortconfiguration.html#cfn-quicksight-analysis-heatmapsortconfiguration-heatmapcolumnitemslimitconfiguration
         */
        readonly heatMapColumnItemsLimitConfiguration?: cdk.IResolvable | CfnAnalysis.ItemsLimitConfigurationProperty;
        /**
         * The column sort configuration for heat map for columns that aren't a part of a field well.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapsortconfiguration.html#cfn-quicksight-analysis-heatmapsortconfiguration-heatmapcolumnsort
         */
        readonly heatMapColumnSort?: Array<CfnAnalysis.FieldSortOptionsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The limit on the number of rows that are displayed in a heat map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapsortconfiguration.html#cfn-quicksight-analysis-heatmapsortconfiguration-heatmaprowitemslimitconfiguration
         */
        readonly heatMapRowItemsLimitConfiguration?: cdk.IResolvable | CfnAnalysis.ItemsLimitConfigurationProperty;
        /**
         * The field sort configuration of the rows fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapsortconfiguration.html#cfn-quicksight-analysis-heatmapsortconfiguration-heatmaprowsort
         */
        readonly heatMapRowSort?: Array<CfnAnalysis.FieldSortOptionsProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The field well configuration of a heat map.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapfieldwells.html
     */
    interface HeatMapFieldWellsProperty {
        /**
         * The aggregated field wells of a heat map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapfieldwells.html#cfn-quicksight-analysis-heatmapfieldwells-heatmapaggregatedfieldwells
         */
        readonly heatMapAggregatedFieldWells?: CfnAnalysis.HeatMapAggregatedFieldWellsProperty | cdk.IResolvable;
    }
    /**
     * The aggregated field wells of a heat map.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapaggregatedfieldwells.html
     */
    interface HeatMapAggregatedFieldWellsProperty {
        /**
         * The columns field well of a heat map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapaggregatedfieldwells.html#cfn-quicksight-analysis-heatmapaggregatedfieldwells-columns
         */
        readonly columns?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The rows field well of a heat map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapaggregatedfieldwells.html#cfn-quicksight-analysis-heatmapaggregatedfieldwells-rows
         */
        readonly rows?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The values field well of a heat map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapaggregatedfieldwells.html#cfn-quicksight-analysis-heatmapaggregatedfieldwells-values
         */
        readonly values?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
    }
    /**
     * Determines the color scale that is applied to the visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorscale.html
     */
    interface ColorScaleProperty {
        /**
         * Determines the color fill type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorscale.html#cfn-quicksight-analysis-colorscale-colorfilltype
         */
        readonly colorFillType: string;
        /**
         * Determines the list of colors that are applied to the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorscale.html#cfn-quicksight-analysis-colorscale-colors
         */
        readonly colors: Array<CfnAnalysis.DataColorProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * Determines the color that is applied to null values.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorscale.html#cfn-quicksight-analysis-colorscale-nullvaluecolor
         */
        readonly nullValueColor?: CfnAnalysis.DataColorProperty | cdk.IResolvable;
    }
    /**
     * Determines the color that is applied to a particular data value.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datacolor.html
     */
    interface DataColorProperty {
        /**
         * The color that is applied to the data value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datacolor.html#cfn-quicksight-analysis-datacolor-color
         */
        readonly color?: string;
        /**
         * The data value that the color is applied to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datacolor.html#cfn-quicksight-analysis-datacolor-datavalue
         */
        readonly dataValue?: number;
    }
    /**
     * A tree map.
     *
     * For more information, see [Using tree maps](https://docs.aws.amazon.com/quicksight/latest/user/tree-map.html) in the *Amazon QuickSight User Guide* .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapvisual.html
     */
    interface TreeMapVisualProperty {
        /**
         * The list of custom actions that are configured for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapvisual.html#cfn-quicksight-analysis-treemapvisual-actions
         */
        readonly actions?: Array<cdk.IResolvable | CfnAnalysis.VisualCustomActionProperty> | cdk.IResolvable;
        /**
         * The configuration settings of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapvisual.html#cfn-quicksight-analysis-treemapvisual-chartconfiguration
         */
        readonly chartConfiguration?: cdk.IResolvable | CfnAnalysis.TreeMapConfigurationProperty;
        /**
         * The column hierarchy that is used during drill-downs and drill-ups.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapvisual.html#cfn-quicksight-analysis-treemapvisual-columnhierarchies
         */
        readonly columnHierarchies?: Array<CfnAnalysis.ColumnHierarchyProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The subtitle that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapvisual.html#cfn-quicksight-analysis-treemapvisual-subtitle
         */
        readonly subtitle?: cdk.IResolvable | CfnAnalysis.VisualSubtitleLabelOptionsProperty;
        /**
         * The title that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapvisual.html#cfn-quicksight-analysis-treemapvisual-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.VisualTitleLabelOptionsProperty;
        /**
         * The alt text for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapvisual.html#cfn-quicksight-analysis-treemapvisual-visualcontentalttext
         */
        readonly visualContentAltText?: string;
        /**
         * The unique identifier of a visual.
         *
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers..
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapvisual.html#cfn-quicksight-analysis-treemapvisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * The configuration of a tree map.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapconfiguration.html
     */
    interface TreeMapConfigurationProperty {
        /**
         * The label options (label text, label visibility) for the colors displayed in a tree map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapconfiguration.html#cfn-quicksight-analysis-treemapconfiguration-colorlabeloptions
         */
        readonly colorLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The color options (gradient color, point of divergence) of a tree map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapconfiguration.html#cfn-quicksight-analysis-treemapconfiguration-colorscale
         */
        readonly colorScale?: CfnAnalysis.ColorScaleProperty | cdk.IResolvable;
        /**
         * The options that determine if visual data labels are displayed.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapconfiguration.html#cfn-quicksight-analysis-treemapconfiguration-datalabels
         */
        readonly dataLabels?: CfnAnalysis.DataLabelOptionsProperty | cdk.IResolvable;
        /**
         * The field wells of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapconfiguration.html#cfn-quicksight-analysis-treemapconfiguration-fieldwells
         */
        readonly fieldWells?: cdk.IResolvable | CfnAnalysis.TreeMapFieldWellsProperty;
        /**
         * The label options (label text, label visibility) of the groups that are displayed in a tree map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapconfiguration.html#cfn-quicksight-analysis-treemapconfiguration-grouplabeloptions
         */
        readonly groupLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The general visual interactions setup for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapconfiguration.html#cfn-quicksight-analysis-treemapconfiguration-interactions
         */
        readonly interactions?: cdk.IResolvable | CfnAnalysis.VisualInteractionOptionsProperty;
        /**
         * The legend display setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapconfiguration.html#cfn-quicksight-analysis-treemapconfiguration-legend
         */
        readonly legend?: cdk.IResolvable | CfnAnalysis.LegendOptionsProperty;
        /**
         * The label options (label text, label visibility) of the sizes that are displayed in a tree map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapconfiguration.html#cfn-quicksight-analysis-treemapconfiguration-sizelabeloptions
         */
        readonly sizeLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The sort configuration of a tree map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapconfiguration.html#cfn-quicksight-analysis-treemapconfiguration-sortconfiguration
         */
        readonly sortConfiguration?: cdk.IResolvable | CfnAnalysis.TreeMapSortConfigurationProperty;
        /**
         * The tooltip display setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapconfiguration.html#cfn-quicksight-analysis-treemapconfiguration-tooltip
         */
        readonly tooltip?: cdk.IResolvable | CfnAnalysis.TooltipOptionsProperty;
    }
    /**
     * The sort configuration of a tree map.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapsortconfiguration.html
     */
    interface TreeMapSortConfigurationProperty {
        /**
         * The limit on the number of groups that are displayed.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapsortconfiguration.html#cfn-quicksight-analysis-treemapsortconfiguration-treemapgroupitemslimitconfiguration
         */
        readonly treeMapGroupItemsLimitConfiguration?: cdk.IResolvable | CfnAnalysis.ItemsLimitConfigurationProperty;
        /**
         * The sort configuration of group by fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapsortconfiguration.html#cfn-quicksight-analysis-treemapsortconfiguration-treemapsort
         */
        readonly treeMapSort?: Array<CfnAnalysis.FieldSortOptionsProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The field wells of a tree map.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapfieldwells.html
     */
    interface TreeMapFieldWellsProperty {
        /**
         * The aggregated field wells of a tree map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapfieldwells.html#cfn-quicksight-analysis-treemapfieldwells-treemapaggregatedfieldwells
         */
        readonly treeMapAggregatedFieldWells?: cdk.IResolvable | CfnAnalysis.TreeMapAggregatedFieldWellsProperty;
    }
    /**
     * Aggregated field wells of a tree map.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapaggregatedfieldwells.html
     */
    interface TreeMapAggregatedFieldWellsProperty {
        /**
         * The color field well of a tree map.
         *
         * Values are grouped by aggregations based on group by fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapaggregatedfieldwells.html#cfn-quicksight-analysis-treemapaggregatedfieldwells-colors
         */
        readonly colors?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
        /**
         * The group by field well of a tree map.
         *
         * Values are grouped based on group by fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapaggregatedfieldwells.html#cfn-quicksight-analysis-treemapaggregatedfieldwells-groups
         */
        readonly groups?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The size field well of a tree map.
         *
         * Values are aggregated based on group by fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapaggregatedfieldwells.html#cfn-quicksight-analysis-treemapaggregatedfieldwells-sizes
         */
        readonly sizes?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
    }
    /**
     * A combo chart.
     *
     * The `ComboChartVisual` includes stacked bar combo charts and clustered bar combo charts
     *
     * For more information, see [Using combo charts](https://docs.aws.amazon.com/quicksight/latest/user/combo-charts.html) in the *Amazon QuickSight User Guide* .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartvisual.html
     */
    interface ComboChartVisualProperty {
        /**
         * The list of custom actions that are configured for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartvisual.html#cfn-quicksight-analysis-combochartvisual-actions
         */
        readonly actions?: Array<cdk.IResolvable | CfnAnalysis.VisualCustomActionProperty> | cdk.IResolvable;
        /**
         * The configuration settings of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartvisual.html#cfn-quicksight-analysis-combochartvisual-chartconfiguration
         */
        readonly chartConfiguration?: CfnAnalysis.ComboChartConfigurationProperty | cdk.IResolvable;
        /**
         * The column hierarchy that is used during drill-downs and drill-ups.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartvisual.html#cfn-quicksight-analysis-combochartvisual-columnhierarchies
         */
        readonly columnHierarchies?: Array<CfnAnalysis.ColumnHierarchyProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The subtitle that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartvisual.html#cfn-quicksight-analysis-combochartvisual-subtitle
         */
        readonly subtitle?: cdk.IResolvable | CfnAnalysis.VisualSubtitleLabelOptionsProperty;
        /**
         * The title that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartvisual.html#cfn-quicksight-analysis-combochartvisual-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.VisualTitleLabelOptionsProperty;
        /**
         * The alt text for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartvisual.html#cfn-quicksight-analysis-combochartvisual-visualcontentalttext
         */
        readonly visualContentAltText?: string;
        /**
         * The unique identifier of a visual.
         *
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartvisual.html#cfn-quicksight-analysis-combochartvisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * The configuration of a `ComboChartVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html
     */
    interface ComboChartConfigurationProperty {
        /**
         * The options that determine if visual data labels are displayed.
         *
         * The data label options for a bar in a combo chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-bardatalabels
         */
        readonly barDataLabels?: CfnAnalysis.DataLabelOptionsProperty | cdk.IResolvable;
        /**
         * Determines the bar arrangement in a combo chart. The following are valid values in this structure:.
         *
         * - `CLUSTERED` : For clustered bar combo charts.
         * - `STACKED` : For stacked bar combo charts.
         * - `STACKED_PERCENT` : Do not use. If you use this value, the operation returns a validation error.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-barsarrangement
         */
        readonly barsArrangement?: string;
        /**
         * The category axis of a combo chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-categoryaxis
         */
        readonly categoryAxis?: CfnAnalysis.AxisDisplayOptionsProperty | cdk.IResolvable;
        /**
         * The label options (label text, label visibility, and sort icon visibility) of a combo chart category (group/color) field well.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-categorylabeloptions
         */
        readonly categoryLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The label options (label text, label visibility, and sort icon visibility) of a combo chart's color field well.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-colorlabeloptions
         */
        readonly colorLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The field wells of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-fieldwells
         */
        readonly fieldWells?: CfnAnalysis.ComboChartFieldWellsProperty | cdk.IResolvable;
        /**
         * The general visual interactions setup for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-interactions
         */
        readonly interactions?: cdk.IResolvable | CfnAnalysis.VisualInteractionOptionsProperty;
        /**
         * The legend display setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-legend
         */
        readonly legend?: cdk.IResolvable | CfnAnalysis.LegendOptionsProperty;
        /**
         * The options that determine if visual data labels are displayed.
         *
         * The data label options for a line in a combo chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-linedatalabels
         */
        readonly lineDataLabels?: CfnAnalysis.DataLabelOptionsProperty | cdk.IResolvable;
        /**
         * The label display options (grid line, range, scale, and axis step) of a combo chart's primary y-axis (bar) field well.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-primaryyaxisdisplayoptions
         */
        readonly primaryYAxisDisplayOptions?: CfnAnalysis.AxisDisplayOptionsProperty | cdk.IResolvable;
        /**
         * The label options (label text, label visibility, and sort icon visibility) of a combo chart's primary y-axis (bar) field well.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-primaryyaxislabeloptions
         */
        readonly primaryYAxisLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The reference line setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-referencelines
         */
        readonly referenceLines?: Array<cdk.IResolvable | CfnAnalysis.ReferenceLineProperty> | cdk.IResolvable;
        /**
         * The label display options (grid line, range, scale, axis step) of a combo chart's secondary y-axis (line) field well.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-secondaryyaxisdisplayoptions
         */
        readonly secondaryYAxisDisplayOptions?: CfnAnalysis.AxisDisplayOptionsProperty | cdk.IResolvable;
        /**
         * The label options (label text, label visibility, and sort icon visibility) of a combo chart's secondary y-axis(line) field well.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-secondaryyaxislabeloptions
         */
        readonly secondaryYAxisLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-singleaxisoptions
         */
        readonly singleAxisOptions?: cdk.IResolvable | CfnAnalysis.SingleAxisOptionsProperty;
        /**
         * The sort configuration of a `ComboChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-sortconfiguration
         */
        readonly sortConfiguration?: CfnAnalysis.ComboChartSortConfigurationProperty | cdk.IResolvable;
        /**
         * The legend display setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-tooltip
         */
        readonly tooltip?: cdk.IResolvable | CfnAnalysis.TooltipOptionsProperty;
        /**
         * The palette (chart color) display setup of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html#cfn-quicksight-analysis-combochartconfiguration-visualpalette
         */
        readonly visualPalette?: cdk.IResolvable | CfnAnalysis.VisualPaletteProperty;
    }
    /**
     * The sort configuration of a `ComboChartVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartsortconfiguration.html
     */
    interface ComboChartSortConfigurationProperty {
        /**
         * The item limit configuration for the category field well of a combo chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartsortconfiguration.html#cfn-quicksight-analysis-combochartsortconfiguration-categoryitemslimit
         */
        readonly categoryItemsLimit?: cdk.IResolvable | CfnAnalysis.ItemsLimitConfigurationProperty;
        /**
         * The sort configuration of the category field well in a combo chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartsortconfiguration.html#cfn-quicksight-analysis-combochartsortconfiguration-categorysort
         */
        readonly categorySort?: Array<CfnAnalysis.FieldSortOptionsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The item limit configuration of the color field well in a combo chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartsortconfiguration.html#cfn-quicksight-analysis-combochartsortconfiguration-coloritemslimit
         */
        readonly colorItemsLimit?: cdk.IResolvable | CfnAnalysis.ItemsLimitConfigurationProperty;
        /**
         * The sort configuration of the color field well in a combo chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartsortconfiguration.html#cfn-quicksight-analysis-combochartsortconfiguration-colorsort
         */
        readonly colorSort?: Array<CfnAnalysis.FieldSortOptionsProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The field wells of the visual.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartfieldwells.html
     */
    interface ComboChartFieldWellsProperty {
        /**
         * The aggregated field wells of a combo chart.
         *
         * Combo charts only have aggregated field wells. Columns in a combo chart are aggregated by category.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartfieldwells.html#cfn-quicksight-analysis-combochartfieldwells-combochartaggregatedfieldwells
         */
        readonly comboChartAggregatedFieldWells?: CfnAnalysis.ComboChartAggregatedFieldWellsProperty | cdk.IResolvable;
    }
    /**
     * The aggregated field wells of a combo chart.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartaggregatedfieldwells.html
     */
    interface ComboChartAggregatedFieldWellsProperty {
        /**
         * The aggregated `BarValues` field well of a combo chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartaggregatedfieldwells.html#cfn-quicksight-analysis-combochartaggregatedfieldwells-barvalues
         */
        readonly barValues?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
        /**
         * The aggregated category field wells of a combo chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartaggregatedfieldwells.html#cfn-quicksight-analysis-combochartaggregatedfieldwells-category
         */
        readonly category?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The aggregated colors field well of a combo chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartaggregatedfieldwells.html#cfn-quicksight-analysis-combochartaggregatedfieldwells-colors
         */
        readonly colors?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The aggregated `LineValues` field well of a combo chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartaggregatedfieldwells.html#cfn-quicksight-analysis-combochartaggregatedfieldwells-linevalues
         */
        readonly lineValues?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
    }
    /**
     * The settings of a chart's single axis configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-singleaxisoptions.html
     */
    interface SingleAxisOptionsProperty {
        /**
         * The Y axis options of a single axis configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-singleaxisoptions.html#cfn-quicksight-analysis-singleaxisoptions-yaxisoptions
         */
        readonly yAxisOptions?: cdk.IResolvable | CfnAnalysis.YAxisOptionsProperty;
    }
    /**
     * The options that are available for a single Y axis in a chart.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-yaxisoptions.html
     */
    interface YAxisOptionsProperty {
        /**
         * The Y axis type to be used in the chart.
         *
         * If you choose `PRIMARY_Y_AXIS` , the primary Y Axis is located on the leftmost vertical axis of the chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-yaxisoptions.html#cfn-quicksight-analysis-yaxisoptions-yaxis
         */
        readonly yAxis: string;
    }
    /**
     * A word cloud.
     *
     * For more information, see [Using word clouds](https://docs.aws.amazon.com/quicksight/latest/user/word-cloud.html) in the *Amazon QuickSight User Guide* .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudvisual.html
     */
    interface WordCloudVisualProperty {
        /**
         * The list of custom actions that are configured for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudvisual.html#cfn-quicksight-analysis-wordcloudvisual-actions
         */
        readonly actions?: Array<cdk.IResolvable | CfnAnalysis.VisualCustomActionProperty> | cdk.IResolvable;
        /**
         * The configuration settings of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudvisual.html#cfn-quicksight-analysis-wordcloudvisual-chartconfiguration
         */
        readonly chartConfiguration?: cdk.IResolvable | CfnAnalysis.WordCloudChartConfigurationProperty;
        /**
         * The column hierarchy that is used during drill-downs and drill-ups.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudvisual.html#cfn-quicksight-analysis-wordcloudvisual-columnhierarchies
         */
        readonly columnHierarchies?: Array<CfnAnalysis.ColumnHierarchyProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The subtitle that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudvisual.html#cfn-quicksight-analysis-wordcloudvisual-subtitle
         */
        readonly subtitle?: cdk.IResolvable | CfnAnalysis.VisualSubtitleLabelOptionsProperty;
        /**
         * The title that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudvisual.html#cfn-quicksight-analysis-wordcloudvisual-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.VisualTitleLabelOptionsProperty;
        /**
         * The alt text for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudvisual.html#cfn-quicksight-analysis-wordcloudvisual-visualcontentalttext
         */
        readonly visualContentAltText?: string;
        /**
         * The unique identifier of a visual.
         *
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers..
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudvisual.html#cfn-quicksight-analysis-wordcloudvisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * The configuration of a word cloud visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudchartconfiguration.html
     */
    interface WordCloudChartConfigurationProperty {
        /**
         * The label options (label text, label visibility, and sort icon visibility) for the word cloud category.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudchartconfiguration.html#cfn-quicksight-analysis-wordcloudchartconfiguration-categorylabeloptions
         */
        readonly categoryLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The field wells of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudchartconfiguration.html#cfn-quicksight-analysis-wordcloudchartconfiguration-fieldwells
         */
        readonly fieldWells?: cdk.IResolvable | CfnAnalysis.WordCloudFieldWellsProperty;
        /**
         * The general visual interactions setup for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudchartconfiguration.html#cfn-quicksight-analysis-wordcloudchartconfiguration-interactions
         */
        readonly interactions?: cdk.IResolvable | CfnAnalysis.VisualInteractionOptionsProperty;
        /**
         * The sort configuration of a word cloud visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudchartconfiguration.html#cfn-quicksight-analysis-wordcloudchartconfiguration-sortconfiguration
         */
        readonly sortConfiguration?: cdk.IResolvable | CfnAnalysis.WordCloudSortConfigurationProperty;
        /**
         * The options for a word cloud visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudchartconfiguration.html#cfn-quicksight-analysis-wordcloudchartconfiguration-wordcloudoptions
         */
        readonly wordCloudOptions?: cdk.IResolvable | CfnAnalysis.WordCloudOptionsProperty;
    }
    /**
     * The sort configuration of a word cloud visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudsortconfiguration.html
     */
    interface WordCloudSortConfigurationProperty {
        /**
         * The limit on the number of groups that are displayed in a word cloud.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudsortconfiguration.html#cfn-quicksight-analysis-wordcloudsortconfiguration-categoryitemslimit
         */
        readonly categoryItemsLimit?: cdk.IResolvable | CfnAnalysis.ItemsLimitConfigurationProperty;
        /**
         * The sort configuration of group by fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudsortconfiguration.html#cfn-quicksight-analysis-wordcloudsortconfiguration-categorysort
         */
        readonly categorySort?: Array<CfnAnalysis.FieldSortOptionsProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The field wells of a word cloud visual.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudfieldwells.html
     */
    interface WordCloudFieldWellsProperty {
        /**
         * The aggregated field wells of a word cloud.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudfieldwells.html#cfn-quicksight-analysis-wordcloudfieldwells-wordcloudaggregatedfieldwells
         */
        readonly wordCloudAggregatedFieldWells?: cdk.IResolvable | CfnAnalysis.WordCloudAggregatedFieldWellsProperty;
    }
    /**
     * The aggregated field wells of a word cloud.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudaggregatedfieldwells.html
     */
    interface WordCloudAggregatedFieldWellsProperty {
        /**
         * The group by field well of a word cloud.
         *
         * Values are grouped by group by fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudaggregatedfieldwells.html#cfn-quicksight-analysis-wordcloudaggregatedfieldwells-groupby
         */
        readonly groupBy?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The size field well of a word cloud.
         *
         * Values are aggregated based on group by fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudaggregatedfieldwells.html#cfn-quicksight-analysis-wordcloudaggregatedfieldwells-size
         */
        readonly size?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
    }
    /**
     * The word cloud options for a word cloud visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudoptions.html
     */
    interface WordCloudOptionsProperty {
        /**
         * The cloud layout options (fluid, normal) of a word cloud.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudoptions.html#cfn-quicksight-analysis-wordcloudoptions-cloudlayout
         */
        readonly cloudLayout?: string;
        /**
         * The length limit of each word from 1-100.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudoptions.html#cfn-quicksight-analysis-wordcloudoptions-maximumstringlength
         */
        readonly maximumStringLength?: number;
        /**
         * The word casing options (lower_case, existing_case) for the words in a word cloud.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudoptions.html#cfn-quicksight-analysis-wordcloudoptions-wordcasing
         */
        readonly wordCasing?: string;
        /**
         * The word orientation options (horizontal, horizontal_and_vertical) for the words in a word cloud.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudoptions.html#cfn-quicksight-analysis-wordcloudoptions-wordorientation
         */
        readonly wordOrientation?: string;
        /**
         * The word padding options (none, small, medium, large) for the words in a word cloud.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudoptions.html#cfn-quicksight-analysis-wordcloudoptions-wordpadding
         */
        readonly wordPadding?: string;
        /**
         * The word scaling options (emphasize, normal) for the words in a word cloud.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-wordcloudoptions.html#cfn-quicksight-analysis-wordcloudoptions-wordscaling
         */
        readonly wordScaling?: string;
    }
    /**
     * An insight visual.
     *
     * For more information, see [Working with insights](https://docs.aws.amazon.com/quicksight/latest/user/computational-insights.html) in the *Amazon QuickSight User Guide* .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-insightvisual.html
     */
    interface InsightVisualProperty {
        /**
         * The list of custom actions that are configured for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-insightvisual.html#cfn-quicksight-analysis-insightvisual-actions
         */
        readonly actions?: Array<cdk.IResolvable | CfnAnalysis.VisualCustomActionProperty> | cdk.IResolvable;
        /**
         * The dataset that is used in the insight visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-insightvisual.html#cfn-quicksight-analysis-insightvisual-datasetidentifier
         */
        readonly dataSetIdentifier: string;
        /**
         * The configuration of an insight visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-insightvisual.html#cfn-quicksight-analysis-insightvisual-insightconfiguration
         */
        readonly insightConfiguration?: CfnAnalysis.InsightConfigurationProperty | cdk.IResolvable;
        /**
         * The subtitle that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-insightvisual.html#cfn-quicksight-analysis-insightvisual-subtitle
         */
        readonly subtitle?: cdk.IResolvable | CfnAnalysis.VisualSubtitleLabelOptionsProperty;
        /**
         * The title that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-insightvisual.html#cfn-quicksight-analysis-insightvisual-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.VisualTitleLabelOptionsProperty;
        /**
         * The alt text for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-insightvisual.html#cfn-quicksight-analysis-insightvisual-visualcontentalttext
         */
        readonly visualContentAltText?: string;
        /**
         * The unique identifier of a visual.
         *
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-insightvisual.html#cfn-quicksight-analysis-insightvisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * The configuration of an insight visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-insightconfiguration.html
     */
    interface InsightConfigurationProperty {
        /**
         * The computations configurations of the insight visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-insightconfiguration.html#cfn-quicksight-analysis-insightconfiguration-computations
         */
        readonly computations?: Array<CfnAnalysis.ComputationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The custom narrative of the insight visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-insightconfiguration.html#cfn-quicksight-analysis-insightconfiguration-customnarrative
         */
        readonly customNarrative?: CfnAnalysis.CustomNarrativeOptionsProperty | cdk.IResolvable;
        /**
         * The general visual interactions setup for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-insightconfiguration.html#cfn-quicksight-analysis-insightconfiguration-interactions
         */
        readonly interactions?: cdk.IResolvable | CfnAnalysis.VisualInteractionOptionsProperty;
    }
    /**
     * The computation union that is used in an insight visual.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-computation.html
     */
    interface ComputationProperty {
        /**
         * The forecast computation configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-computation.html#cfn-quicksight-analysis-computation-forecast
         */
        readonly forecast?: CfnAnalysis.ForecastComputationProperty | cdk.IResolvable;
        /**
         * The growth rate computation configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-computation.html#cfn-quicksight-analysis-computation-growthrate
         */
        readonly growthRate?: CfnAnalysis.GrowthRateComputationProperty | cdk.IResolvable;
        /**
         * The maximum and minimum computation configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-computation.html#cfn-quicksight-analysis-computation-maximumminimum
         */
        readonly maximumMinimum?: cdk.IResolvable | CfnAnalysis.MaximumMinimumComputationProperty;
        /**
         * The metric comparison computation configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-computation.html#cfn-quicksight-analysis-computation-metriccomparison
         */
        readonly metricComparison?: cdk.IResolvable | CfnAnalysis.MetricComparisonComputationProperty;
        /**
         * The period over period computation configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-computation.html#cfn-quicksight-analysis-computation-periodoverperiod
         */
        readonly periodOverPeriod?: cdk.IResolvable | CfnAnalysis.PeriodOverPeriodComputationProperty;
        /**
         * The period to `DataSetIdentifier` computation configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-computation.html#cfn-quicksight-analysis-computation-periodtodate
         */
        readonly periodToDate?: cdk.IResolvable | CfnAnalysis.PeriodToDateComputationProperty;
        /**
         * The top movers and bottom movers computation configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-computation.html#cfn-quicksight-analysis-computation-topbottommovers
         */
        readonly topBottomMovers?: cdk.IResolvable | CfnAnalysis.TopBottomMoversComputationProperty;
        /**
         * The top ranked and bottom ranked computation configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-computation.html#cfn-quicksight-analysis-computation-topbottomranked
         */
        readonly topBottomRanked?: cdk.IResolvable | CfnAnalysis.TopBottomRankedComputationProperty;
        /**
         * The total aggregation computation configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-computation.html#cfn-quicksight-analysis-computation-totalaggregation
         */
        readonly totalAggregation?: cdk.IResolvable | CfnAnalysis.TotalAggregationComputationProperty;
        /**
         * The unique values computation configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-computation.html#cfn-quicksight-analysis-computation-uniquevalues
         */
        readonly uniqueValues?: cdk.IResolvable | CfnAnalysis.UniqueValuesComputationProperty;
    }
    /**
     * The period to date computation configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-periodtodatecomputation.html
     */
    interface PeriodToDateComputationProperty {
        /**
         * The ID for a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-periodtodatecomputation.html#cfn-quicksight-analysis-periodtodatecomputation-computationid
         */
        readonly computationId: string;
        /**
         * The name of a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-periodtodatecomputation.html#cfn-quicksight-analysis-periodtodatecomputation-name
         */
        readonly name?: string;
        /**
         * The time granularity setup of period to date computation. Choose from the following options:.
         *
         * - YEAR: Year to date.
         * - MONTH: Month to date.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-periodtodatecomputation.html#cfn-quicksight-analysis-periodtodatecomputation-periodtimegranularity
         */
        readonly periodTimeGranularity?: string;
        /**
         * The time field that is used in a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-periodtodatecomputation.html#cfn-quicksight-analysis-periodtodatecomputation-time
         */
        readonly time?: CfnAnalysis.DimensionFieldProperty | cdk.IResolvable;
        /**
         * The value field that is used in a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-periodtodatecomputation.html#cfn-quicksight-analysis-periodtodatecomputation-value
         */
        readonly value?: cdk.IResolvable | CfnAnalysis.MeasureFieldProperty;
    }
    /**
     * The growth rate computation configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-growthratecomputation.html
     */
    interface GrowthRateComputationProperty {
        /**
         * The ID for a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-growthratecomputation.html#cfn-quicksight-analysis-growthratecomputation-computationid
         */
        readonly computationId: string;
        /**
         * The name of a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-growthratecomputation.html#cfn-quicksight-analysis-growthratecomputation-name
         */
        readonly name?: string;
        /**
         * The period size setup of a growth rate computation.
         *
         * @default - 0
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-growthratecomputation.html#cfn-quicksight-analysis-growthratecomputation-periodsize
         */
        readonly periodSize?: number;
        /**
         * The time field that is used in a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-growthratecomputation.html#cfn-quicksight-analysis-growthratecomputation-time
         */
        readonly time?: CfnAnalysis.DimensionFieldProperty | cdk.IResolvable;
        /**
         * The value field that is used in a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-growthratecomputation.html#cfn-quicksight-analysis-growthratecomputation-value
         */
        readonly value?: cdk.IResolvable | CfnAnalysis.MeasureFieldProperty;
    }
    /**
     * The top ranked and bottom ranked computation configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottomrankedcomputation.html
     */
    interface TopBottomRankedComputationProperty {
        /**
         * The category field that is used in a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottomrankedcomputation.html#cfn-quicksight-analysis-topbottomrankedcomputation-category
         */
        readonly category?: CfnAnalysis.DimensionFieldProperty | cdk.IResolvable;
        /**
         * The ID for a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottomrankedcomputation.html#cfn-quicksight-analysis-topbottomrankedcomputation-computationid
         */
        readonly computationId: string;
        /**
         * The name of a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottomrankedcomputation.html#cfn-quicksight-analysis-topbottomrankedcomputation-name
         */
        readonly name?: string;
        /**
         * The result size of a top and bottom ranked computation.
         *
         * @default - 0
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottomrankedcomputation.html#cfn-quicksight-analysis-topbottomrankedcomputation-resultsize
         */
        readonly resultSize?: number;
        /**
         * The computation type. Choose one of the following options:.
         *
         * - TOP: A top ranked computation.
         * - BOTTOM: A bottom ranked computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottomrankedcomputation.html#cfn-quicksight-analysis-topbottomrankedcomputation-type
         */
        readonly type: string;
        /**
         * The value field that is used in a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottomrankedcomputation.html#cfn-quicksight-analysis-topbottomrankedcomputation-value
         */
        readonly value?: cdk.IResolvable | CfnAnalysis.MeasureFieldProperty;
    }
    /**
     * The total aggregation computation configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-totalaggregationcomputation.html
     */
    interface TotalAggregationComputationProperty {
        /**
         * The ID for a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-totalaggregationcomputation.html#cfn-quicksight-analysis-totalaggregationcomputation-computationid
         */
        readonly computationId: string;
        /**
         * The name of a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-totalaggregationcomputation.html#cfn-quicksight-analysis-totalaggregationcomputation-name
         */
        readonly name?: string;
        /**
         * The value field that is used in a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-totalaggregationcomputation.html#cfn-quicksight-analysis-totalaggregationcomputation-value
         */
        readonly value?: cdk.IResolvable | CfnAnalysis.MeasureFieldProperty;
    }
    /**
     * The forecast computation configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-forecastcomputation.html
     */
    interface ForecastComputationProperty {
        /**
         * The ID for a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-forecastcomputation.html#cfn-quicksight-analysis-forecastcomputation-computationid
         */
        readonly computationId: string;
        /**
         * The custom seasonality value setup of a forecast computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-forecastcomputation.html#cfn-quicksight-analysis-forecastcomputation-customseasonalityvalue
         */
        readonly customSeasonalityValue?: number;
        /**
         * The lower boundary setup of a forecast computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-forecastcomputation.html#cfn-quicksight-analysis-forecastcomputation-lowerboundary
         */
        readonly lowerBoundary?: number;
        /**
         * The name of a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-forecastcomputation.html#cfn-quicksight-analysis-forecastcomputation-name
         */
        readonly name?: string;
        /**
         * The periods backward setup of a forecast computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-forecastcomputation.html#cfn-quicksight-analysis-forecastcomputation-periodsbackward
         */
        readonly periodsBackward?: number;
        /**
         * The periods forward setup of a forecast computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-forecastcomputation.html#cfn-quicksight-analysis-forecastcomputation-periodsforward
         */
        readonly periodsForward?: number;
        /**
         * The prediction interval setup of a forecast computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-forecastcomputation.html#cfn-quicksight-analysis-forecastcomputation-predictioninterval
         */
        readonly predictionInterval?: number;
        /**
         * The seasonality setup of a forecast computation. Choose one of the following options:.
         *
         * - `AUTOMATIC`
         * - `CUSTOM` : Checks the custom seasonality value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-forecastcomputation.html#cfn-quicksight-analysis-forecastcomputation-seasonality
         */
        readonly seasonality?: string;
        /**
         * The time field that is used in a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-forecastcomputation.html#cfn-quicksight-analysis-forecastcomputation-time
         */
        readonly time?: CfnAnalysis.DimensionFieldProperty | cdk.IResolvable;
        /**
         * The upper boundary setup of a forecast computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-forecastcomputation.html#cfn-quicksight-analysis-forecastcomputation-upperboundary
         */
        readonly upperBoundary?: number;
        /**
         * The value field that is used in a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-forecastcomputation.html#cfn-quicksight-analysis-forecastcomputation-value
         */
        readonly value?: cdk.IResolvable | CfnAnalysis.MeasureFieldProperty;
    }
    /**
     * The maximum and minimum computation configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-maximumminimumcomputation.html
     */
    interface MaximumMinimumComputationProperty {
        /**
         * The ID for a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-maximumminimumcomputation.html#cfn-quicksight-analysis-maximumminimumcomputation-computationid
         */
        readonly computationId: string;
        /**
         * The name of a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-maximumminimumcomputation.html#cfn-quicksight-analysis-maximumminimumcomputation-name
         */
        readonly name?: string;
        /**
         * The time field that is used in a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-maximumminimumcomputation.html#cfn-quicksight-analysis-maximumminimumcomputation-time
         */
        readonly time?: CfnAnalysis.DimensionFieldProperty | cdk.IResolvable;
        /**
         * The type of computation. Choose one of the following options:.
         *
         * - MAXIMUM: A maximum computation.
         * - MINIMUM: A minimum computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-maximumminimumcomputation.html#cfn-quicksight-analysis-maximumminimumcomputation-type
         */
        readonly type: string;
        /**
         * The value field that is used in a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-maximumminimumcomputation.html#cfn-quicksight-analysis-maximumminimumcomputation-value
         */
        readonly value?: cdk.IResolvable | CfnAnalysis.MeasureFieldProperty;
    }
    /**
     * The period over period computation configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-periodoverperiodcomputation.html
     */
    interface PeriodOverPeriodComputationProperty {
        /**
         * The ID for a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-periodoverperiodcomputation.html#cfn-quicksight-analysis-periodoverperiodcomputation-computationid
         */
        readonly computationId: string;
        /**
         * The name of a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-periodoverperiodcomputation.html#cfn-quicksight-analysis-periodoverperiodcomputation-name
         */
        readonly name?: string;
        /**
         * The time field that is used in a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-periodoverperiodcomputation.html#cfn-quicksight-analysis-periodoverperiodcomputation-time
         */
        readonly time?: CfnAnalysis.DimensionFieldProperty | cdk.IResolvable;
        /**
         * The value field that is used in a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-periodoverperiodcomputation.html#cfn-quicksight-analysis-periodoverperiodcomputation-value
         */
        readonly value?: cdk.IResolvable | CfnAnalysis.MeasureFieldProperty;
    }
    /**
     * The metric comparison computation configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-metriccomparisoncomputation.html
     */
    interface MetricComparisonComputationProperty {
        /**
         * The ID for a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-metriccomparisoncomputation.html#cfn-quicksight-analysis-metriccomparisoncomputation-computationid
         */
        readonly computationId: string;
        /**
         * The field that is used in a metric comparison from value setup.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-metriccomparisoncomputation.html#cfn-quicksight-analysis-metriccomparisoncomputation-fromvalue
         */
        readonly fromValue?: cdk.IResolvable | CfnAnalysis.MeasureFieldProperty;
        /**
         * The name of a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-metriccomparisoncomputation.html#cfn-quicksight-analysis-metriccomparisoncomputation-name
         */
        readonly name?: string;
        /**
         * The field that is used in a metric comparison to value setup.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-metriccomparisoncomputation.html#cfn-quicksight-analysis-metriccomparisoncomputation-targetvalue
         */
        readonly targetValue?: cdk.IResolvable | CfnAnalysis.MeasureFieldProperty;
        /**
         * The time field that is used in a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-metriccomparisoncomputation.html#cfn-quicksight-analysis-metriccomparisoncomputation-time
         */
        readonly time?: CfnAnalysis.DimensionFieldProperty | cdk.IResolvable;
    }
    /**
     * The top movers and bottom movers computation setup.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottommoverscomputation.html
     */
    interface TopBottomMoversComputationProperty {
        /**
         * The category field that is used in a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottommoverscomputation.html#cfn-quicksight-analysis-topbottommoverscomputation-category
         */
        readonly category?: CfnAnalysis.DimensionFieldProperty | cdk.IResolvable;
        /**
         * The ID for a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottommoverscomputation.html#cfn-quicksight-analysis-topbottommoverscomputation-computationid
         */
        readonly computationId: string;
        /**
         * The mover size setup of the top and bottom movers computation.
         *
         * @default - 0
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottommoverscomputation.html#cfn-quicksight-analysis-topbottommoverscomputation-moversize
         */
        readonly moverSize?: number;
        /**
         * The name of a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottommoverscomputation.html#cfn-quicksight-analysis-topbottommoverscomputation-name
         */
        readonly name?: string;
        /**
         * The sort order setup of the top and bottom movers computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottommoverscomputation.html#cfn-quicksight-analysis-topbottommoverscomputation-sortorder
         */
        readonly sortOrder?: string;
        /**
         * The time field that is used in a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottommoverscomputation.html#cfn-quicksight-analysis-topbottommoverscomputation-time
         */
        readonly time?: CfnAnalysis.DimensionFieldProperty | cdk.IResolvable;
        /**
         * The computation type. Choose from the following options:.
         *
         * - TOP: Top movers computation.
         * - BOTTOM: Bottom movers computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottommoverscomputation.html#cfn-quicksight-analysis-topbottommoverscomputation-type
         */
        readonly type: string;
        /**
         * The value field that is used in a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottommoverscomputation.html#cfn-quicksight-analysis-topbottommoverscomputation-value
         */
        readonly value?: cdk.IResolvable | CfnAnalysis.MeasureFieldProperty;
    }
    /**
     * The unique values computation configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-uniquevaluescomputation.html
     */
    interface UniqueValuesComputationProperty {
        /**
         * The category field that is used in a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-uniquevaluescomputation.html#cfn-quicksight-analysis-uniquevaluescomputation-category
         */
        readonly category?: CfnAnalysis.DimensionFieldProperty | cdk.IResolvable;
        /**
         * The ID for a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-uniquevaluescomputation.html#cfn-quicksight-analysis-uniquevaluescomputation-computationid
         */
        readonly computationId: string;
        /**
         * The name of a computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-uniquevaluescomputation.html#cfn-quicksight-analysis-uniquevaluescomputation-name
         */
        readonly name?: string;
    }
    /**
     * The custom narrative options.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customnarrativeoptions.html
     */
    interface CustomNarrativeOptionsProperty {
        /**
         * The string input of custom narrative.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customnarrativeoptions.html#cfn-quicksight-analysis-customnarrativeoptions-narrative
         */
        readonly narrative: string;
    }
    /**
     * A sankey diagram.
     *
     * For more information, see [Using Sankey diagrams](https://docs.aws.amazon.com/quicksight/latest/user/sankey-diagram.html) in the *Amazon QuickSight User Guide* .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramvisual.html
     */
    interface SankeyDiagramVisualProperty {
        /**
         * The list of custom actions that are configured for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramvisual.html#cfn-quicksight-analysis-sankeydiagramvisual-actions
         */
        readonly actions?: Array<cdk.IResolvable | CfnAnalysis.VisualCustomActionProperty> | cdk.IResolvable;
        /**
         * The configuration of a sankey diagram.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramvisual.html#cfn-quicksight-analysis-sankeydiagramvisual-chartconfiguration
         */
        readonly chartConfiguration?: cdk.IResolvable | CfnAnalysis.SankeyDiagramChartConfigurationProperty;
        /**
         * The subtitle that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramvisual.html#cfn-quicksight-analysis-sankeydiagramvisual-subtitle
         */
        readonly subtitle?: cdk.IResolvable | CfnAnalysis.VisualSubtitleLabelOptionsProperty;
        /**
         * The title that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramvisual.html#cfn-quicksight-analysis-sankeydiagramvisual-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.VisualTitleLabelOptionsProperty;
        /**
         * The alt text for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramvisual.html#cfn-quicksight-analysis-sankeydiagramvisual-visualcontentalttext
         */
        readonly visualContentAltText?: string;
        /**
         * The unique identifier of a visual.
         *
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramvisual.html#cfn-quicksight-analysis-sankeydiagramvisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * The configuration of a sankey diagram.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramchartconfiguration.html
     */
    interface SankeyDiagramChartConfigurationProperty {
        /**
         * The data label configuration of a sankey diagram.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramchartconfiguration.html#cfn-quicksight-analysis-sankeydiagramchartconfiguration-datalabels
         */
        readonly dataLabels?: CfnAnalysis.DataLabelOptionsProperty | cdk.IResolvable;
        /**
         * The field well configuration of a sankey diagram.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramchartconfiguration.html#cfn-quicksight-analysis-sankeydiagramchartconfiguration-fieldwells
         */
        readonly fieldWells?: cdk.IResolvable | CfnAnalysis.SankeyDiagramFieldWellsProperty;
        /**
         * The general visual interactions setup for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramchartconfiguration.html#cfn-quicksight-analysis-sankeydiagramchartconfiguration-interactions
         */
        readonly interactions?: cdk.IResolvable | CfnAnalysis.VisualInteractionOptionsProperty;
        /**
         * The sort configuration of a sankey diagram.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramchartconfiguration.html#cfn-quicksight-analysis-sankeydiagramchartconfiguration-sortconfiguration
         */
        readonly sortConfiguration?: cdk.IResolvable | CfnAnalysis.SankeyDiagramSortConfigurationProperty;
    }
    /**
     * The sort configuration of a sankey diagram.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramsortconfiguration.html
     */
    interface SankeyDiagramSortConfigurationProperty {
        /**
         * The limit on the number of destination nodes that are displayed in a sankey diagram.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramsortconfiguration.html#cfn-quicksight-analysis-sankeydiagramsortconfiguration-destinationitemslimit
         */
        readonly destinationItemsLimit?: cdk.IResolvable | CfnAnalysis.ItemsLimitConfigurationProperty;
        /**
         * The limit on the number of source nodes that are displayed in a sankey diagram.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramsortconfiguration.html#cfn-quicksight-analysis-sankeydiagramsortconfiguration-sourceitemslimit
         */
        readonly sourceItemsLimit?: cdk.IResolvable | CfnAnalysis.ItemsLimitConfigurationProperty;
        /**
         * The sort configuration of the weight fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramsortconfiguration.html#cfn-quicksight-analysis-sankeydiagramsortconfiguration-weightsort
         */
        readonly weightSort?: Array<CfnAnalysis.FieldSortOptionsProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The field well configuration of a sankey diagram.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramfieldwells.html
     */
    interface SankeyDiagramFieldWellsProperty {
        /**
         * The field well configuration of a sankey diagram.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramfieldwells.html#cfn-quicksight-analysis-sankeydiagramfieldwells-sankeydiagramaggregatedfieldwells
         */
        readonly sankeyDiagramAggregatedFieldWells?: cdk.IResolvable | CfnAnalysis.SankeyDiagramAggregatedFieldWellsProperty;
    }
    /**
     * The field well configuration of a sankey diagram.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramaggregatedfieldwells.html
     */
    interface SankeyDiagramAggregatedFieldWellsProperty {
        /**
         * The destination field wells of a sankey diagram.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramaggregatedfieldwells.html#cfn-quicksight-analysis-sankeydiagramaggregatedfieldwells-destination
         */
        readonly destination?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The source field wells of a sankey diagram.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramaggregatedfieldwells.html#cfn-quicksight-analysis-sankeydiagramaggregatedfieldwells-source
         */
        readonly source?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The weight field wells of a sankey diagram.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramaggregatedfieldwells.html#cfn-quicksight-analysis-sankeydiagramaggregatedfieldwells-weight
         */
        readonly weight?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
    }
    /**
     * A gauge chart.
     *
     * For more information, see [Using gauge charts](https://docs.aws.amazon.com/quicksight/latest/user/gauge-chart.html) in the *Amazon QuickSight User Guide* .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartvisual.html
     */
    interface GaugeChartVisualProperty {
        /**
         * The list of custom actions that are configured for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartvisual.html#cfn-quicksight-analysis-gaugechartvisual-actions
         */
        readonly actions?: Array<cdk.IResolvable | CfnAnalysis.VisualCustomActionProperty> | cdk.IResolvable;
        /**
         * The configuration of a `GaugeChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartvisual.html#cfn-quicksight-analysis-gaugechartvisual-chartconfiguration
         */
        readonly chartConfiguration?: CfnAnalysis.GaugeChartConfigurationProperty | cdk.IResolvable;
        /**
         * The conditional formatting of a `GaugeChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartvisual.html#cfn-quicksight-analysis-gaugechartvisual-conditionalformatting
         */
        readonly conditionalFormatting?: CfnAnalysis.GaugeChartConditionalFormattingProperty | cdk.IResolvable;
        /**
         * The subtitle that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartvisual.html#cfn-quicksight-analysis-gaugechartvisual-subtitle
         */
        readonly subtitle?: cdk.IResolvable | CfnAnalysis.VisualSubtitleLabelOptionsProperty;
        /**
         * The title that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartvisual.html#cfn-quicksight-analysis-gaugechartvisual-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.VisualTitleLabelOptionsProperty;
        /**
         * The alt text for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartvisual.html#cfn-quicksight-analysis-gaugechartvisual-visualcontentalttext
         */
        readonly visualContentAltText?: string;
        /**
         * The unique identifier of a visual.
         *
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartvisual.html#cfn-quicksight-analysis-gaugechartvisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * The conditional formatting of a `GaugeChartVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartconditionalformatting.html
     */
    interface GaugeChartConditionalFormattingProperty {
        /**
         * Conditional formatting options of a `GaugeChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartconditionalformatting.html#cfn-quicksight-analysis-gaugechartconditionalformatting-conditionalformattingoptions
         */
        readonly conditionalFormattingOptions?: Array<CfnAnalysis.GaugeChartConditionalFormattingOptionProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * Conditional formatting options of a `GaugeChartVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartconditionalformattingoption.html
     */
    interface GaugeChartConditionalFormattingOptionProperty {
        /**
         * The options that determine the presentation of the arc of a `GaugeChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartconditionalformattingoption.html#cfn-quicksight-analysis-gaugechartconditionalformattingoption-arc
         */
        readonly arc?: CfnAnalysis.GaugeChartArcConditionalFormattingProperty | cdk.IResolvable;
        /**
         * The conditional formatting for the primary value of a `GaugeChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartconditionalformattingoption.html#cfn-quicksight-analysis-gaugechartconditionalformattingoption-primaryvalue
         */
        readonly primaryValue?: CfnAnalysis.GaugeChartPrimaryValueConditionalFormattingProperty | cdk.IResolvable;
    }
    /**
     * The options that determine the presentation of the arc of a `GaugeChartVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartarcconditionalformatting.html
     */
    interface GaugeChartArcConditionalFormattingProperty {
        /**
         * The conditional formatting of the arc foreground color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartarcconditionalformatting.html#cfn-quicksight-analysis-gaugechartarcconditionalformatting-foregroundcolor
         */
        readonly foregroundColor?: CfnAnalysis.ConditionalFormattingColorProperty | cdk.IResolvable;
    }
    /**
     * The conditional formatting for the primary value of a `GaugeChartVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartprimaryvalueconditionalformatting.html
     */
    interface GaugeChartPrimaryValueConditionalFormattingProperty {
        /**
         * The conditional formatting of the primary value icon.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartprimaryvalueconditionalformatting.html#cfn-quicksight-analysis-gaugechartprimaryvalueconditionalformatting-icon
         */
        readonly icon?: CfnAnalysis.ConditionalFormattingIconProperty | cdk.IResolvable;
        /**
         * The conditional formatting of the primary value text color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartprimaryvalueconditionalformatting.html#cfn-quicksight-analysis-gaugechartprimaryvalueconditionalformatting-textcolor
         */
        readonly textColor?: CfnAnalysis.ConditionalFormattingColorProperty | cdk.IResolvable;
    }
    /**
     * The configuration of a `GaugeChartVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartconfiguration.html
     */
    interface GaugeChartConfigurationProperty {
        /**
         * The color configuration of a `GaugeChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartconfiguration.html#cfn-quicksight-analysis-gaugechartconfiguration-colorconfiguration
         */
        readonly colorConfiguration?: CfnAnalysis.GaugeChartColorConfigurationProperty | cdk.IResolvable;
        /**
         * The data label configuration of a `GaugeChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartconfiguration.html#cfn-quicksight-analysis-gaugechartconfiguration-datalabels
         */
        readonly dataLabels?: CfnAnalysis.DataLabelOptionsProperty | cdk.IResolvable;
        /**
         * The field well configuration of a `GaugeChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartconfiguration.html#cfn-quicksight-analysis-gaugechartconfiguration-fieldwells
         */
        readonly fieldWells?: CfnAnalysis.GaugeChartFieldWellsProperty | cdk.IResolvable;
        /**
         * The options that determine the presentation of the `GaugeChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartconfiguration.html#cfn-quicksight-analysis-gaugechartconfiguration-gaugechartoptions
         */
        readonly gaugeChartOptions?: CfnAnalysis.GaugeChartOptionsProperty | cdk.IResolvable;
        /**
         * The general visual interactions setup for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartconfiguration.html#cfn-quicksight-analysis-gaugechartconfiguration-interactions
         */
        readonly interactions?: cdk.IResolvable | CfnAnalysis.VisualInteractionOptionsProperty;
        /**
         * The tooltip configuration of a `GaugeChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartconfiguration.html#cfn-quicksight-analysis-gaugechartconfiguration-tooltipoptions
         */
        readonly tooltipOptions?: cdk.IResolvable | CfnAnalysis.TooltipOptionsProperty;
        /**
         * The visual palette configuration of a `GaugeChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartconfiguration.html#cfn-quicksight-analysis-gaugechartconfiguration-visualpalette
         */
        readonly visualPalette?: cdk.IResolvable | CfnAnalysis.VisualPaletteProperty;
    }
    /**
     * The field well configuration of a `GaugeChartVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartfieldwells.html
     */
    interface GaugeChartFieldWellsProperty {
        /**
         * The target value field wells of a `GaugeChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartfieldwells.html#cfn-quicksight-analysis-gaugechartfieldwells-targetvalues
         */
        readonly targetValues?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
        /**
         * The value field wells of a `GaugeChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartfieldwells.html#cfn-quicksight-analysis-gaugechartfieldwells-values
         */
        readonly values?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
    }
    /**
     * The options that determine the presentation of the `GaugeChartVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartoptions.html
     */
    interface GaugeChartOptionsProperty {
        /**
         * The arc configuration of a `GaugeChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartoptions.html#cfn-quicksight-analysis-gaugechartoptions-arc
         */
        readonly arc?: CfnAnalysis.ArcConfigurationProperty | cdk.IResolvable;
        /**
         * The arc axis configuration of a `GaugeChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartoptions.html#cfn-quicksight-analysis-gaugechartoptions-arcaxis
         */
        readonly arcAxis?: CfnAnalysis.ArcAxisConfigurationProperty | cdk.IResolvable;
        /**
         * The comparison configuration of a `GaugeChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartoptions.html#cfn-quicksight-analysis-gaugechartoptions-comparison
         */
        readonly comparison?: CfnAnalysis.ComparisonConfigurationProperty | cdk.IResolvable;
        /**
         * The options that determine the primary value display type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartoptions.html#cfn-quicksight-analysis-gaugechartoptions-primaryvaluedisplaytype
         */
        readonly primaryValueDisplayType?: string;
        /**
         * The options that determine the primary value font configuration.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartoptions.html#cfn-quicksight-analysis-gaugechartoptions-primaryvaluefontconfiguration
         */
        readonly primaryValueFontConfiguration?: CfnAnalysis.FontConfigurationProperty | cdk.IResolvable;
    }
    /**
     * The arc configuration of a `GaugeChartVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcconfiguration.html
     */
    interface ArcConfigurationProperty {
        /**
         * The option that determines the arc angle of a `GaugeChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcconfiguration.html#cfn-quicksight-analysis-arcconfiguration-arcangle
         */
        readonly arcAngle?: number;
        /**
         * The options that determine the arc thickness of a `GaugeChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcconfiguration.html#cfn-quicksight-analysis-arcconfiguration-arcthickness
         */
        readonly arcThickness?: string;
    }
    /**
     * The arc axis configuration of a `GaugeChartVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisconfiguration.html
     */
    interface ArcAxisConfigurationProperty {
        /**
         * The arc axis range of a `GaugeChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisconfiguration.html#cfn-quicksight-analysis-arcaxisconfiguration-range
         */
        readonly range?: CfnAnalysis.ArcAxisDisplayRangeProperty | cdk.IResolvable;
        /**
         * The reserved range of the arc axis.
         *
         * @default - 0
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisconfiguration.html#cfn-quicksight-analysis-arcaxisconfiguration-reserverange
         */
        readonly reserveRange?: number;
    }
    /**
     * The arc axis range of a `GaugeChartVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisdisplayrange.html
     */
    interface ArcAxisDisplayRangeProperty {
        /**
         * The maximum value of the arc axis range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisdisplayrange.html#cfn-quicksight-analysis-arcaxisdisplayrange-max
         */
        readonly max?: number;
        /**
         * The minimum value of the arc axis range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisdisplayrange.html#cfn-quicksight-analysis-arcaxisdisplayrange-min
         */
        readonly min?: number;
    }
    /**
     * The color configuration of a `GaugeChartVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartcolorconfiguration.html
     */
    interface GaugeChartColorConfigurationProperty {
        /**
         * The background color configuration of a `GaugeChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartcolorconfiguration.html#cfn-quicksight-analysis-gaugechartcolorconfiguration-backgroundcolor
         */
        readonly backgroundColor?: string;
        /**
         * The foreground color configuration of a `GaugeChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartcolorconfiguration.html#cfn-quicksight-analysis-gaugechartcolorconfiguration-foregroundcolor
         */
        readonly foregroundColor?: string;
    }
    /**
     * A line chart.
     *
     * For more information, see [Using line charts](https://docs.aws.amazon.com/quicksight/latest/user/line-charts.html) in the *Amazon QuickSight User Guide* .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartvisual.html
     */
    interface LineChartVisualProperty {
        /**
         * The list of custom actions that are configured for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartvisual.html#cfn-quicksight-analysis-linechartvisual-actions
         */
        readonly actions?: Array<cdk.IResolvable | CfnAnalysis.VisualCustomActionProperty> | cdk.IResolvable;
        /**
         * The configuration of a line chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartvisual.html#cfn-quicksight-analysis-linechartvisual-chartconfiguration
         */
        readonly chartConfiguration?: cdk.IResolvable | CfnAnalysis.LineChartConfigurationProperty;
        /**
         * The column hierarchy that is used during drill-downs and drill-ups.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartvisual.html#cfn-quicksight-analysis-linechartvisual-columnhierarchies
         */
        readonly columnHierarchies?: Array<CfnAnalysis.ColumnHierarchyProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The subtitle that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartvisual.html#cfn-quicksight-analysis-linechartvisual-subtitle
         */
        readonly subtitle?: cdk.IResolvable | CfnAnalysis.VisualSubtitleLabelOptionsProperty;
        /**
         * The title that is displayed on the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartvisual.html#cfn-quicksight-analysis-linechartvisual-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.VisualTitleLabelOptionsProperty;
        /**
         * The alt text for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartvisual.html#cfn-quicksight-analysis-linechartvisual-visualcontentalttext
         */
        readonly visualContentAltText?: string;
        /**
         * The unique identifier of a visual.
         *
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartvisual.html#cfn-quicksight-analysis-linechartvisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * The configuration of a line chart.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartconfiguration.html
     */
    interface LineChartConfigurationProperty {
        /**
         * The default configuration of a line chart's contribution analysis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartconfiguration.html#cfn-quicksight-analysis-linechartconfiguration-contributionanalysisdefaults
         */
        readonly contributionAnalysisDefaults?: Array<CfnAnalysis.ContributionAnalysisDefaultProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The data label configuration of a line chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartconfiguration.html#cfn-quicksight-analysis-linechartconfiguration-datalabels
         */
        readonly dataLabels?: CfnAnalysis.DataLabelOptionsProperty | cdk.IResolvable;
        /**
         * The options that determine the default presentation of all line series in `LineChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartconfiguration.html#cfn-quicksight-analysis-linechartconfiguration-defaultseriessettings
         */
        readonly defaultSeriesSettings?: cdk.IResolvable | CfnAnalysis.LineChartDefaultSeriesSettingsProperty;
        /**
         * The field well configuration of a line chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartconfiguration.html#cfn-quicksight-analysis-linechartconfiguration-fieldwells
         */
        readonly fieldWells?: cdk.IResolvable | CfnAnalysis.LineChartFieldWellsProperty;
        /**
         * The forecast configuration of a line chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartconfiguration.html#cfn-quicksight-analysis-linechartconfiguration-forecastconfigurations
         */
        readonly forecastConfigurations?: Array<CfnAnalysis.ForecastConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The general visual interactions setup for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartconfiguration.html#cfn-quicksight-analysis-linechartconfiguration-interactions
         */
        readonly interactions?: cdk.IResolvable | CfnAnalysis.VisualInteractionOptionsProperty;
        /**
         * The legend configuration of a line chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartconfiguration.html#cfn-quicksight-analysis-linechartconfiguration-legend
         */
        readonly legend?: cdk.IResolvable | CfnAnalysis.LegendOptionsProperty;
        /**
         * The series axis configuration of a line chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartconfiguration.html#cfn-quicksight-analysis-linechartconfiguration-primaryyaxisdisplayoptions
         */
        readonly primaryYAxisDisplayOptions?: cdk.IResolvable | CfnAnalysis.LineSeriesAxisDisplayOptionsProperty;
        /**
         * The options that determine the presentation of the y-axis label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartconfiguration.html#cfn-quicksight-analysis-linechartconfiguration-primaryyaxislabeloptions
         */
        readonly primaryYAxisLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The reference lines configuration of a line chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartconfiguration.html#cfn-quicksight-analysis-linechartconfiguration-referencelines
         */
        readonly referenceLines?: Array<cdk.IResolvable | CfnAnalysis.ReferenceLineProperty> | cdk.IResolvable;
        /**
         * The series axis configuration of a line chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartconfiguration.html#cfn-quicksight-analysis-linechartconfiguration-secondaryyaxisdisplayoptions
         */
        readonly secondaryYAxisDisplayOptions?: cdk.IResolvable | CfnAnalysis.LineSeriesAxisDisplayOptionsProperty;
        /**
         * The options that determine the presentation of the secondary y-axis label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartconfiguration.html#cfn-quicksight-analysis-linechartconfiguration-secondaryyaxislabeloptions
         */
        readonly secondaryYAxisLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
        /**
         * The series item configuration of a line chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartconfiguration.html#cfn-quicksight-analysis-linechartconfiguration-series
         */
        readonly series?: Array<cdk.IResolvable | CfnAnalysis.SeriesItemProperty> | cdk.IResolvable;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartconfiguration.html#cfn-quicksight-analysis-linechartconfiguration-singleaxisoptions
         */
        readonly singleAxisOptions?: cdk.IResolvable | CfnAnalysis.SingleAxisOptionsProperty;
        /**
         * The small multiples setup for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartconfiguration.html#cfn-quicksight-analysis-linechartconfiguration-smallmultiplesoptions
         */
        readonly smallMultiplesOptions?: cdk.IResolvable | CfnAnalysis.SmallMultiplesOptionsProperty;
        /**
         * The sort configuration of a line chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartconfiguration.html#cfn-quicksight-analysis-linechartconfiguration-sortconfiguration
         */
        readonly sortConfiguration?: cdk.IResolvable | CfnAnalysis.LineChartSortConfigurationProperty;
        /**
         * The tooltip configuration of a line chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartconfiguration.html#cfn-quicksight-analysis-linechartconfiguration-tooltip
         */
        readonly tooltip?: cdk.IResolvable | CfnAnalysis.TooltipOptionsProperty;
        /**
         * Determines the type of the line chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartconfiguration.html#cfn-quicksight-analysis-linechartconfiguration-type
         */
        readonly type?: string;
        /**
         * The visual palette configuration of a line chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartconfiguration.html#cfn-quicksight-analysis-linechartconfiguration-visualpalette
         */
        readonly visualPalette?: cdk.IResolvable | CfnAnalysis.VisualPaletteProperty;
        /**
         * The options that determine the presentation of the x-axis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartconfiguration.html#cfn-quicksight-analysis-linechartconfiguration-xaxisdisplayoptions
         */
        readonly xAxisDisplayOptions?: CfnAnalysis.AxisDisplayOptionsProperty | cdk.IResolvable;
        /**
         * The options that determine the presentation of the x-axis label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartconfiguration.html#cfn-quicksight-analysis-linechartconfiguration-xaxislabeloptions
         */
        readonly xAxisLabelOptions?: CfnAnalysis.ChartAxisLabelOptionsProperty | cdk.IResolvable;
    }
    /**
     * The sort configuration of a line chart.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartsortconfiguration.html
     */
    interface LineChartSortConfigurationProperty {
        /**
         * The limit on the number of categories that are displayed in a line chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartsortconfiguration.html#cfn-quicksight-analysis-linechartsortconfiguration-categoryitemslimitconfiguration
         */
        readonly categoryItemsLimitConfiguration?: cdk.IResolvable | CfnAnalysis.ItemsLimitConfigurationProperty;
        /**
         * The sort configuration of the category fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartsortconfiguration.html#cfn-quicksight-analysis-linechartsortconfiguration-categorysort
         */
        readonly categorySort?: Array<CfnAnalysis.FieldSortOptionsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The limit on the number of lines that are displayed in a line chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartsortconfiguration.html#cfn-quicksight-analysis-linechartsortconfiguration-coloritemslimitconfiguration
         */
        readonly colorItemsLimitConfiguration?: cdk.IResolvable | CfnAnalysis.ItemsLimitConfigurationProperty;
        /**
         * The limit on the number of small multiples panels that are displayed.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartsortconfiguration.html#cfn-quicksight-analysis-linechartsortconfiguration-smallmultipleslimitconfiguration
         */
        readonly smallMultiplesLimitConfiguration?: cdk.IResolvable | CfnAnalysis.ItemsLimitConfigurationProperty;
        /**
         * The sort configuration of the small multiples field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartsortconfiguration.html#cfn-quicksight-analysis-linechartsortconfiguration-smallmultiplessort
         */
        readonly smallMultiplesSort?: Array<CfnAnalysis.FieldSortOptionsProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The series axis configuration of a line chart.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-lineseriesaxisdisplayoptions.html
     */
    interface LineSeriesAxisDisplayOptionsProperty {
        /**
         * The options that determine the presentation of the line series axis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-lineseriesaxisdisplayoptions.html#cfn-quicksight-analysis-lineseriesaxisdisplayoptions-axisoptions
         */
        readonly axisOptions?: CfnAnalysis.AxisDisplayOptionsProperty | cdk.IResolvable;
        /**
         * The configuration options that determine how missing data is treated during the rendering of a line chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-lineseriesaxisdisplayoptions.html#cfn-quicksight-analysis-lineseriesaxisdisplayoptions-missingdataconfigurations
         */
        readonly missingDataConfigurations?: Array<cdk.IResolvable | CfnAnalysis.MissingDataConfigurationProperty> | cdk.IResolvable;
    }
    /**
     * The configuration options that determine how missing data is treated during the rendering of a line chart.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-missingdataconfiguration.html
     */
    interface MissingDataConfigurationProperty {
        /**
         * The treatment option that determines how missing data should be rendered. Choose from the following options:.
         *
         * - `INTERPOLATE` : Interpolate missing values between the prior and the next known value.
         * - `SHOW_AS_ZERO` : Show missing values as the value `0` .
         * - `SHOW_AS_BLANK` : Display a blank space when rendering missing data.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-missingdataconfiguration.html#cfn-quicksight-analysis-missingdataconfiguration-treatmentoption
         */
        readonly treatmentOption?: string;
    }
    /**
     * The options that determine the default presentation of all line series in `LineChartVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartdefaultseriessettings.html
     */
    interface LineChartDefaultSeriesSettingsProperty {
        /**
         * The axis to which you are binding all line series to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartdefaultseriessettings.html#cfn-quicksight-analysis-linechartdefaultseriessettings-axisbinding
         */
        readonly axisBinding?: string;
        /**
         * Line styles options for all line series in the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartdefaultseriessettings.html#cfn-quicksight-analysis-linechartdefaultseriessettings-linestylesettings
         */
        readonly lineStyleSettings?: cdk.IResolvable | CfnAnalysis.LineChartLineStyleSettingsProperty;
        /**
         * Marker styles options for all line series in the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartdefaultseriessettings.html#cfn-quicksight-analysis-linechartdefaultseriessettings-markerstylesettings
         */
        readonly markerStyleSettings?: cdk.IResolvable | CfnAnalysis.LineChartMarkerStyleSettingsProperty;
    }
    /**
     * Line styles options for a line series in `LineChartVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartlinestylesettings.html
     */
    interface LineChartLineStyleSettingsProperty {
        /**
         * Interpolation style for line series.
         *
         * - `LINEAR` : Show as default, linear style.
         * - `SMOOTH` : Show as a smooth curve.
         * - `STEPPED` : Show steps in line.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartlinestylesettings.html#cfn-quicksight-analysis-linechartlinestylesettings-lineinterpolation
         */
        readonly lineInterpolation?: string;
        /**
         * Line style for line series.
         *
         * - `SOLID` : Show as a solid line.
         * - `DOTTED` : Show as a dotted line.
         * - `DASHED` : Show as a dashed line.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartlinestylesettings.html#cfn-quicksight-analysis-linechartlinestylesettings-linestyle
         */
        readonly lineStyle?: string;
        /**
         * Configuration option that determines whether to show the line for the series.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartlinestylesettings.html#cfn-quicksight-analysis-linechartlinestylesettings-linevisibility
         */
        readonly lineVisibility?: string;
        /**
         * Width that determines the line thickness.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartlinestylesettings.html#cfn-quicksight-analysis-linechartlinestylesettings-linewidth
         */
        readonly lineWidth?: string;
    }
    /**
     * Marker styles options for a line series in `LineChartVisual` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartmarkerstylesettings.html
     */
    interface LineChartMarkerStyleSettingsProperty {
        /**
         * Color of marker in the series.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartmarkerstylesettings.html#cfn-quicksight-analysis-linechartmarkerstylesettings-markercolor
         */
        readonly markerColor?: string;
        /**
         * Shape option for markers in the series.
         *
         * - `CIRCLE` : Show marker as a circle.
         * - `TRIANGLE` : Show marker as a triangle.
         * - `SQUARE` : Show marker as a square.
         * - `DIAMOND` : Show marker as a diamond.
         * - `ROUNDED_SQUARE` : Show marker as a rounded square.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartmarkerstylesettings.html#cfn-quicksight-analysis-linechartmarkerstylesettings-markershape
         */
        readonly markerShape?: string;
        /**
         * Size of marker in the series.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartmarkerstylesettings.html#cfn-quicksight-analysis-linechartmarkerstylesettings-markersize
         */
        readonly markerSize?: string;
        /**
         * Configuration option that determines whether to show the markers in the series.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartmarkerstylesettings.html#cfn-quicksight-analysis-linechartmarkerstylesettings-markervisibility
         */
        readonly markerVisibility?: string;
    }
    /**
     * The forecast configuration that is used in a line chart's display properties.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-forecastconfiguration.html
     */
    interface ForecastConfigurationProperty {
        /**
         * The forecast properties setup of a forecast in the line chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-forecastconfiguration.html#cfn-quicksight-analysis-forecastconfiguration-forecastproperties
         */
        readonly forecastProperties?: cdk.IResolvable | CfnAnalysis.TimeBasedForecastPropertiesProperty;
        /**
         * The forecast scenario of a forecast in the line chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-forecastconfiguration.html#cfn-quicksight-analysis-forecastconfiguration-scenario
         */
        readonly scenario?: CfnAnalysis.ForecastScenarioProperty | cdk.IResolvable;
    }
    /**
     * The forecast properties setup of a forecast in the line chart.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timebasedforecastproperties.html
     */
    interface TimeBasedForecastPropertiesProperty {
        /**
         * The lower boundary setup of a forecast computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timebasedforecastproperties.html#cfn-quicksight-analysis-timebasedforecastproperties-lowerboundary
         */
        readonly lowerBoundary?: number;
        /**
         * The periods backward setup of a forecast computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timebasedforecastproperties.html#cfn-quicksight-analysis-timebasedforecastproperties-periodsbackward
         */
        readonly periodsBackward?: number;
        /**
         * The periods forward setup of a forecast computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timebasedforecastproperties.html#cfn-quicksight-analysis-timebasedforecastproperties-periodsforward
         */
        readonly periodsForward?: number;
        /**
         * The prediction interval setup of a forecast computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timebasedforecastproperties.html#cfn-quicksight-analysis-timebasedforecastproperties-predictioninterval
         */
        readonly predictionInterval?: number;
        /**
         * The seasonality setup of a forecast computation. Choose one of the following options:.
         *
         * - `NULL` : The input is set to `NULL` .
         * - `NON_NULL` : The input is set to a custom value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timebasedforecastproperties.html#cfn-quicksight-analysis-timebasedforecastproperties-seasonality
         */
        readonly seasonality?: number;
        /**
         * The upper boundary setup of a forecast computation.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timebasedforecastproperties.html#cfn-quicksight-analysis-timebasedforecastproperties-upperboundary
         */
        readonly upperBoundary?: number;
    }
    /**
     * The forecast scenario of a forecast in the line chart.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-forecastscenario.html
     */
    interface ForecastScenarioProperty {
        /**
         * The what-if analysis forecast setup with the target date.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-forecastscenario.html#cfn-quicksight-analysis-forecastscenario-whatifpointscenario
         */
        readonly whatIfPointScenario?: cdk.IResolvable | CfnAnalysis.WhatIfPointScenarioProperty;
        /**
         * The what-if analysis forecast setup with the date range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-forecastscenario.html#cfn-quicksight-analysis-forecastscenario-whatifrangescenario
         */
        readonly whatIfRangeScenario?: cdk.IResolvable | CfnAnalysis.WhatIfRangeScenarioProperty;
    }
    /**
     * Provides the forecast to meet the target for a particular date range.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-whatifrangescenario.html
     */
    interface WhatIfRangeScenarioProperty {
        /**
         * The end date in the date range that you need the forecast results for.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-whatifrangescenario.html#cfn-quicksight-analysis-whatifrangescenario-enddate
         */
        readonly endDate: string;
        /**
         * The start date in the date range that you need the forecast results for.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-whatifrangescenario.html#cfn-quicksight-analysis-whatifrangescenario-startdate
         */
        readonly startDate: string;
        /**
         * The target value that you want to meet for the provided date range.
         *
         * @default - 0
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-whatifrangescenario.html#cfn-quicksight-analysis-whatifrangescenario-value
         */
        readonly value: number;
    }
    /**
     * Provides the forecast to meet the target for a particular date.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-whatifpointscenario.html
     */
    interface WhatIfPointScenarioProperty {
        /**
         * The date that you need the forecast results for.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-whatifpointscenario.html#cfn-quicksight-analysis-whatifpointscenario-date
         */
        readonly date: string;
        /**
         * The target value that you want to meet for the provided date.
         *
         * @default - 0
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-whatifpointscenario.html#cfn-quicksight-analysis-whatifpointscenario-value
         */
        readonly value: number;
    }
    /**
     * The series item configuration of a line chart.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-seriesitem.html
     */
    interface SeriesItemProperty {
        /**
         * The data field series item configuration of a line chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-seriesitem.html#cfn-quicksight-analysis-seriesitem-datafieldseriesitem
         */
        readonly dataFieldSeriesItem?: CfnAnalysis.DataFieldSeriesItemProperty | cdk.IResolvable;
        /**
         * The field series item configuration of a line chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-seriesitem.html#cfn-quicksight-analysis-seriesitem-fieldseriesitem
         */
        readonly fieldSeriesItem?: CfnAnalysis.FieldSeriesItemProperty | cdk.IResolvable;
    }
    /**
     * The field series item configuration of a line chart.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldseriesitem.html
     */
    interface FieldSeriesItemProperty {
        /**
         * The axis that you are binding the field to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldseriesitem.html#cfn-quicksight-analysis-fieldseriesitem-axisbinding
         */
        readonly axisBinding: string;
        /**
         * The field ID of the field for which you are setting the axis binding.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldseriesitem.html#cfn-quicksight-analysis-fieldseriesitem-fieldid
         */
        readonly fieldId: string;
        /**
         * The options that determine the presentation of line series associated to the field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldseriesitem.html#cfn-quicksight-analysis-fieldseriesitem-settings
         */
        readonly settings?: cdk.IResolvable | CfnAnalysis.LineChartSeriesSettingsProperty;
    }
    /**
     * The options that determine the presentation of a line series in the visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartseriessettings.html
     */
    interface LineChartSeriesSettingsProperty {
        /**
         * Line styles options for a line series in `LineChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartseriessettings.html#cfn-quicksight-analysis-linechartseriessettings-linestylesettings
         */
        readonly lineStyleSettings?: cdk.IResolvable | CfnAnalysis.LineChartLineStyleSettingsProperty;
        /**
         * Marker styles options for a line series in `LineChartVisual` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartseriessettings.html#cfn-quicksight-analysis-linechartseriessettings-markerstylesettings
         */
        readonly markerStyleSettings?: cdk.IResolvable | CfnAnalysis.LineChartMarkerStyleSettingsProperty;
    }
    /**
     * The data field series item configuration of a line chart.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datafieldseriesitem.html
     */
    interface DataFieldSeriesItemProperty {
        /**
         * The axis that you are binding the field to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datafieldseriesitem.html#cfn-quicksight-analysis-datafieldseriesitem-axisbinding
         */
        readonly axisBinding: string;
        /**
         * The field ID of the field that you are setting the axis binding to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datafieldseriesitem.html#cfn-quicksight-analysis-datafieldseriesitem-fieldid
         */
        readonly fieldId: string;
        /**
         * The field value of the field that you are setting the axis binding to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datafieldseriesitem.html#cfn-quicksight-analysis-datafieldseriesitem-fieldvalue
         */
        readonly fieldValue?: string;
        /**
         * The options that determine the presentation of line series associated to the field.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datafieldseriesitem.html#cfn-quicksight-analysis-datafieldseriesitem-settings
         */
        readonly settings?: cdk.IResolvable | CfnAnalysis.LineChartSeriesSettingsProperty;
    }
    /**
     * The field well configuration of a line chart.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartfieldwells.html
     */
    interface LineChartFieldWellsProperty {
        /**
         * The field well configuration of a line chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartfieldwells.html#cfn-quicksight-analysis-linechartfieldwells-linechartaggregatedfieldwells
         */
        readonly lineChartAggregatedFieldWells?: cdk.IResolvable | CfnAnalysis.LineChartAggregatedFieldWellsProperty;
    }
    /**
     * The field well configuration of a line chart.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartaggregatedfieldwells.html
     */
    interface LineChartAggregatedFieldWellsProperty {
        /**
         * The category field wells of a line chart.
         *
         * Values are grouped by category fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartaggregatedfieldwells.html#cfn-quicksight-analysis-linechartaggregatedfieldwells-category
         */
        readonly category?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The color field wells of a line chart.
         *
         * Values are grouped by category fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartaggregatedfieldwells.html#cfn-quicksight-analysis-linechartaggregatedfieldwells-colors
         */
        readonly colors?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The small multiples field well of a line chart.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartaggregatedfieldwells.html#cfn-quicksight-analysis-linechartaggregatedfieldwells-smallmultiples
         */
        readonly smallMultiples?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The value field wells of a line chart.
         *
         * Values are aggregated based on categories.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartaggregatedfieldwells.html#cfn-quicksight-analysis-linechartaggregatedfieldwells-values
         */
        readonly values?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
    }
    /**
     * An empty visual.
     *
     * Empty visuals are used in layouts but have not been configured to show any data. A new visual created in the Amazon QuickSight console is considered an `EmptyVisual` until a visual type is selected.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-emptyvisual.html
     */
    interface EmptyVisualProperty {
        /**
         * The list of custom actions that are configured for a visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-emptyvisual.html#cfn-quicksight-analysis-emptyvisual-actions
         */
        readonly actions?: Array<cdk.IResolvable | CfnAnalysis.VisualCustomActionProperty> | cdk.IResolvable;
        /**
         * The data set that is used in the empty visual.
         *
         * Every visual requires a dataset to render.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-emptyvisual.html#cfn-quicksight-analysis-emptyvisual-datasetidentifier
         */
        readonly dataSetIdentifier: string;
        /**
         * The unique identifier of a visual.
         *
         * This identifier must be unique within the context of a dashboard, template, or analysis. Two dashboards, analyses, or templates can have visuals with the same identifiers.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-emptyvisual.html#cfn-quicksight-analysis-emptyvisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * A layer map visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layermapvisual.html
     */
    interface LayerMapVisualProperty {
        /**
         * The configuration settings of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layermapvisual.html#cfn-quicksight-analysis-layermapvisual-chartconfiguration
         */
        readonly chartConfiguration?: CfnAnalysis.GeospatialLayerMapConfigurationProperty | cdk.IResolvable;
        /**
         * The dataset that is used to create the layer map visual.
         *
         * You can't create a visual without a dataset.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layermapvisual.html#cfn-quicksight-analysis-layermapvisual-datasetidentifier
         */
        readonly dataSetIdentifier: string;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layermapvisual.html#cfn-quicksight-analysis-layermapvisual-subtitle
         */
        readonly subtitle?: cdk.IResolvable | CfnAnalysis.VisualSubtitleLabelOptionsProperty;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layermapvisual.html#cfn-quicksight-analysis-layermapvisual-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.VisualTitleLabelOptionsProperty;
        /**
         * The alt text for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layermapvisual.html#cfn-quicksight-analysis-layermapvisual-visualcontentalttext
         */
        readonly visualContentAltText?: string;
        /**
         * The ID of the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layermapvisual.html#cfn-quicksight-analysis-layermapvisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * The map definition that defines map state, map style, and geospatial layers.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayermapconfiguration.html
     */
    interface GeospatialLayerMapConfigurationProperty {
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayermapconfiguration.html#cfn-quicksight-analysis-geospatiallayermapconfiguration-interactions
         */
        readonly interactions?: cdk.IResolvable | CfnAnalysis.VisualInteractionOptionsProperty;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayermapconfiguration.html#cfn-quicksight-analysis-geospatiallayermapconfiguration-legend
         */
        readonly legend?: cdk.IResolvable | CfnAnalysis.LegendOptionsProperty;
        /**
         * The geospatial layers to visualize on the map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayermapconfiguration.html#cfn-quicksight-analysis-geospatiallayermapconfiguration-maplayers
         */
        readonly mapLayers?: Array<CfnAnalysis.GeospatialLayerItemProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The map state properties for the map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayermapconfiguration.html#cfn-quicksight-analysis-geospatiallayermapconfiguration-mapstate
         */
        readonly mapState?: CfnAnalysis.GeospatialMapStateProperty | cdk.IResolvable;
        /**
         * The map style properties for the map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayermapconfiguration.html#cfn-quicksight-analysis-geospatiallayermapconfiguration-mapstyle
         */
        readonly mapStyle?: CfnAnalysis.GeospatialMapStyleProperty | cdk.IResolvable;
    }
    /**
     * The map state properties for a map.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapstate.html
     */
    interface GeospatialMapStateProperty {
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapstate.html#cfn-quicksight-analysis-geospatialmapstate-bounds
         */
        readonly bounds?: CfnAnalysis.GeospatialCoordinateBoundsProperty | cdk.IResolvable;
        /**
         * Enables or disables map navigation for a map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapstate.html#cfn-quicksight-analysis-geospatialmapstate-mapnavigation
         */
        readonly mapNavigation?: string;
    }
    /**
     * The map style properties for a map.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapstyle.html
     */
    interface GeospatialMapStyleProperty {
        /**
         * The background color and opacity values for a map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapstyle.html#cfn-quicksight-analysis-geospatialmapstyle-backgroundcolor
         */
        readonly backgroundColor?: string;
        /**
         * The selected base map style.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapstyle.html#cfn-quicksight-analysis-geospatialmapstyle-basemapstyle
         */
        readonly baseMapStyle?: string;
        /**
         * The state of visibility for the base map.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapstyle.html#cfn-quicksight-analysis-geospatialmapstyle-basemapvisibility
         */
        readonly baseMapVisibility?: string;
    }
    /**
     * The properties for a single geospatial layer.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayeritem.html
     */
    interface GeospatialLayerItemProperty {
        /**
         * A list of custom actions for a layer.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayeritem.html#cfn-quicksight-analysis-geospatiallayeritem-actions
         */
        readonly actions?: Array<cdk.IResolvable | CfnAnalysis.LayerCustomActionProperty> | cdk.IResolvable;
        /**
         * The data source for the layer.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayeritem.html#cfn-quicksight-analysis-geospatiallayeritem-datasource
         */
        readonly dataSource?: CfnAnalysis.GeospatialDataSourceItemProperty | cdk.IResolvable;
        /**
         * The join definition properties for a layer.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayeritem.html#cfn-quicksight-analysis-geospatiallayeritem-joindefinition
         */
        readonly joinDefinition?: CfnAnalysis.GeospatialLayerJoinDefinitionProperty | cdk.IResolvable;
        /**
         * The label that is displayed for the layer.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayeritem.html#cfn-quicksight-analysis-geospatiallayeritem-label
         */
        readonly label?: string;
        /**
         * The definition properties for a layer.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayeritem.html#cfn-quicksight-analysis-geospatiallayeritem-layerdefinition
         */
        readonly layerDefinition?: CfnAnalysis.GeospatialLayerDefinitionProperty | cdk.IResolvable;
        /**
         * The ID of the layer.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayeritem.html#cfn-quicksight-analysis-geospatiallayeritem-layerid
         */
        readonly layerId: string;
        /**
         * The layer type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayeritem.html#cfn-quicksight-analysis-geospatiallayeritem-layertype
         */
        readonly layerType?: string;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayeritem.html#cfn-quicksight-analysis-geospatiallayeritem-tooltip
         */
        readonly tooltip?: cdk.IResolvable | CfnAnalysis.TooltipOptionsProperty;
        /**
         * The state of visibility for the layer.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayeritem.html#cfn-quicksight-analysis-geospatiallayeritem-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The custom actions for a layer.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayerjoindefinition.html
     */
    interface GeospatialLayerJoinDefinitionProperty {
        /**
         * The geospatial color field for the join definition.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayerjoindefinition.html#cfn-quicksight-analysis-geospatiallayerjoindefinition-colorfield
         */
        readonly colorField?: CfnAnalysis.GeospatialLayerColorFieldProperty | cdk.IResolvable;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayerjoindefinition.html#cfn-quicksight-analysis-geospatiallayerjoindefinition-datasetkeyfield
         */
        readonly datasetKeyField?: cdk.IResolvable | CfnAnalysis.UnaggregatedFieldProperty;
        /**
         * The name of the field or property in the geospatial data source.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayerjoindefinition.html#cfn-quicksight-analysis-geospatiallayerjoindefinition-shapekeyfield
         */
        readonly shapeKeyField?: string;
    }
    /**
     * The color field that defines a gradient or categorical style.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayercolorfield.html
     */
    interface GeospatialLayerColorFieldProperty {
        /**
         * A list of color dimension fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayercolorfield.html#cfn-quicksight-analysis-geospatiallayercolorfield-colordimensionsfields
         */
        readonly colorDimensionsFields?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * A list of color measure fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayercolorfield.html#cfn-quicksight-analysis-geospatiallayercolorfield-colorvaluesfields
         */
        readonly colorValuesFields?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
    }
    /**
     * A layer custom action.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layercustomaction.html
     */
    interface LayerCustomActionProperty {
        /**
         * A list of `LayerCustomActionOperations` .
         *
         * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layercustomaction.html#cfn-quicksight-analysis-layercustomaction-actionoperations
         */
        readonly actionOperations: Array<cdk.IResolvable | CfnAnalysis.LayerCustomActionOperationProperty> | cdk.IResolvable;
        /**
         * The ID of the custom action.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layercustomaction.html#cfn-quicksight-analysis-layercustomaction-customactionid
         */
        readonly customActionId: string;
        /**
         * The name of the custom action.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layercustomaction.html#cfn-quicksight-analysis-layercustomaction-name
         */
        readonly name: string;
        /**
         * The status of the `LayerCustomAction` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layercustomaction.html#cfn-quicksight-analysis-layercustomaction-status
         */
        readonly status?: string;
        /**
         * The trigger of the `LayerCustomAction` .
         *
         * Valid values are defined as follows:
         *
         * - `DATA_POINT_CLICK` : Initiates a custom action by a left pointer click on a data point.
         * - `DATA_POINT_MENU` : Initiates a custom action by right pointer click from the menu.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layercustomaction.html#cfn-quicksight-analysis-layercustomaction-trigger
         */
        readonly trigger: string;
    }
    /**
     * The operation that is defined by the custom action.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layercustomactionoperation.html
     */
    interface LayerCustomActionOperationProperty {
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layercustomactionoperation.html#cfn-quicksight-analysis-layercustomactionoperation-filteroperation
         */
        readonly filterOperation?: CfnAnalysis.CustomActionFilterOperationProperty | cdk.IResolvable;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layercustomactionoperation.html#cfn-quicksight-analysis-layercustomactionoperation-navigationoperation
         */
        readonly navigationOperation?: CfnAnalysis.CustomActionNavigationOperationProperty | cdk.IResolvable;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layercustomactionoperation.html#cfn-quicksight-analysis-layercustomactionoperation-setparametersoperation
         */
        readonly setParametersOperation?: CfnAnalysis.CustomActionSetParametersOperationProperty | cdk.IResolvable;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layercustomactionoperation.html#cfn-quicksight-analysis-layercustomactionoperation-urloperation
         */
        readonly urlOperation?: CfnAnalysis.CustomActionURLOperationProperty | cdk.IResolvable;
    }
    /**
     * The definition properties for a geospatial layer.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayerdefinition.html
     */
    interface GeospatialLayerDefinitionProperty {
        /**
         * The definition for a line layer.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayerdefinition.html#cfn-quicksight-analysis-geospatiallayerdefinition-linelayer
         */
        readonly lineLayer?: CfnAnalysis.GeospatialLineLayerProperty | cdk.IResolvable;
        /**
         * The definition for a point layer.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayerdefinition.html#cfn-quicksight-analysis-geospatiallayerdefinition-pointlayer
         */
        readonly pointLayer?: CfnAnalysis.GeospatialPointLayerProperty | cdk.IResolvable;
        /**
         * The definition for a polygon layer.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallayerdefinition.html#cfn-quicksight-analysis-geospatiallayerdefinition-polygonlayer
         */
        readonly polygonLayer?: CfnAnalysis.GeospatialPolygonLayerProperty | cdk.IResolvable;
    }
    /**
     * The geospatial Point layer.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialpointlayer.html
     */
    interface GeospatialPointLayerProperty {
        /**
         * The visualization style for a point layer.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialpointlayer.html#cfn-quicksight-analysis-geospatialpointlayer-style
         */
        readonly style: CfnAnalysis.GeospatialPointStyleProperty | cdk.IResolvable;
    }
    /**
     * The point style for a point layer.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialpointstyle.html
     */
    interface GeospatialPointStyleProperty {
        /**
         * The circle symbol style for a point layer.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialpointstyle.html#cfn-quicksight-analysis-geospatialpointstyle-circlesymbolstyle
         */
        readonly circleSymbolStyle?: CfnAnalysis.GeospatialCircleSymbolStyleProperty | cdk.IResolvable;
    }
    /**
     * The properties for a circle symbol style.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcirclesymbolstyle.html
     */
    interface GeospatialCircleSymbolStyleProperty {
        /**
         * The radius of the circle.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcirclesymbolstyle.html#cfn-quicksight-analysis-geospatialcirclesymbolstyle-circleradius
         */
        readonly circleRadius?: CfnAnalysis.GeospatialCircleRadiusProperty | cdk.IResolvable;
        /**
         * The color and opacity values for the fill color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcirclesymbolstyle.html#cfn-quicksight-analysis-geospatialcirclesymbolstyle-fillcolor
         */
        readonly fillColor?: CfnAnalysis.GeospatialColorProperty | cdk.IResolvable;
        /**
         * The color and opacity values for the stroke color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcirclesymbolstyle.html#cfn-quicksight-analysis-geospatialcirclesymbolstyle-strokecolor
         */
        readonly strokeColor?: CfnAnalysis.GeospatialColorProperty | cdk.IResolvable;
        /**
         * The width of the stroke (border).
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcirclesymbolstyle.html#cfn-quicksight-analysis-geospatialcirclesymbolstyle-strokewidth
         */
        readonly strokeWidth?: CfnAnalysis.GeospatialLineWidthProperty | cdk.IResolvable;
    }
    /**
     * The visualization properties for solid, gradient, and categorical colors.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcolor.html
     */
    interface GeospatialColorProperty {
        /**
         * The visualization properties for the categorical color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcolor.html#cfn-quicksight-analysis-geospatialcolor-categorical
         */
        readonly categorical?: CfnAnalysis.GeospatialCategoricalColorProperty | cdk.IResolvable;
        /**
         * The visualization properties for the gradient color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcolor.html#cfn-quicksight-analysis-geospatialcolor-gradient
         */
        readonly gradient?: CfnAnalysis.GeospatialGradientColorProperty | cdk.IResolvable;
        /**
         * The visualization properties for the solid color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcolor.html#cfn-quicksight-analysis-geospatialcolor-solid
         */
        readonly solid?: CfnAnalysis.GeospatialSolidColorProperty | cdk.IResolvable;
    }
    /**
     * The definition for a gradient color.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialgradientcolor.html
     */
    interface GeospatialGradientColorProperty {
        /**
         * The default opacity for the gradient color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialgradientcolor.html#cfn-quicksight-analysis-geospatialgradientcolor-defaultopacity
         */
        readonly defaultOpacity?: number;
        /**
         * The null data visualization settings.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialgradientcolor.html#cfn-quicksight-analysis-geospatialgradientcolor-nulldatasettings
         */
        readonly nullDataSettings?: CfnAnalysis.GeospatialNullDataSettingsProperty | cdk.IResolvable;
        /**
         * The state of visibility for null data.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialgradientcolor.html#cfn-quicksight-analysis-geospatialgradientcolor-nulldatavisibility
         */
        readonly nullDataVisibility?: string;
        /**
         * A list of gradient step colors for the gradient.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialgradientcolor.html#cfn-quicksight-analysis-geospatialgradientcolor-stepcolors
         */
        readonly stepColors: Array<CfnAnalysis.GeospatialGradientStepColorProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * The gradient step color for a single step.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialgradientstepcolor.html
     */
    interface GeospatialGradientStepColorProperty {
        /**
         * The color and opacity values for the gradient step color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialgradientstepcolor.html#cfn-quicksight-analysis-geospatialgradientstepcolor-color
         */
        readonly color: string;
        /**
         * The data value for the gradient step color.
         *
         * @default - 0
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialgradientstepcolor.html#cfn-quicksight-analysis-geospatialgradientstepcolor-datavalue
         */
        readonly dataValue: number;
    }
    /**
     * The properties for the visualization of null data.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialnulldatasettings.html
     */
    interface GeospatialNullDataSettingsProperty {
        /**
         * The symbol style for null data.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialnulldatasettings.html#cfn-quicksight-analysis-geospatialnulldatasettings-symbolstyle
         */
        readonly symbolStyle: CfnAnalysis.GeospatialNullSymbolStyleProperty | cdk.IResolvable;
    }
    /**
     * The symbol style for null data.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialnullsymbolstyle.html
     */
    interface GeospatialNullSymbolStyleProperty {
        /**
         * The color and opacity values for the fill color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialnullsymbolstyle.html#cfn-quicksight-analysis-geospatialnullsymbolstyle-fillcolor
         */
        readonly fillColor?: string;
        /**
         * The color and opacity values for the stroke color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialnullsymbolstyle.html#cfn-quicksight-analysis-geospatialnullsymbolstyle-strokecolor
         */
        readonly strokeColor?: string;
        /**
         * The width of the border stroke.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialnullsymbolstyle.html#cfn-quicksight-analysis-geospatialnullsymbolstyle-strokewidth
         */
        readonly strokeWidth?: number;
    }
    /**
     * The definition for a categorical color.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcategoricalcolor.html
     */
    interface GeospatialCategoricalColorProperty {
        /**
         * A list of categorical data colors for each category.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcategoricalcolor.html#cfn-quicksight-analysis-geospatialcategoricalcolor-categorydatacolors
         */
        readonly categoryDataColors: Array<CfnAnalysis.GeospatialCategoricalDataColorProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The default opacity of a categorical color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcategoricalcolor.html#cfn-quicksight-analysis-geospatialcategoricalcolor-defaultopacity
         */
        readonly defaultOpacity?: number;
        /**
         * The null data visualization settings.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcategoricalcolor.html#cfn-quicksight-analysis-geospatialcategoricalcolor-nulldatasettings
         */
        readonly nullDataSettings?: CfnAnalysis.GeospatialNullDataSettingsProperty | cdk.IResolvable;
        /**
         * The state of visibility for null data.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcategoricalcolor.html#cfn-quicksight-analysis-geospatialcategoricalcolor-nulldatavisibility
         */
        readonly nullDataVisibility?: string;
    }
    /**
     * The categorical data color for a single category.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcategoricaldatacolor.html
     */
    interface GeospatialCategoricalDataColorProperty {
        /**
         * The color and opacity values for the category data color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcategoricaldatacolor.html#cfn-quicksight-analysis-geospatialcategoricaldatacolor-color
         */
        readonly color: string;
        /**
         * The data value for the category data color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcategoricaldatacolor.html#cfn-quicksight-analysis-geospatialcategoricaldatacolor-datavalue
         */
        readonly dataValue: string;
    }
    /**
     * The definition for a solid color.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialsolidcolor.html
     */
    interface GeospatialSolidColorProperty {
        /**
         * The color and opacity values for the color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialsolidcolor.html#cfn-quicksight-analysis-geospatialsolidcolor-color
         */
        readonly color: string;
        /**
         * Enables and disables the view state of the color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialsolidcolor.html#cfn-quicksight-analysis-geospatialsolidcolor-state
         */
        readonly state?: string;
    }
    /**
     * The width properties for a line.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallinewidth.html
     */
    interface GeospatialLineWidthProperty {
        /**
         * The positive value for the width of a line.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallinewidth.html#cfn-quicksight-analysis-geospatiallinewidth-linewidth
         */
        readonly lineWidth?: number;
    }
    /**
     * The geospatial radius for a circle.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcircleradius.html
     */
    interface GeospatialCircleRadiusProperty {
        /**
         * The positive value for the radius of a circle.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcircleradius.html#cfn-quicksight-analysis-geospatialcircleradius-radius
         */
        readonly radius?: number;
    }
    /**
     * The geospatial polygon layer.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialpolygonlayer.html
     */
    interface GeospatialPolygonLayerProperty {
        /**
         * The visualization style for a polygon layer.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialpolygonlayer.html#cfn-quicksight-analysis-geospatialpolygonlayer-style
         */
        readonly style: CfnAnalysis.GeospatialPolygonStyleProperty | cdk.IResolvable;
    }
    /**
     * The polygon style for a polygon layer.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialpolygonstyle.html
     */
    interface GeospatialPolygonStyleProperty {
        /**
         * The polygon symbol style for a polygon layer.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialpolygonstyle.html#cfn-quicksight-analysis-geospatialpolygonstyle-polygonsymbolstyle
         */
        readonly polygonSymbolStyle?: CfnAnalysis.GeospatialPolygonSymbolStyleProperty | cdk.IResolvable;
    }
    /**
     * The polygon symbol style for a polygon layer.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialpolygonsymbolstyle.html
     */
    interface GeospatialPolygonSymbolStyleProperty {
        /**
         * The color and opacity values for the fill color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialpolygonsymbolstyle.html#cfn-quicksight-analysis-geospatialpolygonsymbolstyle-fillcolor
         */
        readonly fillColor?: CfnAnalysis.GeospatialColorProperty | cdk.IResolvable;
        /**
         * The color and opacity values for the stroke color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialpolygonsymbolstyle.html#cfn-quicksight-analysis-geospatialpolygonsymbolstyle-strokecolor
         */
        readonly strokeColor?: CfnAnalysis.GeospatialColorProperty | cdk.IResolvable;
        /**
         * The width of the border stroke.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialpolygonsymbolstyle.html#cfn-quicksight-analysis-geospatialpolygonsymbolstyle-strokewidth
         */
        readonly strokeWidth?: CfnAnalysis.GeospatialLineWidthProperty | cdk.IResolvable;
    }
    /**
     * The geospatial Line layer.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallinelayer.html
     */
    interface GeospatialLineLayerProperty {
        /**
         * The visualization style for a line layer.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallinelayer.html#cfn-quicksight-analysis-geospatiallinelayer-style
         */
        readonly style: CfnAnalysis.GeospatialLineStyleProperty | cdk.IResolvable;
    }
    /**
     * The visualization style for a line layer.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallinestyle.html
     */
    interface GeospatialLineStyleProperty {
        /**
         * The symbol style for a line style.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallinestyle.html#cfn-quicksight-analysis-geospatiallinestyle-linesymbolstyle
         */
        readonly lineSymbolStyle?: CfnAnalysis.GeospatialLineSymbolStyleProperty | cdk.IResolvable;
    }
    /**
     * The symbol style for a line layer.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallinesymbolstyle.html
     */
    interface GeospatialLineSymbolStyleProperty {
        /**
         * The color and opacity values for the fill color.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallinesymbolstyle.html#cfn-quicksight-analysis-geospatiallinesymbolstyle-fillcolor
         */
        readonly fillColor?: CfnAnalysis.GeospatialColorProperty | cdk.IResolvable;
        /**
         * The width value for a line.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatiallinesymbolstyle.html#cfn-quicksight-analysis-geospatiallinesymbolstyle-linewidth
         */
        readonly lineWidth?: CfnAnalysis.GeospatialLineWidthProperty | cdk.IResolvable;
    }
    /**
     * The data source properties for the geospatial data.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialdatasourceitem.html
     */
    interface GeospatialDataSourceItemProperty {
        /**
         * The static file data source properties for the geospatial data.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialdatasourceitem.html#cfn-quicksight-analysis-geospatialdatasourceitem-staticfiledatasource
         */
        readonly staticFileDataSource?: CfnAnalysis.GeospatialStaticFileSourceProperty | cdk.IResolvable;
    }
    /**
     * The source properties for a geospatial static file.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialstaticfilesource.html
     */
    interface GeospatialStaticFileSourceProperty {
        /**
         * The ID of the static file.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialstaticfilesource.html#cfn-quicksight-analysis-geospatialstaticfilesource-staticfileid
         */
        readonly staticFileId: string;
    }
    /**
     * A flexible visualization type that allows engineers to create new custom charts in Amazon QuickSight.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisual.html
     */
    interface PluginVisualProperty {
        /**
         * A description of the plugin field wells and their persisted properties.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisual.html#cfn-quicksight-analysis-pluginvisual-chartconfiguration
         */
        readonly chartConfiguration?: cdk.IResolvable | CfnAnalysis.PluginVisualConfigurationProperty;
        /**
         * The Amazon Resource Name (ARN) that reflects the plugin and version.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisual.html#cfn-quicksight-analysis-pluginvisual-pluginarn
         */
        readonly pluginArn: string;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisual.html#cfn-quicksight-analysis-pluginvisual-subtitle
         */
        readonly subtitle?: cdk.IResolvable | CfnAnalysis.VisualSubtitleLabelOptionsProperty;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisual.html#cfn-quicksight-analysis-pluginvisual-title
         */
        readonly title?: cdk.IResolvable | CfnAnalysis.VisualTitleLabelOptionsProperty;
        /**
         * The alt text for the visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisual.html#cfn-quicksight-analysis-pluginvisual-visualcontentalttext
         */
        readonly visualContentAltText?: string;
        /**
         * The ID of the visual that you want to use.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisual.html#cfn-quicksight-analysis-pluginvisual-visualid
         */
        readonly visualId: string;
    }
    /**
     * The plugin visual configuration.
     *
     * This includes the field wells, sorting options, and persisted options of the plugin visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisualconfiguration.html
     */
    interface PluginVisualConfigurationProperty {
        /**
         * The field wells configuration of the plugin visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisualconfiguration.html#cfn-quicksight-analysis-pluginvisualconfiguration-fieldwells
         */
        readonly fieldWells?: Array<cdk.IResolvable | CfnAnalysis.PluginVisualFieldWellProperty> | cdk.IResolvable;
        /**
         * The sort configuration of the plugin visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisualconfiguration.html#cfn-quicksight-analysis-pluginvisualconfiguration-sortconfiguration
         */
        readonly sortConfiguration?: cdk.IResolvable | CfnAnalysis.PluginVisualSortConfigurationProperty;
        /**
         * The persisted properties of the plugin visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisualconfiguration.html#cfn-quicksight-analysis-pluginvisualconfiguration-visualoptions
         */
        readonly visualOptions?: cdk.IResolvable | CfnAnalysis.PluginVisualOptionsProperty;
    }
    /**
     * Determines how the plugin visual sorts the data during query.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisualsortconfiguration.html
     */
    interface PluginVisualSortConfigurationProperty {
        /**
         * The table query sorting options for the plugin visual.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisualsortconfiguration.html#cfn-quicksight-analysis-pluginvisualsortconfiguration-pluginvisualtablequerysort
         */
        readonly pluginVisualTableQuerySort?: cdk.IResolvable | CfnAnalysis.PluginVisualTableQuerySortProperty;
    }
    /**
     * The table query sorting options for the plugin visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisualtablequerysort.html
     */
    interface PluginVisualTableQuerySortProperty {
        /**
         * The maximum amount of data to be returned by a query.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisualtablequerysort.html#cfn-quicksight-analysis-pluginvisualtablequerysort-itemslimitconfiguration
         */
        readonly itemsLimitConfiguration?: cdk.IResolvable | CfnAnalysis.PluginVisualItemsLimitConfigurationProperty;
        /**
         * Determines how data is sorted in the response.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisualtablequerysort.html#cfn-quicksight-analysis-pluginvisualtablequerysort-rowsort
         */
        readonly rowSort?: Array<CfnAnalysis.FieldSortOptionsProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * A query limits configuration.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisualitemslimitconfiguration.html
     */
    interface PluginVisualItemsLimitConfigurationProperty {
        /**
         * Determines how many values are be fetched at once.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisualitemslimitconfiguration.html#cfn-quicksight-analysis-pluginvisualitemslimitconfiguration-itemslimit
         */
        readonly itemsLimit?: number;
    }
    /**
     * The options and persisted properties for the plugin visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisualoptions.html
     */
    interface PluginVisualOptionsProperty {
        /**
         * The persisted properties and their values.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisualoptions.html#cfn-quicksight-analysis-pluginvisualoptions-visualproperties
         */
        readonly visualProperties?: Array<cdk.IResolvable | CfnAnalysis.PluginVisualPropertyProperty> | cdk.IResolvable;
    }
    /**
     * The key value pair of the persisted property.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisualproperty.html
     */
    interface PluginVisualPropertyProperty {
        /**
         * The name of the plugin visual property.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisualproperty.html#cfn-quicksight-analysis-pluginvisualproperty-name
         */
        readonly name?: string;
        /**
         * The value of the plugin visual property.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisualproperty.html#cfn-quicksight-analysis-pluginvisualproperty-value
         */
        readonly value?: string;
    }
    /**
     * A collection of field wells for a plugin visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisualfieldwell.html
     */
    interface PluginVisualFieldWellProperty {
        /**
         * The semantic axis name for the field well.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisualfieldwell.html#cfn-quicksight-analysis-pluginvisualfieldwell-axisname
         */
        readonly axisName?: string;
        /**
         * A list of dimensions for the field well.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisualfieldwell.html#cfn-quicksight-analysis-pluginvisualfieldwell-dimensions
         */
        readonly dimensions?: Array<CfnAnalysis.DimensionFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * A list of measures that exist in the field well.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisualfieldwell.html#cfn-quicksight-analysis-pluginvisualfieldwell-measures
         */
        readonly measures?: Array<cdk.IResolvable | CfnAnalysis.MeasureFieldProperty> | cdk.IResolvable;
        /**
         * A list of unaggregated fields that exist in the field well.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pluginvisualfieldwell.html#cfn-quicksight-analysis-pluginvisualfieldwell-unaggregated
         */
        readonly unaggregated?: Array<cdk.IResolvable | CfnAnalysis.UnaggregatedFieldProperty> | cdk.IResolvable;
    }
    /**
     * An image that is located on a sheet.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetimage.html
     */
    interface SheetImageProperty {
        /**
         * A list of custom actions that are configured for an image.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetimage.html#cfn-quicksight-analysis-sheetimage-actions
         */
        readonly actions?: Array<CfnAnalysis.ImageCustomActionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The alt text for the image.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetimage.html#cfn-quicksight-analysis-sheetimage-imagecontentalttext
         */
        readonly imageContentAltText?: string;
        /**
         * The general image interactions setup for an image.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetimage.html#cfn-quicksight-analysis-sheetimage-interactions
         */
        readonly interactions?: CfnAnalysis.ImageInteractionOptionsProperty | cdk.IResolvable;
        /**
         * Determines how the image is scaled.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetimage.html#cfn-quicksight-analysis-sheetimage-scaling
         */
        readonly scaling?: cdk.IResolvable | CfnAnalysis.SheetImageScalingConfigurationProperty;
        /**
         * The ID of the sheet image.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetimage.html#cfn-quicksight-analysis-sheetimage-sheetimageid
         */
        readonly sheetImageId: string;
        /**
         * The source of the image.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetimage.html#cfn-quicksight-analysis-sheetimage-source
         */
        readonly source: cdk.IResolvable | CfnAnalysis.SheetImageSourceProperty;
        /**
         * The tooltip to be shown when hovering over the image.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetimage.html#cfn-quicksight-analysis-sheetimage-tooltip
         */
        readonly tooltip?: cdk.IResolvable | CfnAnalysis.SheetImageTooltipConfigurationProperty;
    }
    /**
     * A custom action defined on an image.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-imagecustomaction.html
     */
    interface ImageCustomActionProperty {
        /**
         * A list of `ImageCustomActionOperations` .
         *
         * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-imagecustomaction.html#cfn-quicksight-analysis-imagecustomaction-actionoperations
         */
        readonly actionOperations: Array<CfnAnalysis.ImageCustomActionOperationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The ID of the custom action.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-imagecustomaction.html#cfn-quicksight-analysis-imagecustomaction-customactionid
         */
        readonly customActionId: string;
        /**
         * The name of the custom action.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-imagecustomaction.html#cfn-quicksight-analysis-imagecustomaction-name
         */
        readonly name: string;
        /**
         * The status of the custom action.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-imagecustomaction.html#cfn-quicksight-analysis-imagecustomaction-status
         */
        readonly status?: string;
        /**
         * The trigger of the `VisualCustomAction` .
         *
         * Valid values are defined as follows:
         *
         * - `CLICK` : Initiates a custom action by a left pointer click on a data point.
         * - `MENU` : Initiates a custom action by right pointer click from the menu.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-imagecustomaction.html#cfn-quicksight-analysis-imagecustomaction-trigger
         */
        readonly trigger: string;
    }
    /**
     * The operation that is defined by the custom action.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-imagecustomactionoperation.html
     */
    interface ImageCustomActionOperationProperty {
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-imagecustomactionoperation.html#cfn-quicksight-analysis-imagecustomactionoperation-navigationoperation
         */
        readonly navigationOperation?: CfnAnalysis.CustomActionNavigationOperationProperty | cdk.IResolvable;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-imagecustomactionoperation.html#cfn-quicksight-analysis-imagecustomactionoperation-setparametersoperation
         */
        readonly setParametersOperation?: CfnAnalysis.CustomActionSetParametersOperationProperty | cdk.IResolvable;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-imagecustomactionoperation.html#cfn-quicksight-analysis-imagecustomactionoperation-urloperation
         */
        readonly urlOperation?: CfnAnalysis.CustomActionURLOperationProperty | cdk.IResolvable;
    }
    /**
     * The tooltip configuration for a sheet image.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetimagetooltipconfiguration.html
     */
    interface SheetImageTooltipConfigurationProperty {
        /**
         * The text that appears in the tooltip.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetimagetooltipconfiguration.html#cfn-quicksight-analysis-sheetimagetooltipconfiguration-tooltiptext
         */
        readonly tooltipText?: cdk.IResolvable | CfnAnalysis.SheetImageTooltipTextProperty;
        /**
         * The visibility of the tooltip.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetimagetooltipconfiguration.html#cfn-quicksight-analysis-sheetimagetooltipconfiguration-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The text that appears in the sheet image tooltip.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetimagetooltiptext.html
     */
    interface SheetImageTooltipTextProperty {
        /**
         * The plain text format.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetimagetooltiptext.html#cfn-quicksight-analysis-sheetimagetooltiptext-plaintext
         */
        readonly plainText?: string;
    }
    /**
     * Determines how the image is scaled.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetimagescalingconfiguration.html
     */
    interface SheetImageScalingConfigurationProperty {
        /**
         * The scaling option to use when fitting the image inside the container.
         *
         * Valid values are defined as follows:
         *
         * - `SCALE_TO_WIDTH` : The image takes up the entire width of the container. The image aspect ratio is preserved.
         * - `SCALE_TO_HEIGHT` : The image takes up the entire height of the container. The image aspect ratio is preserved.
         * - `SCALE_TO_CONTAINER` : The image takes up the entire width and height of the container. The image aspect ratio is not preserved.
         * - `SCALE_NONE` : The image is displayed in its original size and is not scaled to the container.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetimagescalingconfiguration.html#cfn-quicksight-analysis-sheetimagescalingconfiguration-scalingtype
         */
        readonly scalingType?: string;
    }
    /**
     * The general image interactions setup for image publish options.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-imageinteractionoptions.html
     */
    interface ImageInteractionOptionsProperty {
        /**
         * The menu options for the image.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-imageinteractionoptions.html#cfn-quicksight-analysis-imageinteractionoptions-imagemenuoption
         */
        readonly imageMenuOption?: CfnAnalysis.ImageMenuOptionProperty | cdk.IResolvable;
    }
    /**
     * The menu options for the interactions of an image.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-imagemenuoption.html
     */
    interface ImageMenuOptionProperty {
        /**
         * The availability status of the image menu.
         *
         * If the value of this property is set to `ENABLED` , dashboard readers can interact with the image menu.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-imagemenuoption.html#cfn-quicksight-analysis-imagemenuoption-availabilitystatus
         */
        readonly availabilityStatus?: string;
    }
    /**
     * The source of the image.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetimagesource.html
     */
    interface SheetImageSourceProperty {
        /**
         * The source of the static file that contains the image.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetimagesource.html#cfn-quicksight-analysis-sheetimagesource-sheetimagestaticfilesource
         */
        readonly sheetImageStaticFileSource?: cdk.IResolvable | CfnAnalysis.SheetImageStaticFileSourceProperty;
    }
    /**
     * The source of the static file that contains the image.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetimagestaticfilesource.html
     */
    interface SheetImageStaticFileSourceProperty {
        /**
         * The ID of the static file that contains the image.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetimagestaticfilesource.html#cfn-quicksight-analysis-sheetimagestaticfilesource-staticfileid
         */
        readonly staticFileId: string;
    }
    /**
     * The declaration definition of a parameter.
     *
     * For more information, see [Parameters in Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html) in the *Amazon QuickSight User Guide* .
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterdeclaration.html
     */
    interface ParameterDeclarationProperty {
        /**
         * A parameter declaration for the `DateTime` data type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterdeclaration.html#cfn-quicksight-analysis-parameterdeclaration-datetimeparameterdeclaration
         */
        readonly dateTimeParameterDeclaration?: CfnAnalysis.DateTimeParameterDeclarationProperty | cdk.IResolvable;
        /**
         * A parameter declaration for the `Decimal` data type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterdeclaration.html#cfn-quicksight-analysis-parameterdeclaration-decimalparameterdeclaration
         */
        readonly decimalParameterDeclaration?: CfnAnalysis.DecimalParameterDeclarationProperty | cdk.IResolvable;
        /**
         * A parameter declaration for the `Integer` data type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterdeclaration.html#cfn-quicksight-analysis-parameterdeclaration-integerparameterdeclaration
         */
        readonly integerParameterDeclaration?: CfnAnalysis.IntegerParameterDeclarationProperty | cdk.IResolvable;
        /**
         * A parameter declaration for the `String` data type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterdeclaration.html#cfn-quicksight-analysis-parameterdeclaration-stringparameterdeclaration
         */
        readonly stringParameterDeclaration?: cdk.IResolvable | CfnAnalysis.StringParameterDeclarationProperty;
    }
    /**
     * A parameter declaration for the `String` data type.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringparameterdeclaration.html
     */
    interface StringParameterDeclarationProperty {
        /**
         * The default values of a parameter.
         *
         * If the parameter is a single-value parameter, a maximum of one default value can be provided.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringparameterdeclaration.html#cfn-quicksight-analysis-stringparameterdeclaration-defaultvalues
         */
        readonly defaultValues?: cdk.IResolvable | CfnAnalysis.StringDefaultValuesProperty;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringparameterdeclaration.html#cfn-quicksight-analysis-stringparameterdeclaration-mappeddatasetparameters
         */
        readonly mappedDataSetParameters?: Array<cdk.IResolvable | CfnAnalysis.MappedDataSetParameterProperty> | cdk.IResolvable;
        /**
         * The name of the parameter that is being declared.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringparameterdeclaration.html#cfn-quicksight-analysis-stringparameterdeclaration-name
         */
        readonly name: string;
        /**
         * The value type determines whether the parameter is a single-value or multi-value parameter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringparameterdeclaration.html#cfn-quicksight-analysis-stringparameterdeclaration-parametervaluetype
         */
        readonly parameterValueType: string;
        /**
         * The configuration that defines the default value of a `String` parameter when a value has not been set.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringparameterdeclaration.html#cfn-quicksight-analysis-stringparameterdeclaration-valuewhenunset
         */
        readonly valueWhenUnset?: cdk.IResolvable | CfnAnalysis.StringValueWhenUnsetConfigurationProperty;
    }
    /**
     * A dataset parameter that is mapped to an analysis parameter.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-mappeddatasetparameter.html
     */
    interface MappedDataSetParameterProperty {
        /**
         * A unique name that identifies a dataset within the analysis or dashboard.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-mappeddatasetparameter.html#cfn-quicksight-analysis-mappeddatasetparameter-datasetidentifier
         */
        readonly dataSetIdentifier: string;
        /**
         * The name of the dataset parameter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-mappeddatasetparameter.html#cfn-quicksight-analysis-mappeddatasetparameter-datasetparametername
         */
        readonly dataSetParameterName: string;
    }
    /**
     * The default values of the `StringParameterDeclaration` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringdefaultvalues.html
     */
    interface StringDefaultValuesProperty {
        /**
         * The dynamic value of the `StringDefaultValues` .
         *
         * Different defaults displayed according to users, groups, and values mapping.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringdefaultvalues.html#cfn-quicksight-analysis-stringdefaultvalues-dynamicvalue
         */
        readonly dynamicValue?: CfnAnalysis.DynamicDefaultValueProperty | cdk.IResolvable;
        /**
         * The static values of the `DecimalDefaultValues` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringdefaultvalues.html#cfn-quicksight-analysis-stringdefaultvalues-staticvalues
         */
        readonly staticValues?: Array<string>;
    }
    /**
     * Defines different defaults to the users or groups based on mapping.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-dynamicdefaultvalue.html
     */
    interface DynamicDefaultValueProperty {
        /**
         * The column that contains the default value of each user or group.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-dynamicdefaultvalue.html#cfn-quicksight-analysis-dynamicdefaultvalue-defaultvaluecolumn
         */
        readonly defaultValueColumn: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The column that contains the group name.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-dynamicdefaultvalue.html#cfn-quicksight-analysis-dynamicdefaultvalue-groupnamecolumn
         */
        readonly groupNameColumn?: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The column that contains the username.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-dynamicdefaultvalue.html#cfn-quicksight-analysis-dynamicdefaultvalue-usernamecolumn
         */
        readonly userNameColumn?: CfnAnalysis.ColumnIdentifierProperty | cdk.IResolvable;
    }
    /**
     * The configuration that defines the default value of a `String` parameter when a value has not been set.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringvaluewhenunsetconfiguration.html
     */
    interface StringValueWhenUnsetConfigurationProperty {
        /**
         * A custom value that's used when the value of a parameter isn't set.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringvaluewhenunsetconfiguration.html#cfn-quicksight-analysis-stringvaluewhenunsetconfiguration-customvalue
         */
        readonly customValue?: string;
        /**
         * The built-in options for default values. The value can be one of the following:.
         *
         * - `RECOMMENDED` : The recommended value.
         * - `NULL` : The `NULL` value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringvaluewhenunsetconfiguration.html#cfn-quicksight-analysis-stringvaluewhenunsetconfiguration-valuewhenunsetoption
         */
        readonly valueWhenUnsetOption?: string;
    }
    /**
     * A parameter declaration for the `DateTime` data type.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameterdeclaration.html
     */
    interface DateTimeParameterDeclarationProperty {
        /**
         * The default values of a parameter.
         *
         * If the parameter is a single-value parameter, a maximum of one default value can be provided.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameterdeclaration.html#cfn-quicksight-analysis-datetimeparameterdeclaration-defaultvalues
         */
        readonly defaultValues?: CfnAnalysis.DateTimeDefaultValuesProperty | cdk.IResolvable;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameterdeclaration.html#cfn-quicksight-analysis-datetimeparameterdeclaration-mappeddatasetparameters
         */
        readonly mappedDataSetParameters?: Array<cdk.IResolvable | CfnAnalysis.MappedDataSetParameterProperty> | cdk.IResolvable;
        /**
         * The name of the parameter that is being declared.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameterdeclaration.html#cfn-quicksight-analysis-datetimeparameterdeclaration-name
         */
        readonly name: string;
        /**
         * The level of time precision that is used to aggregate `DateTime` values.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameterdeclaration.html#cfn-quicksight-analysis-datetimeparameterdeclaration-timegranularity
         */
        readonly timeGranularity?: string;
        /**
         * The configuration that defines the default value of a `DateTime` parameter when a value has not been set.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameterdeclaration.html#cfn-quicksight-analysis-datetimeparameterdeclaration-valuewhenunset
         */
        readonly valueWhenUnset?: CfnAnalysis.DateTimeValueWhenUnsetConfigurationProperty | cdk.IResolvable;
    }
    /**
     * The default values of the `DateTimeParameterDeclaration` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimedefaultvalues.html
     */
    interface DateTimeDefaultValuesProperty {
        /**
         * The dynamic value of the `DataTimeDefaultValues` .
         *
         * Different defaults are displayed according to users, groups, and values mapping.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimedefaultvalues.html#cfn-quicksight-analysis-datetimedefaultvalues-dynamicvalue
         */
        readonly dynamicValue?: CfnAnalysis.DynamicDefaultValueProperty | cdk.IResolvable;
        /**
         * The rolling date of the `DataTimeDefaultValues` .
         *
         * The date is determined from the dataset based on input expression.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimedefaultvalues.html#cfn-quicksight-analysis-datetimedefaultvalues-rollingdate
         */
        readonly rollingDate?: cdk.IResolvable | CfnAnalysis.RollingDateConfigurationProperty;
        /**
         * The static values of the `DataTimeDefaultValues` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimedefaultvalues.html#cfn-quicksight-analysis-datetimedefaultvalues-staticvalues
         */
        readonly staticValues?: Array<string>;
    }
    /**
     * The configuration that defines the default value of a `DateTime` parameter when a value has not been set.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimevaluewhenunsetconfiguration.html
     */
    interface DateTimeValueWhenUnsetConfigurationProperty {
        /**
         * A custom value that's used when the value of a parameter isn't set.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimevaluewhenunsetconfiguration.html#cfn-quicksight-analysis-datetimevaluewhenunsetconfiguration-customvalue
         */
        readonly customValue?: string;
        /**
         * The built-in options for default values. The value can be one of the following:.
         *
         * - `RECOMMENDED` : The recommended value.
         * - `NULL` : The `NULL` value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimevaluewhenunsetconfiguration.html#cfn-quicksight-analysis-datetimevaluewhenunsetconfiguration-valuewhenunsetoption
         */
        readonly valueWhenUnsetOption?: string;
    }
    /**
     * A parameter declaration for the `Decimal` data type.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameterdeclaration.html
     */
    interface DecimalParameterDeclarationProperty {
        /**
         * The default values of a parameter.
         *
         * If the parameter is a single-value parameter, a maximum of one default value can be provided.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameterdeclaration.html#cfn-quicksight-analysis-decimalparameterdeclaration-defaultvalues
         */
        readonly defaultValues?: CfnAnalysis.DecimalDefaultValuesProperty | cdk.IResolvable;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameterdeclaration.html#cfn-quicksight-analysis-decimalparameterdeclaration-mappeddatasetparameters
         */
        readonly mappedDataSetParameters?: Array<cdk.IResolvable | CfnAnalysis.MappedDataSetParameterProperty> | cdk.IResolvable;
        /**
         * The name of the parameter that is being declared.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameterdeclaration.html#cfn-quicksight-analysis-decimalparameterdeclaration-name
         */
        readonly name: string;
        /**
         * The value type determines whether the parameter is a single-value or multi-value parameter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameterdeclaration.html#cfn-quicksight-analysis-decimalparameterdeclaration-parametervaluetype
         */
        readonly parameterValueType: string;
        /**
         * The configuration that defines the default value of a `Decimal` parameter when a value has not been set.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameterdeclaration.html#cfn-quicksight-analysis-decimalparameterdeclaration-valuewhenunset
         */
        readonly valueWhenUnset?: CfnAnalysis.DecimalValueWhenUnsetConfigurationProperty | cdk.IResolvable;
    }
    /**
     * The default values of the `DecimalParameterDeclaration` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimaldefaultvalues.html
     */
    interface DecimalDefaultValuesProperty {
        /**
         * The dynamic value of the `DecimalDefaultValues` .
         *
         * Different defaults are displayed according to users, groups, and values mapping.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimaldefaultvalues.html#cfn-quicksight-analysis-decimaldefaultvalues-dynamicvalue
         */
        readonly dynamicValue?: CfnAnalysis.DynamicDefaultValueProperty | cdk.IResolvable;
        /**
         * The static values of the `DecimalDefaultValues` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimaldefaultvalues.html#cfn-quicksight-analysis-decimaldefaultvalues-staticvalues
         */
        readonly staticValues?: Array<number> | cdk.IResolvable;
    }
    /**
     * The configuration that defines the default value of a `Decimal` parameter when a value has not been set.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalvaluewhenunsetconfiguration.html
     */
    interface DecimalValueWhenUnsetConfigurationProperty {
        /**
         * A custom value that's used when the value of a parameter isn't set.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalvaluewhenunsetconfiguration.html#cfn-quicksight-analysis-decimalvaluewhenunsetconfiguration-customvalue
         */
        readonly customValue?: number;
        /**
         * The built-in options for default values. The value can be one of the following:.
         *
         * - `RECOMMENDED` : The recommended value.
         * - `NULL` : The `NULL` value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalvaluewhenunsetconfiguration.html#cfn-quicksight-analysis-decimalvaluewhenunsetconfiguration-valuewhenunsetoption
         */
        readonly valueWhenUnsetOption?: string;
    }
    /**
     * A parameter declaration for the `Integer` data type.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integerparameterdeclaration.html
     */
    interface IntegerParameterDeclarationProperty {
        /**
         * The default values of a parameter.
         *
         * If the parameter is a single-value parameter, a maximum of one default value can be provided.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integerparameterdeclaration.html#cfn-quicksight-analysis-integerparameterdeclaration-defaultvalues
         */
        readonly defaultValues?: CfnAnalysis.IntegerDefaultValuesProperty | cdk.IResolvable;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integerparameterdeclaration.html#cfn-quicksight-analysis-integerparameterdeclaration-mappeddatasetparameters
         */
        readonly mappedDataSetParameters?: Array<cdk.IResolvable | CfnAnalysis.MappedDataSetParameterProperty> | cdk.IResolvable;
        /**
         * The name of the parameter that is being declared.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integerparameterdeclaration.html#cfn-quicksight-analysis-integerparameterdeclaration-name
         */
        readonly name: string;
        /**
         * The value type determines whether the parameter is a single-value or multi-value parameter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integerparameterdeclaration.html#cfn-quicksight-analysis-integerparameterdeclaration-parametervaluetype
         */
        readonly parameterValueType: string;
        /**
         * A parameter declaration for the `Integer` data type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integerparameterdeclaration.html#cfn-quicksight-analysis-integerparameterdeclaration-valuewhenunset
         */
        readonly valueWhenUnset?: CfnAnalysis.IntegerValueWhenUnsetConfigurationProperty | cdk.IResolvable;
    }
    /**
     * The default values of the `IntegerParameterDeclaration` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integerdefaultvalues.html
     */
    interface IntegerDefaultValuesProperty {
        /**
         * The dynamic value of the `IntegerDefaultValues` .
         *
         * Different defaults are displayed according to users, groups, and values mapping.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integerdefaultvalues.html#cfn-quicksight-analysis-integerdefaultvalues-dynamicvalue
         */
        readonly dynamicValue?: CfnAnalysis.DynamicDefaultValueProperty | cdk.IResolvable;
        /**
         * The static values of the `IntegerDefaultValues` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integerdefaultvalues.html#cfn-quicksight-analysis-integerdefaultvalues-staticvalues
         */
        readonly staticValues?: Array<number> | cdk.IResolvable;
    }
    /**
     * A parameter declaration for the `Integer` data type.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integervaluewhenunsetconfiguration.html
     */
    interface IntegerValueWhenUnsetConfigurationProperty {
        /**
         * A custom value that's used when the value of a parameter isn't set.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integervaluewhenunsetconfiguration.html#cfn-quicksight-analysis-integervaluewhenunsetconfiguration-customvalue
         */
        readonly customValue?: number;
        /**
         * The built-in options for default values. The value can be one of the following:.
         *
         * - `RECOMMENDED` : The recommended value.
         * - `NULL` : The `NULL` value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integervaluewhenunsetconfiguration.html#cfn-quicksight-analysis-integervaluewhenunsetconfiguration-valuewhenunsetoption
         */
        readonly valueWhenUnsetOption?: string;
    }
    /**
     * An array of analysis level configurations.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-assetoptions.html
     */
    interface AssetOptionsProperty {
        /**
         * Determines the timezone for the analysis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-assetoptions.html#cfn-quicksight-analysis-assetoptions-timezone
         */
        readonly timezone?: string;
        /**
         * Determines the week start day for an analysis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-assetoptions.html#cfn-quicksight-analysis-assetoptions-weekstart
         */
        readonly weekStart?: string;
    }
    /**
     * A structure that describes the query execution options.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-queryexecutionoptions.html
     */
    interface QueryExecutionOptionsProperty {
        /**
         * A structure that describes the query execution mode.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-queryexecutionoptions.html#cfn-quicksight-analysis-queryexecutionoptions-queryexecutionmode
         */
        readonly queryExecutionMode?: string;
    }
    /**
     * The static file.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-staticfile.html
     */
    interface StaticFileProperty {
        /**
         * The image static file.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-staticfile.html#cfn-quicksight-analysis-staticfile-imagestaticfile
         */
        readonly imageStaticFile?: CfnAnalysis.ImageStaticFileProperty | cdk.IResolvable;
        /**
         * The spacial static file.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-staticfile.html#cfn-quicksight-analysis-staticfile-spatialstaticfile
         */
        readonly spatialStaticFile?: cdk.IResolvable | CfnAnalysis.SpatialStaticFileProperty;
    }
    /**
     * A static file that contains an image.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-imagestaticfile.html
     */
    interface ImageStaticFileProperty {
        /**
         * The source of the image static file.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-imagestaticfile.html#cfn-quicksight-analysis-imagestaticfile-source
         */
        readonly source?: cdk.IResolvable | CfnAnalysis.StaticFileSourceProperty;
        /**
         * The ID of the static file that contains an image.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-imagestaticfile.html#cfn-quicksight-analysis-imagestaticfile-staticfileid
         */
        readonly staticFileId: string;
    }
    /**
     * The source of the static file.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-staticfilesource.html
     */
    interface StaticFileSourceProperty {
        /**
         * The structure that contains the Amazon S3 location to download the static file from.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-staticfilesource.html#cfn-quicksight-analysis-staticfilesource-s3options
         */
        readonly s3Options?: cdk.IResolvable | CfnAnalysis.StaticFileS3SourceOptionsProperty;
        /**
         * The structure that contains the URL to download the static file from.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-staticfilesource.html#cfn-quicksight-analysis-staticfilesource-urloptions
         */
        readonly urlOptions?: cdk.IResolvable | CfnAnalysis.StaticFileUrlSourceOptionsProperty;
    }
    /**
     * The structure that contains the URL to download the static file from.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-staticfileurlsourceoptions.html
     */
    interface StaticFileUrlSourceOptionsProperty {
        /**
         * The URL to download the static file from.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-staticfileurlsourceoptions.html#cfn-quicksight-analysis-staticfileurlsourceoptions-url
         */
        readonly url: string;
    }
    /**
     * The structure that contains the Amazon S3 location to download the static file from.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-staticfiles3sourceoptions.html
     */
    interface StaticFileS3SourceOptionsProperty {
        /**
         * The name of the Amazon S3 bucket.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-staticfiles3sourceoptions.html#cfn-quicksight-analysis-staticfiles3sourceoptions-bucketname
         */
        readonly bucketName: string;
        /**
         * The identifier of the static file in the Amazon S3 bucket.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-staticfiles3sourceoptions.html#cfn-quicksight-analysis-staticfiles3sourceoptions-objectkey
         */
        readonly objectKey: string;
        /**
         * The Region of the Amazon S3 account that contains the bucket.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-staticfiles3sourceoptions.html#cfn-quicksight-analysis-staticfiles3sourceoptions-region
         */
        readonly region: string;
    }
    /**
     * A static file that contains the geospatial data.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-spatialstaticfile.html
     */
    interface SpatialStaticFileProperty {
        /**
         * The source of the spatial static file.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-spatialstaticfile.html#cfn-quicksight-analysis-spatialstaticfile-source
         */
        readonly source?: cdk.IResolvable | CfnAnalysis.StaticFileSourceProperty;
        /**
         * The ID of the spatial static file.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-spatialstaticfile.html#cfn-quicksight-analysis-spatialstaticfile-staticfileid
         */
        readonly staticFileId: string;
    }
    /**
     * Permission for the resource.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-resourcepermission.html
     */
    interface ResourcePermissionProperty {
        /**
         * The IAM action to grant or revoke permissions on.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-resourcepermission.html#cfn-quicksight-analysis-resourcepermission-actions
         */
        readonly actions: Array<string>;
        /**
         * The Amazon Resource Name (ARN) of the principal. This can be one of the following:.
         *
         * - The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)
         * - The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)
         * - The ARN of an AWS account root: This is an IAM ARN rather than a Amazon QuickSight ARN. Use this option only to share resources (templates) across AWS accounts . (This is less common.)
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-resourcepermission.html#cfn-quicksight-analysis-resourcepermission-principal
         */
        readonly principal: string;
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-resourcepermission.html#cfn-quicksight-analysis-resourcepermission-resource
         */
        readonly resource?: string;
    }
    /**
     * The option to relax the validation that is required to create and update analyses, dashboards, and templates with definition objects.
     *
     * When you set this value to `LENIENT` , validation is skipped for specific errors.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-validationstrategy.html
     */
    interface ValidationStrategyProperty {
        /**
         * The mode of validation for the asset to be created or updated.
         *
         * When you set this value to `STRICT` , strict validation for every error is enforced. When you set this value to `LENIENT` , validation is skipped for specific UI errors.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-validationstrategy.html#cfn-quicksight-analysis-validationstrategy-mode
         */
        readonly mode: string;
    }
    /**
     * Analysis error.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html
     */
    interface AnalysisErrorProperty {
        /**
         * The message associated with the analysis error.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html#cfn-quicksight-analysis-analysiserror-message
         */
        readonly message?: string;
        /**
         * The type of the analysis error.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html#cfn-quicksight-analysis-analysiserror-type
         */
        readonly type?: string;
        /**
         * Lists the violated entities that caused the analysis error.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html#cfn-quicksight-analysis-analysiserror-violatedentities
         */
        readonly violatedEntities?: Array<CfnAnalysis.EntityProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * An object, structure, or sub-structure of an analysis, template, or dashboard.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-entity.html
     */
    interface EntityProperty {
        /**
         * The hierarchical path of the entity within the analysis, template, or dashboard definition tree.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-entity.html#cfn-quicksight-analysis-entity-path
         */
        readonly path?: string;
    }
    /**
     * A *sheet* , which is an object that contains a set of visuals that are viewed together on one page in Amazon QuickSight.
     *
     * Every analysis and dashboard contains at least one sheet. Each sheet contains at least one visualization widget, for example a chart, pivot table, or narrative insight. Sheets can be associated with other components, such as controls, filters, and so on.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheet.html
     */
    interface SheetProperty {
        /**
         * The name of a sheet.
         *
         * This name is displayed on the sheet's tab in the Amazon QuickSight console.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheet.html#cfn-quicksight-analysis-sheet-name
         */
        readonly name?: string;
        /**
         * The unique identifier associated with a sheet.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheet.html#cfn-quicksight-analysis-sheet-sheetid
         */
        readonly sheetId?: string;
    }
}
/**
 * Properties for defining a `CfnAnalysis`
 *
 * @struct
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 */
export interface CfnAnalysisProps {
    /**
     * The ID for the analysis that you're creating.
     *
     * This ID displays in the URL of the analysis.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-analysisid
     */
    readonly analysisId: string;
    /**
     * The ID of the AWS account where you are creating an analysis.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-awsaccountid
     */
    readonly awsAccountId: string;
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-definition
     */
    readonly definition?: CfnAnalysis.AnalysisDefinitionProperty | cdk.IResolvable;
    /**
     * Errors associated with the analysis.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-errors
     */
    readonly errors?: Array<CfnAnalysis.AnalysisErrorProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-folderarns
     */
    readonly folderArns?: Array<string>;
    /**
     * A descriptive name for the analysis that you're creating.
     *
     * This name displays for the analysis in the Amazon QuickSight console.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-name
     */
    readonly name: string;
    /**
     * The parameter names and override values that you want to use.
     *
     * An analysis can have any parameter type, and some parameters might accept multiple values.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-parameters
     */
    readonly parameters?: cdk.IResolvable | CfnAnalysis.ParametersProperty;
    /**
     * A structure that describes the principals and the resource-level permissions on an analysis.
     *
     * You can use the `Permissions` structure to grant permissions by providing a list of AWS Identity and Access Management (IAM) action information for each principal listed by Amazon Resource Name (ARN).
     *
     * To specify no permissions, omit `Permissions` .
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-permissions
     */
    readonly permissions?: Array<cdk.IResolvable | CfnAnalysis.ResourcePermissionProperty> | cdk.IResolvable;
    /**
     * A list of the associated sheets with the unique identifier and name of each sheet.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-sheets
     */
    readonly sheets?: Array<cdk.IResolvable | CfnAnalysis.SheetProperty> | cdk.IResolvable;
    /**
     * A source entity to use for the analysis that you're creating.
     *
     * This metadata structure contains details that describe a source template and one or more datasets.
     *
     * Either a `SourceEntity` or a `Definition` must be provided in order for the request to be valid.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-sourceentity
     */
    readonly sourceEntity?: CfnAnalysis.AnalysisSourceEntityProperty | cdk.IResolvable;
    /**
     * Status associated with the analysis.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-status
     */
    readonly status?: string;
    /**
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the analysis.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-tags
     */
    readonly tags?: Array<cdk.CfnTag>;
    /**
     * The ARN for the theme to apply to the analysis that you're creating.
     *
     * To see the theme in the Amazon QuickSight console, make sure that you have access to it.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-themearn
     */
    readonly themeArn?: string;
    /**
     * The option to relax the validation that is required to create and update analyses, dashboards, and templates with definition objects.
     *
     * When you set this value to `LENIENT` , validation is skipped for specific errors.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-validationstrategy
     */
    readonly validationStrategy?: cdk.IResolvable | CfnAnalysis.ValidationStrategyProperty;
}
/**
 * Creates a dashboard from a template. To first create a template, see the `CreateTemplate` API operation.
 *
 * A dashboard is an entity in Amazon QuickSight that identifies Amazon QuickSight reports, created from analyses. You can share Amazon QuickSight dashboards. With the right permissions, you can create scheduled email reports from them. If you have the correct permissions, you can create a dashboard from a template that exists in a different AWS account .
 *
 * @cloudformationResource AWS::QuickSight::Dashboard
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 */
export declare class CfnDashboard extends cdk.CfnResource implements cdk.IInspectable, cdk.ITaggable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME: string;
    /**
     * Build a CfnDashboard from CloudFormation properties
     *
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: constructs.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDashboard;
    /**
     * The Amazon Resource Name (ARN) of the dashboard.
     *
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * The time this dashboard version was created.
     *
     * @cloudformationAttribute CreatedTime
     */
    readonly attrCreatedTime: string;
    /**
     * The time that the dashboard was last published.
     *
     * @cloudformationAttribute LastPublishedTime
     */
    readonly attrLastPublishedTime: string;
    /**
     * The time that the dashboard was last updated.
     *
     * @cloudformationAttribute LastUpdatedTime
     */
    readonly attrLastUpdatedTime: string;
    /**
     * <p>Dashboard version.</p>
     *
     * @cloudformationAttribute Version
     */
    readonly attrVersion: cdk.IResolvable;
    /**
     * @cloudformationAttribute Version.Arn
     */
    readonly attrVersionArn: string;
    /**
     * @cloudformationAttribute Version.CreatedTime
     */
    readonly attrVersionCreatedTime: string;
    /**
     * @cloudformationAttribute Version.DataSetArns
     */
    readonly attrVersionDataSetArns: Array<string>;
    /**
     * @cloudformationAttribute Version.Description
     */
    readonly attrVersionDescription: string;
    /**
     * @cloudformationAttribute Version.Errors
     */
    readonly attrVersionErrors: cdk.IResolvable;
    /**
     * @cloudformationAttribute Version.Sheets
     */
    readonly attrVersionSheets: cdk.IResolvable;
    /**
     * @cloudformationAttribute Version.SourceEntityArn
     */
    readonly attrVersionSourceEntityArn: string;
    /**
     * @cloudformationAttribute Version.Status
     */
    readonly attrVersionStatus: string;
    /**
     * @cloudformationAttribute Version.ThemeArn
     */
    readonly attrVersionThemeArn: string;
    /**
     * @cloudformationAttribute Version.VersionNumber
     */
    readonly attrVersionVersionNumber: cdk.IResolvable;
    /**
     * The ID of the AWS account where you want to create the dashboard.
     */
    awsAccountId: string;
    /**
     * The ID for the dashboard, also added to the IAM policy.
     */
    dashboardId: string;
    /**
     * Options for publishing the dashboard when you create it:.
     */
    dashboardPublishOptions?: CfnDashboard.DashboardPublishOptionsProperty | cdk.IResolvable;
    definition?: CfnDashboard.DashboardVersionDefinitionProperty | cdk.IResolvable;
    folderArns?: Array<string>;
    /**
     * A list of analysis Amazon Resource Names (ARNs) to be linked to the dashboard.
     */
    linkEntities?: Array<string>;
    /**
     * A structure that contains the link sharing configurations that you want to apply overrides to.
     */
    linkSharingConfiguration?: cdk.IResolvable | CfnDashboard.LinkSharingConfigurationProperty;
    /**
     * The display name of the dashboard.
     */
    name: string;
    /**
     * The parameters for the creation of the dashboard, which you want to use to override the default settings.
     */
    parameters?: cdk.IResolvable | CfnDashboard.ParametersProperty;
    /**
     * A structure that contains the permissions of the dashboard.
     */
    permissions?: Array<cdk.IResolvable | CfnDashboard.ResourcePermissionProperty> | cdk.IResolvable;
    /**
     * The entity that you are using as a source when you create the dashboard.
     */
    sourceEntity?: CfnDashboard.DashboardSourceEntityProperty | cdk.IResolvable;
    /**
     * Tag Manager which manages the tags for this resource
     */
    readonly tags: cdk.TagManager;
    /**
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard.
     */
    tagsRaw?: Array<cdk.CfnTag>;
    /**
     * The Amazon Resource Name (ARN) of the theme that is being used for this dashboard.
     */
    themeArn?: string;
    /**
     * The option to relax the validation that is required to create and update analyses, dashboards, and templates with definition objects.
     */
    validationStrategy?: cdk.IResolvable | CfnDashboard.ValidationStrategyProperty;
    /**
     * A description for the first version of the dashboard being created.
     */
    versionDescription?: string;
    /**
     * @param scope Scope in which this resource is defined
     * @param id Construct identifier for this resource (unique in its scope)
     * @param props Resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnDashboardProps);
    protected get cfnProperties(): Record<string, any>;
    /**
     * Examines the CloudFormation resource and discloses attributes
     *
     * @param inspector tree inspector to collect and process attributes
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected renderProperties(props: Record<string, any>): Record<string, any>;
}
export declare namespace CfnDashboard {
    /**
     * Dashboard publish options.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html
     */
    interface DashboardPublishOptionsProperty {
        /**
         * Ad hoc (one-time) filtering option.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html#cfn-quicksight-dashboard-dashboardpublishoptions-adhocfilteringoption
         */
        readonly adHocFilteringOption?: CfnDashboard.AdHocFilteringOptionProperty | cdk.IResolvable;
        /**
         * The drill-down options of data points in a dashboard.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html#cfn-quicksight-dashboard-dashboardpublishoptions-datapointdrillupdownoption
         */
        readonly dataPointDrillUpDownOption?: CfnDashboard.DataPointDrillUpDownOptionProperty | cdk.IResolvable;
        /**
         * The data point menu label options of a dashboard.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html#cfn-quicksight-dashboard-dashboardpublishoptions-datapointmenulabeloption
         */
        readonly dataPointMenuLabelOption?: CfnDashboard.DataPointMenuLabelOptionProperty | cdk.IResolvable;
        /**
         * The data point tool tip options of a dashboard.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html#cfn-quicksight-dashboard-dashboardpublishoptions-datapointtooltipoption
         */
        readonly dataPointTooltipOption?: CfnDashboard.DataPointTooltipOptionProperty | cdk.IResolvable;
        /**
         * Export to .csv option.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html#cfn-quicksight-dashboard-dashboardpublishoptions-exporttocsvoption
         */
        readonly exportToCsvOption?: CfnDashboard.ExportToCSVOptionProperty | cdk.IResolvable;
        /**
         * Determines if hidden fields are exported with a dashboard.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html#cfn-quicksight-dashboard-dashboardpublishoptions-exportwithhiddenfieldsoption
         */
        readonly exportWithHiddenFieldsOption?: CfnDashboard.ExportWithHiddenFieldsOptionProperty | cdk.IResolvable;
        /**
         * Sheet controls option.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html#cfn-quicksight-dashboard-dashboardpublishoptions-sheetcontrolsoption
         */
        readonly sheetControlsOption?: cdk.IResolvable | CfnDashboard.SheetControlsOptionProperty;
        /**
         * The sheet layout maximization options of a dashbaord.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html#cfn-quicksight-dashboard-dashboardpublishoptions-sheetlayoutelementmaximizationoption
         */
        readonly sheetLayoutElementMaximizationOption?: cdk.IResolvable | CfnDashboard.SheetLayoutElementMaximizationOptionProperty;
        /**
         * The axis sort options of a dashboard.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html#cfn-quicksight-dashboard-dashboardpublishoptions-visualaxissortoption
         */
        readonly visualAxisSortOption?: cdk.IResolvable | CfnDashboard.VisualAxisSortOptionProperty;
        /**
         * The menu options of a visual in a dashboard.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html#cfn-quicksight-dashboard-dashboardpublishoptions-visualmenuoption
         */
        readonly visualMenuOption?: cdk.IResolvable | CfnDashboard.VisualMenuOptionProperty;
        /**
         * The visual publish options of a visual in a dashboard.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html#cfn-quicksight-dashboard-dashboardpublishoptions-visualpublishoptions
         */
        readonly visualPublishOptions?: CfnDashboard.DashboardVisualPublishOptionsProperty | cdk.IResolvable;
    }
    /**
     * Sheet controls option.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-sheetcontrolsoption.html
     */
    interface SheetControlsOptionProperty {
        /**
         * Visibility state.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-sheetcontrolsoption.html#cfn-quicksight-dashboard-sheetcontrolsoption-visibilitystate
         */
        readonly visibilityState?: string;
    }
    /**
     * Export to .csv option.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-exporttocsvoption.html
     */
    interface ExportToCSVOptionProperty {
        /**
         * Availability status.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-exporttocsvoption.html#cfn-quicksight-dashboard-exporttocsvoption-availabilitystatus
         */
        readonly availabilityStatus?: string;
    }
    /**
     * The data point menu options of a dashboard.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datapointmenulabeloption.html
     */
    interface DataPointMenuLabelOptionProperty {
        /**
         * The status of the data point menu options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datapointmenulabeloption.html#cfn-quicksight-dashboard-datapointmenulabeloption-availabilitystatus
         */
        readonly availabilityStatus?: string;
    }
    /**
     * The drill down options for data points in a dashbaord.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datapointdrillupdownoption.html
     */
    interface DataPointDrillUpDownOptionProperty {
        /**
         * The status of the drill down options of data points.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datapointdrillupdownoption.html#cfn-quicksight-dashboard-datapointdrillupdownoption-availabilitystatus
         */
        readonly availabilityStatus?: string;
    }
    /**
     * An ad hoc (one-time) filtering option.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-adhocfilteringoption.html
     */
    interface AdHocFilteringOptionProperty {
        /**
         * Availability status.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-adhocfilteringoption.html#cfn-quicksight-dashboard-adhocfilteringoption-availabilitystatus
         */
        readonly availabilityStatus?: string;
    }
    /**
     * The visual publish options of a visual in a dashboard.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardvisualpublishoptions.html
     */
    interface DashboardVisualPublishOptionsProperty {
        /**
         * Determines if hidden fields are included in an exported dashboard.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardvisualpublishoptions.html#cfn-quicksight-dashboard-dashboardvisualpublishoptions-exporthiddenfieldsoption
         */
        readonly exportHiddenFieldsOption?: CfnDashboard.ExportHiddenFieldsOptionProperty | cdk.IResolvable;
    }
    /**
     * Determines if hidden fields are included in an exported dashboard.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-exporthiddenfieldsoption.html
     */
    interface ExportHiddenFieldsOptionProperty {
        /**
         * The status of the export hidden fields options of a dashbaord.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-exporthiddenfieldsoption.html#cfn-quicksight-dashboard-exporthiddenfieldsoption-availabilitystatus
         */
        readonly availabilityStatus?: string;
    }
    /**
     * The menu options for a visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-visualmenuoption.html
     */
    interface VisualMenuOptionProperty {
        /**
         * The availaiblity status of a visual's menu options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-visualmenuoption.html#cfn-quicksight-dashboard-visualmenuoption-availabilitystatus
         */
        readonly availabilityStatus?: string;
    }
    /**
     * The data point tooltip options.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datapointtooltipoption.html
     */
    interface DataPointTooltipOptionProperty {
        /**
         * The status of the data point tool tip options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datapointtooltipoption.html#cfn-quicksight-dashboard-datapointtooltipoption-availabilitystatus
         */
        readonly availabilityStatus?: string;
    }
    /**
     * The axis sort options for a visual.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-visualaxissortoption.html
     */
    interface VisualAxisSortOptionProperty {
        /**
         * The availaiblity status of a visual's axis sort options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-visualaxissortoption.html#cfn-quicksight-dashboard-visualaxissortoption-availabilitystatus
         */
        readonly availabilityStatus?: string;
    }
    /**
     * Determines whether or not hidden fields are visible on exported dashbaords.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-exportwithhiddenfieldsoption.html
     */
    interface ExportWithHiddenFieldsOptionProperty {
        /**
         * The status of the export with hidden fields options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-exportwithhiddenfieldsoption.html#cfn-quicksight-dashboard-exportwithhiddenfieldsoption-availabilitystatus
         */
        readonly availabilityStatus?: string;
    }
    /**
     * The sheet layout maximization options of a dashbaord.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-sheetlayoutelementmaximizationoption.html
     */
    interface SheetLayoutElementMaximizationOptionProperty {
        /**
         * The status of the sheet layout maximization options of a dashbaord.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-sheetlayoutelementmaximizationoption.html#cfn-quicksight-dashboard-sheetlayoutelementmaximizationoption-availabilitystatus
         */
        readonly availabilityStatus?: string;
    }
    /**
     * A list of Amazon QuickSight parameters and the list's override values.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-parameters.html
     */
    interface ParametersProperty {
        /**
         * The parameters that have a data type of date-time.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-parameters.html#cfn-quicksight-dashboard-parameters-datetimeparameters
         */
        readonly dateTimeParameters?: Array<CfnDashboard.DateTimeParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The parameters that have a data type of decimal.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-parameters.html#cfn-quicksight-dashboard-parameters-decimalparameters
         */
        readonly decimalParameters?: Array<CfnDashboard.DecimalParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The parameters that have a data type of integer.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-parameters.html#cfn-quicksight-dashboard-parameters-integerparameters
         */
        readonly integerParameters?: Array<CfnDashboard.IntegerParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The parameters that have a data type of string.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-parameters.html#cfn-quicksight-dashboard-parameters-stringparameters
         */
        readonly stringParameters?: Array<cdk.IResolvable | CfnDashboard.StringParameterProperty> | cdk.IResolvable;
    }
    /**
     * A string parameter.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-stringparameter.html
     */
    interface StringParameterProperty {
        /**
         * A display name for a string parameter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-stringparameter.html#cfn-quicksight-dashboard-stringparameter-name
         */
        readonly name: string;
        /**
         * The values of a string parameter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-stringparameter.html#cfn-quicksight-dashboard-stringparameter-values
         */
        readonly values: Array<string>;
    }
    /**
     * A decimal parameter.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-decimalparameter.html
     */
    interface DecimalParameterProperty {
        /**
         * A display name for the decimal parameter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-decimalparameter.html#cfn-quicksight-dashboard-decimalparameter-name
         */
        readonly name: string;
        /**
         * The values for the decimal parameter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-decimalparameter.html#cfn-quicksight-dashboard-decimalparameter-values
         */
        readonly values: Array<number> | cdk.IResolvable;
    }
    /**
     * An integer parameter.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-integerparameter.html
     */
    interface IntegerParameterProperty {
        /**
         * The name of the integer parameter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-integerparameter.html#cfn-quicksight-dashboard-integerparameter-name
         */
        readonly name: string;
        /**
         * The values for the integer parameter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-integerparameter.html#cfn-quicksight-dashboard-integerparameter-values
         */
        readonly values: Array<number> | cdk.IResolvable;
    }
    /**
     * A date-time parameter.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datetimeparameter.html
     */
    interface DateTimeParameterProperty {
        /**
         * A display name for the date-time parameter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datetimeparameter.html#cfn-quicksight-dashboard-datetimeparameter-name
         */
        readonly name: string;
        /**
         * The values for the date-time parameter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datetimeparameter.html#cfn-quicksight-dashboard-datetimeparameter-values
         */
        readonly values: Array<string>;
    }
    /**
     * Dashboard source entity.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardsourceentity.html
     */
    interface DashboardSourceEntityProperty {
        /**
         * Source template.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardsourceentity.html#cfn-quicksight-dashboard-dashboardsourceentity-sourcetemplate
         */
        readonly sourceTemplate?: CfnDashboard.DashboardSourceTemplateProperty | cdk.IResolvable;
    }
    /**
     * Dashboard source template.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardsourcetemplate.html
     */
    interface DashboardSourceTemplateProperty {
        /**
         * The Amazon Resource Name (ARN) of the resource.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardsourcetemplate.html#cfn-quicksight-dashboard-dashboardsourcetemplate-arn
         */
        readonly arn: string;
        /**
         * Dataset references.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardsourcetemplate.html#cfn-quicksight-dashboard-dashboardsourcetemplate-datasetreferences
         */
        readonly dataSetReferences: Array<CfnDashboard.DataSetReferenceProperty | cdk.IResolvable> | cdk.IResolvable;
    }
    /**
     * Dataset reference.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datasetreference.html
     */
    interface DataSetReferenceProperty {
        /**
         * Dataset Amazon Resource Name (ARN).
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datasetreference.html#cfn-quicksight-dashboard-datasetreference-datasetarn
         */
        readonly dataSetArn: string;
        /**
         * Dataset placeholder.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datasetreference.html#cfn-quicksight-dashboard-datasetreference-datasetplaceholder
         */
        readonly dataSetPlaceholder: string;
    }
    /**
     * The contents of a dashboard.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardversiondefinition.html
     */
    interface DashboardVersionDefinitionProperty {
        /**
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardversiondefinition.html#cfn-quicksight-dashboard-dashboardversiondefinition-analysisdefaults
         */
        readonly analysisDefaults?: CfnDashboard.AnalysisDefaultsProperty | cdk.IResolvable;
        /**
         * An array of calculated field definitions for the dashboard.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardversiondefinition.html#cfn-quicksight-dashboard-dashboardversiondefinition-calculatedfields
         */
        readonly calculatedFields?: Array<CfnDashboard.CalculatedFieldProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * An array of dashboard-level column configurations.
         *
         * Column configurations are used to set the default formatting for a column that is used throughout a dashboard.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardversiondefinition.html#cfn-quicksight-dashboard-dashboardversiondefinition-columnconfigurations
         */
        readonly columnConfigurations?: Array<CfnDashboard.ColumnConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * An array of dataset identifier declarations.
         *
         * With this mapping,you can use dataset identifiers instead of dataset Amazon Resource Names (ARNs) throughout the dashboard's sub-structures.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardversiondefinition.html#cfn-quicksight-dashboard-dashboardversiondefinition-datasetidentifierdeclarations
         */
        readonly dataSetIdentifierDeclarations: Array<CfnDashboard.DataSetIdentifierDeclarationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The filter definitions for a dashboard.
         *
         * For more information, see [Filtering Data in Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/adding-a-filter.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardversiondefinition.html#cfn-quicksight-dashboard-dashboardversiondefinition-filtergroups
         */
        readonly filterGroups?: Array<CfnDashboard.FilterGroupProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * An array of option definitions for a dashboard.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardversiondefinition.html#cfn-quicksight-dashboard-dashboardversiondefinition-options
         */
        readonly options?: CfnDashboard.AssetOptionsProperty | cdk.IResolvable;
        /**
         * The parameter declarations for a dashboard.
         *
         * Parameters are named variables that can transfer a value for use by an action or an object.
         *
         * For more information, see [Parameters in Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardversiondefinition.html#cfn-quicksight-dashboard-dashboardversiondefinition-parameterdeclarations
         */
        readonly parameterDeclarations?: Array<cdk.IResolvable | CfnDashboard.ParameterDeclarationProperty> | cdk.IResolvable;
        /**
         * An array of sheet definitions for a dashboard.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardversiondefinition.html#cfn-quicksight-dashboard-dashboardversiondefinition-sheets
         */
        readonly sheets?: Array<cdk.IResolvable | CfnDashboard.SheetDefinitionProperty> | cdk.IResolvable;
        /**
         * The static files for the definition.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardversiondefinition.html#cfn-quicksight-dashboard-dashboardversiondefinition-staticfiles
         */
        readonly staticFiles?: Array<cdk.IResolvable | CfnDashboard.StaticFileProperty> | cdk.IResolvable;
    }
    /**
     * A grouping of individual filters. Filter groups are applied to the same group of visuals.
     *
     * For more information, see [Adding filter conditions (group filters) with AND and OR operators](https://docs.aws.amazon.com/quicksight/latest/user/add-a-compound-filter.html) in the *Amazon QuickSight User Guide* .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-filtergroup.html
     */
    interface FilterGroupProperty {
        /**
         * The filter new feature which can apply filter group to all data sets. Choose one of the following options:.
         *
         * - `ALL_DATASETS`
         * - `SINGLE_DATASET`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-filtergroup.html#cfn-quicksight-dashboard-filtergroup-crossdataset
         */
        readonly crossDataset: string;
        /**
         * The value that uniquely identifies a `FilterGroup` within a dashboard, template, or analysis.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-filtergroup.html#cfn-quicksight-dashboard-filtergroup-filtergroupid
         */
        readonly filterGroupId: string;
        /**
         * The list of filters that are present in a `FilterGroup` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-filtergroup.html#cfn-quicksight-dashboard-filtergroup-filters
         */
        readonly filters: Array<CfnDashboard.FilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The configuration that specifies what scope to apply to a `FilterGroup` .
         *
         * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-filtergroup.html#cfn-quicksight-dashboard-filtergroup-scopeconfiguration
         */
        readonly scopeConfiguration: CfnDashboard.FilterScopeConfigurationProperty | cdk.IResolvable;
        /**
         * The status of the `FilterGroup` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-filtergroup.html#cfn-quicksight-dashboard-filtergroup-status
         */
        readonly status?: string;
    }
    /**
     * With a `Filter` , you can remove portions of data from a particular visual or view.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-filter.html
     */
    interface FilterProperty {
        /**
         * A `CategoryFilter` filters text values.
         *
         * For more information, see [Adding text filters](https://docs.aws.amazon.com/quicksight/latest/user/add-a-text-filter-data-prep.html) in the *Amazon QuickSight User Guide* .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-filter.html#cfn-quicksight-dashboard-filter-categoryfilter
         */
        readonly categoryFilter?: CfnDashboard.CategoryFilterProperty | cdk.IResolvable;
        /**
         * A `NestedFilter` filters data with a subset of data that is defined by the nested inner filter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-filter.html#cfn-quicksight-dashboard-filter-nestedfilter
         */
        readonly nestedFilter?: cdk.IResolvable | CfnDashboard.NestedFilterProperty;
        /**
         * A `NumericEqualityFilter` filters numeric values that equal or do not equal a given numeric value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-filter.html#cfn-quicksight-dashboard-filter-numericequalityfilter
         */
        readonly numericEqualityFilter?: cdk.IResolvable | CfnDashboard.NumericEqualityFilterProperty;
        /**
         * A `NumericRangeFilter` filters numeric values that are either inside or outside a given numeric range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-filter.html#cfn-quicksight-dashboard-filter-numericrangefilter
         */
        readonly numericRangeFilter?: cdk.IResolvable | CfnDashboard.NumericRangeFilterProperty;
        /**
         * A `RelativeDatesFilter` filters date values that are relative to a given date.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-filter.html#cfn-quicksight-dashboard-filter-relativedatesfilter
         */
        readonly relativeDatesFilter?: cdk.IResolvable | CfnDashboard.RelativeDatesFilterProperty;
        /**
         * A `TimeEqualityFilter` filters date-time values that equal or do not equal a given date/time value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-filter.html#cfn-quicksight-dashboard-filter-timeequalityfilter
         */
        readonly timeEqualityFilter?: cdk.IResolvable | CfnDashboard.TimeEqualityFilterProperty;
        /**
         * A `TimeRangeFilter` filters date-time values that are either inside or outside a given date/time range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-filter.html#cfn-quicksight-dashboard-filter-timerangefilter
         */
        readonly timeRangeFilter?: cdk.IResolvable | CfnDashboard.TimeRangeFilterProperty;
        /**
         * A `TopBottomFilter` filters data to the top or bottom values for a given column.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-filter.html#cfn-quicksight-dashboard-filter-topbottomfilter
         */
        readonly topBottomFilter?: cdk.IResolvable | CfnDashboard.TopBottomFilterProperty;
    }
    /**
     * A `NumericEqualityFilter` filters values that are equal to the specified value.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-numericequalityfilter.html
     */
    interface NumericEqualityFilterProperty {
        /**
         * The aggregation function of the filter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-numericequalityfilter.html#cfn-quicksight-dashboard-numericequalityfilter-aggregationfunction
         */
        readonly aggregationFunction?: CfnDashboard.AggregationFunctionProperty | cdk.IResolvable;
        /**
         * The column that the filter is applied to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-numericequalityfilter.html#cfn-quicksight-dashboard-numericequalityfilter-column
         */
        readonly column: CfnDashboard.ColumnIdentifierProperty | cdk.IResolvable;
        /**
         * The default configurations for the associated controls.
         *
         * This applies only for filters that are scoped to multiple sheets.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-numericequalityfilter.html#cfn-quicksight-dashboard-numericequalityfilter-defaultfiltercontrolconfiguration
         */
        readonly defaultFilterControlConfiguration?: CfnDashboard.DefaultFilterControlConfigurationProperty | cdk.IResolvable;
        /**
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-numericequalityfilter.html#cfn-quicksight-dashboard-numericequalityfilter-filterid
         */
        readonly filterId: string;
        /**
         * The match operator that is used to determine if a filter should be applied.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-numericequalityfilter.html#cfn-quicksight-dashboard-numericequalityfilter-matchoperator
         */
        readonly matchOperator: string;
        /**
         * This option determines how null values should be treated when filtering data.
         *
         * - `ALL_VALUES` : Include null values in filtered results.
         * - `NULLS_ONLY` : Only include null values in filtered results.
         * - `NON_NULLS_ONLY` : Exclude null values from filtered results.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-numericequalityfilter.html#cfn-quicksight-dashboard-numericequalityfilter-nulloption
         */
        readonly nullOption: string;
        /**
         * The parameter whose value should be used for the filter value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-numericequalityfilter.html#cfn-quicksight-dashboard-numericequalityfilter-parametername
         */
        readonly parameterName?: string;
        /**
         * Select all of the values. Null is not the assigned value of select all.
         *
         * - `FILTER_ALL_VALUES`
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-numericequalityfilter.html#cfn-quicksight-dashboard-numericequalityfilter-selectalloptions
         */
        readonly selectAllOptions?: string;
        /**
         * The input value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-numericequalityfilter.html#cfn-quicksight-dashboard-numericequalityfilter-value
         */
        readonly value?: number;
    }
    /**
     * An aggregation function aggregates values from a dimension or measure.
     *
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-aggregationfunction.html
     */
    interface AggregationFunctionProperty {
        /**
         * Aggregation for attributes.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-aggregationfunction.html#cfn-quicksight-dashboard-aggregationfunction-attributeaggregationfunction
         */
        readonly attributeAggregationFunction?: CfnDashboard.AttributeAggregationFunctionProperty | cdk.IResolvable;
        /**
         * Aggregation for categorical values.
         *
         * - `COUNT` : Aggregate by the total number of values, including duplicates.
         * - `DISTINCT_COUNT` : Aggregate by the total number of distinct values.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-aggregationfunction.html#cfn-quicksight-dashboard-aggregationfunction-categoricalaggregationfunction
         */
        readonly categoricalAggregationFunction?: string;
        /**
         * Aggregation for date values.
         *
         * - `COUNT` : Aggregate by the total number of values, including duplicates.
         * - `DISTINCT_COUNT` : Aggregate by the total number of distinct values.
         * - `MIN` : Select the smallest date value.
         * - `MAX` : Select the largest date value.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-aggregationfunction.html#cfn-quicksight-dashboard-aggregationfunction-dateaggregationfunction
         */
        readonly dateAggregationFunction?: string;
        /**
         * Aggregation for numerical values.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-aggregationfunction.html#cfn-quicksight-dashboard-aggregationfunction-numericalaggregationfunction
         */
        readonly numericalAggregationFunction?: cdk.IResolvable | CfnDashboard.NumericalAggregationFunctionProperty;
    }
    /**
     * Aggregation for attributes.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-attributeaggregationfunction.html
     */
    interface AttributeAggregationFunctionProperty {
        /**
         * The built-in aggregation functions for attributes.
         *
         * - `UNIQUE_VALUE` : Returns the unique value for a field, aggregated by the dimension fields.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-attributeaggregationfunction.html#cfn-quicksight-dashboard-attributeaggregationfunction-simpleattributeaggregation
         */
        readonly simpleAttributeAggregation?: string;
        /**
         * Used by the `UNIQUE_VALUE` aggregation function.
         *
         * If there are multiple values for the field used by the aggregation, the value for this property will be returned instead. Defaults to '*'.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-attributeaggregationfunction.html#cfn-quicksight-dashboard-attributeaggregationfunction-valueformultiplevalues
         */
        readonly valueForMultipleValues?: string;
    }
    /**
     * Aggregation for numerical values.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-numericalaggregationfunction.html
     */
    interface NumericalAggregationFunctionProperty {
        /**
         * An aggregation based on the percentile of values in a dimension or measure.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-numericalaggregationfunction.html#cfn-quicksight-dashboard-numericalaggregationfunction-percentileaggregation
         */
        readonly percentileAggregation?: cdk.IResolvable | CfnDashboard.PercentileAggregationProperty;
        /**
         * Built-in aggregation functions for numerical values.
         *
         * - `SUM` : The sum of a dimension or measure.
         * - `AVERAGE` : The average of a dimension or measure.
         * - `MIN` : The minimum value of a dimension or measure.
         * - `MAX` : The maximum value of a dimension or measure.
         * - `COUNT` : The count of a dimension or measure.
         * - `DISTINCT_COUNT` : The count of distinct values in a dimension or measure.
         * - `VAR` : The variance of a dimension or measure.
         * - `VARP` : The partitioned variance of a dimension or measure.
         * - `STDEV` : The standard deviation of a dimension or measure.
         * - `STDEVP` : The partitioned standard deviation of a dimension or measure.
         * - `MEDIAN` : The median value of a dimension or measure.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-numericalaggregationfunction.html#cfn-quicksight-dashboard-numericalaggregationfunction-simplenumericalaggregation
         */
        readonly simpleNumericalAggregation?: string;
    }
    /**
     * An aggregation based on the percentile of values in a dimension or measure.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-percentileaggregation.html
     */
    interface PercentileAggregationProperty {
        /**
         * The percentile value.
         *
         * This value can be any numeric constant 0–100. A percentile value of 50 computes the median value of the measure.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-percentileaggregation.html#cfn-quicksight-dashboard-percentileaggregation-percentilevalue
         */
        readonly percentileValue?: number;
    }
    /**
     * A column of a data set.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-columnidentifier.html
     */
    interface ColumnIdentifierProperty {
        /**
         * The name of the column.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-columnidentifier.html#cfn-quicksight-dashboard-columnidentifier-columnname
         */
        readonly columnName: string;
        /**
         * The data set that the column belongs to.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-columnidentifier.html#cfn-quicksight-dashboard-columnidentifier-datasetidentifier
         */
        readonly dataSetIdentifier: string;
    }
    /**
     * The default configuration for all dependent controls of the filter.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultfiltercontrolconfiguration.html
     */
    interface DefaultFilterControlConfigurationProperty {
        /**
         * The control option for the `DefaultFilterControlConfiguration` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultfiltercontrolconfiguration.html#cfn-quicksight-dashboard-defaultfiltercontrolconfiguration-controloptions
         */
        readonly controlOptions: CfnDashboard.DefaultFilterControlOptionsProperty | cdk.IResolvable;
        /**
         * The title of the `DefaultFilterControlConfiguration` .
         *
         * This title is shared by all controls that are tied to this filter.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultfiltercontrolconfiguration.html#cfn-quicksight-dashboard-defaultfiltercontrolconfiguration-title
         */
        readonly title: string;
    }
    /**
     * The option that corresponds to the control type of the filter.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultfiltercontroloptions.html
     */
    interface DefaultFilterControlOptionsProperty {
        /**
         * The default options that correspond to the filter control type of a `DateTimePicker` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultfiltercontroloptions.html#cfn-quicksight-dashboard-defaultfiltercontroloptions-defaultdatetimepickeroptions
         */
        readonly defaultDateTimePickerOptions?: CfnDashboard.DefaultDateTimePickerControlOptionsProperty | cdk.IResolvable;
        /**
         * The default options that correspond to the `Dropdown` filter control type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultfiltercontroloptions.html#cfn-quicksight-dashboard-defaultfiltercontroloptions-defaultdropdownoptions
         */
        readonly defaultDropdownOptions?: CfnDashboard.DefaultFilterDropDownControlOptionsProperty | cdk.IResolvable;
        /**
         * The default options that correspond to the `List` filter control type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultfiltercontroloptions.html#cfn-quicksight-dashboard-defaultfiltercontroloptions-defaultlistoptions
         */
        readonly defaultListOptions?: CfnDashboard.DefaultFilterListControlOptionsProperty | cdk.IResolvable;
        /**
         * The default options that correspond to the `RelativeDateTime` filter control type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultfiltercontroloptions.html#cfn-quicksight-dashboard-defaultfiltercontroloptions-defaultrelativedatetimeoptions
         */
        readonly defaultRelativeDateTimeOptions?: CfnDashboard.DefaultRelativeDateTimeControlOptionsProperty | cdk.IResolvable;
        /**
         * The default options that correspond to the `Slider` filter control type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultfiltercontroloptions.html#cfn-quicksight-dashboard-defaultfiltercontroloptions-defaultslideroptions
         */
        readonly defaultSliderOptions?: CfnDashboard.DefaultSliderControlOptionsProperty | cdk.IResolvable;
        /**
         * The default options that correspond to the `TextArea` filter control type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultfiltercontroloptions.html#cfn-quicksight-dashboard-defaultfiltercontroloptions-defaulttextareaoptions
         */
        readonly defaultTextAreaOptions?: CfnDashboard.DefaultTextAreaControlOptionsProperty | cdk.IResolvable;
        /**
         * The default options that correspond to the `TextField` filter control type.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultfiltercontroloptions.html#cfn-quicksight-dashboard-defaultfiltercontroloptions-defaulttextfieldoptions
         */
        readonly defaultTextFieldOptions?: CfnDashboard.DefaultTextFieldControlOptionsProperty | cdk.IResolvable;
    }
    /**
     * The default options that correspond to the `Slider` filter control type.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultslidercontroloptions.html
     */
    interface DefaultSliderControlOptionsProperty {
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultslidercontroloptions.html#cfn-quicksight-dashboard-defaultslidercontroloptions-displayoptions
         */
        readonly displayOptions?: cdk.IResolvable | CfnDashboard.SliderControlDisplayOptionsProperty;
        /**
         * The larger value that is displayed at the right of the slider.
         *
         * @default - 0
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultslidercontroloptions.html#cfn-quicksight-dashboard-defaultslidercontroloptions-maximumvalue
         */
        readonly maximumValue: number;
        /**
         * The smaller value that is displayed at the left of the slider.
         *
         * @default - 0
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultslidercontroloptions.html#cfn-quicksight-dashboard-defaultslidercontroloptions-minimumvalue
         */
        readonly minimumValue: number;
        /**
         * The number of increments that the slider bar is divided into.
         *
         * @default - 0
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultslidercontroloptions.html#cfn-quicksight-dashboard-defaultslidercontroloptions-stepsize
         */
        readonly stepSize: number;
        /**
         * The type of the `DefaultSliderControlOptions` . Choose one of the following options:.
         *
         * - `SINGLE_POINT` : Filter against(equals) a single data point.
         * - `RANGE` : Filter data that is in a specified range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultslidercontroloptions.html#cfn-quicksight-dashboard-defaultslidercontroloptions-type
         */
        readonly type?: string;
    }
    /**
     * The display options of a control.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-slidercontroldisplayoptions.html
     */
    interface SliderControlDisplayOptionsProperty {
        /**
         * The configuration of info icon label options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-slidercontroldisplayoptions.html#cfn-quicksight-dashboard-slidercontroldisplayoptions-infoiconlabeloptions
         */
        readonly infoIconLabelOptions?: cdk.IResolvable | CfnDashboard.SheetControlInfoIconLabelOptionsProperty;
        /**
         * The options to configure the title visibility, name, and font size.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-slidercontroldisplayoptions.html#cfn-quicksight-dashboard-slidercontroldisplayoptions-titleoptions
         */
        readonly titleOptions?: cdk.IResolvable | CfnDashboard.LabelOptionsProperty;
    }
    /**
     * The share label options for the labels.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-labeloptions.html
     */
    interface LabelOptionsProperty {
        /**
         * The text for the label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-labeloptions.html#cfn-quicksight-dashboard-labeloptions-customlabel
         */
        readonly customLabel?: string;
        /**
         * The font configuration of the label.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-labeloptions.html#cfn-quicksight-dashboard-labeloptions-fontconfiguration
         */
        readonly fontConfiguration?: CfnDashboard.FontConfigurationProperty | cdk.IResolvable;
        /**
         * Determines whether or not the label is visible.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-labeloptions.html#cfn-quicksight-dashboard-labeloptions-visibility
         */
        readonly visibility?: string;
    }
    /**
     * Configures the display properties of the given text.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-fontconfiguration.html
     */
    interface FontConfigurationProperty {
        /**
         * Determines the color of the text.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-fontconfiguration.html#cfn-quicksight-dashboard-fontconfiguration-fontcolor
         */
        readonly fontColor?: string;
        /**
         * Determines the appearance of decorative lines on the text.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-fontconfiguration.html#cfn-quicksight-dashboard-fontconfiguration-fontdecoration
         */
        readonly fontDecoration?: string;
        /**
         * The font family that you want to use.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-fontconfiguration.html#cfn-quicksight-dashboard-fontconfiguration-fontfamily
         */
        readonly fontFamily?: string;
        /**
         * The option that determines the text display size.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-fontconfiguration.html#cfn-quicksight-dashboard-fontconfiguration-fontsize
         */
        readonly fontSize?: CfnDashboard.FontSizeProperty | cdk.IResolvable;
        /**
         * Determines the text display face that is inherited by the given font family.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-fontconfiguration.html#cfn-quicksight-dashboard-fontconfiguration-fontstyle
         */
        readonly fontStyle?: string;
        /**
         * The option that determines the text display weight, or boldness.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-fontconfiguration.html#cfn-quicksight-dashboard-fontconfiguration-fontweight
         */
        readonly fontWeight?: CfnDashboard.FontWeightProperty | cdk.IResolvable;
    }
    /**
     * The option that determines the text display size.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-fontsize.html
     */
    interface FontSizeProperty {
        /**
         * The font size that you want to use in px.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-fontsize.html#cfn-quicksight-dashboard-fontsize-absolute
         */
        readonly absolute?: string;
        /**
         * The lexical name for the text size, proportional to its surrounding context.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-fontsize.html#cfn-quicksight-dashboard-fontsize-relative
         */
        readonly relative?: string;
    }
    /**
     * The option that determines the text display weight, or boldness.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-fontweight.html
     */
    interface FontWeightProperty {
        /**
         * The lexical name for the level of boldness of the text display.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-fontweight.html#cfn-quicksight-dashboard-fontweight-name
         */
        readonly name?: string;
    }
    /**
     * A control to display info icons for filters and parameters.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-sheetcontrolinfoiconlabeloptions.html
     */
    interface SheetControlInfoIconLabelOptionsProperty {
        /**
         * The text content of info icon.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-sheetcontrolinfoiconlabeloptions.html#cfn-quicksight-dashboard-sheetcontrolinfoiconlabeloptions-infoicontext
         */
        readonly infoIconText?: string;
        /**
         * The visibility configuration of info icon label options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-sheetcontrolinfoiconlabeloptions.html#cfn-quicksight-dashboard-sheetcontrolinfoiconlabeloptions-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The default options that correspond to the `RelativeDateTime` filter control type.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultrelativedatetimecontroloptions.html
     */
    interface DefaultRelativeDateTimeControlOptionsProperty {
        /**
         * The visibility configuration of the Apply button on a `RelativeDateTimeControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultrelativedatetimecontroloptions.html#cfn-quicksight-dashboard-defaultrelativedatetimecontroloptions-commitmode
         */
        readonly commitMode?: string;
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultrelativedatetimecontroloptions.html#cfn-quicksight-dashboard-defaultrelativedatetimecontroloptions-displayoptions
         */
        readonly displayOptions?: cdk.IResolvable | CfnDashboard.RelativeDateTimeControlDisplayOptionsProperty;
    }
    /**
     * The display options of a control.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-relativedatetimecontroldisplayoptions.html
     */
    interface RelativeDateTimeControlDisplayOptionsProperty {
        /**
         * Customize how dates are formatted in controls.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-relativedatetimecontroldisplayoptions.html#cfn-quicksight-dashboard-relativedatetimecontroldisplayoptions-datetimeformat
         */
        readonly dateTimeFormat?: string;
        /**
         * The configuration of info icon label options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-relativedatetimecontroldisplayoptions.html#cfn-quicksight-dashboard-relativedatetimecontroldisplayoptions-infoiconlabeloptions
         */
        readonly infoIconLabelOptions?: cdk.IResolvable | CfnDashboard.SheetControlInfoIconLabelOptionsProperty;
        /**
         * The options to configure the title visibility, name, and font size.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-relativedatetimecontroldisplayoptions.html#cfn-quicksight-dashboard-relativedatetimecontroldisplayoptions-titleoptions
         */
        readonly titleOptions?: cdk.IResolvable | CfnDashboard.LabelOptionsProperty;
    }
    /**
     * The default options that correspond to the `TextField` filter control type.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaulttextfieldcontroloptions.html
     */
    interface DefaultTextFieldControlOptionsProperty {
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaulttextfieldcontroloptions.html#cfn-quicksight-dashboard-defaulttextfieldcontroloptions-displayoptions
         */
        readonly displayOptions?: cdk.IResolvable | CfnDashboard.TextFieldControlDisplayOptionsProperty;
    }
    /**
     * The display options of a control.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-textfieldcontroldisplayoptions.html
     */
    interface TextFieldControlDisplayOptionsProperty {
        /**
         * The configuration of info icon label options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-textfieldcontroldisplayoptions.html#cfn-quicksight-dashboard-textfieldcontroldisplayoptions-infoiconlabeloptions
         */
        readonly infoIconLabelOptions?: cdk.IResolvable | CfnDashboard.SheetControlInfoIconLabelOptionsProperty;
        /**
         * The configuration of the placeholder options in a text field control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-textfieldcontroldisplayoptions.html#cfn-quicksight-dashboard-textfieldcontroldisplayoptions-placeholderoptions
         */
        readonly placeholderOptions?: cdk.IResolvable | CfnDashboard.TextControlPlaceholderOptionsProperty;
        /**
         * The options to configure the title visibility, name, and font size.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-textfieldcontroldisplayoptions.html#cfn-quicksight-dashboard-textfieldcontroldisplayoptions-titleoptions
         */
        readonly titleOptions?: cdk.IResolvable | CfnDashboard.LabelOptionsProperty;
    }
    /**
     * The configuration of the placeholder options in a text control.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-textcontrolplaceholderoptions.html
     */
    interface TextControlPlaceholderOptionsProperty {
        /**
         * The visibility configuration of the placeholder options in a text control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-textcontrolplaceholderoptions.html#cfn-quicksight-dashboard-textcontrolplaceholderoptions-visibility
         */
        readonly visibility?: string;
    }
    /**
     * The default options that correspond to the `TextArea` filter control type.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaulttextareacontroloptions.html
     */
    interface DefaultTextAreaControlOptionsProperty {
        /**
         * The delimiter that is used to separate the lines in text.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaulttextareacontroloptions.html#cfn-quicksight-dashboard-defaulttextareacontroloptions-delimiter
         */
        readonly delimiter?: string;
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaulttextareacontroloptions.html#cfn-quicksight-dashboard-defaulttextareacontroloptions-displayoptions
         */
        readonly displayOptions?: cdk.IResolvable | CfnDashboard.TextAreaControlDisplayOptionsProperty;
    }
    /**
     * The display options of a control.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-textareacontroldisplayoptions.html
     */
    interface TextAreaControlDisplayOptionsProperty {
        /**
         * The configuration of info icon label options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-textareacontroldisplayoptions.html#cfn-quicksight-dashboard-textareacontroldisplayoptions-infoiconlabeloptions
         */
        readonly infoIconLabelOptions?: cdk.IResolvable | CfnDashboard.SheetControlInfoIconLabelOptionsProperty;
        /**
         * The configuration of the placeholder options in a text area control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-textareacontroldisplayoptions.html#cfn-quicksight-dashboard-textareacontroldisplayoptions-placeholderoptions
         */
        readonly placeholderOptions?: cdk.IResolvable | CfnDashboard.TextControlPlaceholderOptionsProperty;
        /**
         * The options to configure the title visibility, name, and font size.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-textareacontroldisplayoptions.html#cfn-quicksight-dashboard-textareacontroldisplayoptions-titleoptions
         */
        readonly titleOptions?: cdk.IResolvable | CfnDashboard.LabelOptionsProperty;
    }
    /**
     * The default options that correspond to the `Dropdown` filter control type.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultfilterdropdowncontroloptions.html
     */
    interface DefaultFilterDropDownControlOptionsProperty {
        /**
         * The visibility configuration of the Apply button on a `FilterDropDownControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultfilterdropdowncontroloptions.html#cfn-quicksight-dashboard-defaultfilterdropdowncontroloptions-commitmode
         */
        readonly commitMode?: string;
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultfilterdropdowncontroloptions.html#cfn-quicksight-dashboard-defaultfilterdropdowncontroloptions-displayoptions
         */
        readonly displayOptions?: CfnDashboard.DropDownControlDisplayOptionsProperty | cdk.IResolvable;
        /**
         * A list of selectable values that are used in a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultfilterdropdowncontroloptions.html#cfn-quicksight-dashboard-defaultfilterdropdowncontroloptions-selectablevalues
         */
        readonly selectableValues?: CfnDashboard.FilterSelectableValuesProperty | cdk.IResolvable;
        /**
         * The type of the `FilterDropDownControl` . Choose one of the following options:.
         *
         * - `MULTI_SELECT` : The user can select multiple entries from a dropdown menu.
         * - `SINGLE_SELECT` : The user can select a single entry from a dropdown menu.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultfilterdropdowncontroloptions.html#cfn-quicksight-dashboard-defaultfilterdropdowncontroloptions-type
         */
        readonly type?: string;
    }
    /**
     * The display options of a control.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dropdowncontroldisplayoptions.html
     */
    interface DropDownControlDisplayOptionsProperty {
        /**
         * The configuration of info icon label options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dropdowncontroldisplayoptions.html#cfn-quicksight-dashboard-dropdowncontroldisplayoptions-infoiconlabeloptions
         */
        readonly infoIconLabelOptions?: cdk.IResolvable | CfnDashboard.SheetControlInfoIconLabelOptionsProperty;
        /**
         * The configuration of the `Select all` options in a dropdown control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dropdowncontroldisplayoptions.html#cfn-quicksight-dashboard-dropdowncontroldisplayoptions-selectalloptions
         */
        readonly selectAllOptions?: cdk.IResolvable | CfnDashboard.ListControlSelectAllOptionsProperty;
        /**
         * The options to configure the title visibility, name, and font size.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dropdowncontroldisplayoptions.html#cfn-quicksight-dashboard-dropdowncontroldisplayoptions-titleoptions
         */
        readonly titleOptions?: cdk.IResolvable | CfnDashboard.LabelOptionsProperty;
    }
    /**
     * The configuration of the `Select all` options in a list control.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-listcontrolselectalloptions.html
     */
    interface ListControlSelectAllOptionsProperty {
        /**
         * The visibility configuration of the `Select all` options in a list control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-listcontrolselectalloptions.html#cfn-quicksight-dashboard-listcontrolselectalloptions-visibility
         */
        readonly visibility?: string;
    }
    /**
     * A list of selectable values that are used in a control.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-filterselectablevalues.html
     */
    interface FilterSelectableValuesProperty {
        /**
         * The values that are used in the `FilterSelectableValues` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-filterselectablevalues.html#cfn-quicksight-dashboard-filterselectablevalues-values
         */
        readonly values?: Array<string>;
    }
    /**
     * The default options that correspond to the filter control type of a `DateTimePicker` .
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultdatetimepickercontroloptions.html
     */
    interface DefaultDateTimePickerControlOptionsProperty {
        /**
         * The visibility configuration of the Apply button on a `DateTimePickerControl` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultdatetimepickercontroloptions.html#cfn-quicksight-dashboard-defaultdatetimepickercontroloptions-commitmode
         */
        readonly commitMode?: string;
        /**
         * The display options of a control.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultdatetimepickercontroloptions.html#cfn-quicksight-dashboard-defaultdatetimepickercontroloptions-displayoptions
         */
        readonly displayOptions?: CfnDashboard.DateTimePickerControlDisplayOptionsProperty | cdk.IResolvable;
        /**
         * The date time picker type of the `DefaultDateTimePickerControlOptions` . Choose one of the following options:.
         *
         * - `SINGLE_VALUED` : The filter condition is a fixed date.
         * - `DATE_RANGE` : The filter condition is a date time range.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-defaultdatetimepickercontroloptions.html#cfn-quicksight-dashboard-defaultdatetimepickercontroloptions-type
         */
        readonly type?: string;
    }
    /**
     * The display options of a control.
     *
     * @struct
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datetimepickercontroldisplayoptions.html
     */
    interface DateTimePickerControlDisplayOptionsProperty {
        /**
         * The date icon visibility of the `DateTimePickerControlDisplayOptions` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datetimepickercontroldisplayoptions.html#cfn-quicksight-dashboard-datetimepickercontroldisplayoptions-dateiconvisibility
         */
        readonly dateIconVisibility?: string;
        /**
         * Customize how dates are formatted in controls.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datetimepickercontroldisplayoptions.html#cfn-quicksight-dashboard-datetimepickercontroldisplayoptions-datetimeformat
         */
        readonly dateTimeFormat?: string;
        /**
         * The helper text visibility of the `DateTimePickerControlDisplayOptions` .
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datetimepickercontroldisplayoptions.html#cfn-quicksight-dashboard-datetimepickercontroldisplayoptions-helpertextvisibility
         */
        readonly helperTextVisibility?: string;
        /**
         * The configuration of info icon label options.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datetimepickercontroldisplayoptions.html#cfn-quicksight-dashboard-datetimepickercontroldisplayoptions-infoiconlabeloptions
         */
        readonly infoIconLabelOptions?: cdk.IResolvable | CfnDashboard.SheetControlInfoIconLabelOptionsProperty;
        /**
         * The options to configure the title visibility, name, and font size.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datetimepickercontroldisplayoptions.html#cfn-quicksight-dashboard-datetimepickercontroldisplayoptions-titleoptions
     