"use strict";var _a,_b,_c;Object.defineProperty(exports,"__esModule",{value:!0}),exports.SpaceDelimitedTextPattern=exports.FilterPattern=exports.JsonPattern=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var core_1=()=>{var tmp=require("../../core");return core_1=()=>tmp,tmp};class JsonPattern{constructor(jsonPatternString){this.jsonPatternString=jsonPatternString}get logPatternString(){return"{ "+this.jsonPatternString+" }"}}exports.JsonPattern=JsonPattern,_a=JSII_RTTI_SYMBOL_1,JsonPattern[_a]={fqn:"aws-cdk-lib.aws_logs.JsonPattern",version:"2.188.0"};class FilterPattern{static literal(logPatternString){return new LiteralLogPattern(logPatternString)}static allEvents(){return new LiteralLogPattern("")}static allTerms(...terms){return new TextLogPattern([terms])}static anyTerm(...terms){return new TextLogPattern(terms.map(t=>[t]))}static anyTermGroup(...termGroups){return new TextLogPattern(termGroups)}static stringValue(jsonField,comparison,value){return new JSONStringPattern(jsonField,comparison,value)}static numberValue(jsonField,comparison,value){return new JSONNumberPattern(jsonField,comparison,value)}static regexValue(jsonField,comparison,value){return new JSONRegexPattern(jsonField,comparison,value)}static isNull(jsonField){return new JSONPostfixPattern(jsonField,"IS NULL")}static notExists(jsonField){return new JSONPostfixPattern(jsonField,"NOT EXISTS")}static exists(jsonField){return new JSONStringPattern(jsonField,"=","*")}static booleanValue(jsonField,value){return new JSONPostfixPattern(jsonField,value?"IS TRUE":"IS FALSE")}static all(...patterns){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_logs_JsonPattern(patterns)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.all),error}if(patterns.length===0)throw new(core_1()).UnscopedValidationError("Must supply at least one pattern, or use allEvents() to match all events.");return patterns.length===1?patterns[0]:new JSONAggregatePattern("&&",patterns)}static any(...patterns){try{jsiiDeprecationWarnings().aws_cdk_lib_aws_logs_JsonPattern(patterns)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.any),error}if(patterns.length===0)throw new(core_1()).UnscopedValidationError("Must supply at least one pattern");return patterns.length===1?patterns[0]:new JSONAggregatePattern("||",patterns)}static spaceDelimited(...columns){return SpaceDelimitedTextPattern.construct(columns)}}exports.FilterPattern=FilterPattern,_b=JSII_RTTI_SYMBOL_1,FilterPattern[_b]={fqn:"aws-cdk-lib.aws_logs.FilterPattern",version:"2.188.0"};class LiteralLogPattern{constructor(logPatternString){this.logPatternString=logPatternString}}class TextLogPattern{constructor(clauses){const quotedClauses=clauses.map(terms=>terms.map(quoteTerm).join(" "));quotedClauses.length===1?this.logPatternString=quotedClauses[0]:this.logPatternString=quotedClauses.map(alt=>"?"+alt).join(" ")}}class JSONStringPattern extends JsonPattern{constructor(jsonField,comparison,value){comparison=validateStringOperator(comparison),super(`${jsonField} ${comparison} ${quoteTerm(value)}`)}}class JSONRegexPattern extends JsonPattern{constructor(jsonField,comparison,value){super(`${jsonField} ${comparison} %${value}%`)}}class JSONNumberPattern extends JsonPattern{constructor(jsonField,comparison,value){comparison=validateNumericalOperator(comparison),super(`${jsonField} ${comparison} ${value}`)}}class JSONPostfixPattern extends JsonPattern{constructor(jsonField,postfix){super(`${jsonField} ${postfix}`)}}class JSONAggregatePattern extends JsonPattern{constructor(operator,patterns){if(operator!=="&&"&&operator!=="||")throw new(core_1()).UnscopedValidationError("Operator must be one of && or ||");const clauses=patterns.map(p=>"("+p.jsonPatternString+")");super(clauses.join(` ${operator} `))}}const COL_ELLIPSIS="...";class SpaceDelimitedTextPattern{static construct(columns){for(const column of columns)if(!validColumnName(column))throw new(core_1()).UnscopedValidationError(`Invalid column name: ${column}`);if(sum(columns.map(c=>c===COL_ELLIPSIS?1:0))>1)throw new(core_1()).UnscopedValidationError("Can use at most one '...' column");return new SpaceDelimitedTextPattern(columns,{})}constructor(columns,restrictions){this.columns=columns,this.restrictions=restrictions}whereString(columnName,comparison,value){if(columnName===COL_ELLIPSIS)throw new(core_1()).UnscopedValidationError("Can't use '...' in a restriction");if(this.columns.indexOf(columnName)===-1)throw new(core_1()).UnscopedValidationError(`Column in restrictions that is not in columns: ${columnName}`);return comparison=validateStringOperator(comparison),new SpaceDelimitedTextPattern(this.columns,this.addRestriction(columnName,{comparison,stringValue:value}))}whereNumber(columnName,comparison,value){if(columnName===COL_ELLIPSIS)throw new(core_1()).UnscopedValidationError("Can't use '...' in a restriction");if(this.columns.indexOf(columnName)===-1)throw new(core_1()).UnscopedValidationError(`Column in restrictions that is not in columns: ${columnName}`);return comparison=validateNumericalOperator(comparison),new SpaceDelimitedTextPattern(this.columns,this.addRestriction(columnName,{comparison,numberValue:value}))}get logPatternString(){return"["+this.columns.map(this.columnExpression.bind(this)).join(", ")+"]"}columnExpression(column){const restrictions=this.restrictions[column];return restrictions?restrictions.map(r=>renderRestriction(column,r)).join(" && "):column}addRestriction(columnName,restriction){const ret={};for(const key of Object.keys(this.restrictions))ret[key]=this.restrictions[key].slice();return columnName in ret||(ret[columnName]=[]),ret[columnName].push(restriction),ret}}exports.SpaceDelimitedTextPattern=SpaceDelimitedTextPattern,_c=JSII_RTTI_SYMBOL_1,SpaceDelimitedTextPattern[_c]={fqn:"aws-cdk-lib.aws_logs.SpaceDelimitedTextPattern",version:"2.188.0"};function quoteTerm(term){return'"'+term.replace(/\\/g,"\\\\").replace(/"/g,'\\"')+'"'}function validColumnName(column){return column===COL_ELLIPSIS||/^[a-zA-Z0-9_-]+$/.exec(column)}function validateStringOperator(operator){if(operator==="=="&&(operator="="),operator!=="="&&operator!=="!=")throw new(core_1()).UnscopedValidationError(`Invalid comparison operator ('${operator}'), must be either '=' or '!='`);return operator}const VALID_OPERATORS=["=","!=","<","<=",">",">="];function validateNumericalOperator(operator){if(operator==="=="&&(operator="="),VALID_OPERATORS.indexOf(operator)===-1)throw new(core_1()).UnscopedValidationError(`Invalid comparison operator ('${operator}'), must be one of ${VALID_OPERATORS.join(", ")}`);return operator}function renderRestriction(column,restriction){if(restriction.numberValue!==void 0)return`${column} ${restriction.comparison} ${restriction.numberValue}`;if(restriction.stringValue)return`${column} ${restriction.comparison} ${quoteTerm(restriction.stringValue)}`;throw new(core_1()).UnscopedValidationError("Invalid restriction")}function sum(xs){return xs.reduce((a,c)=>a+c,0)}
