"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.StartingPosition=exports.EventSourceMapping=exports.MetricType=exports.SourceAccessConfigurationType=void 0;var jsiiDeprecationWarnings=()=>{var tmp=require("../../.warnings.jsii.js");return jsiiDeprecationWarnings=()=>tmp,tmp};const JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti");var lambda_generated_1=()=>{var tmp=require("./lambda.generated");return lambda_generated_1=()=>tmp,tmp},iam=()=>{var tmp=require("../../aws-iam");return iam=()=>tmp,tmp},cdk=()=>{var tmp=require("../../core");return cdk=()=>tmp,tmp},errors_1=()=>{var tmp=require("../../core/lib/errors");return errors_1=()=>tmp,tmp},metadata_resource_1=()=>{var tmp=require("../../core/lib/metadata-resource");return metadata_resource_1=()=>tmp,tmp};class SourceAccessConfigurationType{static of(name){return new SourceAccessConfigurationType(name)}constructor(type){this.type=type}}exports.SourceAccessConfigurationType=SourceAccessConfigurationType,_a=JSII_RTTI_SYMBOL_1,SourceAccessConfigurationType[_a]={fqn:"aws-cdk-lib.aws_lambda.SourceAccessConfigurationType",version:"2.188.0"},SourceAccessConfigurationType.BASIC_AUTH=new SourceAccessConfigurationType("BASIC_AUTH"),SourceAccessConfigurationType.VPC_SUBNET=new SourceAccessConfigurationType("VPC_SUBNET"),SourceAccessConfigurationType.VPC_SECURITY_GROUP=new SourceAccessConfigurationType("VPC_SECURITY_GROUP"),SourceAccessConfigurationType.SASL_SCRAM_256_AUTH=new SourceAccessConfigurationType("SASL_SCRAM_256_AUTH"),SourceAccessConfigurationType.SASL_SCRAM_512_AUTH=new SourceAccessConfigurationType("SASL_SCRAM_512_AUTH"),SourceAccessConfigurationType.CLIENT_CERTIFICATE_TLS_AUTH=new SourceAccessConfigurationType("CLIENT_CERTIFICATE_TLS_AUTH"),SourceAccessConfigurationType.SERVER_ROOT_CA_CERTIFICATE=new SourceAccessConfigurationType("SERVER_ROOT_CA_CERTIFICATE"),SourceAccessConfigurationType.VIRTUAL_HOST=new SourceAccessConfigurationType("VIRTUAL_HOST");var MetricType;(function(MetricType2){MetricType2.EVENT_COUNT="EventCount"})(MetricType||(exports.MetricType=MetricType={}));class EventSourceMapping extends cdk().Resource{static fromEventSourceMappingId(scope,id,eventSourceMappingId){const eventSourceMappingArn=EventSourceMapping.formatArn(scope,eventSourceMappingId);class Import extends cdk().Resource{constructor(){super(...arguments),this.eventSourceMappingId=eventSourceMappingId,this.eventSourceMappingArn=eventSourceMappingArn}}return new Import(scope,id)}static formatArn(scope,eventSourceMappingId){return cdk().Stack.of(scope).formatArn({service:"lambda",resource:"event-source-mapping",resourceName:eventSourceMappingId,arnFormat:cdk().ArnFormat.COLON_RESOURCE_NAME})}constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings().aws_cdk_lib_aws_lambda_EventSourceMappingProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,EventSourceMapping),error}if((0,metadata_resource_1().addConstructMetadata)(this,props),props.eventSourceArn==null&&props.kafkaBootstrapServers==null)throw new(errors_1()).ValidationError("Either eventSourceArn or kafkaBootstrapServers must be set",this);if(props.eventSourceArn!==void 0&&props.kafkaBootstrapServers!==void 0)throw new(errors_1()).ValidationError("eventSourceArn and kafkaBootstrapServers are mutually exclusive",this);if(props.provisionedPollerConfig){const{minimumPollers,maximumPollers}=props.provisionedPollerConfig;if(minimumPollers!=null&&(minimumPollers<1||minimumPollers>200))throw new(errors_1()).ValidationError("Minimum provisioned pollers must be between 1 and 200 inclusive",this);if(maximumPollers!=null&&(maximumPollers<1||maximumPollers>2e3))throw new(errors_1()).ValidationError("Maximum provisioned pollers must be between 1 and 2000 inclusive",this);if(minimumPollers!=null&&maximumPollers!=null&&minimumPollers>maximumPollers)throw new(errors_1()).ValidationError("Minimum provisioned pollers must be less than or equal to maximum provisioned pollers",this)}if(props.kafkaBootstrapServers&&props.kafkaBootstrapServers?.length<1)throw new(errors_1()).ValidationError("kafkaBootStrapServers must not be empty if set",this);if(props.maxBatchingWindow&&props.maxBatchingWindow.toSeconds()>300)throw new(errors_1()).ValidationError(`maxBatchingWindow cannot be over 300 seconds, got ${props.maxBatchingWindow.toSeconds()}`,this);if(props.maxConcurrency&&!cdk().Token.isUnresolved(props.maxConcurrency)&&(props.maxConcurrency<2||props.maxConcurrency>1e3))throw new(errors_1()).ValidationError("maxConcurrency must be between 2 and 1000 concurrent instances",this);if(props.maxRecordAge&&(props.maxRecordAge.toSeconds()<60||props.maxRecordAge.toDays({integral:!1})>7))throw new(errors_1()).ValidationError("maxRecordAge must be between 60 seconds and 7 days inclusive",this);if(props.retryAttempts!==void 0&&cdk().withResolved(props.retryAttempts,attempts=>{if(!(attempts===-1||attempts>=0&&attempts<=1e4))throw new(errors_1()).ValidationError(`retryAttempts must be -1 (for infinite) or between 0 and 10000 inclusive, got ${attempts}`,this)}),props.parallelizationFactor!==void 0&&cdk().withResolved(props.parallelizationFactor,factor=>{if(factor<1||factor>10)throw new(errors_1()).ValidationError(`parallelizationFactor must be between 1 and 10 inclusive, got ${factor}`,this)}),props.tumblingWindow&&!cdk().Token.isUnresolved(props.tumblingWindow)&&props.tumblingWindow.toSeconds()>900)throw new(errors_1()).ValidationError(`tumblingWindow cannot be over 900 seconds, got ${props.tumblingWindow.toSeconds()}`,this);if(props.startingPosition===StartingPosition.AT_TIMESTAMP&&!props.startingPositionTimestamp)throw new(errors_1()).ValidationError("startingPositionTimestamp must be provided when startingPosition is AT_TIMESTAMP",this);if(props.startingPosition!==StartingPosition.AT_TIMESTAMP&&props.startingPositionTimestamp)throw new(errors_1()).ValidationError("startingPositionTimestamp can only be used when startingPosition is AT_TIMESTAMP",this);if(props.kafkaConsumerGroupId&&this.validateKafkaConsumerGroupIdOrThrow(props.kafkaConsumerGroupId),props.filterEncryption!==void 0&&props.filters==null)throw new(errors_1()).ValidationError("filter criteria must be provided to enable setting filter criteria encryption",this);if(props.filterEncryption!==void 0){const lambdaPrincipal=new(iam()).ServicePrincipal("lambda.amazonaws.com");props.filterEncryption.grantDecrypt(lambdaPrincipal)}let destinationConfig;props.onFailure&&(destinationConfig={onFailure:props.onFailure.bind(this,props.target)});let selfManagedEventSource;props.kafkaBootstrapServers&&(selfManagedEventSource={endpoints:{kafkaBootstrapServers:props.kafkaBootstrapServers}});let consumerGroupConfig=props.kafkaConsumerGroupId?{consumerGroupId:props.kafkaConsumerGroupId}:void 0;const cfnEventSourceMapping=new(lambda_generated_1()).CfnEventSourceMapping(this,"Resource",{batchSize:props.batchSize,bisectBatchOnFunctionError:props.bisectBatchOnError,destinationConfig,enabled:props.enabled,eventSourceArn:props.eventSourceArn,functionName:props.target.functionName,startingPosition:props.startingPosition,startingPositionTimestamp:props.startingPositionTimestamp,functionResponseTypes:props.reportBatchItemFailures?["ReportBatchItemFailures"]:void 0,maximumBatchingWindowInSeconds:props.maxBatchingWindow?.toSeconds(),maximumRecordAgeInSeconds:props.maxRecordAge?.toSeconds(),maximumRetryAttempts:props.retryAttempts,parallelizationFactor:props.parallelizationFactor,topics:props.kafkaTopic!==void 0?[props.kafkaTopic]:void 0,tumblingWindowInSeconds:props.tumblingWindow?.toSeconds(),scalingConfig:props.maxConcurrency?{maximumConcurrency:props.maxConcurrency}:void 0,sourceAccessConfigurations:props.sourceAccessConfigurations?.map(o=>({type:o.type.type,uri:o.uri})),selfManagedEventSource,filterCriteria:props.filters?{filters:props.filters}:void 0,kmsKeyArn:props.filterEncryption?.keyArn,selfManagedKafkaEventSourceConfig:props.kafkaBootstrapServers?consumerGroupConfig:void 0,amazonManagedKafkaEventSourceConfig:props.eventSourceArn?consumerGroupConfig:void 0,provisionedPollerConfig:props.provisionedPollerConfig,metricsConfig:props.metricsConfig});this.eventSourceMappingId=cfnEventSourceMapping.ref,this.eventSourceMappingArn=EventSourceMapping.formatArn(this,this.eventSourceMappingId)}validateKafkaConsumerGroupIdOrThrow(kafkaConsumerGroupId){if(cdk().Token.isUnresolved(kafkaConsumerGroupId))return;if(kafkaConsumerGroupId.length>200||kafkaConsumerGroupId.length<1)throw new(errors_1()).ValidationError("kafkaConsumerGroupId must be a valid string between 1 and 200 characters",this);const patternMatch=new RegExp(/[a-zA-Z0-9-\/*:_+=.@-]*/).exec(kafkaConsumerGroupId);if(patternMatch===null||patternMatch[0]!==kafkaConsumerGroupId)throw new(errors_1()).ValidationError('kafkaConsumerGroupId contains invalid characters. Allowed values are "[a-zA-Z0-9-/*:_+=.@-]"',this)}}exports.EventSourceMapping=EventSourceMapping,_b=JSII_RTTI_SYMBOL_1,EventSourceMapping[_b]={fqn:"aws-cdk-lib.aws_lambda.EventSourceMapping",version:"2.188.0"};var StartingPosition;(function(StartingPosition2){StartingPosition2.TRIM_HORIZON="TRIM_HORIZON",StartingPosition2.LATEST="LATEST",StartingPosition2.AT_TIMESTAMP="AT_TIMESTAMP"})(StartingPosition||(exports.StartingPosition=StartingPosition={}));
